/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSStyleSheet.h"

#include "JSMediaList.h"
#include "JSNode.h"
#include "JSStyleSheet.h"
#include "KURL.h"
#include "MediaList.h"
#include "Node.h"
#include "StyleSheet.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSStyleSheet);

/* Hash table */

static const HashTableValue JSStyleSheetTableValues[9] =
{
    { "type", DontDelete|ReadOnly, (intptr_t)jsStyleSheetType, (intptr_t)0 },
    { "disabled", DontDelete, (intptr_t)jsStyleSheetDisabled, (intptr_t)setJSStyleSheetDisabled },
    { "ownerNode", DontDelete|ReadOnly, (intptr_t)jsStyleSheetOwnerNode, (intptr_t)0 },
    { "parentStyleSheet", DontDelete|ReadOnly, (intptr_t)jsStyleSheetParentStyleSheet, (intptr_t)0 },
    { "href", DontDelete|ReadOnly, (intptr_t)jsStyleSheetHref, (intptr_t)0 },
    { "title", DontDelete|ReadOnly, (intptr_t)jsStyleSheetTitle, (intptr_t)0 },
    { "media", DontDelete|ReadOnly, (intptr_t)jsStyleSheetMedia, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsStyleSheetConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSStyleSheetTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 31, JSStyleSheetTableValues, 0 };
#else
    { 17, 15, JSStyleSheetTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSStyleSheetConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSStyleSheetConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSStyleSheetConstructorTableValues, 0 };
#else
    { 1, 0, JSStyleSheetConstructorTableValues, 0 };
#endif

class JSStyleSheetConstructor : public DOMConstructorObject {
public:
    JSStyleSheetConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSStyleSheetConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSStyleSheetPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags)); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSStyleSheetConstructor::s_info = { "StyleSheetConstructor", 0, &JSStyleSheetConstructorTable, 0 };

bool JSStyleSheetConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSStyleSheetConstructor, DOMObject>(exec, &JSStyleSheetConstructorTable, this, propertyName, slot);
}

bool JSStyleSheetConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSStyleSheetConstructor, DOMObject>(exec, &JSStyleSheetConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSStyleSheetPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSStyleSheetPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSStyleSheetPrototypeTableValues, 0 };
#else
    { 1, 0, JSStyleSheetPrototypeTableValues, 0 };
#endif

const ClassInfo JSStyleSheetPrototype::s_info = { "StyleSheetPrototype", 0, &JSStyleSheetPrototypeTable, 0 };

JSObject* JSStyleSheetPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSStyleSheet>(exec, globalObject);
}

const ClassInfo JSStyleSheet::s_info = { "StyleSheet", 0, &JSStyleSheetTable, 0 };

JSStyleSheet::JSStyleSheet(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<StyleSheet> impl)
    : DOMObjectWithGlobalPointer(structure, globalObject)
    , m_impl(impl)
{
}

JSStyleSheet::~JSStyleSheet()
{
    forgetDOMObject(*Heap::heap(this)->globalData(), impl());
}

JSObject* JSStyleSheet::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSStyleSheetPrototype(JSStyleSheetPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSStyleSheet::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSStyleSheet, Base>(exec, &JSStyleSheetTable, this, propertyName, slot);
}

bool JSStyleSheet::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSStyleSheet, Base>(exec, &JSStyleSheetTable, this, propertyName, descriptor);
}

JSValue jsStyleSheetType(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSStyleSheet* castedThis = static_cast<JSStyleSheet*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    StyleSheet* imp = static_cast<StyleSheet*>(castedThis->impl());
    return jsStringOrNull(exec, imp->type());
}

JSValue jsStyleSheetDisabled(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSStyleSheet* castedThis = static_cast<JSStyleSheet*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    StyleSheet* imp = static_cast<StyleSheet*>(castedThis->impl());
    return jsBoolean(imp->disabled());
}

JSValue jsStyleSheetOwnerNode(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSStyleSheet* castedThis = static_cast<JSStyleSheet*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    StyleSheet* imp = static_cast<StyleSheet*>(castedThis->impl());
    return toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->ownerNode()));
}

JSValue jsStyleSheetParentStyleSheet(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSStyleSheet* castedThis = static_cast<JSStyleSheet*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    StyleSheet* imp = static_cast<StyleSheet*>(castedThis->impl());
    return toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->parentStyleSheet()));
}

JSValue jsStyleSheetHref(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSStyleSheet* castedThis = static_cast<JSStyleSheet*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    StyleSheet* imp = static_cast<StyleSheet*>(castedThis->impl());
    return jsStringOrNull(exec, imp->href());
}

JSValue jsStyleSheetTitle(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSStyleSheet* castedThis = static_cast<JSStyleSheet*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    StyleSheet* imp = static_cast<StyleSheet*>(castedThis->impl());
    return jsStringOrNull(exec, imp->title());
}

JSValue jsStyleSheetMedia(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSStyleSheet* castedThis = static_cast<JSStyleSheet*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    StyleSheet* imp = static_cast<StyleSheet*>(castedThis->impl());
    return toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->media()));
}

JSValue jsStyleSheetConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSStyleSheet* domObject = static_cast<JSStyleSheet*>(asObject(slot.slotBase()));
    return JSStyleSheet::getConstructor(exec, domObject->globalObject());
}
void JSStyleSheet::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSStyleSheet, Base>(exec, propertyName, value, &JSStyleSheetTable, this, slot);
}

void setJSStyleSheetDisabled(ExecState* exec, JSObject* thisObject, JSValue value)
{
    StyleSheet* imp = static_cast<StyleSheet*>(static_cast<JSStyleSheet*>(thisObject)->impl());
    imp->setDisabled(value.toBoolean(exec));
}

JSValue JSStyleSheet::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSStyleSheetConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

StyleSheet* toStyleSheet(JSC::JSValue value)
{
    return value.inherits(&JSStyleSheet::s_info) ? static_cast<JSStyleSheet*>(asObject(value))->impl() : 0;
}

}
