/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGAnimatedLength.h"

#include "JSSVGLength.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGAnimatedLength);

/* Hash table */

static const HashTableValue JSSVGAnimatedLengthTableValues[3] =
{
    { "baseVal", DontDelete|ReadOnly, (intptr_t)jsSVGAnimatedLengthBaseVal, (intptr_t)0 },
    { "animVal", DontDelete|ReadOnly, (intptr_t)jsSVGAnimatedLengthAnimVal, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGAnimatedLengthTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 1, JSSVGAnimatedLengthTableValues, 0 };
#else
    { 4, 3, JSSVGAnimatedLengthTableValues, 0 };
#endif

/* Hash table for prototype */

static const HashTableValue JSSVGAnimatedLengthPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGAnimatedLengthPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSSVGAnimatedLengthPrototypeTableValues, 0 };
#else
    { 1, 0, JSSVGAnimatedLengthPrototypeTableValues, 0 };
#endif

const ClassInfo JSSVGAnimatedLengthPrototype::s_info = { "SVGAnimatedLengthPrototype", 0, &JSSVGAnimatedLengthPrototypeTable, 0 };

JSObject* JSSVGAnimatedLengthPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGAnimatedLength>(exec, globalObject);
}

const ClassInfo JSSVGAnimatedLength::s_info = { "SVGAnimatedLength", 0, &JSSVGAnimatedLengthTable, 0 };

JSSVGAnimatedLength::JSSVGAnimatedLength(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGAnimatedLength> impl, SVGElement* context)
    : DOMObjectWithSVGContext(structure, globalObject, context)
    , m_impl(impl)
{
}

JSSVGAnimatedLength::~JSSVGAnimatedLength()
{
    forgetDOMObject(*Heap::heap(this)->globalData(), impl());
}

JSObject* JSSVGAnimatedLength::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSSVGAnimatedLengthPrototype(JSSVGAnimatedLengthPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSSVGAnimatedLength::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGAnimatedLength, Base>(exec, &JSSVGAnimatedLengthTable, this, propertyName, slot);
}

bool JSSVGAnimatedLength::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGAnimatedLength, Base>(exec, &JSSVGAnimatedLengthTable, this, propertyName, descriptor);
}

JSValue jsSVGAnimatedLengthBaseVal(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGAnimatedLength* castedThis = static_cast<JSSVGAnimatedLength*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGAnimatedLength* imp = static_cast<SVGAnimatedLength*>(castedThis->impl());
    return toJS(exec, deprecatedGlobalObjectForPrototype(exec), JSSVGDynamicPODTypeWrapperCache<SVGLength, SVGAnimatedLength>::lookupOrCreateWrapper(imp, &SVGAnimatedLength::baseVal, &SVGAnimatedLength::setBaseVal).get(), castedThis->context());
}

JSValue jsSVGAnimatedLengthAnimVal(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGAnimatedLength* castedThis = static_cast<JSSVGAnimatedLength*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGAnimatedLength* imp = static_cast<SVGAnimatedLength*>(castedThis->impl());
    return toJS(exec, deprecatedGlobalObjectForPrototype(exec), JSSVGDynamicPODTypeWrapperCache<SVGLength, SVGAnimatedLength>::lookupOrCreateWrapper(imp, &SVGAnimatedLength::animVal, &SVGAnimatedLength::setAnimVal).get(), castedThis->context());
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, SVGAnimatedLength* object, SVGElement* context)
{
    return getDOMObjectWrapper<JSSVGAnimatedLength>(exec, globalObject, object, context);
}
SVGAnimatedLength* toSVGAnimatedLength(JSC::JSValue value)
{
    return value.inherits(&JSSVGAnimatedLength::s_info) ? static_cast<JSSVGAnimatedLength*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(SVG)
