/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGMatrix.h"

#include "JSSVGMatrix.h"
#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGMatrix);

/* Hash table */

static const HashTableValue JSSVGMatrixTableValues[7] =
{
    { "a", DontDelete, (intptr_t)jsSVGMatrixA, (intptr_t)setJSSVGMatrixA },
    { "b", DontDelete, (intptr_t)jsSVGMatrixB, (intptr_t)setJSSVGMatrixB },
    { "c", DontDelete, (intptr_t)jsSVGMatrixC, (intptr_t)setJSSVGMatrixC },
    { "d", DontDelete, (intptr_t)jsSVGMatrixD, (intptr_t)setJSSVGMatrixD },
    { "e", DontDelete, (intptr_t)jsSVGMatrixE, (intptr_t)setJSSVGMatrixE },
    { "f", DontDelete, (intptr_t)jsSVGMatrixF, (intptr_t)setJSSVGMatrixF },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGMatrixTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 15, JSSVGMatrixTableValues, 0 };
#else
    { 16, 15, JSSVGMatrixTableValues, 0 };
#endif

/* Hash table for prototype */

static const HashTableValue JSSVGMatrixPrototypeTableValues[12] =
{
    { "multiply", DontDelete|Function, (intptr_t)jsSVGMatrixPrototypeFunctionMultiply, (intptr_t)1 },
    { "inverse", DontDelete|Function, (intptr_t)jsSVGMatrixPrototypeFunctionInverse, (intptr_t)0 },
    { "translate", DontDelete|Function, (intptr_t)jsSVGMatrixPrototypeFunctionTranslate, (intptr_t)2 },
    { "scale", DontDelete|Function, (intptr_t)jsSVGMatrixPrototypeFunctionScale, (intptr_t)1 },
    { "scaleNonUniform", DontDelete|Function, (intptr_t)jsSVGMatrixPrototypeFunctionScaleNonUniform, (intptr_t)2 },
    { "rotate", DontDelete|Function, (intptr_t)jsSVGMatrixPrototypeFunctionRotate, (intptr_t)1 },
    { "rotateFromVector", DontDelete|Function, (intptr_t)jsSVGMatrixPrototypeFunctionRotateFromVector, (intptr_t)2 },
    { "flipX", DontDelete|Function, (intptr_t)jsSVGMatrixPrototypeFunctionFlipX, (intptr_t)0 },
    { "flipY", DontDelete|Function, (intptr_t)jsSVGMatrixPrototypeFunctionFlipY, (intptr_t)0 },
    { "skewX", DontDelete|Function, (intptr_t)jsSVGMatrixPrototypeFunctionSkewX, (intptr_t)1 },
    { "skewY", DontDelete|Function, (intptr_t)jsSVGMatrixPrototypeFunctionSkewY, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGMatrixPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 63, JSSVGMatrixPrototypeTableValues, 0 };
#else
    { 33, 31, JSSVGMatrixPrototypeTableValues, 0 };
#endif

const ClassInfo JSSVGMatrixPrototype::s_info = { "SVGMatrixPrototype", 0, &JSSVGMatrixPrototypeTable, 0 };

JSObject* JSSVGMatrixPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGMatrix>(exec, globalObject);
}

bool JSSVGMatrixPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGMatrixPrototypeTable, this, propertyName, slot);
}

bool JSSVGMatrixPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSSVGMatrixPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSSVGMatrix::s_info = { "SVGMatrix", 0, &JSSVGMatrixTable, 0 };

JSSVGMatrix::JSSVGMatrix(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<JSSVGPODTypeWrapper<TransformationMatrix> > impl, SVGElement* context)
    : DOMObjectWithSVGContext(structure, globalObject, context)
    , m_impl(impl)
{
}

JSSVGMatrix::~JSSVGMatrix()
{
    forgetDOMObject(*Heap::heap(this)->globalData(), impl());
}

JSObject* JSSVGMatrix::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSSVGMatrixPrototype(JSSVGMatrixPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSSVGMatrix::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGMatrix, Base>(exec, &JSSVGMatrixTable, this, propertyName, slot);
}

bool JSSVGMatrix::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGMatrix, Base>(exec, &JSSVGMatrixTable, this, propertyName, descriptor);
}

JSValue jsSVGMatrixA(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGMatrix* castedThis = static_cast<JSSVGMatrix*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    TransformationMatrix imp(*castedThis->impl());
    return jsNumber(exec, imp.a());
}

JSValue jsSVGMatrixB(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGMatrix* castedThis = static_cast<JSSVGMatrix*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    TransformationMatrix imp(*castedThis->impl());
    return jsNumber(exec, imp.b());
}

JSValue jsSVGMatrixC(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGMatrix* castedThis = static_cast<JSSVGMatrix*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    TransformationMatrix imp(*castedThis->impl());
    return jsNumber(exec, imp.c());
}

JSValue jsSVGMatrixD(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGMatrix* castedThis = static_cast<JSSVGMatrix*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    TransformationMatrix imp(*castedThis->impl());
    return jsNumber(exec, imp.d());
}

JSValue jsSVGMatrixE(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGMatrix* castedThis = static_cast<JSSVGMatrix*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    TransformationMatrix imp(*castedThis->impl());
    return jsNumber(exec, imp.e());
}

JSValue jsSVGMatrixF(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGMatrix* castedThis = static_cast<JSSVGMatrix*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    TransformationMatrix imp(*castedThis->impl());
    return jsNumber(exec, imp.f());
}

void JSSVGMatrix::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSSVGMatrix, Base>(exec, propertyName, value, &JSSVGMatrixTable, this, slot);
}

void setJSSVGMatrixA(ExecState* exec, JSObject* thisObject, JSValue value)
{
    TransformationMatrix imp(*static_cast<JSSVGMatrix*>(thisObject)->impl());
    imp.setA(value.toNumber(exec));
        static_cast<JSSVGMatrix*>(thisObject)->impl()->commitChange(imp, static_cast<JSSVGMatrix*>(thisObject)->context());
}

void setJSSVGMatrixB(ExecState* exec, JSObject* thisObject, JSValue value)
{
    TransformationMatrix imp(*static_cast<JSSVGMatrix*>(thisObject)->impl());
    imp.setB(value.toNumber(exec));
        static_cast<JSSVGMatrix*>(thisObject)->impl()->commitChange(imp, static_cast<JSSVGMatrix*>(thisObject)->context());
}

void setJSSVGMatrixC(ExecState* exec, JSObject* thisObject, JSValue value)
{
    TransformationMatrix imp(*static_cast<JSSVGMatrix*>(thisObject)->impl());
    imp.setC(value.toNumber(exec));
        static_cast<JSSVGMatrix*>(thisObject)->impl()->commitChange(imp, static_cast<JSSVGMatrix*>(thisObject)->context());
}

void setJSSVGMatrixD(ExecState* exec, JSObject* thisObject, JSValue value)
{
    TransformationMatrix imp(*static_cast<JSSVGMatrix*>(thisObject)->impl());
    imp.setD(value.toNumber(exec));
        static_cast<JSSVGMatrix*>(thisObject)->impl()->commitChange(imp, static_cast<JSSVGMatrix*>(thisObject)->context());
}

void setJSSVGMatrixE(ExecState* exec, JSObject* thisObject, JSValue value)
{
    TransformationMatrix imp(*static_cast<JSSVGMatrix*>(thisObject)->impl());
    imp.setE(value.toNumber(exec));
        static_cast<JSSVGMatrix*>(thisObject)->impl()->commitChange(imp, static_cast<JSSVGMatrix*>(thisObject)->context());
}

void setJSSVGMatrixF(ExecState* exec, JSObject* thisObject, JSValue value)
{
    TransformationMatrix imp(*static_cast<JSSVGMatrix*>(thisObject)->impl());
    imp.setF(value.toNumber(exec));
        static_cast<JSSVGMatrix*>(thisObject)->impl()->commitChange(imp, static_cast<JSSVGMatrix*>(thisObject)->context());
}

JSValue JSC_HOST_CALL jsSVGMatrixPrototypeFunctionMultiply(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGMatrix::s_info))
        return throwError(exec, TypeError);
    JSSVGMatrix* castedThisObj = static_cast<JSSVGMatrix*>(asObject(thisValue));
    JSSVGPODTypeWrapper<TransformationMatrix>* wrapper = castedThisObj->impl();
    TransformationMatrix imp(*wrapper);
    TransformationMatrix secondMatrix = toSVGMatrix(args.at(0));


    JSC::JSValue result = toJS(exec, deprecatedGlobalObjectForPrototype(exec), JSSVGStaticPODTypeWrapper<TransformationMatrix>::create(imp.multiply(secondMatrix)).get(), castedThisObj->context());
    return result;
}

JSValue JSC_HOST_CALL jsSVGMatrixPrototypeFunctionInverse(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGMatrix::s_info))
        return throwError(exec, TypeError);
    JSSVGMatrix* castedThisObj = static_cast<JSSVGMatrix*>(asObject(thisValue));
    return castedThisObj->inverse(exec, args);
}

JSValue JSC_HOST_CALL jsSVGMatrixPrototypeFunctionTranslate(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGMatrix::s_info))
        return throwError(exec, TypeError);
    JSSVGMatrix* castedThisObj = static_cast<JSSVGMatrix*>(asObject(thisValue));
    JSSVGPODTypeWrapper<TransformationMatrix>* wrapper = castedThisObj->impl();
    TransformationMatrix imp(*wrapper);
    float x = args.at(0).toFloat(exec);
    float y = args.at(1).toFloat(exec);


    JSC::JSValue result = toJS(exec, deprecatedGlobalObjectForPrototype(exec), JSSVGStaticPODTypeWrapper<TransformationMatrix>::create(imp.translate(x, y)).get(), castedThisObj->context());
    return result;
}

JSValue JSC_HOST_CALL jsSVGMatrixPrototypeFunctionScale(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGMatrix::s_info))
        return throwError(exec, TypeError);
    JSSVGMatrix* castedThisObj = static_cast<JSSVGMatrix*>(asObject(thisValue));
    JSSVGPODTypeWrapper<TransformationMatrix>* wrapper = castedThisObj->impl();
    TransformationMatrix imp(*wrapper);
    float scaleFactor = args.at(0).toFloat(exec);


    JSC::JSValue result = toJS(exec, deprecatedGlobalObjectForPrototype(exec), JSSVGStaticPODTypeWrapper<TransformationMatrix>::create(imp.scale(scaleFactor)).get(), castedThisObj->context());
    return result;
}

JSValue JSC_HOST_CALL jsSVGMatrixPrototypeFunctionScaleNonUniform(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGMatrix::s_info))
        return throwError(exec, TypeError);
    JSSVGMatrix* castedThisObj = static_cast<JSSVGMatrix*>(asObject(thisValue));
    JSSVGPODTypeWrapper<TransformationMatrix>* wrapper = castedThisObj->impl();
    TransformationMatrix imp(*wrapper);
    float scaleFactorX = args.at(0).toFloat(exec);
    float scaleFactorY = args.at(1).toFloat(exec);


    JSC::JSValue result = toJS(exec, deprecatedGlobalObjectForPrototype(exec), JSSVGStaticPODTypeWrapper<TransformationMatrix>::create(imp.scaleNonUniform(scaleFactorX, scaleFactorY)).get(), castedThisObj->context());
    return result;
}

JSValue JSC_HOST_CALL jsSVGMatrixPrototypeFunctionRotate(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGMatrix::s_info))
        return throwError(exec, TypeError);
    JSSVGMatrix* castedThisObj = static_cast<JSSVGMatrix*>(asObject(thisValue));
    JSSVGPODTypeWrapper<TransformationMatrix>* wrapper = castedThisObj->impl();
    TransformationMatrix imp(*wrapper);
    float angle = args.at(0).toFloat(exec);


    JSC::JSValue result = toJS(exec, deprecatedGlobalObjectForPrototype(exec), JSSVGStaticPODTypeWrapper<TransformationMatrix>::create(imp.rotate(angle)).get(), castedThisObj->context());
    return result;
}

JSValue JSC_HOST_CALL jsSVGMatrixPrototypeFunctionRotateFromVector(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGMatrix::s_info))
        return throwError(exec, TypeError);
    JSSVGMatrix* castedThisObj = static_cast<JSSVGMatrix*>(asObject(thisValue));
    return castedThisObj->rotateFromVector(exec, args);
}

JSValue JSC_HOST_CALL jsSVGMatrixPrototypeFunctionFlipX(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGMatrix::s_info))
        return throwError(exec, TypeError);
    JSSVGMatrix* castedThisObj = static_cast<JSSVGMatrix*>(asObject(thisValue));
    JSSVGPODTypeWrapper<TransformationMatrix>* wrapper = castedThisObj->impl();
    TransformationMatrix imp(*wrapper);


    JSC::JSValue result = toJS(exec, deprecatedGlobalObjectForPrototype(exec), JSSVGStaticPODTypeWrapper<TransformationMatrix>::create(imp.flipX()).get(), castedThisObj->context());
    return result;
}

JSValue JSC_HOST_CALL jsSVGMatrixPrototypeFunctionFlipY(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGMatrix::s_info))
        return throwError(exec, TypeError);
    JSSVGMatrix* castedThisObj = static_cast<JSSVGMatrix*>(asObject(thisValue));
    JSSVGPODTypeWrapper<TransformationMatrix>* wrapper = castedThisObj->impl();
    TransformationMatrix imp(*wrapper);


    JSC::JSValue result = toJS(exec, deprecatedGlobalObjectForPrototype(exec), JSSVGStaticPODTypeWrapper<TransformationMatrix>::create(imp.flipY()).get(), castedThisObj->context());
    return result;
}

JSValue JSC_HOST_CALL jsSVGMatrixPrototypeFunctionSkewX(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGMatrix::s_info))
        return throwError(exec, TypeError);
    JSSVGMatrix* castedThisObj = static_cast<JSSVGMatrix*>(asObject(thisValue));
    JSSVGPODTypeWrapper<TransformationMatrix>* wrapper = castedThisObj->impl();
    TransformationMatrix imp(*wrapper);
    float angle = args.at(0).toFloat(exec);


    JSC::JSValue result = toJS(exec, deprecatedGlobalObjectForPrototype(exec), JSSVGStaticPODTypeWrapper<TransformationMatrix>::create(imp.skewX(angle)).get(), castedThisObj->context());
    return result;
}

JSValue JSC_HOST_CALL jsSVGMatrixPrototypeFunctionSkewY(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGMatrix::s_info))
        return throwError(exec, TypeError);
    JSSVGMatrix* castedThisObj = static_cast<JSSVGMatrix*>(asObject(thisValue));
    JSSVGPODTypeWrapper<TransformationMatrix>* wrapper = castedThisObj->impl();
    TransformationMatrix imp(*wrapper);
    float angle = args.at(0).toFloat(exec);


    JSC::JSValue result = toJS(exec, deprecatedGlobalObjectForPrototype(exec), JSSVGStaticPODTypeWrapper<TransformationMatrix>::create(imp.skewY(angle)).get(), castedThisObj->context());
    return result;
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, JSSVGPODTypeWrapper<TransformationMatrix>* object, SVGElement* context)
{
    return getDOMObjectWrapper<JSSVGMatrix, JSSVGPODTypeWrapper<TransformationMatrix> >(exec, globalObject, object, context);
}
TransformationMatrix toSVGMatrix(JSC::JSValue value)
{
    return value.inherits(&JSSVGMatrix::s_info) ? (TransformationMatrix) *static_cast<JSSVGMatrix*>(asObject(value))->impl() : TransformationMatrix();
}

}

#endif // ENABLE(SVG)
