/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(3D_CANVAS)

#include "JSCanvasArrayBuffer.h"

#include "CanvasArrayBuffer.h"
#include <runtime/JSNumberCell.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSCanvasArrayBuffer);

/* Hash table */

static const HashTableValue JSCanvasArrayBufferTableValues[2] =
{
    { "byteLength", DontDelete|ReadOnly, (intptr_t)jsCanvasArrayBufferByteLength, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSCanvasArrayBufferTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSCanvasArrayBufferTableValues, 0 };
#else
    { 2, 1, JSCanvasArrayBufferTableValues, 0 };
#endif

/* Hash table for prototype */

static const HashTableValue JSCanvasArrayBufferPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSCanvasArrayBufferPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSCanvasArrayBufferPrototypeTableValues, 0 };
#else
    { 1, 0, JSCanvasArrayBufferPrototypeTableValues, 0 };
#endif

const ClassInfo JSCanvasArrayBufferPrototype::s_info = { "CanvasArrayBufferPrototype", 0, &JSCanvasArrayBufferPrototypeTable, 0 };

JSObject* JSCanvasArrayBufferPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSCanvasArrayBuffer>(exec, globalObject);
}

const ClassInfo JSCanvasArrayBuffer::s_info = { "CanvasArrayBuffer", 0, &JSCanvasArrayBufferTable, 0 };

JSCanvasArrayBuffer::JSCanvasArrayBuffer(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<CanvasArrayBuffer> impl)
    : DOMObjectWithGlobalPointer(structure, globalObject)
    , m_impl(impl)
{
}

JSCanvasArrayBuffer::~JSCanvasArrayBuffer()
{
    forgetDOMObject(*Heap::heap(this)->globalData(), impl());
}

JSObject* JSCanvasArrayBuffer::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSCanvasArrayBufferPrototype(JSCanvasArrayBufferPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSCanvasArrayBuffer::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCanvasArrayBuffer, Base>(exec, &JSCanvasArrayBufferTable, this, propertyName, slot);
}

bool JSCanvasArrayBuffer::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSCanvasArrayBuffer, Base>(exec, &JSCanvasArrayBufferTable, this, propertyName, descriptor);
}

JSValue jsCanvasArrayBufferByteLength(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSCanvasArrayBuffer* castedThis = static_cast<JSCanvasArrayBuffer*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    CanvasArrayBuffer* imp = static_cast<CanvasArrayBuffer*>(castedThis->impl());
    return jsNumber(exec, imp->byteLength());
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, CanvasArrayBuffer* object)
{
    return getDOMObjectWrapper<JSCanvasArrayBuffer>(exec, globalObject, object);
}
CanvasArrayBuffer* toCanvasArrayBuffer(JSC::JSValue value)
{
    return value.inherits(&JSCanvasArrayBuffer::s_info) ? static_cast<JSCanvasArrayBuffer*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(3D_CANVAS)
