/****************************************************************************
**
** Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** This file is part of the demonstration applications of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights.  These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** Nokia at qt-info@nokia.com.
**
**
**
**
**
**
**
**
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef MAIN_WINDOW_H
#define MAIN_WINDOW_H

#include <QtGui>
#include <QPixmap>

class DemoTextItem;
class ImageItem;

class MainWindow : public QGraphicsView
{
    Q_OBJECT

public:
    MainWindow(QWidget *parent = 0);
    ~MainWindow();
    void enableMask(bool enable);
    void toggleFullscreen();
    int performBenchmark();
    void switchTimerOnOff(bool on);
    void start();

    QGraphicsScene *scene;
    bool loop;

    // FPS stuff:
    QList<QTime> frameTimeList;
    QList<float> fpsHistory;
    float currentFps;
    float fpsMedian;
    DemoTextItem *fpsLabel;

protected:
    // Overidden methods:
    void showEvent(QShowEvent *event);
    void keyPressEvent(QKeyEvent *event);
    void resizeEvent(QResizeEvent *event);
    void drawBackground(QPainter *painter, const QRectF &rect);
    void drawItems(QPainter *painter, int numItems, QGraphicsItem ** items, const QStyleOptionGraphicsItem* options);
    void focusInEvent(QFocusEvent *event);
    void focusOutEvent(QFocusEvent *event);

private slots:
    void tick();

private:
    void setupWidget();
    void setupSceneItems();
    void drawBackgroundToPixmap();
    void setupScene();
    bool measureFps();
    void forceFpsMedianCalculation();
    void checkAdapt();
    void setRenderingSystem();

    QTimer updateTimer;
    QTime demoStartTime;
    QTime fpsTime;
    QPixmap background;
    ImageItem *companyLogo;
    ImageItem *qtLogo;
    bool doneAdapt;
    bool useTimer;
    DemoTextItem *pausedLabel;
};

#endif // MAIN_WINDOW_H

