/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLFrameSetElement.h"

#include "AtomicString.h"
#include "EventListener.h"
#include "Frame.h"
#include "HTMLFrameSetElement.h"
#include "JSDOMGlobalObject.h"
#include "JSEventListener.h"
#include "KURL.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLFrameSetElement);

/* Hash table */

static const HashTableValue JSHTMLFrameSetElementTableValues[12] =
{
    { "cols", DontDelete, (intptr_t)jsHTMLFrameSetElementCols, (intptr_t)setJSHTMLFrameSetElementCols },
    { "rows", DontDelete, (intptr_t)jsHTMLFrameSetElementRows, (intptr_t)setJSHTMLFrameSetElementRows },
    { "onbeforeunload", DontDelete|DontEnum, (intptr_t)jsHTMLFrameSetElementOnbeforeunload, (intptr_t)setJSHTMLFrameSetElementOnbeforeunload },
    { "onhashchange", DontDelete|DontEnum, (intptr_t)jsHTMLFrameSetElementOnhashchange, (intptr_t)setJSHTMLFrameSetElementOnhashchange },
    { "onmessage", DontDelete|DontEnum, (intptr_t)jsHTMLFrameSetElementOnmessage, (intptr_t)setJSHTMLFrameSetElementOnmessage },
    { "onoffline", DontDelete|DontEnum, (intptr_t)jsHTMLFrameSetElementOnoffline, (intptr_t)setJSHTMLFrameSetElementOnoffline },
    { "ononline", DontDelete|DontEnum, (intptr_t)jsHTMLFrameSetElementOnonline, (intptr_t)setJSHTMLFrameSetElementOnonline },
    { "onresize", DontDelete|DontEnum, (intptr_t)jsHTMLFrameSetElementOnresize, (intptr_t)setJSHTMLFrameSetElementOnresize },
    { "onstorage", DontDelete|DontEnum, (intptr_t)jsHTMLFrameSetElementOnstorage, (intptr_t)setJSHTMLFrameSetElementOnstorage },
    { "onunload", DontDelete|DontEnum, (intptr_t)jsHTMLFrameSetElementOnunload, (intptr_t)setJSHTMLFrameSetElementOnunload },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsHTMLFrameSetElementConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSHTMLFrameSetElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 31, JSHTMLFrameSetElementTableValues, 0 };
#else
    { 32, 31, JSHTMLFrameSetElementTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSHTMLFrameSetElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSHTMLFrameSetElementConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLFrameSetElementConstructorTableValues, 0 };
#else
    { 1, 0, JSHTMLFrameSetElementConstructorTableValues, 0 };
#endif

class JSHTMLFrameSetElementConstructor : public DOMConstructorObject {
public:
    JSHTMLFrameSetElementConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSHTMLFrameSetElementConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSHTMLFrameSetElementPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags)); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSHTMLFrameSetElementConstructor::s_info = { "HTMLFrameSetElementConstructor", 0, &JSHTMLFrameSetElementConstructorTable, 0 };

bool JSHTMLFrameSetElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLFrameSetElementConstructor, DOMObject>(exec, &JSHTMLFrameSetElementConstructorTable, this, propertyName, slot);
}

bool JSHTMLFrameSetElementConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLFrameSetElementConstructor, DOMObject>(exec, &JSHTMLFrameSetElementConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLFrameSetElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSHTMLFrameSetElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLFrameSetElementPrototypeTableValues, 0 };
#else
    { 1, 0, JSHTMLFrameSetElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSHTMLFrameSetElementPrototype::s_info = { "HTMLFrameSetElementPrototype", 0, &JSHTMLFrameSetElementPrototypeTable, 0 };

JSObject* JSHTMLFrameSetElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLFrameSetElement>(exec, globalObject);
}

const ClassInfo JSHTMLFrameSetElement::s_info = { "HTMLFrameSetElement", &JSHTMLElement::s_info, &JSHTMLFrameSetElementTable, 0 };

JSHTMLFrameSetElement::JSHTMLFrameSetElement(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLFrameSetElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

JSObject* JSHTMLFrameSetElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSHTMLFrameSetElementPrototype(JSHTMLFrameSetElementPrototype::createStructure(JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLFrameSetElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    if (canGetItemsForName(exec, static_cast<HTMLFrameSetElement*>(impl()), propertyName)) {
        slot.setCustom(this, nameGetter);
        return true;
    }
    return getStaticValueSlot<JSHTMLFrameSetElement, Base>(exec, &JSHTMLFrameSetElementTable, this, propertyName, slot);
}

bool JSHTMLFrameSetElement::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    if (canGetItemsForName(exec, static_cast<HTMLFrameSetElement*>(impl()), propertyName)) {
        PropertySlot slot;
        slot.setCustom(this, nameGetter);
        descriptor.setDescriptor(slot.getValue(exec, propertyName), ReadOnly | DontDelete | DontEnum);
        return true;
    }
    return getStaticValueDescriptor<JSHTMLFrameSetElement, Base>(exec, &JSHTMLFrameSetElementTable, this, propertyName, descriptor);
}

JSValue jsHTMLFrameSetElementCols(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLFrameSetElement* castedThis = static_cast<JSHTMLFrameSetElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLFrameSetElement* imp = static_cast<HTMLFrameSetElement*>(castedThis->impl());
    return jsString(exec, imp->cols());
}

JSValue jsHTMLFrameSetElementRows(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLFrameSetElement* castedThis = static_cast<JSHTMLFrameSetElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLFrameSetElement* imp = static_cast<HTMLFrameSetElement*>(castedThis->impl());
    return jsString(exec, imp->rows());
}

JSValue jsHTMLFrameSetElementOnbeforeunload(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLFrameSetElement* castedThis = static_cast<JSHTMLFrameSetElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLFrameSetElement* imp = static_cast<HTMLFrameSetElement*>(castedThis->impl());
    if (EventListener* listener = imp->onbeforeunload()) {
        if (JSObject* jsFunction = listener->jsFunction(imp->scriptExecutionContext()))
            return jsFunction;
    }
    return jsNull();
}

JSValue jsHTMLFrameSetElementOnhashchange(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLFrameSetElement* castedThis = static_cast<JSHTMLFrameSetElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLFrameSetElement* imp = static_cast<HTMLFrameSetElement*>(castedThis->impl());
    if (EventListener* listener = imp->onhashchange()) {
        if (JSObject* jsFunction = listener->jsFunction(imp->scriptExecutionContext()))
            return jsFunction;
    }
    return jsNull();
}

JSValue jsHTMLFrameSetElementOnmessage(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLFrameSetElement* castedThis = static_cast<JSHTMLFrameSetElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLFrameSetElement* imp = static_cast<HTMLFrameSetElement*>(castedThis->impl());
    if (EventListener* listener = imp->onmessage()) {
        if (JSObject* jsFunction = listener->jsFunction(imp->scriptExecutionContext()))
            return jsFunction;
    }
    return jsNull();
}

JSValue jsHTMLFrameSetElementOnoffline(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLFrameSetElement* castedThis = static_cast<JSHTMLFrameSetElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLFrameSetElement* imp = static_cast<HTMLFrameSetElement*>(castedThis->impl());
    if (EventListener* listener = imp->onoffline()) {
        if (JSObject* jsFunction = listener->jsFunction(imp->scriptExecutionContext()))
            return jsFunction;
    }
    return jsNull();
}

JSValue jsHTMLFrameSetElementOnonline(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLFrameSetElement* castedThis = static_cast<JSHTMLFrameSetElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLFrameSetElement* imp = static_cast<HTMLFrameSetElement*>(castedThis->impl());
    if (EventListener* listener = imp->ononline()) {
        if (JSObject* jsFunction = listener->jsFunction(imp->scriptExecutionContext()))
            return jsFunction;
    }
    return jsNull();
}

JSValue jsHTMLFrameSetElementOnresize(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLFrameSetElement* castedThis = static_cast<JSHTMLFrameSetElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLFrameSetElement* imp = static_cast<HTMLFrameSetElement*>(castedThis->impl());
    if (EventListener* listener = imp->onresize()) {
        if (JSObject* jsFunction = listener->jsFunction(imp->scriptExecutionContext()))
            return jsFunction;
    }
    return jsNull();
}

JSValue jsHTMLFrameSetElementOnstorage(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLFrameSetElement* castedThis = static_cast<JSHTMLFrameSetElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLFrameSetElement* imp = static_cast<HTMLFrameSetElement*>(castedThis->impl());
    if (EventListener* listener = imp->onstorage()) {
        if (JSObject* jsFunction = listener->jsFunction(imp->scriptExecutionContext()))
            return jsFunction;
    }
    return jsNull();
}

JSValue jsHTMLFrameSetElementOnunload(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLFrameSetElement* castedThis = static_cast<JSHTMLFrameSetElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLFrameSetElement* imp = static_cast<HTMLFrameSetElement*>(castedThis->impl());
    if (EventListener* listener = imp->onunload()) {
        if (JSObject* jsFunction = listener->jsFunction(imp->scriptExecutionContext()))
            return jsFunction;
    }
    return jsNull();
}

JSValue jsHTMLFrameSetElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLFrameSetElement* domObject = static_cast<JSHTMLFrameSetElement*>(asObject(slot.slotBase()));
    return JSHTMLFrameSetElement::getConstructor(exec, domObject->globalObject());
}
void JSHTMLFrameSetElement::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSHTMLFrameSetElement, Base>(exec, propertyName, value, &JSHTMLFrameSetElementTable, this, slot);
}

void setJSHTMLFrameSetElementCols(ExecState* exec, JSObject* thisObject, JSValue value)
{
    HTMLFrameSetElement* imp = static_cast<HTMLFrameSetElement*>(static_cast<JSHTMLFrameSetElement*>(thisObject)->impl());
    imp->setCols(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLFrameSetElementRows(ExecState* exec, JSObject* thisObject, JSValue value)
{
    HTMLFrameSetElement* imp = static_cast<HTMLFrameSetElement*>(static_cast<JSHTMLFrameSetElement*>(thisObject)->impl());
    imp->setRows(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLFrameSetElementOnbeforeunload(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    HTMLFrameSetElement* imp = static_cast<HTMLFrameSetElement*>(static_cast<JSHTMLFrameSetElement*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext(), exec);
    if (!globalObject)
        return;
    imp->setOnbeforeunload(globalObject->createJSAttributeEventListener(value));
}

void setJSHTMLFrameSetElementOnhashchange(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    HTMLFrameSetElement* imp = static_cast<HTMLFrameSetElement*>(static_cast<JSHTMLFrameSetElement*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext(), exec);
    if (!globalObject)
        return;
    imp->setOnhashchange(globalObject->createJSAttributeEventListener(value));
}

void setJSHTMLFrameSetElementOnmessage(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    HTMLFrameSetElement* imp = static_cast<HTMLFrameSetElement*>(static_cast<JSHTMLFrameSetElement*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext(), exec);
    if (!globalObject)
        return;
    imp->setOnmessage(globalObject->createJSAttributeEventListener(value));
}

void setJSHTMLFrameSetElementOnoffline(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    HTMLFrameSetElement* imp = static_cast<HTMLFrameSetElement*>(static_cast<JSHTMLFrameSetElement*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext(), exec);
    if (!globalObject)
        return;
    imp->setOnoffline(globalObject->createJSAttributeEventListener(value));
}

void setJSHTMLFrameSetElementOnonline(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    HTMLFrameSetElement* imp = static_cast<HTMLFrameSetElement*>(static_cast<JSHTMLFrameSetElement*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext(), exec);
    if (!globalObject)
        return;
    imp->setOnonline(globalObject->createJSAttributeEventListener(value));
}

void setJSHTMLFrameSetElementOnresize(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    HTMLFrameSetElement* imp = static_cast<HTMLFrameSetElement*>(static_cast<JSHTMLFrameSetElement*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext(), exec);
    if (!globalObject)
        return;
    imp->setOnresize(globalObject->createJSAttributeEventListener(value));
}

void setJSHTMLFrameSetElementOnstorage(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    HTMLFrameSetElement* imp = static_cast<HTMLFrameSetElement*>(static_cast<JSHTMLFrameSetElement*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext(), exec);
    if (!globalObject)
        return;
    imp->setOnstorage(globalObject->createJSAttributeEventListener(value));
}

void setJSHTMLFrameSetElementOnunload(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    HTMLFrameSetElement* imp = static_cast<HTMLFrameSetElement*>(static_cast<JSHTMLFrameSetElement*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext(), exec);
    if (!globalObject)
        return;
    imp->setOnunload(globalObject->createJSAttributeEventListener(value));
}

JSValue JSHTMLFrameSetElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLFrameSetElementConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}


}
