/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGPolylineElement.h"

#include "CSSMutableStyleDeclaration.h"
#include "CSSStyleDeclaration.h"
#include "CSSValue.h"
#include "JSCSSStyleDeclaration.h"
#include "JSCSSValue.h"
#include "JSSVGAnimatedBoolean.h"
#include "JSSVGAnimatedString.h"
#include "JSSVGAnimatedTransformList.h"
#include "JSSVGElement.h"
#include "JSSVGMatrix.h"
#include "JSSVGPointList.h"
#include "JSSVGRect.h"
#include "JSSVGStringList.h"
#include "KURL.h"
#include "SVGElement.h"
#include "SVGPointList.h"
#include "SVGPolylineElement.h"
#include "SVGStringList.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGPolylineElement);

/* Hash table */

static const HashTableValue JSSVGPolylineElementTableValues[14] =
{
    { "requiredFeatures", DontDelete|ReadOnly, (intptr_t)jsSVGPolylineElementRequiredFeatures, (intptr_t)0 },
    { "requiredExtensions", DontDelete|ReadOnly, (intptr_t)jsSVGPolylineElementRequiredExtensions, (intptr_t)0 },
    { "systemLanguage", DontDelete|ReadOnly, (intptr_t)jsSVGPolylineElementSystemLanguage, (intptr_t)0 },
    { "xmllang", DontDelete, (intptr_t)jsSVGPolylineElementXmllang, (intptr_t)setJSSVGPolylineElementXmllang },
    { "xmlspace", DontDelete, (intptr_t)jsSVGPolylineElementXmlspace, (intptr_t)setJSSVGPolylineElementXmlspace },
    { "externalResourcesRequired", DontDelete|ReadOnly, (intptr_t)jsSVGPolylineElementExternalResourcesRequired, (intptr_t)0 },
    { "className", DontDelete|ReadOnly, (intptr_t)jsSVGPolylineElementClassName, (intptr_t)0 },
    { "style", DontDelete|ReadOnly, (intptr_t)jsSVGPolylineElementStyle, (intptr_t)0 },
    { "transform", DontDelete|ReadOnly, (intptr_t)jsSVGPolylineElementTransform, (intptr_t)0 },
    { "nearestViewportElement", DontDelete|ReadOnly, (intptr_t)jsSVGPolylineElementNearestViewportElement, (intptr_t)0 },
    { "farthestViewportElement", DontDelete|ReadOnly, (intptr_t)jsSVGPolylineElementFarthestViewportElement, (intptr_t)0 },
    { "points", DontDelete|ReadOnly, (intptr_t)jsSVGPolylineElementPoints, (intptr_t)0 },
    { "animatedPoints", DontDelete|ReadOnly, (intptr_t)jsSVGPolylineElementAnimatedPoints, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGPolylineElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 127, JSSVGPolylineElementTableValues, 0 };
#else
    { 33, 31, JSSVGPolylineElementTableValues, 0 };
#endif

/* Hash table for prototype */

static const HashTableValue JSSVGPolylineElementPrototypeTableValues[7] =
{
    { "hasExtension", DontDelete|Function, (intptr_t)jsSVGPolylineElementPrototypeFunctionHasExtension, (intptr_t)1 },
    { "getPresentationAttribute", DontDelete|Function, (intptr_t)jsSVGPolylineElementPrototypeFunctionGetPresentationAttribute, (intptr_t)1 },
    { "getBBox", DontDelete|Function, (intptr_t)jsSVGPolylineElementPrototypeFunctionGetBBox, (intptr_t)0 },
    { "getCTM", DontDelete|Function, (intptr_t)jsSVGPolylineElementPrototypeFunctionGetCTM, (intptr_t)0 },
    { "getScreenCTM", DontDelete|Function, (intptr_t)jsSVGPolylineElementPrototypeFunctionGetScreenCTM, (intptr_t)0 },
    { "getTransformToElement", DontDelete|Function, (intptr_t)jsSVGPolylineElementPrototypeFunctionGetTransformToElement, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGPolylineElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 2047, JSSVGPolylineElementPrototypeTableValues, 0 };
#else
    { 17, 15, JSSVGPolylineElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSSVGPolylineElementPrototype::s_info = { "SVGPolylineElementPrototype", 0, &JSSVGPolylineElementPrototypeTable, 0 };

JSObject* JSSVGPolylineElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGPolylineElement>(exec, globalObject);
}

bool JSSVGPolylineElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGPolylineElementPrototypeTable, this, propertyName, slot);
}

bool JSSVGPolylineElementPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSSVGPolylineElementPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSSVGPolylineElement::s_info = { "SVGPolylineElement", &JSSVGElement::s_info, &JSSVGPolylineElementTable, 0 };

JSSVGPolylineElement::JSSVGPolylineElement(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGPolylineElement> impl)
    : JSSVGElement(structure, globalObject, impl)
{
}

JSObject* JSSVGPolylineElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSSVGPolylineElementPrototype(JSSVGPolylineElementPrototype::createStructure(JSSVGElementPrototype::self(exec, globalObject)));
}

bool JSSVGPolylineElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGPolylineElement, Base>(exec, &JSSVGPolylineElementTable, this, propertyName, slot);
}

bool JSSVGPolylineElement::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGPolylineElement, Base>(exec, &JSSVGPolylineElementTable, this, propertyName, descriptor);
}

JSValue jsSVGPolylineElementRequiredFeatures(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGPolylineElement* castedThis = static_cast<JSSVGPolylineElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGPolylineElement* imp = static_cast<SVGPolylineElement*>(castedThis->impl());
    return toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->requiredFeatures()), imp);
}

JSValue jsSVGPolylineElementRequiredExtensions(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGPolylineElement* castedThis = static_cast<JSSVGPolylineElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGPolylineElement* imp = static_cast<SVGPolylineElement*>(castedThis->impl());
    return toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->requiredExtensions()), imp);
}

JSValue jsSVGPolylineElementSystemLanguage(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGPolylineElement* castedThis = static_cast<JSSVGPolylineElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGPolylineElement* imp = static_cast<SVGPolylineElement*>(castedThis->impl());
    return toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->systemLanguage()), imp);
}

JSValue jsSVGPolylineElementXmllang(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGPolylineElement* castedThis = static_cast<JSSVGPolylineElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGPolylineElement* imp = static_cast<SVGPolylineElement*>(castedThis->impl());
    return jsString(exec, imp->xmllang());
}

JSValue jsSVGPolylineElementXmlspace(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGPolylineElement* castedThis = static_cast<JSSVGPolylineElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGPolylineElement* imp = static_cast<SVGPolylineElement*>(castedThis->impl());
    return jsString(exec, imp->xmlspace());
}

JSValue jsSVGPolylineElementExternalResourcesRequired(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGPolylineElement* castedThis = static_cast<JSSVGPolylineElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGPolylineElement* imp = static_cast<SVGPolylineElement*>(castedThis->impl());
    RefPtr<SVGAnimatedBoolean> obj = imp->externalResourcesRequiredAnimated();
    return toJS(exec, castedThis->globalObject(), obj.get(), imp);
}

JSValue jsSVGPolylineElementClassName(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGPolylineElement* castedThis = static_cast<JSSVGPolylineElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGPolylineElement* imp = static_cast<SVGPolylineElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = imp->classNameAnimated();
    return toJS(exec, castedThis->globalObject(), obj.get(), imp);
}

JSValue jsSVGPolylineElementStyle(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGPolylineElement* castedThis = static_cast<JSSVGPolylineElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGPolylineElement* imp = static_cast<SVGPolylineElement*>(castedThis->impl());
    return toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->style()));
}

JSValue jsSVGPolylineElementTransform(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGPolylineElement* castedThis = static_cast<JSSVGPolylineElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGPolylineElement* imp = static_cast<SVGPolylineElement*>(castedThis->impl());
    RefPtr<SVGAnimatedTransformList> obj = imp->transformAnimated();
    return toJS(exec, castedThis->globalObject(), obj.get(), imp);
}

JSValue jsSVGPolylineElementNearestViewportElement(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGPolylineElement* castedThis = static_cast<JSSVGPolylineElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGPolylineElement* imp = static_cast<SVGPolylineElement*>(castedThis->impl());
    return toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->nearestViewportElement()));
}

JSValue jsSVGPolylineElementFarthestViewportElement(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGPolylineElement* castedThis = static_cast<JSSVGPolylineElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGPolylineElement* imp = static_cast<SVGPolylineElement*>(castedThis->impl());
    return toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->farthestViewportElement()));
}

JSValue jsSVGPolylineElementPoints(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGPolylineElement* castedThis = static_cast<JSSVGPolylineElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGPolylineElement* imp = static_cast<SVGPolylineElement*>(castedThis->impl());
    return toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->points()), imp);
}

JSValue jsSVGPolylineElementAnimatedPoints(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGPolylineElement* castedThis = static_cast<JSSVGPolylineElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGPolylineElement* imp = static_cast<SVGPolylineElement*>(castedThis->impl());
    return toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->animatedPoints()), imp);
}

void JSSVGPolylineElement::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSSVGPolylineElement, Base>(exec, propertyName, value, &JSSVGPolylineElementTable, this, slot);
}

void setJSSVGPolylineElementXmllang(ExecState* exec, JSObject* thisObject, JSValue value)
{
    SVGPolylineElement* imp = static_cast<SVGPolylineElement*>(static_cast<JSSVGPolylineElement*>(thisObject)->impl());
    imp->setXmllang(value.toString(exec));
}

void setJSSVGPolylineElementXmlspace(ExecState* exec, JSObject* thisObject, JSValue value)
{
    SVGPolylineElement* imp = static_cast<SVGPolylineElement*>(static_cast<JSSVGPolylineElement*>(thisObject)->impl());
    imp->setXmlspace(value.toString(exec));
}

JSValue JSC_HOST_CALL jsSVGPolylineElementPrototypeFunctionHasExtension(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGPolylineElement::s_info))
        return throwError(exec, TypeError);
    JSSVGPolylineElement* castedThisObj = static_cast<JSSVGPolylineElement*>(asObject(thisValue));
    SVGPolylineElement* imp = static_cast<SVGPolylineElement*>(castedThisObj->impl());
    const UString& extension = args.at(0).toString(exec);


    JSC::JSValue result = jsBoolean(imp->hasExtension(extension));
    return result;
}

JSValue JSC_HOST_CALL jsSVGPolylineElementPrototypeFunctionGetPresentationAttribute(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGPolylineElement::s_info))
        return throwError(exec, TypeError);
    JSSVGPolylineElement* castedThisObj = static_cast<JSSVGPolylineElement*>(asObject(thisValue));
    SVGPolylineElement* imp = static_cast<SVGPolylineElement*>(castedThisObj->impl());
    const UString& name = args.at(0).toString(exec);


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->getPresentationAttribute(name)));
    return result;
}

JSValue JSC_HOST_CALL jsSVGPolylineElementPrototypeFunctionGetBBox(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGPolylineElement::s_info))
        return throwError(exec, TypeError);
    JSSVGPolylineElement* castedThisObj = static_cast<JSSVGPolylineElement*>(asObject(thisValue));
    SVGPolylineElement* imp = static_cast<SVGPolylineElement*>(castedThisObj->impl());


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), JSSVGStaticPODTypeWrapper<FloatRect>::create(imp->getBBox()).get(), imp);
    return result;
}

JSValue JSC_HOST_CALL jsSVGPolylineElementPrototypeFunctionGetCTM(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGPolylineElement::s_info))
        return throwError(exec, TypeError);
    JSSVGPolylineElement* castedThisObj = static_cast<JSSVGPolylineElement*>(asObject(thisValue));
    SVGPolylineElement* imp = static_cast<SVGPolylineElement*>(castedThisObj->impl());


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), JSSVGStaticPODTypeWrapper<TransformationMatrix>::create(imp->getCTM()).get(), imp);
    return result;
}

JSValue JSC_HOST_CALL jsSVGPolylineElementPrototypeFunctionGetScreenCTM(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGPolylineElement::s_info))
        return throwError(exec, TypeError);
    JSSVGPolylineElement* castedThisObj = static_cast<JSSVGPolylineElement*>(asObject(thisValue));
    SVGPolylineElement* imp = static_cast<SVGPolylineElement*>(castedThisObj->impl());


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), JSSVGStaticPODTypeWrapper<TransformationMatrix>::create(imp->getScreenCTM()).get(), imp);
    return result;
}

JSValue JSC_HOST_CALL jsSVGPolylineElementPrototypeFunctionGetTransformToElement(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGPolylineElement::s_info))
        return throwError(exec, TypeError);
    JSSVGPolylineElement* castedThisObj = static_cast<JSSVGPolylineElement*>(asObject(thisValue));
    SVGPolylineElement* imp = static_cast<SVGPolylineElement*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    SVGElement* element = toSVGElement(args.at(0));


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), JSSVGStaticPODTypeWrapper<TransformationMatrix>::create(imp->getTransformToElement(element, ec)).get(), imp);
    setDOMException(exec, ec);
    return result;
}


}

#endif // ENABLE(SVG)
