/*
 * This file is part of the DOM implementation for KDE.
 *
 * Copyright (C) 2003 Lars Knoll (knoll@kde.org)
 *
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

/* This file is mostly data generated by flex. Unfortunately flex
   can't handle 16bit strings directly, so we just copy the part of
   the code we need and modify it to our needs.

   Most of the defines below are to make sure we can easily use the
   flex generated code, using as little editing as possible.

   The flex syntax to generate the lexer are more or less directly
   copied from the CSS2.1 specs, with some fixes for comments and
   the important symbol.

   To regenerate, run flex on tokenizer.flex. After this, copy the
   data tables and the YY_DECL method over to this file. Remove the
   init code from YY_DECL and change the YY_END_OF_BUFFER to only call
   yyterminate().

*/

// --------- begin generated code -------------------


#include "CSSGrammar.h"

#define INITIAL 0
#define mediaquery 1
#define forkeyword 2

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined __STDC_VERSION__ && __STDC_VERSION__ >= 199901L
#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t;
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;
#endif /* ! C99 */
#define YY_NUM_RULES 69
#define YY_END_OF_BUFFER 70
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static yyconst flex_int16_t yy_accept[481] =
    {   0,
        0,    0,    0,    0,    0,    0,   70,   68,    2,    2,
       68,   68,   68,   68,   68,   68,   68,   68,   68,   57,
       68,   68,   15,   15,   15,   68,   68,   68,   68,   67,
       15,   15,   15,   66,   15,    2,    0,    0,    0,   14,
        0,    0,    0,   18,   18,    0,    8,    0,    0,    9,
        0,    0,   15,   15,   15,    0,   58,    0,   56,    0,
        0,   57,   55,   55,   55,   55,   55,   55,   55,   55,
       55,   16,   55,   55,   52,   55,    0,   55,    0,    0,
       35,   35,   35,   35,   35,   35,   35,    0,   63,   15,
        0,    0,   15,   15,    0,   15,   15,   15,    7,    6,

        5,   15,   15,   15,   15,    0,    0,    0,   14,    0,
        0,    0,   18,   18,    0,   18,   18,    0,    0,   14,
        0,    0,    4,   16,   15,    0,    0,   55,    0,   42,
       55,   37,   40,   55,   53,   44,   55,   43,   51,   55,
       46,   45,   41,   55,   55,   55,   55,   55,   55,    0,
       35,   35,    0,   35,   35,   35,   35,   35,   35,   35,
       35,   15,   15,   16,   15,   15,   64,   64,   15,   15,
       12,   10,   15,   13,    0,    0,    0,   17,   17,   18,
       18,   18,    0,    0,   15,    0,    1,   55,   55,   47,
       55,   54,   16,   48,   38,   55,   55,   55,    3,   35,

       35,   35,   35,   35,   35,   35,   35,   35,   35,   15,
       59,    0,   64,   64,   64,   63,   15,   11,    0,    0,
        0,   18,   18,   18,    0,   15,    0,    0,   55,   49,
       50,   55,   55,   35,   35,   35,   35,   35,   35,   35,
       20,   35,   15,   65,   64,   64,   64,   64,    0,    0,
        0,    0,   61,    0,   15,    0,    0,    0,   18,   18,
       18,    0,   15,   55,   55,   39,   35,   35,   35,   35,
       35,   21,   35,   35,   15,   65,   64,   64,   64,   64,
       64,    0,    0,    0,    0,    0,    0,    0,    0,    0,
       61,    0,    0,   15,    0,    0,   17,   17,   18,   18,

        0,   15,   55,   55,   35,   35,   35,   35,   19,   35,
       35,   15,   65,   64,   64,   64,   64,   64,   64,    0,
       60,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,   15,    0,    0,   18,   18,    0,   15,   55,
       55,   35,   35,   23,   35,   35,   35,   15,   65,   64,
       64,   64,   64,   64,   64,   64,    0,   60,    0,    0,
        0,   60,    0,    0,    0,    0,   18,   15,   55,   35,
       35,   35,   35,   65,    0,    0,    0,   36,   15,   35,
       35,   35,   35,   35,   35,   22,   24,   65,    0,    0,
        0,   15,   35,   35,   35,   35,   35,   35,    0,    0,

        0,   63,   35,   35,   35,   35,   35,   35,   35,   35,
        0,    0,    0,    0,    0,    0,   35,   35,   35,   35,
       25,   35,   35,   35,    0,   62,    0,    0,    0,    0,
       26,   35,   35,   35,   35,   27,   35,    0,    0,    0,
        0,   31,   35,   35,   35,   35,    0,    0,    0,   35,
       35,   35,   35,    0,    0,   35,   35,   29,   35,    0,
        0,   35,   33,   35,   30,    0,    0,   35,   28,   35,
        0,   35,   35,   35,   35,   34,   35,   35,   32,    0
    } ;

static yyconst flex_int32_t yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    4,    5,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    6,    7,    8,    9,   10,   11,   12,   13,   14,
       15,   16,   17,   12,   18,   19,   20,   21,   21,   21,
       21,   21,   21,   21,   21,   21,   21,   12,   22,   23,
       24,   25,   26,   27,   28,   29,   30,   31,   32,   33,
       34,   35,   36,   37,   38,   39,   40,   41,   42,   43,
       44,   45,   46,   47,   48,   49,   50,   51,   52,   53,
       12,   54,   12,   55,   56,   12,   57,   58,   59,   60,

       61,   62,   63,   64,   65,   37,   66,   67,   68,   69,
       70,   71,   72,   73,   74,   75,   76,   77,   78,   79,
       80,   81,   82,   83,   12,   84,    1,   85,   85,   85,
       85,   85,   85,   85,   85,   85,   85,   85,   85,   85,
       85,   85,   85,   85,   85,   85,   85,   85,   85,   85,
       85,   85,   85,   85,   85,   85,   85,   85,   85,   85,
       85,   85,   85,   85,   85,   85,   85,   85,   85,   85,
       85,   85,   85,   85,   85,   85,   85,   85,   85,   85,
       85,   85,   85,   85,   85,   85,   85,   85,   85,   85,
       85,   85,   85,   85,   85,   85,   85,   85,   85,   85,

       85,   85,   85,   85,   85,   85,   85,   85,   85,   85,
       85,   85,   85,   85,   85,   85,   85,   85,   85,   85,
       85,   85,   85,   85,   85,   85,   85,   85,   85,   85,
       85,   85,   85,   85,   85,   85,   85,   85,   85,   85,
       85,   85,   85,   85,   85,   85,   85,   85,   85,   85,
       85,   85,   85,   85,   85
    } ;

static yyconst flex_int32_t yy_meta[86] =
    {   0,
        1,    2,    3,    4,    4,    5,    6,    7,    6,    6,
        6,    6,    7,    8,    9,    6,    6,   10,    6,    6,
       11,    6,    6,    6,    6,   12,    6,   13,   13,   13,
       13,   13,   13,   14,   14,   14,   14,   14,   14,   14,
       14,   14,   14,   14,   14,   14,   14,   14,   14,   14,
       14,   14,   14,   14,    6,   14,   13,   13,   13,   13,
       13,   13,   14,   14,   14,   14,   14,   14,   14,   14,
       14,   14,   14,   14,   14,   14,   14,   14,   14,   14,
       14,    6,    6,    6,   14
    } ;

static yyconst flex_int16_t yy_base[552] =
    {   0,
        0,    0,   64,   66,   54,   56, 1515, 6578,   93,   98,
      107,   83,  155, 1489,   77, 1480,   99, 1477, 1470,  207,
     1477,  275,  100,  108,  125,  326, 1442, 1441, 1438, 6578,
      141,  110,  151, 6578,  105,  197,  295,   89,  107, 6578,
      387,  120,    0,  429, 1371,  471, 6578,  117,  532, 6578,
     1380,  269,  137,  176,  281,  574,  283, 1383, 1367, 1297,
     1329,    0, 1294,  249,  135,  282,  276,  153,   91,  169,
      299,  308,  318,  342, 1293,  328,  616,  102, 1326,  273,
     1288,  346,  127,  326,  369,  370,  374,  658, 6578,  208,
      700, 1320,  357,  418, 1314,  399,  314,  761, 6578, 6578,

     6578,  420,  421,  400,  398,  336,  461,  355,  367,  822,
      883,    0, 1284,  925,  967, 1283, 1028,  351,  423,  460,
     1089, 1150, 6578,  214,  465, 1320,  409, 1281, 1192, 1250,
      278, 1240, 1225,  427, 1222, 1221,  444, 1218, 1217,  416,
     1208, 1188, 1176,  451,  470,  467, 1173, 1253,  441, 1200,
      485, 1140, 1295,  490,  500,  505,  489,  502,  517, 1115,
     1356,  462, 1417, 1147,  554,  512,  193, 1133,  513, 1459,
      543,  544,  558,  559,  436,  501, 1520,    0, 1562, 1062,
     1623, 1684,  571, 1745,  563, 1092, 6578, 1053, 1806, 1000,
      568,  996,  529,  989,  988,  546, 1848,  589, 6578,  597,

      955, 1909,  566,  534,  588,  587,  608,  631, 1951, 2012,
     6578,    0,  203,  963,  947,  691, 2054,  564,  551, 2115,
        0, 2157, 2218, 2279, 2340,  646,  935,  637, 2401,  896,
      884, 2443,  616,  660, 2504,  681,  388,  668,  626,  694,
      878, 2546, 2607,    0,  288,  884,  876,  869,  793,  854,
      611,  614, 6578, 2668, 2710,  634, 2771,    0, 2813, 2874,
     2935, 2996, 3057, 3131, 3173, 3234,  669, 3295,  692,  716,
      696,  823,  729, 3337, 3398,    0,  641,  842,  781,  753,
      730,  829,  653,  834, 3459,  658, 3520,  894,  915,  920,
      957, 3581, 3642, 3684,  557, 3745, 6578,  684, 3806, 3867,

     3928, 3989, 4050, 4111,  727, 4172,  730,  682,  654,  697,
     4214, 4275,    0,  646,  590,  556,  553,  526,  496,  962,
     6578,  693,  734,  999, 4336, 4397,  690,  926, 1060, 4458,
     4519, 4580,  988,  711, 1013, 4622, 4664, 1042,  768, 4706,
     4767,  648, 4828,  454,  755,  757, 1074, 1033,    0,  489,
     6578, 6578, 6578, 6578, 6578, 6578, 1121,  838,  898, 4870,
     1182,  968, 1102, 4912, 4973,  729,  868,  785, 1066, 5005,
     1135,  873, 1020,    0, 5062, 5104, 5146, 6578,  830, 1050,
     1052, 1103, 1055, 1112,  836,  402,  386, 6578, 5188, 5230,
     5272,  755, 1137,  809,  916, 1091, 1123, 1161, 5314, 5356,

     1263, 1242, 1162, 1047,  874, 1138, 1144, 1209, 1185, 1178,
     1285, 1295, 1316, 1327, 1388, 5398,  966, 1223, 1088,  921,
      379, 1172, 1241, 1252, 1361, 6578, 1428, 5440, 1449, 5501,
      368, 1314, 1315,  969, 1118,  173, 1342, 1454, 5562, 1491,
     5604,  170, 1343, 1325,  824, 1341, 1531, 5646, 5688, 1374,
     1375, 1427, 1407, 5730, 5772, 1453, 1456,  154, 1328, 5814,
     5856, 1457,  112, 1080,  811, 5898, 1552, 1350,  109, 1413,
     1557, 1370, 1409, 1451, 1455,   90, 1373, 1522,   39, 6578,
     5959, 5964, 5977, 5982, 5987, 5994, 6004, 6017,  283, 6022,
     6032, 6045, 6059,  306, 6064, 6074, 6079, 6089, 6099, 6103,

      296, 6112, 6125, 6138, 6152, 6166, 6176, 6186, 6191, 6203,
      799, 6217,  920, 6222, 6234, 6247,  997, 6261, 1086, 6266,
     6278, 6291, 6304, 6317, 6330, 1087, 6335, 6348, 1206, 6353,
     6365, 6378, 6391, 6404, 6417, 6430, 6435, 6448, 1224, 6453,
     6465, 6478, 6491, 6504, 6517, 1227, 1292, 6530, 6543, 6553,
     6563
    } ;

static yyconst flex_int16_t yy_def[552] =
    {   0,
      480,    1,    1,    1,    1,    1,  480,  480,  480,  480,
      480,  481,  482,  480,  483,  480,  484,  480,  480,  480,
      480,  485,  486,  486,  486,  487,  480,  480,  480,  480,
      486,  486,  486,  480,  486,  480,  480,  480,  481,  480,
      488,  482,  489,  490,  490,  491,  480,  483,  492,  480,
      480,  480,  486,  486,  486,  487,   20,  493,  480,  494,
      480,   20,  495,  495,  495,  495,  495,  495,  495,  495,
      495,  495,  495,  495,  495,  495,  496,  495,  480,  485,
      497,  497,  497,  497,  497,  497,  497,  498,  480,  486,
      499,  480,  486,  486,  500,  486,  486,  486,  480,  480,

      480,  486,  486,  486,  486,  480,  481,  481,  481,  481,
      488,  501,  490,  490,  502,  490,  114,  503,  503,  503,
      503,  504,  480,  480,  486,  505,  506,  495,  507,  495,
      495,  495,  495,  495,  495,  495,  495,  495,  495,  495,
      495,  495,  495,  495,  495,  495,  495,  495,  495,  480,
      497,  497,  508,  497,  497,  497,  497,  497,  497,  497,
      497,  486,   98,  480,  486,  486,  509,  480,  486,   98,
      486,  486,  486,  486,  480,  510,  510,  511,  114,  490,
      114,  114,  503,  503,  486,  512,  480,  495,  148,  495,
      495,  495,  495,  495,  495,  495,  148,  495,  480,  497,

      497,  161,  497,  497,  497,  497,  497,  497,  161,   98,
      480,  513,  514,  480,  480,  515,   98,  486,  480,  516,
      517,  114,  114,  114,  503,  486,  512,  518,  148,  495,
      495,  148,  495,  497,  161,  497,  497,  497,  497,  497,
      497,  161,   98,  519,  520,  480,  480,  480,  521,  521,
      522,  523,  480,  524,   98,  480,  525,  526,  527,  527,
      260,  528,   98,  148,  148,  148,  497,  161,  497,  497,
      497,  497,  497,  161,   98,  529,  530,  480,  480,  480,
      480,  480,  522,  480,  531,  532,  533,  534,  534,  534,
      534,  534,  535,   98,  480,  536,  480,  537,  537,  299,

      538,   98,  148,  303,  497,  161,  497,  497,  497,  497,
      161,   98,  539,  540,  480,  480,  480,  480,  480,  480,
      480,  541,  541,  541,  541,  542,  543,  543,  543,  543,
      544,  545,  302,  480,  536,  299,  300,  538,  302,  303,
      303,  497,  161,  497,  497,  497,  497,  302,  546,  480,
      480,  480,  480,  480,  480,  480,  541,  541,  541,  325,
      543,  543,  543,  330,  545,  480,  337,  302,  341,  497,
      497,  497,  497,  547,  325,  330,  365,  480,  302,  497,
      497,  497,  497,  497,  497,  497,  497,  480,  325,  330,
      365,  302,  497,  497,  497,  497,  497,  497,  325,  330,

      545,  548,  497,  497,  497,  497,  497,  497,  497,  497,
      541,  543,  548,  548,  549,  550,  497,  497,  497,  497,
      497,  497,  497,  497,  480,  480,  549,  551,  549,  549,
      497,  497,  497,  497,  497,  497,  497,  549,  430,  549,
      430,  497,  497,  497,  497,  497,  549,  439,  430,  497,
      497,  497,  497,  439,  430,  497,  497,  497,  497,  439,
      430,  497,  497,  497,  497,  439,  549,  497,  497,  497,
      549,  497,  497,  497,  497,  497,  497,  497,  497,    0,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,

      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480
    } ;

static yyconst flex_int16_t yy_nxt[6664] =
    {   0,
        8,    9,   10,    9,    9,    9,   11,   12,   13,   14,
        8,    8,   15,    8,    8,   16,    8,   17,   18,   19,
       20,    8,   21,    8,    8,    8,   22,   23,   23,   23,
       23,   23,   23,   23,   23,   23,   23,   23,   23,   23,
       24,   23,   23,   23,   23,   23,   23,   25,   23,   23,
       23,   23,   23,   26,   27,   23,   23,   23,   23,   23,
       23,   23,   23,   23,   23,   23,   23,   23,   24,   23,
       23,   23,   23,   23,   23,   25,   23,   23,   23,   23,
       23,    8,   28,   29,   23,   30,   35,   30,   35,   40,
       40,   31,  153,   31,   36,   36,   36,   36,   36,   36,

       36,   36,   36,   36,   32,   33,   32,   33,   37,   37,
       37,   37,   37,   89,   40,   35,   51,   35,   89,   52,
       31,   89,   31,   89,   92,   93,   92,   93,  106,   40,
       49,  136,   32,   33,   32,   33,   41,  480,   89,   54,
      480,   95,   38,  153,  129,   34,  105,   34,   55,   94,
       89,  103,   56,   91,   89,  129,  106,  149,   91,  136,
       41,   91,  153,   91,   89,  153,  131,   54,  155,   96,
       49,   38,   42,   46,  105,   43,   55,   94,   91,  103,
      153,  102,   44,   44,   44,   44,   44,   44,  129,   89,
       91,  104,   92,   93,   91,  131,  155,   96,   36,   36,

       36,   36,   36,  137,   91,  135,  129,  153,   46,  102,
      212,   44,   44,   44,   44,   44,   44,   59,  214,  104,
      212,   89,  129,  153,   60,   61,  153,   62,  246,   91,
       92,   92,  137,  135,   63,   63,   64,   65,   66,   63,
       67,   68,   69,   63,   70,   63,   71,   72,   63,   73,
       63,   74,   75,   76,   63,   63,   63,   63,   63,   63,
       77,   91,   78,   63,   63,   64,   65,   66,   63,   67,
       68,   69,   70,   63,   71,   72,   63,   73,   63,   74,
       75,   76,   63,   63,   63,   63,   63,   63,  130,   52,
      480,   63,   80,  112,   89,  112,   37,   37,   37,   37,

       37,  480,  129,   57,   82,  212,  178,   83,  178,  124,
       84,  190,  125,  278,   85,   86,  130,   87,   63,   63,
      134,  132,  151,   63,   92,  140,   88,   89,   88,  129,
       38,  129,  133,   82,   91,  129,   83,  124,  138,   84,
      190,  125,   85,   86,  139,   87,   98,  141,  134,  132,
      151,   63,  129,   98,   98,   98,   98,   98,   98,   38,
      133,  129,   40,   40,  142,  156,  138,   91,  143,  144,
       89,  129,  139,  145,   40,  146,  141,  165,  175,  153,
      154,  129,   98,   98,   98,   98,   98,   98,   39,   39,
       39,  107,  142,  156,  109,  129,  143,  158,  144,  153,

      157,  159,  145,  146,   49,  270,  175,  110,   41,  154,
       91,   89,   89,   89,  110,  110,  110,  110,  110,  110,
       41,  153,  153,  153,  127,  480,  158,  153,  187,  157,
      159,   89,  153,   89,   89,   40,  193,  169,  173,  153,
      111,  153,  174,  110,  110,  110,  110,  110,  110,  114,
      171,   91,   91,   91,  191,  153,  114,  114,  114,  114,
      114,  114,  480,   39,  166,  169,  173,  172,   40,  129,
      174,   91,   40,   91,   91,   89,   49,  219,   89,  171,
      129,  194,  115,  191,  198,  114,  114,  114,  114,  114,
      114,  117,  166,  185,  129,  172,  192,  129,  117,  117,

      117,  117,  117,  117,  129,  219,  212,  153,   40,  195,
      194,  196,  198,   49,   41,   91,  200,  203,   91,  206,
      129,  356,  185,  129,  192,  211,  216,  117,  117,  117,
      117,  117,  117,   48,   48,   48,  118,  195,  153,  196,
      204,  207,  153,  153,  120,  200,  203,  205,  206,  193,
      208,  355,  121,  153,   41,  153,   89,  211,  153,  121,
      121,  121,  121,  121,  121,   91,   91,   89,  204,  207,
      153,   89,   89,  480,  165,  205,   89,   89,  354,  208,
      237,  353,  129,   40,  334,  122,  231,  153,  121,  121,
      121,  121,  121,  121,   98,  256,   91,   91,  230,  129,

      226,   98,   98,   98,   98,   98,   98,   91,  237,  218,
      236,   91,   91,  334,  231,  352,   91,   91,  284,  153,
      233,  129,  239,  256,   49,  234,  284,  230,  226,  238,
       98,   98,   98,   98,   98,   98,  148,  218,  236,  240,
      153,  153,  129,  148,  148,  148,  148,  148,  148,  233,
      153,  239,  228,  272,  234,  266,  187,  238,  212,   89,
      284,  153,  241,  212,  285,  370,  315,  287,  240,  129,
      284,  351,  148,  148,  148,  148,  148,  148,  161,  153,
      295,  263,  272,  266,  153,  161,  161,  161,  161,  161,
      161,  241,  249,  249,  249,  249,  249,  267,  251,   91,

      284,  153,  284,  252,  305,  253,  285,  153,  295,  345,
      263,  287,  271,  153,  161,  161,  161,  161,  161,  161,
      163,  153,  153,  307,  346,  267,  269,  163,  163,  163,
      163,  163,  163,  305,  153,  153,  480,  115,  345,  273,
      271,  284,  309,  287,  254,  153,  285,  153,  308,  153,
      153,  366,  307,  346,  269,  319,  163,  163,  163,  163,
      163,  163,   97,   97,   97,   97,   97,  273,  402,  153,
      309,  310,   90,  342,   89,  378,  344,  308,  318,  366,
      153,  170,  153,  153,  372,   90,  373,  285,  170,  170,
      170,  170,  170,  170,  249,  249,  249,  249,  249,  310,

      251,  342,   90,  378,  344,  252,  317,  253,  153,  221,
      153,  221,  379,  372,   91,  373,  368,  170,  170,  170,
      170,  170,  170,  108,  176,  176,  176,  108,  470,   40,
      282,  282,  282,  282,  282,  320,  320,  320,  320,  320,
      480,  379,  177,  253,  368,  284,  254,   90,  321,  177,
      177,  177,  177,  177,  177,  282,  282,  282,  282,  282,
      405,  480,  153,  398,  153,  452,  480,  316,  253,  180,
      180,  180,  180,  180,  392,   41,  153,  153,  177,  177,
      177,  177,  177,  177,   39,   39,   39,  107,  405,  153,
      109,  285,  398,  452,  281,  282,  282,  282,  282,  282,

      480,  280,  392,  110,  386,  284,  419,  254,  253,  279,
      110,  110,  110,  110,  110,  110,  282,  282,  282,  282,
      282,  282,  282,  282,  282,  282,  153,  153,  480,  253,
      244,  153,  244,  386,  253,  419,  111,  129,  284,  110,
      110,  110,  110,  110,  110,  179,  406,  254,  434,  129,
      228,  285,  179,  179,  179,  179,  179,  179,  282,  282,
      282,  282,  282,  320,  320,  320,  320,  320,  254,  153,
      480,  253,  248,  254,  153,  406,  321,  434,  115,  287,
      284,  179,  179,  179,  179,  179,  179,  181,  247,   97,
       97,   97,   97,   97,  181,  181,  181,  181,  181,  181,

      357,  320,  320,  320,  357,   90,  284,  258,  153,  258,
      254,  431,  444,  358,  108,  176,  176,  176,  108,  153,
       40,  287,  153,  181,  181,  181,  181,  181,  181,  116,
      116,  116,  116,  116,  162,  162,  162,  162,  162,  431,
      444,  129,  129,  119,  183,  183,  183,  119,  182,  129,
       90,  387,  285,  129,   40,  182,  182,  182,  182,  182,
      182,  361,  320,  320,  320,  361,   41,  188,  188,  188,
      188,  188,  284,  153,  362,  160,  160,  160,  160,  160,
      387,  393,  418,  394,  182,  182,  182,  182,  182,  182,
      119,  183,  183,  183,  119,   49,  276,  297,  276,  297,

      153,   40,  396,  153,  480,  153,  129,  228,  153,  184,
      393,  418,  394,  287,  284,  115,  184,  184,  184,  184,
      184,  184,  357,  320,  320,  320,  357,  153,  284,  407,
      396,  469,  433,  153,  395,  358,  201,  201,  201,  201,
      201,  153,   49,  397,  153,  184,  184,  184,  184,  184,
      184,   48,   48,   48,  118,  287,  153,  407,  215,  469,
      433,  408,  120,  395,  445,  153,  403,  164,  153,  404,
      121,  153,  397,  420,  285,  421,  153,  121,  121,  121,
      121,  121,  121,  361,  320,  320,  320,  361,  153,  408,
      153,  153,  445,  153,  284,  403,  362,  153,  404,  409,

      417,  435,  420,  122,  421,  410,  121,  121,  121,  121,
      121,  121,  189,  424,  153,  153,  313,  199,  313,  189,
      189,  189,  189,  189,  189,  153,  129,  409,  417,  129,
      435,  153,  423,  410,  349,  287,  349,  374,  153,  374,
      422,  129,  424,  413,  413,  413,  413,  413,  189,  189,
      189,  189,  189,  189,  147,  147,  147,  147,  147,  414,
      423,  129,  153,  432,  288,  288,  288,  288,  288,  422,
      129,  129,  436,  197,  129,  129,  153,  253,  129,  437,
      197,  197,  197,  197,  197,  197,  323,  359,  359,  359,
      323,  432,  284,  129,  153,  416,  328,  363,  363,  363,

      328,  436,  388,  129,  388,  153,  129,  284,  437,  197,
      197,  197,  197,  197,  197,  202,  254,  413,  413,  413,
      413,  413,  202,  202,  202,  202,  202,  202,  480,  480,
      480,  480,  480,  414,  129,  127,  115,  115,  285,  168,
      164,  153,  443,  150,  480,  442,  129,  129,  287,   57,
       77,  202,  202,  202,  202,  202,  202,  160,  160,  160,
      160,  160,  425,  425,  425,  425,  425,  153,  153,  416,
      446,  443,  451,  465,  442,  426,  209,   59,  153,  453,
      416,  153,  450,  209,  209,  209,  209,  209,  209,  425,
      425,  425,  425,  425,  153,  153,  153,  472,  127,  446,

      451,  465,  426,  153,  123,  456,  457,  453,  474,  153,
      450,  478,  209,  209,  209,  209,  209,  209,  162,  162,
      162,  162,  162,  153,  115,  472,  153,  153,  153,  425,
      425,  425,  425,  425,  456,  457,  474,  210,  459,  478,
      475,  428,  426,  473,  210,  210,  210,  210,  210,  210,
      425,  425,  425,  425,  425,  425,  425,  425,  425,  425,
      153,  101,  153,  426,  100,   99,  153,  459,  426,  475,
      462,  458,  473,  210,  210,  210,  210,  210,  210,  217,
      153,  428,  476,   79,  477,   58,  217,  217,  217,  217,
      217,  217,  425,  425,  425,  425,  425,   57,  463,  458,

      464,  468,  428,   50,  153,  426,  153,  428,  153,  153,
      153,  476,   47,  477,  480,  217,  217,  217,  217,  217,
      217,  108,  176,  176,  176,  108,  463,   40,  464,  468,
      480,  480,  425,  425,  425,  425,  425,  480,  480,  480,
      220,  480,  480,  480,  428,  426,  480,  220,  220,  220,
      220,  220,  220,  440,  440,  440,  440,  440,  447,  447,
      447,  447,  447,  480,  480,  480,  426,  479,  480,  480,
      480,  426,  480,   41,  480,  153,  220,  220,  220,  220,
      220,  220,  222,  480,  428,  480,  480,  480,  480,  222,
      222,  222,  222,  222,  222,  479,  480,  480,  480,  480,

      480,  480,  480,  480,  480,  428,  480,  480,  480,  480,
      428,  480,  480,  480,  480,  480,  480,  480,  222,  222,
      222,  222,  222,  222,  180,  180,  180,  180,  180,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  223,  480,  480,  480,  480,  480,  480,
      223,  223,  223,  223,  223,  223,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  223,
      223,  223,  223,  223,  223,  116,  116,  116,  116,  116,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,

      480,  480,  480,  480,  224,  480,  480,  480,  480,  480,
      480,  224,  224,  224,  224,  224,  224,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      224,  224,  224,  224,  224,  224,  119,  183,  183,  183,
      119,  480,  480,  480,  480,  480,  480,   40,  480,  480,
      480,  480,  480,  480,  480,  225,  480,  480,  480,  480,
      480,  480,  225,  225,  225,  225,  225,  225,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,   49,  480,

      480,  225,  225,  225,  225,  225,  225,  188,  188,  188,
      188,  188,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  229,  480,  480,  480,
      480,  480,  480,  229,  229,  229,  229,  229,  229,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  229,  229,  229,  229,  229,  229,  232,  480,
      480,  480,  480,  480,  480,  232,  232,  232,  232,  232,
      232,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,

      480,  480,  480,  480,  232,  232,  232,  232,  232,  232,
      201,  201,  201,  201,  201,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  235,
      480,  480,  480,  480,  480,  480,  235,  235,  235,  235,
      235,  235,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  235,  235,  235,  235,  235,
      235,  242,  480,  480,  480,  480,  480,  480,  242,  242,
      242,  242,  242,  242,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,

      480,  480,  480,  480,  480,  480,  480,  242,  242,  242,
      242,  242,  242,  162,  162,  162,  162,  162,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  243,  480,  480,  480,  480,  480,  480,  243,
      243,  243,  243,  243,  243,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  243,  243,
      243,  243,  243,  243,  255,  480,  480,  480,  480,  480,
      480,  255,  255,  255,  255,  255,  255,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,

      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      255,  255,  255,  255,  255,  255,  108,  176,  176,  176,
      108,  480,   40,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  257,  480,  480,  480,  480,
      480,  480,  257,  257,  257,  257,  257,  257,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,   41,  480,
      480,  257,  257,  257,  257,  257,  257,  259,  480,  480,
      480,  480,  480,  480,  259,  259,  259,  259,  259,  259,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,

      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  259,  259,  259,  259,  259,  259,  180,
      180,  180,  180,  180,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  260,  480,
      480,  480,  480,  480,  480,  260,  260,  260,  260,  260,
      260,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  260,  260,  260,  260,  260,  260,
      116,  116,  116,  116,  116,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  261,

      480,  480,  480,  480,  480,  480,  261,  261,  261,  261,
      261,  261,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  261,  261,  261,  261,  261,
      261,  119,  183,  183,  183,  119,  480,  480,  480,  480,
      480,  480,   40,  480,  480,  480,  480,  480,  480,  480,
      262,  480,  480,  480,  480,  480,  480,  262,  262,  262,
      262,  262,  262,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,   49,  480,  480,  262,  262,  262,  262,

      262,  262,  188,  188,  188,  188,  188,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  264,  480,  480,  480,  480,  480,  480,  264,  264,
      264,  264,  264,  264,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  264,  264,  264,
      264,  264,  264,  265,  480,  480,  480,  480,  480,  480,
      265,  265,  265,  265,  265,  265,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  265,

      265,  265,  265,  265,  265,  201,  201,  201,  201,  201,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  268,  480,  480,  480,  480,  480,
      480,  268,  268,  268,  268,  268,  268,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      268,  268,  268,  268,  268,  268,  274,  480,  480,  480,
      480,  480,  480,  274,  274,  274,  274,  274,  274,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,

      480,  480,  274,  274,  274,  274,  274,  274,  162,  162,
      162,  162,  162,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  275,  480,  480,
      480,  480,  480,  480,  275,  275,  275,  275,  275,  275,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  275,  275,  275,  275,  275,  275,  282,
      282,  282,  282,  288,  480,  290,  480,  480,  480,  480,
      290,  290,  291,  480,  480,  480,  480,  480,  292,  480,
      480,  480,  480,  480,  480,  292,  292,  292,  292,  292,

      292,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  293,  480,  480,  292,  292,  292,  292,  292,  292,
      294,  480,  480,  480,  480,  480,  480,  294,  294,  294,
      294,  294,  294,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  294,  294,  294,  294,
      294,  294,  108,  176,  176,  176,  108,  480,   40,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  296,  480,  480,  480,  480,  480,  480,  296,  296,

      296,  296,  296,  296,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,   41,  480,  480,  296,  296,  296,
      296,  296,  296,  298,  480,  480,  480,  480,  480,  480,
      298,  298,  298,  298,  298,  298,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  115,  480,  480,  298,
      298,  298,  298,  298,  298,  180,  180,  180,  180,  180,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  299,  480,  480,  480,  480,  480,

      480,  299,  299,  299,  299,  299,  299,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  115,  480,  480,
      299,  299,  299,  299,  299,  299,  116,  116,  116,  116,
      116,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  300,  480,  480,  480,  480,
      480,  480,  300,  300,  300,  300,  300,  300,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  300,  300,  300,  300,  300,  300,  119,  183,  183,

      183,  119,  480,  480,  480,  480,  480,  480,   40,  480,
      480,  480,  480,  480,  480,  480,  301,  480,  480,  480,
      480,  480,  480,  301,  301,  301,  301,  301,  301,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,   49,
      480,  480,  301,  301,  301,  301,  301,  301,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,   90,  480,  480,
      480,  480,  480,  480,   90,   90,   90,   90,   90,   90,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,

      480,  480,  480,  302,  480,  480,  480,  480,  480,  480,
      480,  480,  480,   90,   90,   90,   90,   90,   90,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  302,  188,  188,  188,  188,  188,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  303,  480,  480,  480,  480,  480,  480,  303,  303,
      303,  303,  303,  303,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  303,  303,  303,
      303,  303,  303,  304,  480,  480,  480,  480,  480,  480,

      304,  304,  304,  304,  304,  304,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  304,
      304,  304,  304,  304,  304,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  128,  480,  480,  480,  480,  480,
      480,  128,  128,  128,  128,  128,  128,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      128,  128,  128,  128,  128,  128,  201,  201,  201,  201,

      201,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  306,  480,  480,  480,  480,
      480,  480,  306,  306,  306,  306,  306,  306,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  306,  306,  306,  306,  306,  306,  311,  480,  480,
      480,  480,  480,  480,  311,  311,  311,  311,  311,  311,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  311,  311,  311,  311,  311,  311,  162,

      162,  162,  162,  162,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  312,  480,
      480,  480,  480,  480,  480,  312,  312,  312,  312,  312,
      312,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  312,  312,  312,  312,  312,  312,
      283,  283,  283,  322,  480,  480,  324,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  325,
      480,  480,  480,  480,  480,  480,  325,  325,  325,  325,
      325,  325,  480,  480,  480,  480,  480,  480,  480,  480,

      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  326,  480,  480,  325,  325,  325,  325,  325,
      325,  286,  286,  286,  327,  480,  480,  480,  480,  480,
      480,  480,  329,  480,  480,  480,  480,  480,  480,  480,
      330,  480,  480,  480,  480,  480,  480,  330,  330,  330,
      330,  330,  330,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  331,  480,  480,  330,  330,  330,  330,
      330,  330,  288,  288,  288,  288,  288,  480,  480,  480,
      480,  480,  480,  480,  480,  253,  480,  480,  480,  480,

      480,  332,  480,  480,  480,  480,  480,  480,  332,  332,
      332,  332,  332,  332,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  254,  480,  480,  332,  332,  332,
      332,  332,  332,  282,  282,  282,  282,  288,  480,  290,
      480,  480,  480,  480,  290,  290,  291,  480,  480,  480,
      480,  480,  292,  480,  480,  480,  480,  480,  480,  292,
      292,  292,  292,  292,  292,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  293,  480,  480,  292,  292,

      292,  292,  292,  292,  333,  480,  480,  480,  480,  480,
      480,  333,  333,  333,  333,  333,  333,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      333,  333,  333,  333,  333,  333,  108,  176,  176,  176,
      108,  480,   40,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  335,  480,  480,  480,  480,
      480,  480,  335,  335,  335,  335,  335,  335,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,   41,  480,

      480,  335,  335,  335,  335,  335,  335,  180,  180,  180,
      180,  180,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  336,  480,  480,  480,
      480,  480,  480,  336,  336,  336,  336,  336,  336,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  115,
      480,  480,  336,  336,  336,  336,  336,  336,  116,  116,
      116,  116,  116,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  337,  480,  480,
      480,  480,  480,  480,  337,  337,  337,  337,  337,  337,

      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  337,  337,  337,  337,  337,  337,  119,
      183,  183,  183,  119,  480,  480,  480,  480,  480,  480,
       40,  480,  480,  480,  480,  480,  480,  480,  338,  480,
      480,  480,  480,  480,  480,  338,  338,  338,  338,  338,
      338,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,   49,  480,  480,  338,  338,  338,  338,  338,  338,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,

      480,  480,  480,  480,  480,  480,  339,  480,  480,   90,
      480,  480,  480,  480,  480,  480,   90,   90,   90,   90,
       90,   90,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,   90,   90,   90,   90,   90,
       90,  188,  188,  188,  188,  188,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      340,  480,  480,  480,  480,  480,  480,  340,  340,  340,
      340,  340,  340,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,

      480,  480,  480,  480,  480,  480,  340,  340,  340,  340,
      340,  340,  147,  147,  147,  147,  147,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  341,  480,  480,  480,  480,  480,  480,  341,  341,
      341,  341,  341,  341,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  341,  341,  341,
      341,  341,  341,  201,  201,  201,  201,  201,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  343,  480,  480,  480,  480,  480,  480,  343,

      343,  343,  343,  343,  343,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  343,  343,
      343,  343,  343,  343,  347,  480,  480,  480,  480,  480,
      480,  347,  347,  347,  347,  347,  347,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      347,  347,  347,  347,  347,  347,  162,  162,  162,  162,
      162,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  348,  480,  480,  480,  480,

      480,  480,  348,  348,  348,  348,  348,  348,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  348,  348,  348,  348,  348,  348,  323,  359,  359,
      359,  323,  480,  284,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  360,  480,  480,  480,
      480,  480,  480,  360,  360,  360,  360,  360,  360,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  285,
      480,  480,  360,  360,  360,  360,  360,  360,  283,  283,

      283,  322,  480,  480,  324,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  325,  480,  480,
      480,  480,  480,  480,  325,  325,  325,  325,  325,  325,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      326,  480,  480,  325,  325,  325,  325,  325,  325,  328,
      363,  363,  363,  328,  480,  480,  480,  480,  480,  480,
      284,  480,  480,  480,  480,  480,  480,  480,  364,  480,
      480,  480,  480,  480,  480,  364,  364,  364,  364,  364,
      364,  480,  480,  480,  480,  480,  480,  480,  480,  480,

      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  287,  480,  480,  364,  364,  364,  364,  364,  364,
      286,  286,  286,  327,  480,  480,  480,  480,  480,  480,
      480,  329,  480,  480,  480,  480,  480,  480,  480,  330,
      480,  480,  480,  480,  480,  480,  330,  330,  330,  330,
      330,  330,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  331,  480,  480,  330,  330,  330,  330,  330,
      330,  288,  288,  288,  288,  288,  480,  480,  480,  480,
      480,  480,  480,  480,  253,  480,  480,  480,  480,  480,

      365,  480,  480,  480,  480,  480,  480,  365,  365,  365,
      365,  365,  365,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  254,  480,  480,  365,  365,  365,  365,
      365,  365,  367,  480,  480,  480,  480,  480,  480,  367,
      367,  367,  367,  367,  367,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  367,  367,
      367,  367,  367,  367,  113,  480,  480,  480,  480,  480,
      480,  113,  113,  113,  113,  113,  113,  480,  480,  480,

      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      113,  113,  113,  113,  113,  113,  369,  480,  480,  480,
      480,  480,  480,  369,  369,  369,  369,  369,  369,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  369,  369,  369,  369,  369,  369,  147,  147,
      147,  147,  147,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  128,  480,  480,
      480,  480,  480,  480,  128,  128,  128,  128,  128,  128,

      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  128,  128,  128,  128,  128,  128,  201,
      201,  201,  201,  201,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  371,  480,
      480,  480,  480,  480,  480,  371,  371,  371,  371,  371,
      371,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  371,  371,  371,  371,  371,  371,
      375,  480,  480,  480,  480,  480,  480,  375,  375,  375,

      375,  375,  375,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  375,  375,  375,  375,
      375,  375,  376,  480,  480,  480,  480,  480,  480,  376,
      376,  376,  376,  376,  376,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  376,  376,
      376,  376,  376,  376,  288,  288,  288,  288,  288,  480,
      480,  480,  480,  480,  480,  480,  480,  253,  480,  480,
      480,  480,  480,  377,  480,  480,  480,  480,  480,  480,

      377,  377,  377,  377,  377,  377,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  254,  480,  480,  377,
      377,  377,  377,  377,  377,  380,  480,  480,  480,  480,
      480,  480,  381,  480,  382,  480,  480,  480,  480,  383,
      384,  480,  480,  385,  480,  480,  480,  480,  153,  480,
      480,  480,  480,  480,  380,  480,  480,  480,  480,  480,
      381,  480,  382,  480,  480,  480,  480,  383,  384,  480,
      480,  385,  389,  480,  480,  480,  480,  480,  480,  389,
      389,  389,  389,  389,  389,  480,  480,  480,  480,  480,

      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  389,  389,
      389,  389,  389,  389,  390,  480,  480,  480,  480,  480,
      480,  390,  390,  390,  390,  390,  390,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      390,  390,  390,  390,  390,  390,  391,  480,  480,  480,
      480,  480,  480,  391,  391,  391,  391,  391,  391,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,

      480,  480,  391,  391,  391,  391,  391,  391,  399,  480,
      480,  480,  480,  480,  480,  399,  399,  399,  399,  399,
      399,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  399,  399,  399,  399,  399,  399,
      400,  480,  480,  480,  480,  480,  480,  400,  400,  400,
      400,  400,  400,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  400,  400,  400,  400,
      400,  400,  401,  480,  480,  480,  480,  480,  480,  401,

      401,  401,  401,  401,  401,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  401,  401,
      401,  401,  401,  401,  411,  480,  480,  480,  480,  480,
      480,  411,  411,  411,  411,  411,  411,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      411,  411,  411,  411,  411,  411,  412,  480,  480,  480,
      480,  480,  480,  412,  412,  412,  412,  412,  412,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,

      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  412,  412,  412,  412,  412,  412,  430,  480,
      480,  480,  480,  480,  480,  430,  430,  430,  430,  430,
      430,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  430,  430,  430,  430,  430,  430,
      439,  480,  480,  480,  480,  480,  480,  439,  439,  439,
      439,  439,  439,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  439,  439,  439,  439,

      439,  439,  440,  440,  440,  440,  440,  480,  480,  480,
      480,  480,  480,  480,  480,  426,  480,  480,  480,  480,
      480,  441,  480,  480,  480,  480,  480,  480,  441,  441,
      441,  441,  441,  441,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  428,  480,  480,  441,  441,  441,
      441,  441,  441,  447,  447,  447,  447,  447,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  448,  480,  480,  480,  480,  480,  480,  448,
      448,  448,  448,  448,  448,  480,  480,  480,  480,  480,

      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  448,  448,
      448,  448,  448,  448,  449,  480,  480,  480,  480,  480,
      480,  449,  449,  449,  449,  449,  449,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      449,  449,  449,  449,  449,  449,  454,  480,  480,  480,
      480,  480,  480,  454,  454,  454,  454,  454,  454,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,

      480,  480,  454,  454,  454,  454,  454,  454,  455,  480,
      480,  480,  480,  480,  480,  455,  455,  455,  455,  455,
      455,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  455,  455,  455,  455,  455,  455,
      460,  480,  480,  480,  480,  480,  480,  460,  460,  460,
      460,  460,  460,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  460,  460,  460,  460,
      460,  460,  461,  480,  480,  480,  480,  480,  480,  461,

      461,  461,  461,  461,  461,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  461,  461,
      461,  461,  461,  461,  466,  480,  480,  480,  480,  480,
      480,  466,  466,  466,  466,  466,  466,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      466,  466,  466,  466,  466,  466,  467,  480,  480,  480,
      480,  480,  480,  467,  467,  467,  467,  467,  467,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,

      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  467,  467,  467,  467,  467,  467,  471,  480,
      480,  480,  480,  480,  480,  471,  471,  471,  471,  471,
      471,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  471,  471,  471,  471,  471,  471,
       39,  480,  480,   39,   39,   39,   39,   39,   39,   39,
       39,   39,   39,   45,   45,  480,   45,   45,   48,  480,
      480,   48,   48,   48,   48,   48,   48,   48,   48,   48,
       48,   53,   53,  480,   53,   53,   81,  480,  480,   81,

       81,   90,  480,   90,   90,  480,   90,   90,   97,   97,
       97,   97,   97,   97,   97,   97,   97,   97,  108,  108,
      108,  108,  108,  108,  108,  108,  108,  108,  108,  108,
      108,  113,  113,  480,  113,  113,  116,  116,  116,  116,
      116,  116,  116,  116,  116,  116,  119,  119,  119,  119,
      119,  119,  119,  119,  119,  119,  119,  119,  119,  126,
      126,  126,  126,  126,  126,  126,  126,  126,  126,  126,
      126,  126,  126,  128,  128,  480,  128,  128,  147,  147,
      147,  147,  147,  147,  147,  147,  147,  147,  152,  152,
      480,  152,  152,  160,  160,  160,  160,  160,  160,  160,

      160,  160,  160,  162,  162,  162,  162,  162,  162,  162,
      162,  162,  162,  167,  167,  167,  180,  180,  180,  180,
      180,  180,  180,  180,  180,  180,   48,   48,  480,   48,
       48,   48,   48,   48,   48,   48,   48,   48,   48,  119,
      119,  119,  119,  119,  119,  119,  119,  119,  119,  119,
      119,  119,  126,  126,  126,  126,  126,  126,  126,  126,
      126,  126,  126,  126,  126,  126,  186,  186,  186,  186,
      186,  186,  186,  186,  186,  186,  186,  186,  186,  186,
      188,  188,  188,  188,  188,  188,  188,  188,  188,  188,
      201,  201,  201,  201,  201,  201,  201,  201,  201,  201,

      213,  213,  213,  213,   39,  480,  480,   39,   39,   39,
       39,   39,   39,   39,   39,   39,   39,  227,  227,  227,
      227,  227,  227,  227,  227,  227,  227,  227,  227,  227,
      227,  245,  245,  245,  245,  250,  250,  250,  250,  250,
      250,  480,  250,  250,  250,  250,  250,  250,   39,   39,
       39,   39,   39,   39,   39,   39,   39,   39,   39,   39,
       39,  186,  186,  186,  186,  186,  186,  186,  186,  186,
      186,  186,  186,  186,  186,  277,  277,  277,  277,  250,
      250,  250,  250,  250,  250,  480,  250,  250,  250,  250,
      250,  250,  283,  480,  480,  283,  283,  283,  283,  283,

      283,  283,  283,  283,  283,  286,  480,  480,  286,  286,
      286,  286,  286,  286,  286,  286,  286,  286,  289,  289,
      289,  289,  289,  289,  289,  289,  289,  289,  289,  289,
      289,   39,   39,   39,   39,   39,   39,   39,   39,   39,
       39,   39,   39,   39,  113,  113,  480,  113,  113,   48,
       48,   48,   48,   48,   48,   48,   48,   48,   48,   48,
       48,   48,  314,  314,  314,  314,  323,  323,  323,  323,
      323,  323,  323,  323,  323,  323,  323,  323,  323,  286,
      480,  480,  286,  286,  286,  286,  286,  286,  286,  286,
      286,  286,  328,  328,  328,  328,  328,  328,  328,  328,

      328,  328,  328,  328,  328,  250,  250,  250,  250,  250,
      480,  480,  250,  250,  250,  250,  250,  250,  289,  289,
      289,  289,  289,  289,  289,  289,  289,  289,  289,  289,
      289,   39,   39,   39,   39,   39,   39,   39,   39,   39,
       39,   39,   39,   39,  113,  113,  480,  113,  113,   48,
       48,   48,   48,   48,   48,   48,   48,   48,   48,   48,
       48,   48,  350,  350,  350,  350,  283,  283,  480,  283,
      283,  283,  283,  283,  283,  283,  283,  283,  283,  323,
      323,  323,  323,  323,  323,  323,  323,  323,  323,  323,
      323,  323,  286,  286,  480,  286,  286,  286,  286,  286,

      286,  286,  286,  286,  286,  328,  328,  328,  328,  328,
      328,  328,  328,  328,  328,  328,  328,  328,  250,  250,
      250,  250,  250,  480,  480,  250,  250,  250,  250,  250,
      250,  415,  415,  415,  415,  480,  480,  480,  480,  415,
      480,  480,  415,  415,  427,  427,  427,  427,  480,  480,
      480,  427,  427,  427,  480,  427,  427,  429,  429,  429,
      429,  429,  429,  429,  429,  429,  429,  438,  438,  438,
      438,  438,  438,  438,  438,  438,  438,    7,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,

      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480
    } ;

static yyconst flex_int16_t yy_chk[6664] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    3,    5,    4,    6,   15,
       12,    3,  479,    4,    9,    9,    9,    9,    9,   10,

       10,   10,   10,   10,    3,    3,    4,    4,   11,   11,
       11,   11,   11,   23,   39,    5,   17,    6,   35,   17,
        3,   24,    4,   32,   24,   24,   32,   32,   38,   48,
       15,   69,    3,    3,    4,    4,   12,   42,   25,   17,
       42,   25,   11,  476,   69,    3,   35,    4,   17,   24,
       53,   32,   17,   23,   31,   78,   38,   78,   35,   69,
       39,   24,  469,   32,   33,  463,   65,   17,   83,   25,
       48,   11,   13,   42,   35,   13,   17,   24,   25,   32,
       83,   31,   13,   13,   13,   13,   13,   13,   65,   54,
       53,   33,   54,   54,   31,   65,   83,   25,   36,   36,

       36,   36,   36,   70,   33,   68,   68,  458,   13,   31,
      167,   13,   13,   13,   13,   13,   13,   20,  167,   33,
      213,   90,   70,  442,   20,   20,  436,   20,  213,   54,
      124,  124,   70,   68,   20,   20,   20,   20,   20,   20,
       20,   20,   20,   20,   20,   20,   20,   20,   20,   20,
       20,   20,   20,   20,   20,   20,   20,   20,   20,   20,
       20,   90,   20,   20,   20,   20,   20,   20,   20,   20,
       20,   20,   20,   20,   20,   20,   20,   20,   20,   20,
       20,   20,   20,   20,   20,   20,   20,   20,   64,   52,
       80,   20,   22,  489,   55,  489,   37,   37,   37,   37,

       37,   57,   64,   57,   22,  245,  501,   22,  501,   52,
       22,  131,   55,  245,   22,   22,   64,   22,  494,  494,
       67,   66,   80,   57,   72,   72,   80,   97,   22,   67,
       37,  131,   66,   22,   55,   66,   22,   52,   71,   22,
      131,   55,   22,   22,   71,   22,   26,   73,   67,   66,
       80,   57,   71,   26,   26,   26,   26,   26,   26,   37,
       66,   72,  108,  118,   73,   84,   71,   97,   73,   74,
       93,   73,   71,   74,  109,   76,   73,   93,  106,   84,
       82,   76,   26,   26,   26,   26,   26,   26,   41,   41,
       41,   41,   73,   84,   41,   74,   73,   86,   74,   82,

       85,   87,   74,   76,  118,  237,  106,   41,  108,   82,
       93,  105,   96,  104,   41,   41,   41,   41,   41,   41,
      109,  431,   85,   86,  127,  119,   86,   87,  127,   85,
       87,   94,  421,  102,  103,  119,  140,   96,  104,  387,
       41,  237,  105,   41,   41,   41,   41,   41,   41,   44,
      102,  105,   96,  104,  134,  386,   44,   44,   44,   44,
       44,   44,  120,  107,   94,   96,  104,  103,  107,  140,
      105,   94,  120,  102,  103,  162,  119,  175,  125,  102,
      134,  144,   44,  134,  149,   44,   44,   44,   44,   44,
       44,   46,   94,  125,  149,  103,  137,  137,   46,   46,

       46,   46,   46,   46,  144,  175,  350,  344,  176,  145,
      144,  146,  149,  120,  107,  162,  151,  154,  125,  157,
      146,  319,  125,  145,  137,  166,  169,   46,   46,   46,
       46,   46,   46,   49,   49,   49,   49,  145,  151,  146,
      155,  158,  157,  154,   49,  151,  154,  156,  157,  193,
      159,  318,   49,  155,  176,  158,  171,  172,  156,   49,
       49,   49,   49,   49,   49,  166,  169,  165,  155,  158,
      159,  173,  174,  183,  165,  156,  185,  218,  317,  159,
      204,  316,  193,  183,  295,   49,  196,  204,   49,   49,
       49,   49,   49,   49,   56,  219,  171,  172,  191,  196,

      185,   56,   56,   56,   56,   56,   56,  165,  204,  173,
      203,  173,  174,  295,  196,  315,  185,  218,  251,  203,
      198,  191,  206,  219,  183,  200,  252,  191,  185,  205,
       56,   56,   56,   56,   56,   56,   77,  173,  203,  207,
      206,  205,  198,   77,   77,   77,   77,   77,   77,  198,
      200,  206,  228,  239,  200,  233,  228,  205,  277,  226,
      283,  207,  208,  314,  251,  342,  277,  252,  207,  233,
      286,  314,   77,   77,   77,   77,   77,   77,   88,  239,
      256,  226,  239,  233,  208,   88,   88,   88,   88,   88,
       88,  208,  216,  216,  216,  216,  216,  234,  216,  226,

      322,  342,  327,  216,  267,  216,  283,  309,  256,  308,
      226,  286,  238,  234,   88,   88,   88,   88,   88,   88,
       91,  238,  267,  269,  310,  234,  236,   91,   91,   91,
       91,   91,   91,  267,  236,  308,  323,  298,  308,  240,
      238,  323,  271,  327,  216,  269,  322,  240,  270,  271,
      310,  334,  269,  310,  236,  281,   91,   91,   91,   91,
       91,   91,   98,   98,   98,   98,   98,  240,  392,  270,
      271,  273,  392,  305,   98,  366,  307,  270,  280,  334,
      305,   98,  273,  307,  345,  339,  346,  323,   98,   98,
       98,   98,   98,   98,  249,  249,  249,  249,  249,  273,

      249,  305,  368,  366,  307,  249,  279,  249,  345,  511,
      346,  511,  368,  345,   98,  346,  339,   98,   98,   98,
       98,   98,   98,  110,  110,  110,  110,  110,  465,  110,
      282,  282,  282,  282,  282,  284,  284,  284,  284,  284,
      358,  368,  110,  282,  339,  358,  249,  379,  284,  110,
      110,  110,  110,  110,  110,  250,  250,  250,  250,  250,
      394,  250,  394,  385,  465,  445,  250,  278,  250,  367,
      367,  367,  367,  367,  379,  110,  272,  445,  110,  110,
      110,  110,  110,  110,  111,  111,  111,  111,  394,  385,
      111,  358,  385,  445,  248,  288,  288,  288,  288,  288,

      359,  247,  379,  111,  372,  359,  405,  250,  288,  246,
      111,  111,  111,  111,  111,  111,  289,  289,  289,  289,
      289,  290,  290,  290,  290,  290,  372,  405,  328,  289,
      513,  241,  513,  372,  290,  405,  111,  231,  328,  111,
      111,  111,  111,  111,  111,  114,  395,  288,  420,  230,
      227,  359,  114,  114,  114,  114,  114,  114,  291,  291,
      291,  291,  291,  320,  320,  320,  320,  320,  289,  395,
      362,  291,  215,  290,  420,  395,  320,  420,  114,  328,
      362,  114,  114,  114,  114,  114,  114,  115,  214,  333,
      333,  333,  333,  333,  115,  115,  115,  115,  115,  115,

      324,  324,  324,  324,  324,  333,  324,  517,  201,  517,
      291,  417,  434,  324,  335,  335,  335,  335,  335,  417,
      335,  362,  434,  115,  115,  115,  115,  115,  115,  117,
      117,  117,  117,  117,  348,  348,  348,  348,  348,  417,
      434,  195,  194,  338,  338,  338,  338,  338,  117,  192,
      348,  373,  324,  190,  338,  117,  117,  117,  117,  117,
      117,  329,  329,  329,  329,  329,  335,  369,  369,  369,
      369,  369,  329,  373,  329,  347,  347,  347,  347,  347,
      373,  380,  404,  381,  117,  117,  117,  117,  117,  117,
      121,  121,  121,  121,  121,  338,  519,  526,  519,  526,

      404,  121,  383,  380,  363,  381,  188,  186,  383,  121,
      380,  404,  381,  329,  363,  180,  121,  121,  121,  121,
      121,  121,  357,  357,  357,  357,  357,  347,  357,  396,
      383,  464,  419,  464,  382,  357,  371,  371,  371,  371,
      371,  419,  121,  384,  396,  121,  121,  121,  121,  121,
      121,  122,  122,  122,  122,  363,  382,  396,  168,  464,
      419,  397,  122,  382,  435,  384,  393,  164,  160,  393,
      122,  435,  384,  406,  357,  407,  397,  122,  122,  122,
      122,  122,  122,  361,  361,  361,  361,  361,  371,  397,
      393,  406,  435,  152,  361,  393,  361,  407,  393,  398,

      403,  422,  406,  122,  407,  398,  122,  122,  122,  122,
      122,  122,  129,  410,  398,  403,  529,  150,  529,  129,
      129,  129,  129,  129,  129,  422,  147,  398,  403,  143,
      422,  410,  409,  398,  539,  361,  539,  546,  409,  546,
      408,  142,  410,  402,  402,  402,  402,  402,  129,  129,
      129,  129,  129,  129,  148,  148,  148,  148,  148,  402,
      409,  141,  408,  418,  401,  401,  401,  401,  401,  408,
      139,  138,  423,  148,  136,  135,  418,  401,  133,  424,
      148,  148,  148,  148,  148,  148,  411,  411,  411,  411,
      411,  418,  411,  132,  423,  402,  412,  412,  412,  412,

      412,  423,  547,  130,  547,  424,  148,  412,  424,  148,
      148,  148,  148,  148,  148,  153,  401,  413,  413,  413,
      413,  413,  153,  153,  153,  153,  153,  153,  414,  414,
      414,  414,  414,  413,  128,  126,  116,  113,  411,   95,
       92,   81,  433,   79,  414,  432,   75,   63,  412,   61,
       60,  153,  153,  153,  153,  153,  153,  161,  161,  161,
      161,  161,  425,  425,  425,  425,  425,  432,  433,  413,
      437,  433,  444,  459,  432,  425,  161,   59,  444,  446,
      414,  459,  443,  161,  161,  161,  161,  161,  161,  415,
      415,  415,  415,  415,  446,  437,  443,  468,   58,  437,

      444,  459,  415,  468,   51,  450,  451,  446,  472,  161,
      443,  477,  161,  161,  161,  161,  161,  161,  163,  163,
      163,  163,  163,  472,   45,  468,  477,  450,  451,  427,
      427,  427,  427,  427,  450,  451,  472,  163,  453,  477,
      473,  415,  427,  470,  163,  163,  163,  163,  163,  163,
      429,  429,  429,  429,  429,  438,  438,  438,  438,  438,
      453,   29,  473,  429,   28,   27,  470,  453,  438,  473,
      456,  452,  470,  163,  163,  163,  163,  163,  163,  170,
      452,  427,  474,   21,  475,   19,  170,  170,  170,  170,
      170,  170,  440,  440,  440,  440,  440,   18,  456,  452,

      457,  462,  429,   16,  474,  440,  456,  438,  475,  457,
      462,  474,   14,  475,    7,  170,  170,  170,  170,  170,
      170,  177,  177,  177,  177,  177,  456,  177,  457,  462,
        0,    0,  447,  447,  447,  447,  447,    0,    0,    0,
      177,    0,    0,    0,  440,  447,    0,  177,  177,  177,
      177,  177,  177,  467,  467,  467,  467,  467,  471,  471,
      471,  471,  471,    0,    0,    0,  467,  478,    0,    0,
        0,  471,    0,  177,    0,  478,  177,  177,  177,  177,
      177,  177,  179,    0,  447,    0,    0,    0,    0,  179,
      179,  179,  179,  179,  179,  478,    0,    0,    0,    0,

        0,    0,    0,    0,    0,  467,    0,    0,    0,    0,
      471,    0,    0,    0,    0,    0,    0,    0,  179,  179,
      179,  179,  179,  179,  181,  181,  181,  181,  181,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,  181,    0,    0,    0,    0,    0,    0,
      181,  181,  181,  181,  181,  181,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,  181,
      181,  181,  181,  181,  181,  182,  182,  182,  182,  182,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,    0,  182,    0,    0,    0,    0,    0,
        0,  182,  182,  182,  182,  182,  182,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
      182,  182,  182,  182,  182,  182,  184,  184,  184,  184,
      184,    0,    0,    0,    0,    0,    0,  184,    0,    0,
        0,    0,    0,    0,    0,  184,    0,    0,    0,    0,
        0,    0,  184,  184,  184,  184,  184,  184,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  184,    0,

        0,  184,  184,  184,  184,  184,  184,  189,  189,  189,
      189,  189,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,  189,    0,    0,    0,
        0,    0,    0,  189,  189,  189,  189,  189,  189,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,  189,  189,  189,  189,  189,  189,  197,    0,
        0,    0,    0,    0,    0,  197,  197,  197,  197,  197,
      197,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,    0,  197,  197,  197,  197,  197,  197,
      202,  202,  202,  202,  202,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,  202,
        0,    0,    0,    0,    0,    0,  202,  202,  202,  202,
      202,  202,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,  202,  202,  202,  202,  202,
      202,  209,    0,    0,    0,    0,    0,    0,  209,  209,
      209,  209,  209,  209,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,  209,  209,  209,
      209,  209,  209,  210,  210,  210,  210,  210,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,  210,    0,    0,    0,    0,    0,    0,  210,
      210,  210,  210,  210,  210,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  210,  210,
      210,  210,  210,  210,  217,    0,    0,    0,    0,    0,
        0,  217,  217,  217,  217,  217,  217,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
      217,  217,  217,  217,  217,  217,  220,  220,  220,  220,
      220,    0,  220,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,  220,    0,    0,    0,    0,
        0,    0,  220,  220,  220,  220,  220,  220,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  220,    0,
        0,  220,  220,  220,  220,  220,  220,  222,    0,    0,
        0,    0,    0,    0,  222,  222,  222,  222,  222,  222,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,  222,  222,  222,  222,  222,  222,  223,
      223,  223,  223,  223,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  223,    0,
        0,    0,    0,    0,    0,  223,  223,  223,  223,  223,
      223,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  223,  223,  223,  223,  223,  223,
      224,  224,  224,  224,  224,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,  224,

        0,    0,    0,    0,    0,    0,  224,  224,  224,  224,
      224,  224,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,  224,  224,  224,  224,  224,
      224,  225,  225,  225,  225,  225,    0,    0,    0,    0,
        0,    0,  225,    0,    0,    0,    0,    0,    0,    0,
      225,    0,    0,    0,    0,    0,    0,  225,  225,  225,
      225,  225,  225,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,  225,    0,    0,  225,  225,  225,  225,

      225,  225,  229,  229,  229,  229,  229,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,  229,    0,    0,    0,    0,    0,    0,  229,  229,
      229,  229,  229,  229,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,  229,  229,  229,
      229,  229,  229,  232,    0,    0,    0,    0,    0,    0,
      232,  232,  232,  232,  232,  232,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,  232,

      232,  232,  232,  232,  232,  235,  235,  235,  235,  235,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  235,    0,    0,    0,    0,    0,
        0,  235,  235,  235,  235,  235,  235,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
      235,  235,  235,  235,  235,  235,  242,    0,    0,    0,
        0,    0,    0,  242,  242,  242,  242,  242,  242,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,  242,  242,  242,  242,  242,  242,  243,  243,
      243,  243,  243,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,  243,    0,    0,
        0,    0,    0,    0,  243,  243,  243,  243,  243,  243,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,  243,  243,  243,  243,  243,  243,  254,
      254,  254,  254,  254,    0,  254,    0,    0,    0,    0,
      254,  254,  254,    0,    0,    0,    0,    0,  254,    0,
        0,    0,    0,    0,    0,  254,  254,  254,  254,  254,

      254,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,  254,    0,    0,  254,  254,  254,  254,  254,  254,
      255,    0,    0,    0,    0,    0,    0,  255,  255,  255,
      255,  255,  255,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,  255,  255,  255,  255,
      255,  255,  257,  257,  257,  257,  257,    0,  257,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,  257,    0,    0,    0,    0,    0,    0,  257,  257,

      257,  257,  257,  257,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  257,    0,    0,  257,  257,  257,
      257,  257,  257,  259,    0,    0,    0,    0,    0,    0,
      259,  259,  259,  259,  259,  259,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,  259,    0,    0,  259,
      259,  259,  259,  259,  259,  260,  260,  260,  260,  260,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  260,    0,    0,    0,    0,    0,

        0,  260,  260,  260,  260,  260,  260,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,  260,    0,    0,
      260,  260,  260,  260,  260,  260,  261,  261,  261,  261,
      261,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,  261,    0,    0,    0,    0,
        0,    0,  261,  261,  261,  261,  261,  261,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,  261,  261,  261,  261,  261,  261,  262,  262,  262,

      262,  262,    0,    0,    0,    0,    0,    0,  262,    0,
        0,    0,    0,    0,    0,    0,  262,    0,    0,    0,
        0,    0,    0,  262,  262,  262,  262,  262,  262,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,  262,
        0,    0,  262,  262,  262,  262,  262,  262,  263,  263,
      263,  263,  263,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,  263,    0,    0,
        0,    0,    0,    0,  263,  263,  263,  263,  263,  263,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,  263,    0,    0,    0,    0,    0,    0,
        0,    0,    0,  263,  263,  263,  263,  263,  263,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,  263,  264,  264,  264,  264,  264,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,  264,    0,    0,    0,    0,    0,    0,  264,  264,
      264,  264,  264,  264,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,  264,  264,  264,
      264,  264,  264,  265,    0,    0,    0,    0,    0,    0,

      265,  265,  265,  265,  265,  265,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,  265,
      265,  265,  265,  265,  265,  266,  266,  266,  266,  266,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  266,    0,    0,    0,    0,    0,
        0,  266,  266,  266,  266,  266,  266,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
      266,  266,  266,  266,  266,  266,  268,  268,  268,  268,

      268,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,  268,    0,    0,    0,    0,
        0,    0,  268,  268,  268,  268,  268,  268,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,  268,  268,  268,  268,  268,  268,  274,    0,    0,
        0,    0,    0,    0,  274,  274,  274,  274,  274,  274,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,  274,  274,  274,  274,  274,  274,  275,

      275,  275,  275,  275,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  275,    0,
        0,    0,    0,    0,    0,  275,  275,  275,  275,  275,
      275,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  275,  275,  275,  275,  275,  275,
      285,  285,  285,  285,    0,    0,  285,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,  285,
        0,    0,    0,    0,    0,    0,  285,  285,  285,  285,
      285,  285,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,  285,    0,    0,  285,  285,  285,  285,  285,
      285,  287,  287,  287,  287,    0,    0,    0,    0,    0,
        0,    0,  287,    0,    0,    0,    0,    0,    0,    0,
      287,    0,    0,    0,    0,    0,    0,  287,  287,  287,
      287,  287,  287,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,  287,    0,    0,  287,  287,  287,  287,
      287,  287,  292,  292,  292,  292,  292,    0,    0,    0,
        0,    0,    0,    0,    0,  292,    0,    0,    0,    0,

        0,  292,    0,    0,    0,    0,    0,    0,  292,  292,
      292,  292,  292,  292,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  292,    0,    0,  292,  292,  292,
      292,  292,  292,  293,  293,  293,  293,  293,    0,  293,
        0,    0,    0,    0,  293,  293,  293,    0,    0,    0,
        0,    0,  293,    0,    0,    0,    0,    0,    0,  293,
      293,  293,  293,  293,  293,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,  293,    0,    0,  293,  293,

      293,  293,  293,  293,  294,    0,    0,    0,    0,    0,
        0,  294,  294,  294,  294,  294,  294,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
      294,  294,  294,  294,  294,  294,  296,  296,  296,  296,
      296,    0,  296,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,  296,    0,    0,    0,    0,
        0,    0,  296,  296,  296,  296,  296,  296,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  296,    0,

        0,  296,  296,  296,  296,  296,  296,  299,  299,  299,
      299,  299,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,  299,    0,    0,    0,
        0,    0,    0,  299,  299,  299,  299,  299,  299,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,  299,
        0,    0,  299,  299,  299,  299,  299,  299,  300,  300,
      300,  300,  300,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,  300,    0,    0,
        0,    0,    0,    0,  300,  300,  300,  300,  300,  300,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,  300,  300,  300,  300,  300,  300,  301,
      301,  301,  301,  301,    0,    0,    0,    0,    0,    0,
      301,    0,    0,    0,    0,    0,    0,    0,  301,    0,
        0,    0,    0,    0,    0,  301,  301,  301,  301,  301,
      301,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,  301,    0,    0,  301,  301,  301,  301,  301,  301,
      302,  302,  302,  302,  302,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,  302,    0,    0,  302,
        0,    0,    0,    0,    0,    0,  302,  302,  302,  302,
      302,  302,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,  302,  302,  302,  302,  302,
      302,  303,  303,  303,  303,  303,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
      303,    0,    0,    0,    0,    0,    0,  303,  303,  303,
      303,  303,  303,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,  303,  303,  303,  303,
      303,  303,  304,  304,  304,  304,  304,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,  304,    0,    0,    0,    0,    0,    0,  304,  304,
      304,  304,  304,  304,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,  304,  304,  304,
      304,  304,  304,  306,  306,  306,  306,  306,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,  306,    0,    0,    0,    0,    0,    0,  306,

      306,  306,  306,  306,  306,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  306,  306,
      306,  306,  306,  306,  311,    0,    0,    0,    0,    0,
        0,  311,  311,  311,  311,  311,  311,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
      311,  311,  311,  311,  311,  311,  312,  312,  312,  312,
      312,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,  312,    0,    0,    0,    0,

        0,    0,  312,  312,  312,  312,  312,  312,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,  312,  312,  312,  312,  312,  312,  325,  325,  325,
      325,  325,    0,  325,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,  325,    0,    0,    0,
        0,    0,    0,  325,  325,  325,  325,  325,  325,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,  325,
        0,    0,  325,  325,  325,  325,  325,  325,  326,  326,

      326,  326,    0,    0,  326,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,  326,    0,    0,
        0,    0,    0,    0,  326,  326,  326,  326,  326,  326,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
      326,    0,    0,  326,  326,  326,  326,  326,  326,  330,
      330,  330,  330,  330,    0,    0,    0,    0,    0,    0,
      330,    0,    0,    0,    0,    0,    0,    0,  330,    0,
        0,    0,    0,    0,    0,  330,  330,  330,  330,  330,
      330,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,  330,    0,    0,  330,  330,  330,  330,  330,  330,
      331,  331,  331,  331,    0,    0,    0,    0,    0,    0,
        0,  331,    0,    0,    0,    0,    0,    0,    0,  331,
        0,    0,    0,    0,    0,    0,  331,  331,  331,  331,
      331,  331,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,  331,    0,    0,  331,  331,  331,  331,  331,
      331,  332,  332,  332,  332,  332,    0,    0,    0,    0,
        0,    0,    0,    0,  332,    0,    0,    0,    0,    0,

      332,    0,    0,    0,    0,    0,    0,  332,  332,  332,
      332,  332,  332,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,  332,    0,    0,  332,  332,  332,  332,
      332,  332,  336,    0,    0,    0,    0,    0,    0,  336,
      336,  336,  336,  336,  336,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  336,  336,
      336,  336,  336,  336,  337,    0,    0,    0,    0,    0,
        0,  337,  337,  337,  337,  337,  337,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
      337,  337,  337,  337,  337,  337,  340,    0,    0,    0,
        0,    0,    0,  340,  340,  340,  340,  340,  340,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,  340,  340,  340,  340,  340,  340,  341,  341,
      341,  341,  341,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,  341,    0,    0,
        0,    0,    0,    0,  341,  341,  341,  341,  341,  341,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,  341,  341,  341,  341,  341,  341,  343,
      343,  343,  343,  343,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  343,    0,
        0,    0,    0,    0,    0,  343,  343,  343,  343,  343,
      343,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  343,  343,  343,  343,  343,  343,
      360,    0,    0,    0,    0,    0,    0,  360,  360,  360,

      360,  360,  360,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,  360,  360,  360,  360,
      360,  360,  364,    0,    0,    0,    0,    0,    0,  364,
      364,  364,  364,  364,  364,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  364,  364,
      364,  364,  364,  364,  365,  365,  365,  365,  365,    0,
        0,    0,    0,    0,    0,    0,    0,  365,    0,    0,
        0,    0,    0,  365,    0,    0,    0,    0,    0,    0,

      365,  365,  365,  365,  365,  365,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,  365,    0,    0,  365,
      365,  365,  365,  365,  365,  370,    0,    0,    0,    0,
        0,    0,  370,    0,  370,    0,    0,    0,    0,  370,
      370,    0,    0,  370,    0,    0,    0,    0,  370,    0,
        0,    0,    0,    0,  370,    0,    0,    0,    0,    0,
      370,    0,  370,    0,    0,    0,    0,  370,  370,    0,
        0,  370,  375,    0,    0,    0,    0,    0,    0,  375,
      375,  375,  375,  375,  375,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  375,  375,
      375,  375,  375,  375,  376,    0,    0,    0,    0,    0,
        0,  376,  376,  376,  376,  376,  376,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
      376,  376,  376,  376,  376,  376,  377,    0,    0,    0,
        0,    0,    0,  377,  377,  377,  377,  377,  377,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,  377,  377,  377,  377,  377,  377,  389,    0,
        0,    0,    0,    0,    0,  389,  389,  389,  389,  389,
      389,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  389,  389,  389,  389,  389,  389,
      390,    0,    0,    0,    0,    0,    0,  390,  390,  390,
      390,  390,  390,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,  390,  390,  390,  390,
      390,  390,  391,    0,    0,    0,    0,    0,    0,  391,

      391,  391,  391,  391,  391,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  391,  391,
      391,  391,  391,  391,  399,    0,    0,    0,    0,    0,
        0,  399,  399,  399,  399,  399,  399,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
      399,  399,  399,  399,  399,  399,  400,    0,    0,    0,
        0,    0,    0,  400,  400,  400,  400,  400,  400,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,  400,  400,  400,  400,  400,  400,  416,    0,
        0,    0,    0,    0,    0,  416,  416,  416,  416,  416,
      416,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  416,  416,  416,  416,  416,  416,
      428,    0,    0,    0,    0,    0,    0,  428,  428,  428,
      428,  428,  428,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,  428,  428,  428,  428,

      428,  428,  430,  430,  430,  430,  430,    0,    0,    0,
        0,    0,    0,    0,    0,  430,    0,    0,    0,    0,
        0,  430,    0,    0,    0,    0,    0,    0,  430,  430,
      430,  430,  430,  430,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  430,    0,    0,  430,  430,  430,
      430,  430,  430,  439,  439,  439,  439,  439,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,  439,    0,    0,    0,    0,    0,    0,  439,
      439,  439,  439,  439,  439,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  439,  439,
      439,  439,  439,  439,  441,    0,    0,    0,    0,    0,
        0,  441,  441,  441,  441,  441,  441,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
      441,  441,  441,  441,  441,  441,  448,    0,    0,    0,
        0,    0,    0,  448,  448,  448,  448,  448,  448,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,  448,  448,  448,  448,  448,  448,  449,    0,
        0,    0,    0,    0,    0,  449,  449,  449,  449,  449,
      449,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  449,  449,  449,  449,  449,  449,
      454,    0,    0,    0,    0,    0,    0,  454,  454,  454,
      454,  454,  454,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,  454,  454,  454,  454,
      454,  454,  455,    0,    0,    0,    0,    0,    0,  455,

      455,  455,  455,  455,  455,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  455,  455,
      455,  455,  455,  455,  460,    0,    0,    0,    0,    0,
        0,  460,  460,  460,  460,  460,  460,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
      460,  460,  460,  460,  460,  460,  461,    0,    0,    0,
        0,    0,    0,  461,  461,  461,  461,  461,  461,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,  461,  461,  461,  461,  461,  461,  466,    0,
        0,    0,    0,    0,    0,  466,  466,  466,  466,  466,
      466,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  466,  466,  466,  466,  466,  466,
      481,    0,    0,  481,  481,  481,  481,  481,  481,  481,
      481,  481,  481,  482,  482,    0,  482,  482,  483,    0,
        0,  483,  483,  483,  483,  483,  483,  483,  483,  483,
      483,  484,  484,    0,  484,  484,  485,    0,    0,  485,

      485,  486,    0,  486,  486,    0,  486,  486,  487,  487,
      487,  487,  487,  487,  487,  487,  487,  487,  488,  488,
      488,  488,  488,  488,  488,  488,  488,  488,  488,  488,
      488,  490,  490,    0,  490,  490,  491,  491,  491,  491,
      491,  491,  491,  491,  491,  491,  492,  492,  492,  492,
      492,  492,  492,  492,  492,  492,  492,  492,  492,  493,
      493,  493,  493,  493,  493,  493,  493,  493,  493,  493,
      493,  493,  493,  495,  495,    0,  495,  495,  496,  496,
      496,  496,  496,  496,  496,  496,  496,  496,  497,  497,
        0,  497,  497,  498,  498,  498,  498,  498,  498,  498,

      498,  498,  498,  499,  499,  499,  499,  499,  499,  499,
      499,  499,  499,  500,  500,  500,  502,  502,  502,  502,
      502,  502,  502,  502,  502,  502,  503,  503,    0,  503,
      503,  503,  503,  503,  503,  503,  503,  503,  503,  504,
      504,  504,  504,  504,  504,  504,  504,  504,  504,  504,
      504,  504,  505,  505,  505,  505,  505,  505,  505,  505,
      505,  505,  505,  505,  505,  505,  506,  506,  506,  506,
      506,  506,  506,  506,  506,  506,  506,  506,  506,  506,
      507,  507,  507,  507,  507,  507,  507,  507,  507,  507,
      508,  508,  508,  508,  508,  508,  508,  508,  508,  508,

      509,  509,  509,  509,  510,    0,    0,  510,  510,  510,
      510,  510,  510,  510,  510,  510,  510,  512,  512,  512,
      512,  512,  512,  512,  512,  512,  512,  512,  512,  512,
      512,  514,  514,  514,  514,  515,  515,  515,  515,  515,
      515,    0,  515,  515,  515,  515,  515,  515,  516,  516,
      516,  516,  516,  516,  516,  516,  516,  516,  516,  516,
      516,  518,  518,  518,  518,  518,  518,  518,  518,  518,
      518,  518,  518,  518,  518,  520,  520,  520,  520,  521,
      521,  521,  521,  521,  521,    0,  521,  521,  521,  521,
      521,  521,  522,    0,    0,  522,  522,  522,  522,  522,

      522,  522,  522,  522,  522,  523,    0,    0,  523,  523,
      523,  523,  523,  523,  523,  523,  523,  523,  524,  524,
      524,  524,  524,  524,  524,  524,  524,  524,  524,  524,
      524,  525,  525,  525,  525,  525,  525,  525,  525,  525,
      525,  525,  525,  525,  527,  527,    0,  527,  527,  528,
      528,  528,  528,  528,  528,  528,  528,  528,  528,  528,
      528,  528,  530,  530,  530,  530,  531,  531,  531,  531,
      531,  531,  531,  531,  531,  531,  531,  531,  531,  532,
        0,    0,  532,  532,  532,  532,  532,  532,  532,  532,
      532,  532,  533,  533,  533,  533,  533,  533,  533,  533,

      533,  533,  533,  533,  533,  534,  534,  534,  534,  534,
        0,    0,  534,  534,  534,  534,  534,  534,  535,  535,
      535,  535,  535,  535,  535,  535,  535,  535,  535,  535,
      535,  536,  536,  536,  536,  536,  536,  536,  536,  536,
      536,  536,  536,  536,  537,  537,    0,  537,  537,  538,
      538,  538,  538,  538,  538,  538,  538,  538,  538,  538,
      538,  538,  540,  540,  540,  540,  541,  541,    0,  541,
      541,  541,  541,  541,  541,  541,  541,  541,  541,  542,
      542,  542,  542,  542,  542,  542,  542,  542,  542,  542,
      542,  542,  543,  543,    0,  543,  543,  543,  543,  543,

      543,  543,  543,  543,  543,  544,  544,  544,  544,  544,
      544,  544,  544,  544,  544,  544,  544,  544,  545,  545,
      545,  545,  545,    0,    0,  545,  545,  545,  545,  545,
      545,  548,  548,  548,  548,    0,    0,    0,    0,  548,
        0,    0,  548,  548,  549,  549,  549,  549,    0,    0,
        0,  549,  549,  549,    0,  549,  549,  550,  550,  550,
      550,  550,  550,  550,  550,  550,  550,  551,  551,  551,
      551,  551,  551,  551,  551,  551,  551,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,

      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
      480,  480,  480
    } ;

#line 1 "<stdin>"
YY_DECL
{
	register yy_state_type yy_current_state;
	register UChar *yy_cp, *yy_bp;
	register int yy_act;
	while ( 1 )		/* loops until end-of-file is reached */
		{
		yy_cp = (yy_c_buf_p);

		/* Support of yytext. */
		*yy_cp = (yy_hold_char);

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = (yy_start);
		do
			{
			register YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)];
			if ( yy_accept[yy_current_state] )
				{
				(yy_last_accepting_state) = yy_current_state;
				(yy_last_accepting_cpos) = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 481 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			++yy_cp;
			}
		while ( yy_base[yy_current_state] != 6578 );

yy_find_action:
		yy_act = yy_accept[yy_current_state];
		if ( yy_act == 0 )
			{ /* have to back up */
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			yy_act = yy_accept[yy_current_state];
			}

		YY_DO_BEFORE_ACTION;


		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = (yy_hold_char);
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			goto yy_find_action;

case 1:
/* rule 1 can match eol */
YY_RULE_SETUP
#line 31 "<stdin>"
/* ignore comments */
	YY_BREAK
case 2:
/* rule 2 can match eol */
YY_RULE_SETUP
#line 33 "<stdin>"
{yyTok = WHITESPACE; return yyTok;}
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 35 "<stdin>"
{yyTok = SGML_CD; return yyTok;}
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 36 "<stdin>"
{yyTok = SGML_CD; return yyTok;}
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 37 "<stdin>"
{yyTok = INCLUDES; return yyTok;}
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 38 "<stdin>"
{yyTok = DASHMATCH; return yyTok;}
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 39 "<stdin>"
{yyTok = BEGINSWITH; return yyTok;}
	YY_BREAK
case 8:
YY_RULE_SETUP
#line 40 "<stdin>"
{yyTok = ENDSWITH; return yyTok;}
	YY_BREAK
case 9:
YY_RULE_SETUP
#line 41 "<stdin>"
{yyTok = CONTAINS; return yyTok;}
	YY_BREAK
case 10:
YY_RULE_SETUP
#line 42 "<stdin>"
{yyTok = MEDIA_NOT; return yyTok;}
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 43 "<stdin>"
{yyTok = MEDIA_ONLY; return yyTok;}
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 44 "<stdin>"
{yyTok = MEDIA_AND; return yyTok;}
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 45 "<stdin>"
{BEGIN(mediaquery); yyTok = VARIABLES_FOR; return yyTok; }
	YY_BREAK
case 14:
/* rule 14 can match eol */
YY_RULE_SETUP
#line 47 "<stdin>"
{yyTok = STRING; return yyTok;}
	YY_BREAK
case 15:
/* rule 15 can match eol */
YY_RULE_SETUP
#line 48 "<stdin>"
{yyTok = IDENT; return yyTok;}
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 49 "<stdin>"
{yyTok = NTH; return yyTok;}
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 51 "<stdin>"
{yyTok = HEX; return yyTok;}
	YY_BREAK
case 18:
/* rule 18 can match eol */
YY_RULE_SETUP
#line 52 "<stdin>"
{yyTok = IDSEL; return yyTok;}
	YY_BREAK
case 19:
YY_RULE_SETUP
#line 54 "<stdin>"
{BEGIN(mediaquery); yyTok = IMPORT_SYM; return yyTok;}
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 55 "<stdin>"
{yyTok = PAGE_SYM; return yyTok;}
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 56 "<stdin>"
{BEGIN(mediaquery); yyTok = MEDIA_SYM; return yyTok;}
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 57 "<stdin>"
{yyTok = FONT_FACE_SYM; return yyTok;}
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 58 "<stdin>"
{yyTok = CHARSET_SYM; return yyTok;}
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 59 "<stdin>"
{yyTok = NAMESPACE_SYM; return yyTok; }
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 60 "<stdin>"
{yyTok = WEBKIT_RULE_SYM; return yyTok; }
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 61 "<stdin>"
{yyTok = WEBKIT_DECLS_SYM; return yyTok; }
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 62 "<stdin>"
{yyTok = WEBKIT_VALUE_SYM; return yyTok; }
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 63 "<stdin>"
{BEGIN(mediaquery); yyTok = WEBKIT_MEDIAQUERY_SYM; return yyTok; }
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 64 "<stdin>"
{yyTok = WEBKIT_SELECTOR_SYM; return yyTok; }
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 65 "<stdin>"
{BEGIN(mediaquery); yyTok = WEBKIT_VARIABLES_SYM; return yyTok; }
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 66 "<stdin>"
{BEGIN(forkeyword); yyTok = WEBKIT_DEFINE_SYM; return yyTok; }
	YY_BREAK
case 32:
YY_RULE_SETUP
#line 67 "<stdin>"
{ yyTok = WEBKIT_VARIABLES_DECLS_SYM; return yyTok; }
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 68 "<stdin>"
{yyTok = WEBKIT_KEYFRAMES_SYM; return yyTok; }
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 69 "<stdin>"
{yyTok = WEBKIT_KEYFRAME_RULE_SYM; return yyTok; }
	YY_BREAK
case 35:
/* rule 35 can match eol */
YY_RULE_SETUP
#line 71 "<stdin>"
{yyTok = ATKEYWORD; return yyTok; }
	YY_BREAK
case 36:
/* rule 36 can match eol */
YY_RULE_SETUP
#line 73 "<stdin>"
{yyTok = IMPORTANT_SYM; return yyTok;}
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 75 "<stdin>"
{yyTok = EMS; return yyTok;}
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 76 "<stdin>"
{yyTok = REMS; return yyTok;}
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 77 "<stdin>"
{yyTok = QEMS; return yyTok;} /* quirky ems */
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 78 "<stdin>"
{yyTok = EXS; return yyTok;}
	YY_BREAK
case 41:
YY_RULE_SETUP
#line 79 "<stdin>"
{yyTok = PXS; return yyTok;}
	YY_BREAK
case 42:
YY_RULE_SETUP
#line 80 "<stdin>"
{yyTok = CMS; return yyTok;}
	YY_BREAK
case 43:
YY_RULE_SETUP
#line 81 "<stdin>"
{yyTok = MMS; return yyTok;}
	YY_BREAK
case 44:
YY_RULE_SETUP
#line 82 "<stdin>"
{yyTok = INS; return yyTok;}
	YY_BREAK
case 45:
YY_RULE_SETUP
#line 83 "<stdin>"
{yyTok = PTS; return yyTok;}
	YY_BREAK
case 46:
YY_RULE_SETUP
#line 84 "<stdin>"
{yyTok = PCS; return yyTok;}
	YY_BREAK
case 47:
YY_RULE_SETUP
#line 85 "<stdin>"
{yyTok = DEGS; return yyTok;}
	YY_BREAK
case 48:
YY_RULE_SETUP
#line 86 "<stdin>"
{yyTok = RADS; return yyTok;}
	YY_BREAK
case 49:
YY_RULE_SETUP
#line 87 "<stdin>"
{yyTok = GRADS; return yyTok;}
	YY_BREAK
case 50:
YY_RULE_SETUP
#line 88 "<stdin>"
{yyTok = TURNS; return yyTok;}
	YY_BREAK
case 51:
YY_RULE_SETUP
#line 89 "<stdin>"
{yyTok = MSECS; return yyTok;}
	YY_BREAK
case 52:
YY_RULE_SETUP
#line 90 "<stdin>"
{yyTok = SECS; return yyTok;}
	YY_BREAK
case 53:
YY_RULE_SETUP
#line 91 "<stdin>"
{yyTok = HERZ; return yyTok;}
	YY_BREAK
case 54:
YY_RULE_SETUP
#line 92 "<stdin>"
{yyTok = KHERZ; return yyTok;}
	YY_BREAK
case 55:
/* rule 55 can match eol */
YY_RULE_SETUP
#line 93 "<stdin>"
{yyTok = DIMEN; return yyTok;}
	YY_BREAK
case 56:
YY_RULE_SETUP
#line 94 "<stdin>"
{yyTok = PERCENTAGE; return yyTok;}
	YY_BREAK
case 57:
YY_RULE_SETUP
#line 95 "<stdin>"
{yyTok = INTEGER; return yyTok;}
	YY_BREAK
case 58:
YY_RULE_SETUP
#line 96 "<stdin>"
{yyTok = FLOATTOKEN; return yyTok;}
	YY_BREAK
case 59:
YY_RULE_SETUP
#line 98 "<stdin>"
{yyTok = NOTFUNCTION; return yyTok;}
	YY_BREAK
case 60:
/* rule 60 can match eol */
YY_RULE_SETUP
#line 99 "<stdin>"
{yyTok = URI; return yyTok;}
	YY_BREAK
case 61:
/* rule 61 can match eol */
YY_RULE_SETUP
#line 100 "<stdin>"
{yyTok = URI; return yyTok;}
	YY_BREAK
case 62:
/* rule 62 can match eol */
YY_RULE_SETUP
#line 101 "<stdin>"
{ yyTok = VARCALL; return yyTok; }
	YY_BREAK
case 63:
/* rule 63 can match eol */
YY_RULE_SETUP
#line 102 "<stdin>"
{yyTok = FUNCTION; return yyTok;}
	YY_BREAK
case 64:
YY_RULE_SETUP
#line 104 "<stdin>"
{yyTok = UNICODERANGE; return yyTok;}
	YY_BREAK
case 65:
YY_RULE_SETUP
#line 105 "<stdin>"
{yyTok = UNICODERANGE; return yyTok;}
	YY_BREAK
case 66:
#line 108 "<stdin>"
case 67:
YY_RULE_SETUP
#line 108 "<stdin>"
{BEGIN(INITIAL); yyTok = *yytext; return yyTok; }
	YY_BREAK
case 68:
YY_RULE_SETUP
#line 109 "<stdin>"
{yyTok = *yytext; return yyTok;}
	YY_BREAK
case 69:
YY_RULE_SETUP
#line 111 "<stdin>"
ECHO;
	YY_BREAK
#line 2745 "<stdout>"
case YY_END_OF_BUFFER:
	yy_c_buf_p = yy_cp - 1;
	yy_cp = yy_c_buf_p;
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(mediaquery):
case YY_STATE_EOF(forkeyword):
	yyterminate();

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
} /* end of yylex */
