/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLScriptElement.h"

#include "HTMLScriptElement.h"
#include "KURL.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLScriptElement);

/* Hash table */

static const HashTableValue JSHTMLScriptElementTableValues[9] =
{
    { "text", DontDelete, (intptr_t)jsHTMLScriptElementText, (intptr_t)setJSHTMLScriptElementText },
    { "htmlFor", DontDelete, (intptr_t)jsHTMLScriptElementHtmlFor, (intptr_t)setJSHTMLScriptElementHtmlFor },
    { "event", DontDelete, (intptr_t)jsHTMLScriptElementEvent, (intptr_t)setJSHTMLScriptElementEvent },
    { "charset", DontDelete, (intptr_t)jsHTMLScriptElementCharset, (intptr_t)setJSHTMLScriptElementCharset },
    { "defer", DontDelete, (intptr_t)jsHTMLScriptElementDefer, (intptr_t)setJSHTMLScriptElementDefer },
    { "src", DontDelete, (intptr_t)jsHTMLScriptElementSrc, (intptr_t)setJSHTMLScriptElementSrc },
    { "type", DontDelete, (intptr_t)jsHTMLScriptElementType, (intptr_t)setJSHTMLScriptElementType },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsHTMLScriptElementConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSHTMLScriptElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 31, JSHTMLScriptElementTableValues, 0 };
#else
    { 17, 15, JSHTMLScriptElementTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSHTMLScriptElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSHTMLScriptElementConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLScriptElementConstructorTableValues, 0 };
#else
    { 1, 0, JSHTMLScriptElementConstructorTableValues, 0 };
#endif

class JSHTMLScriptElementConstructor : public DOMConstructorObject {
public:
    JSHTMLScriptElementConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSHTMLScriptElementConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSHTMLScriptElementPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags)); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSHTMLScriptElementConstructor::s_info = { "HTMLScriptElementConstructor", 0, &JSHTMLScriptElementConstructorTable, 0 };

bool JSHTMLScriptElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLScriptElementConstructor, DOMObject>(exec, &JSHTMLScriptElementConstructorTable, this, propertyName, slot);
}

bool JSHTMLScriptElementConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLScriptElementConstructor, DOMObject>(exec, &JSHTMLScriptElementConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLScriptElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSHTMLScriptElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLScriptElementPrototypeTableValues, 0 };
#else
    { 1, 0, JSHTMLScriptElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSHTMLScriptElementPrototype::s_info = { "HTMLScriptElementPrototype", 0, &JSHTMLScriptElementPrototypeTable, 0 };

JSObject* JSHTMLScriptElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLScriptElement>(exec, globalObject);
}

const ClassInfo JSHTMLScriptElement::s_info = { "HTMLScriptElement", &JSHTMLElement::s_info, &JSHTMLScriptElementTable, 0 };

JSHTMLScriptElement::JSHTMLScriptElement(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLScriptElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

JSObject* JSHTMLScriptElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSHTMLScriptElementPrototype(JSHTMLScriptElementPrototype::createStructure(JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLScriptElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLScriptElement, Base>(exec, &JSHTMLScriptElementTable, this, propertyName, slot);
}

bool JSHTMLScriptElement::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLScriptElement, Base>(exec, &JSHTMLScriptElementTable, this, propertyName, descriptor);
}

JSValue jsHTMLScriptElementText(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLScriptElement* castedThis = static_cast<JSHTMLScriptElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLScriptElement* imp = static_cast<HTMLScriptElement*>(castedThis->impl());
    return jsString(exec, imp->text());
}

JSValue jsHTMLScriptElementHtmlFor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLScriptElement* castedThis = static_cast<JSHTMLScriptElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLScriptElement* imp = static_cast<HTMLScriptElement*>(castedThis->impl());
    return jsString(exec, imp->htmlFor());
}

JSValue jsHTMLScriptElementEvent(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLScriptElement* castedThis = static_cast<JSHTMLScriptElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLScriptElement* imp = static_cast<HTMLScriptElement*>(castedThis->impl());
    return jsString(exec, imp->event());
}

JSValue jsHTMLScriptElementCharset(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLScriptElement* castedThis = static_cast<JSHTMLScriptElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLScriptElement* imp = static_cast<HTMLScriptElement*>(castedThis->impl());
    return jsString(exec, imp->charset());
}

JSValue jsHTMLScriptElementDefer(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLScriptElement* castedThis = static_cast<JSHTMLScriptElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLScriptElement* imp = static_cast<HTMLScriptElement*>(castedThis->impl());
    return jsBoolean(imp->defer());
}

JSValue jsHTMLScriptElementSrc(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLScriptElement* castedThis = static_cast<JSHTMLScriptElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLScriptElement* imp = static_cast<HTMLScriptElement*>(castedThis->impl());
    return jsString(exec, imp->src());
}

JSValue jsHTMLScriptElementType(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLScriptElement* castedThis = static_cast<JSHTMLScriptElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLScriptElement* imp = static_cast<HTMLScriptElement*>(castedThis->impl());
    return jsString(exec, imp->type());
}

JSValue jsHTMLScriptElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLScriptElement* domObject = static_cast<JSHTMLScriptElement*>(asObject(slot.slotBase()));
    return JSHTMLScriptElement::getConstructor(exec, domObject->globalObject());
}
void JSHTMLScriptElement::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSHTMLScriptElement, Base>(exec, propertyName, value, &JSHTMLScriptElementTable, this, slot);
}

void setJSHTMLScriptElementText(ExecState* exec, JSObject* thisObject, JSValue value)
{
    HTMLScriptElement* imp = static_cast<HTMLScriptElement*>(static_cast<JSHTMLScriptElement*>(thisObject)->impl());
    imp->setText(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLScriptElementHtmlFor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    HTMLScriptElement* imp = static_cast<HTMLScriptElement*>(static_cast<JSHTMLScriptElement*>(thisObject)->impl());
    imp->setHtmlFor(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLScriptElementEvent(ExecState* exec, JSObject* thisObject, JSValue value)
{
    HTMLScriptElement* imp = static_cast<HTMLScriptElement*>(static_cast<JSHTMLScriptElement*>(thisObject)->impl());
    imp->setEvent(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLScriptElementCharset(ExecState* exec, JSObject* thisObject, JSValue value)
{
    HTMLScriptElement* imp = static_cast<HTMLScriptElement*>(static_cast<JSHTMLScriptElement*>(thisObject)->impl());
    imp->setCharset(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLScriptElementDefer(ExecState* exec, JSObject* thisObject, JSValue value)
{
    HTMLScriptElement* imp = static_cast<HTMLScriptElement*>(static_cast<JSHTMLScriptElement*>(thisObject)->impl());
    imp->setDefer(value.toBoolean(exec));
}

void setJSHTMLScriptElementSrc(ExecState* exec, JSObject* thisObject, JSValue value)
{
    HTMLScriptElement* imp = static_cast<HTMLScriptElement*>(static_cast<JSHTMLScriptElement*>(thisObject)->impl());
    imp->setSrc(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLScriptElementType(ExecState* exec, JSObject* thisObject, JSValue value)
{
    HTMLScriptElement* imp = static_cast<HTMLScriptElement*>(static_cast<JSHTMLScriptElement*>(thisObject)->impl());
    imp->setType(valueToStringWithNullCheck(exec, value));
}

JSValue JSHTMLScriptElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLScriptElementConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}


}
