/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLStyleElement.h"

#include "HTMLStyleElement.h"
#include "JSStyleSheet.h"
#include "KURL.h"
#include "StyleSheet.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLStyleElement);

/* Hash table */

static const HashTableValue JSHTMLStyleElementTableValues[6] =
{
    { "disabled", DontDelete, (intptr_t)jsHTMLStyleElementDisabled, (intptr_t)setJSHTMLStyleElementDisabled },
    { "media", DontDelete, (intptr_t)jsHTMLStyleElementMedia, (intptr_t)setJSHTMLStyleElementMedia },
    { "type", DontDelete, (intptr_t)jsHTMLStyleElementType, (intptr_t)setJSHTMLStyleElementType },
    { "sheet", DontDelete|ReadOnly, (intptr_t)jsHTMLStyleElementSheet, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsHTMLStyleElementConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSHTMLStyleElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 31, JSHTMLStyleElementTableValues, 0 };
#else
    { 17, 15, JSHTMLStyleElementTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSHTMLStyleElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSHTMLStyleElementConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLStyleElementConstructorTableValues, 0 };
#else
    { 1, 0, JSHTMLStyleElementConstructorTableValues, 0 };
#endif

class JSHTMLStyleElementConstructor : public DOMConstructorObject {
public:
    JSHTMLStyleElementConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSHTMLStyleElementConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSHTMLStyleElementPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags)); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSHTMLStyleElementConstructor::s_info = { "HTMLStyleElementConstructor", 0, &JSHTMLStyleElementConstructorTable, 0 };

bool JSHTMLStyleElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLStyleElementConstructor, DOMObject>(exec, &JSHTMLStyleElementConstructorTable, this, propertyName, slot);
}

bool JSHTMLStyleElementConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLStyleElementConstructor, DOMObject>(exec, &JSHTMLStyleElementConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLStyleElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSHTMLStyleElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLStyleElementPrototypeTableValues, 0 };
#else
    { 1, 0, JSHTMLStyleElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSHTMLStyleElementPrototype::s_info = { "HTMLStyleElementPrototype", 0, &JSHTMLStyleElementPrototypeTable, 0 };

JSObject* JSHTMLStyleElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLStyleElement>(exec, globalObject);
}

const ClassInfo JSHTMLStyleElement::s_info = { "HTMLStyleElement", &JSHTMLElement::s_info, &JSHTMLStyleElementTable, 0 };

JSHTMLStyleElement::JSHTMLStyleElement(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLStyleElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

JSObject* JSHTMLStyleElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSHTMLStyleElementPrototype(JSHTMLStyleElementPrototype::createStructure(JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLStyleElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLStyleElement, Base>(exec, &JSHTMLStyleElementTable, this, propertyName, slot);
}

bool JSHTMLStyleElement::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLStyleElement, Base>(exec, &JSHTMLStyleElementTable, this, propertyName, descriptor);
}

JSValue jsHTMLStyleElementDisabled(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLStyleElement* castedThis = static_cast<JSHTMLStyleElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLStyleElement* imp = static_cast<HTMLStyleElement*>(castedThis->impl());
    return jsBoolean(imp->disabled());
}

JSValue jsHTMLStyleElementMedia(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLStyleElement* castedThis = static_cast<JSHTMLStyleElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLStyleElement* imp = static_cast<HTMLStyleElement*>(castedThis->impl());
    return jsString(exec, imp->media());
}

JSValue jsHTMLStyleElementType(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLStyleElement* castedThis = static_cast<JSHTMLStyleElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLStyleElement* imp = static_cast<HTMLStyleElement*>(castedThis->impl());
    return jsString(exec, imp->type());
}

JSValue jsHTMLStyleElementSheet(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLStyleElement* castedThis = static_cast<JSHTMLStyleElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLStyleElement* imp = static_cast<HTMLStyleElement*>(castedThis->impl());
    return toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->sheet()));
}

JSValue jsHTMLStyleElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLStyleElement* domObject = static_cast<JSHTMLStyleElement*>(asObject(slot.slotBase()));
    return JSHTMLStyleElement::getConstructor(exec, domObject->globalObject());
}
void JSHTMLStyleElement::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSHTMLStyleElement, Base>(exec, propertyName, value, &JSHTMLStyleElementTable, this, slot);
}

void setJSHTMLStyleElementDisabled(ExecState* exec, JSObject* thisObject, JSValue value)
{
    HTMLStyleElement* imp = static_cast<HTMLStyleElement*>(static_cast<JSHTMLStyleElement*>(thisObject)->impl());
    imp->setDisabled(value.toBoolean(exec));
}

void setJSHTMLStyleElementMedia(ExecState* exec, JSObject* thisObject, JSValue value)
{
    HTMLStyleElement* imp = static_cast<HTMLStyleElement*>(static_cast<JSHTMLStyleElement*>(thisObject)->impl());
    imp->setMedia(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLStyleElementType(ExecState* exec, JSObject* thisObject, JSValue value)
{
    HTMLStyleElement* imp = static_cast<HTMLStyleElement*>(static_cast<JSHTMLStyleElement*>(thisObject)->impl());
    imp->setType(valueToStringWithNullCheck(exec, value));
}

JSValue JSHTMLStyleElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLStyleElementConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}


}
