/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** This file is part of the Qt Mobility Components.
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights.  These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** Nokia at qt-info@nokia.com.
**
**
**
**
**
**
**
**
** $QT_END_LICENSE$
**
****************************************************************************/
#include <QApplication>
#include <QtTest/QtTest>
#include <QDebug>
#include <QEventLoop>
#include <QTimer>

#include "qmessagemanager.h"
#include "qmessage.h"

#ifdef Q_OS_SYMBIAN
#include <msvapi.h>
#include <msvids.h>  // KMsvGlobalInBoxIndexEntryId
#include <mtclreg.h>  // CClientMtmRegistry
#include <smsclnt.h>  // CSmsClientMtm
#include <smut.h>  // KUidMsgTypeSMS
#include <txtrich.h>  // CRichText
#include <cemailaccounts.h>
#include <mmsconst.h>
#include <MIUTMSG.H>
#include <MSVFIND.H>  
#include <IMPCMTM.H>
#include <mmsclient.h>
#endif

#include <qdebug.h>

QTM_USE_NAMESPACE

class OsNative;

#if defined(Q_OS_SYMBIAN)
class OsNative : public MMsvSessionObserver {
public:
  OsNative()
  {    
  };

  void HandleSessionEventL(TMsvSessionEvent aEvent, TAny* aArg1, TAny* aArg2, TAny* aArg3) { };
  
  void getFolders(RArray<TMsvId> &folders);
  
  TMsvId makeSMS(TMsvId folder);
  TMsvId makeIMAP4(TMsvId folder);
  
  CMsvSession *iSession;
  CClientMtmRegistry *iMtmRegistry;
  CSmsClientMtm *iSmsMtm;
  CImap4ClientMtm *iImap4Mtm;  
  CMmsClientMtm *iMmsMtm;
 
  RArray<TMsvId> iFolders;
  RArray<TMsvId> iNewMsgs;

};

TMsvId OsNative::makeSMS(TMsvId folder){
  TBuf<10> aAddress(_L("Nokia"));
  TBuf<20> aDescription(_L("Important Message"));

  _LIT(KTxt1,"Hi phone owner, how r u?");

  TBuf<150> iMessage;     
  iMessage.Copy(KTxt1);

//      m_native->iSmsMtm->SwitchCurrentEntryL(KMsvGlobalInBoxIndexEntryId); //inbox KMsvDraftEntryId
  iSmsMtm->SwitchCurrentEntryL(folder);

  iSmsMtm->CreateMessageL(KUidMsgTypeSMS.iUid);

  CSmsHeader& iHeader = iSmsMtm->SmsHeader();
  iHeader.SetFromAddressL(aAddress);


  CRichText& body = iSmsMtm->Body();
  body.Reset();
  body.InsertL(0, iMessage);

  TMsvEntry entry = iSmsMtm->Entry().Entry();
  entry.SetInPreparation(EFalse);
  entry.SetVisible(ETrue);
  entry.iDate.HomeTime();
  entry.iDescription.Set(aDescription);
  entry.iDetails.Set(aAddress);
  entry.SetUnread(EFalse);


  iSmsMtm->Entry().ChangeL(entry);
  iSmsMtm->SaveMessageL();
  
  return entry.Id();
}

TMsvId OsNative::makeIMAP4(TMsvId folder){
  TBuf<20> aSubject(_L("Test Subject"));
  TBuf<20> aFrom(_L("Nokia@foo.com"));
  TBuf<20> aTo(_L("Boo@bar.com"));
  TBuf<20> aDescription(_L("Test Message"));

  _LIT(KTo, "Boo@bar.com");
  _LIT(KTxt1,"Test autogenerated message by benchmark/tst_messaging for performance testing");

  TBuf<150> iMessage;     
  iMessage.Copy(KTxt1);

//      m_native->iSmsMtm->SwitchCurrentEntryL(KMsvGlobalInBoxIndexEntryId); //inbox KMsvDraftEntryId
  iImap4Mtm->SwitchCurrentEntryL(folder); 

  // Set the context to the folder in which message has to be created
  CMsvEntry* entry = CMsvEntry::NewL(*iSession,folder,TMsvSelectionOrdering());
  CleanupStack::PushL(entry);
  entry->SetEntryL(folder);

  CMsvOperationActiveSchedulerWait* waiter=CMsvOperationActiveSchedulerWait::NewLC();  
  //CleanupStack::PushL(waiter);

  TMsvEmailTypeList msvEmailTypeList = 0;
  TMsvPartList partList = (KMsvMessagePartBody | KMsvMessagePartAttachments);

  CImEmailOperation* emailOperation = CImEmailOperation::CreateNewL(waiter->iStatus, *iSession,KMsvGlobalOutBoxIndexEntryId, partList, msvEmailTypeList, KUidMsgTypeSMTP);
  CleanupStack::PushL(emailOperation);
  waiter->Start();

  TMsvId temp;
  TPckgC<TMsvId> paramPack(temp);
  const TDesC8& progBuf = emailOperation->ProgressL();
  paramPack.Set(progBuf);
  TMsvId newMessageId;
  newMessageId = paramPack();

  entry->SetEntryL(newMessageId);

  CMsvStore* store = entry->EditStoreL();
  CleanupStack::PushL(store);
  CImHeader* emailEntry = CImHeader::NewLC();
  emailEntry->RestoreL(*store);
  emailEntry->SetFromL((TDesC8&)aFrom);
  emailEntry->SetSubjectL((TDesC&)aDescription);
  emailEntry->ToRecipients().AppendL(KTo);

  // Paragraph format layer for the rich text object 
  CParaFormatLayer* paraFormatLayer = CParaFormatLayer::NewL();
  CleanupStack::PushL(paraFormatLayer);
  // Character format layer for the rich text object
  CCharFormatLayer* charFormatLayer = CCharFormatLayer::NewL(); 
  CleanupStack::PushL(charFormatLayer);

  CRichText* bodyText = CRichText::NewL(paraFormatLayer, charFormatLayer, CEditableText::EFlatStorage, 256);
  CleanupStack::PushL(bodyText);

  // Insert the contents of a buffer into the document at specified position
  bodyText->InsertL(0, KTxt1);
  store->StoreBodyTextL(*bodyText);
  emailEntry->StoreL(*store);
  // Store the changes permanently
  store->CommitL();

  CleanupStack::PopAndDestroy(8,entry); // bodyText,charFormatLayer,paraFormatLayer,emailEntry,store, emailOperationg,waiter,entry
 
  return entry->EntryId();
}

#else
    class OsNative {
      
    };
#endif
    


    
//Q_DECLARE_METATYPE(QSystemInfo::Feature);

class tst_messaging : public QObject
{
    Q_OBJECT

public:
    enum platform {
        QMessaging = 0,
        Native = 1
    };
    
    enum bases {
      Accounts = 0,
      AccountsImap,
      AccountsPop,
      AccountsSmtp,
      Folders,
      FoldersEmail,
      FoldersSMS,
      FoldersMMS,
      Messages,
      MessagesAlt,
      
    };

    enum filter {
      Id = 0,
      Type,
      Sender,
      Recipients,
      Subject,
      TimeStamp,
      Status,
      Priority,
      Size,
      AllId,
      AllSender
    };
    
    enum types {
      Sms = 0,
      Mms,
      Email          
    };

    
private slots:
    void initTestCase();
    void cleanupTestCase();
    
    void tst_createTime_data();
    void tst_createTime();

    void tst_counts_data();
    void tst_counts();

    void tst_query_data();
    void tst_query();

    void tst_fetch_data();
    void tst_fetch();

    void tst_fetchAll_data();
    void tst_fetchAll();

    void tst_fetchFilter_data();
    void tst_fetchFilter();

    void tst_addMessage_data();
    void tst_addMessage();
            
    void tst_removeMessage_data();
    void tst_removeMessage();
    
    void tst_removeAllMessage_data();
    void tst_removeAllMessage();
    
private:
    QMessage *createMessage();
    QMessage *messageTemplate();
    QMessageId addMessage(QMessage *);     

    void clearMessages();
    int countMessages();

    QMessageManager *m_mgr;
    
    QMessageIdList msg_list;
    
    QMessageAccount m_act;
    //QMessageFolder m_fol;
    

    OsNative *m_native;
};

Q_DECLARE_METATYPE(tst_messaging::platform);
Q_DECLARE_METATYPE(tst_messaging::bases);
Q_DECLARE_METATYPE(tst_messaging::filter);
Q_DECLARE_METATYPE(tst_messaging::types);

void tst_messaging::initTestCase()
{

#if defined(Q_WS_MAEMO_6)
    QFAIL("Maemo 6 not supported by tst_messaging");
#elif defined(Q_WS_MAEMO_5)
    QFAIL("Maemo 5 does not support tst_messageing");
#elif defined(Q_OS_SYMBIAN)
    
#else
    QFAIL("Platform not supported");
#endif

    m_mgr = new QMessageManager();
    
    QMessageAccountIdList list;
    list = m_mgr->queryAccounts();
    while(!list.empty()) {      
      QMessageAccount act = m_mgr->account(list.takeFirst());
      qDebug() << "Account: " << act.name();
#if defined(Q_OS_SYMBIAN)      
      if(act.name() == "Personal"){
        m_act = act;
        break;
      }     
#endif      
    }

//    QMessageFolderIdList flist = m_mgr->queryFolders();
//    while(!flist.empty()) {      
//      QMessageFolder fol = m_mgr->folder(flist.takeFirst());
//      qDebug() << "Folder: " << fol.name();
//#if defined(Q_OS_SYMBIAN)      
//      if(fol.name() == "Inbox"){
//        m_fol = fol;
//        break;
//      }     
//#endif      
//    }
    
#if defined(Q_OS_SYMBIAN)
    // define/init native features we need native
    m_native = new OsNative;
    m_native->iSession = CMsvSession::OpenSyncL(*m_native);
    m_native->iMtmRegistry = CClientMtmRegistry::NewL(*m_native->iSession);
    m_native->iSmsMtm = STATIC_CAST(CSmsClientMtm*, m_native->iMtmRegistry->NewMtmL(KUidMsgTypeSMS));
    m_native->iImap4Mtm = STATIC_CAST(CImap4ClientMtm*, m_native->iMtmRegistry->NewMtmL(KUidMsgTypeIMAP4));
    m_native->iMmsMtm = STATIC_CAST(CMmsClientMtm*, m_native->iMtmRegistry->NewMtmL(KUidMsgTypeMultimedia));
    
#endif

    for(int i = 0; i < 20; i++)
      createMessage();
    
}

void tst_messaging::cleanupTestCase()
{
  
#if defined(Q_OS_SYMBIAN)
  delete m_native->iMmsMtm;
  delete m_native->iImap4Mtm;
  delete m_native->iSmsMtm;
  delete m_native->iMtmRegistry;
  delete m_native->iSession;
  delete m_native;
#endif
  
  clearMessages();
  delete m_mgr;


}


void tst_messaging::tst_createTime_data()
{
    QTest::addColumn<tst_messaging::platform>("platform");

    QTest::newRow("Qt-Create") << tst_messaging::QMessaging;
    QTest::newRow("Native-Create") << tst_messaging::Native;
}


void tst_messaging::tst_createTime()
{
    QFETCH(tst_messaging::platform, platform);
    
    //qDebug() << "Platform: " << platform;
    
    if(platform == tst_messaging::QMessaging){
      QMessageManager *mgr = 0x0;
      
      QBENCHMARK {
        mgr = new QMessageManager();        
      }
      
      delete mgr;
        
    }
    else if(platform == tst_messaging::Native){
#ifdef Q_OS_SYMBIAN
      
      __UHEAP_MARK;
      
      if(m_native){
        delete m_native->iMmsMtm;
        delete m_native->iImap4Mtm;
        delete m_native->iSmsMtm;
        delete m_native->iMtmRegistry;
        delete m_native->iSession;
        delete m_native;
      }

      QBENCHMARK {
        // define/init native features we need native
        m_native = new OsNative;
        m_native->iSession = CMsvSession::OpenSyncL(*m_native);
        m_native->iMtmRegistry = CClientMtmRegistry::NewL(*m_native->iSession);
        m_native->iSmsMtm = STATIC_CAST(CSmsClientMtm*, m_native->iMtmRegistry->NewMtmL(KUidMsgTypeSMS));
        m_native->iImap4Mtm = STATIC_CAST(CImap4ClientMtm*, m_native->iMtmRegistry->NewMtmL(KUidMsgTypeIMAP4));
        m_native->iMmsMtm = STATIC_CAST(CMmsClientMtm*, m_native->iMtmRegistry->NewMtmL(KUidMsgTypeMultimedia));
      }
      
      __UHEAP_MARKEND;
#endif
    }

}

void tst_messaging::tst_counts_data()
{
    QTest::addColumn<tst_messaging::platform>("platform");
    QTest::addColumn<tst_messaging::bases>("base");

    QTest::newRow("Qt-Accounts") << tst_messaging::QMessaging << tst_messaging::Accounts;
//    QTest::newRow("Native-Accounts") << tst_messaging::Native << tst_messaging::Accounts;
    QTest::newRow("Qt-Folders") << tst_messaging::QMessaging << tst_messaging::Folders;
    QTest::newRow("Native-Folders") << tst_messaging::Native << tst_messaging::Folders;
    QTest::newRow("Qt-Messages") << tst_messaging::QMessaging << tst_messaging::Messages;
    QTest::newRow("Qt-MessagesAlt") << tst_messaging::QMessaging << tst_messaging::MessagesAlt;
    QTest::newRow("Native-Messages") << tst_messaging::Native << tst_messaging::Messages;

}

void tst_messaging::tst_counts()
{
    QFETCH(tst_messaging::platform, platform);
    QFETCH(tst_messaging::bases, base);
    
    if(platform == tst_messaging::QMessaging){
      int cnt;
      Q_UNUSED(cnt);
      if(base == tst_messaging::Accounts){
        QBENCHMARK {
          cnt = m_mgr->countAccounts();
        }
      }
      else if(base == tst_messaging::Folders){
        QBENCHMARK {
          cnt = m_mgr->countFolders();
        }
      }
      else if(base == tst_messaging::Messages){
        QBENCHMARK {
          cnt = m_mgr->countMessages();
        }        
      }
      else if(base == tst_messaging::MessagesAlt){
        QMessageIdList list;
        QBENCHMARK {
          list = m_mgr->queryMessages();
          cnt = list.count();
        }        
      }
      //qDebug() << "Got cnt: " << cnt;      
    }
    else if(platform == tst_messaging::Native){
#ifdef Q_OS_SYMBIAN
      QBENCHMARK {
        // Access the Inbox
        TMsvSelectionOrdering sort;
        CMsvEntry* inboxContext = CMsvEntry::NewL(*m_native->iSession, KMsvGlobalInBoxIndexEntryId, sort);
        CleanupStack::PushL(inboxContext);

        // Get all entries in the Inbox
        CMsvEntrySelection* entries = inboxContext->ChildrenL();
        CleanupStack::PushL(entries);


        TInt messages = entries->Count();

        CleanupStack::PopAndDestroy(2, inboxContext);
      }           
#endif
    }

}

void tst_messaging::tst_query_data()
{
    QTest::addColumn<tst_messaging::platform>("platform");
    QTest::addColumn<tst_messaging::bases>("base");

    QTest::newRow("Qt-Accounts") << tst_messaging::QMessaging << tst_messaging::Accounts;    
//    QTest::newRow("Qt-Folders") << tst_messaging::QMessaging << tst_messaging::Folders;    
    QTest::newRow("Qt-Messages") << tst_messaging::QMessaging << tst_messaging::Messages;
    
    QTest::newRow("Native-Accounts") << tst_messaging::Native << tst_messaging::Accounts;
    QTest::newRow("Native-Accounts-Imap") << tst_messaging::Native << tst_messaging::AccountsImap;
    QTest::newRow("Native-Accounts-Pop") << tst_messaging::Native << tst_messaging::AccountsPop;
    QTest::newRow("Native-Accounts-Smtp") << tst_messaging::Native << tst_messaging::AccountsSmtp;
    QTest::newRow("Native-Folders") << tst_messaging::Native << tst_messaging::Folders;
//    QTest::newRow("Native-Folders") << tst_messaging::Native << tst_messaging::FoldersEmail;
//    QTest::newRow("Native-Folders") << tst_messaging::Native << tst_messaging::FoldersSMS;
//    QTest::newRow("Native-Folders") << tst_messaging::Native << tst_messaging::FoldersMMS;
    QTest::newRow("Native-Messages") << tst_messaging::Native << tst_messaging::Messages;

}

void tst_messaging::tst_query()
{
    QFETCH(tst_messaging::platform, platform);
    QFETCH(tst_messaging::bases, base);
    
    if(platform == tst_messaging::QMessaging){
//      int cnt;
      if(base == tst_messaging::Accounts){
        QMessageAccountIdList list;
        QBENCHMARK {
          list = m_mgr->queryAccounts();
        }
      }
      else if(base == tst_messaging::Folders){
        QMessageFolderIdList list;
        QBENCHMARK {
          list = m_mgr->queryFolders();
        }
//        XXX The library returns inbox/drafts/sent for all default accounts and greatly exagerates the number of folders
//        qDebug() << "Number of folders: " << list.count();
//        while(!list.empty()){
//          QMessageFolder f(list.takeFirst());
//          qDebug() << "Folder: " << f.name(); 
//        }
      }
      else if(base == tst_messaging::Messages){
        QMessageIdList list;
        QBENCHMARK {
          list = m_mgr->queryMessages();
        }        
      }
      //qDebug() << "Got cnt: " << cnt;      
    }
    else if(platform == tst_messaging::Native){
#ifdef Q_OS_SYMBIAN
      if(base == tst_messaging::Accounts){
        CEmailAccounts *email = CEmailAccounts::NewLC();
        RArray<TPopAccount> aPop;
        RArray<TImapAccount> aImap;
        RArray<TSmtpAccount> aSmtp;
        
        QBENCHMARK {
          email->GetPopAccountsL(aPop);
          email->GetImapAccountsL(aImap);
          email->GetSmtpAccountsL(aSmtp);
        }
        CleanupStack::PopAndDestroy(email);        
      }
      else if(base == tst_messaging::AccountsImap) {
        CEmailAccounts *email = CEmailAccounts::NewLC();
        RArray<TImapAccount> aImap;        
        
        QBENCHMARK {          
          email->GetImapAccountsL(aImap);          
        }
        CleanupStack::PopAndDestroy(email);        
        
      }
      else if(base == tst_messaging::AccountsPop) {
        CEmailAccounts *email = CEmailAccounts::NewLC();
        RArray<TPopAccount> aPop;
        
        QBENCHMARK {
          email->GetPopAccountsL(aPop);
        }
        CleanupStack::PopAndDestroy(email);        
        
      }
      else if(base == tst_messaging::AccountsSmtp) {
        CEmailAccounts *email = CEmailAccounts::NewLC();
        RArray<TSmtpAccount> aSmtp;
        
        QBENCHMARK {
          email->GetSmtpAccountsL(aSmtp);
        }
        CleanupStack::PopAndDestroy(email);        
        
      }
      else if(base == tst_messaging::Folders){
        
        __UHEAP_MARK;
        
        CEmailAccounts *email = CEmailAccounts::NewLC();
        RArray<TPopAccount> aPop;
        RArray<TImapAccount> aImap;
        RArray<TSmtpAccount> aSmtp;
                
        email->GetPopAccountsL(aPop);
        email->GetImapAccountsL(aImap);
        email->GetSmtpAccountsL(aSmtp);
                

        RArray<TMsvId> aService;
        
//        qDebug() << "Pop Service: " << aPop.Count();
//        qDebug() << "Imap Service: " << aImap.Count();
//        qDebug() << "Smtp Service: " << aSmtp.Count();
        
        for(int i = 0; i < aPop.Count(); i++){
          aService.Append(aPop[i].iPopService);
        }
        for(int i = 0; i < aImap.Count(); i++){
          aService.Append(aImap[i].iImapService);
        }
        for(int i = 0; i < aSmtp.Count(); i++){
          aService.Append(aSmtp[i].iSmtpService);
        }
        
             
        if(aService.Count() == 0)
          QFAIL("No folders avaailable to query");
        
//        qDebug() << "Total services: " << aService.Count();
        
        int total;

        
        CMsvEntry* pEntry = NULL;        
        TRAPD(err, pEntry = m_native->iSession->GetEntryL(aService[0]));        
        if(err)
          QFAIL("Can't create entry object");
        CleanupStack::PushL(pEntry);

        
        QBENCHMARK {
          total = 0;
          for(int i = 0; i < aService.Count(); i++){
            
            TMsvId msvid = aService[i];
            
            TRAP(err, pEntry->SetEntryL(msvid)); // faster to call set, saves .2ms out of 2.7ms.
            if(err){
              qDebug() << "Failed: " << err;
              continue;
            }

            
            const TMsvEntry& entry = pEntry->Entry();
                        
            if (entry.iMtm == KUidMsgTypeSMS || entry.iMtm == KUidMsgTypeMultimedia || entry.iMtm == KUidMsgTypeSMTP) {
              total += 4;
#define KDocumentsEntryIdValue    0x1008
              pEntry->SetEntryL(KDocumentsEntryIdValue);
            }
            
            if (entry.iMtm == KUidMsgTypePOP3) {
                total+=1;
                continue;
            }
            
            CMsvEntryFilter* pFilter = CMsvEntryFilter::NewLC();
            pFilter->SetService(msvid);
            pFilter->SetType(KUidMsvFolderEntry);

            CMsvEntrySelection* pSelection = new(ELeave) CMsvEntrySelection;
            CleanupStack::PushL(pSelection);

            m_native->iSession->GetChildIdsL(pEntry->Entry().Id(), *pFilter, *pSelection);
            if (pSelection->Count() > 0) {
              for(TInt i = 0; i < pSelection->Count(); i++) {
//                ids.append(createQMessageFolderId(folderServiceEntryId, pSelection->At(i)));
//                qDebug() << "serviceId: " << msvid << " Got one: " <<  "selected: " << pSelection->At(i);
                total++;
                m_native->iFolders.Append(pSelection->At(i));
              }              
            }
            else {               
//              QString details = QString::fromUtf16(entry.iDetails.Ptr(),entry.iDetails.Length());
//              QString desc = QString::fromUtf16(entry.iDescription.Ptr(),entry.iDescription.Length());
//              qDebug() << "Nothing returned for: " << msvid << "entry: " << details << " - " << desc;
            }
            CleanupStack::PopAndDestroy(pSelection);
            CleanupStack::PopAndDestroy(pFilter);

          }
        }
        
//        qDebug() << "Number of Folders: " << total;
        
        aPop.Close();
        aImap.Close();
        aSmtp.Close();
        aService.Close();
        
        CleanupStack::PopAndDestroy(pEntry);        
        CleanupStack::PopAndDestroy(email);
        
        __UHEAP_MARKEND;
        
      }
      else if(base == tst_messaging::Messages) {
        
        RArray<TMsvId> aFolders;
        
        aFolders.Append(KMsvGlobalInBoxIndexEntryId);
        aFolders.Append(KMsvGlobalOutBoxIndexEntryId);
        aFolders.Append(KMsvDraftEntryId);
        aFolders.Append(KMsvSentEntryId);
        for(int i = 0; i < m_native->iFolders.Count(); i++)
          aFolders.Append(m_native->iFolders[i]);

        // Access the Inbox
        QBENCHMARK {

          for(int i = 0; i < aFolders.Count(); i++){
            TMsvSelectionOrdering sort;
            CMsvEntry* inboxContext = CMsvEntry::NewL(*m_native->iSession, aFolders[i], sort);
            CleanupStack::PushL(inboxContext);

            // Get all entries in the Inbox
            CMsvEntrySelection* entries = inboxContext->ChildrenL();
            CleanupStack::PushL(entries);

            TInt messages = entries->Count();
            for (TInt i = 0; i < messages; i++) {
              TMsvId entryID = entries->At(i);
              m_native->iSmsMtm->SwitchCurrentEntryL(entryID);

              CMsvEntry* entry;

              entry = m_native->iSession->GetEntryL((*entries)[i]);

              delete entry;

            }

            CleanupStack::PopAndDestroy(2, inboxContext);
          }
        }
      }
#endif
    }

}

void tst_messaging::tst_fetch_data()
{
  //qDebug() << "Start fetch_data";
    QTest::addColumn<tst_messaging::platform>("platform");
    QTest::addColumn<tst_messaging::bases>("base");

    QTest::newRow("Qt-Accounts") << tst_messaging::QMessaging << tst_messaging::Accounts;
    QTest::newRow("Native-Accounts") << tst_messaging::Native << tst_messaging::Accounts;
    QTest::newRow("Qt-Folders") << tst_messaging::QMessaging << tst_messaging::Folders;
    QTest::newRow("Native-Folders") << tst_messaging::Native << tst_messaging::Folders;
    QTest::newRow("Qt-Messages") << tst_messaging::QMessaging << tst_messaging::Messages;
    QTest::newRow("Native-Messages") << tst_messaging::Native << tst_messaging::Messages;
  //qDebug() << "End fetch_data";
}

void tst_messaging::tst_fetch()
{
  
    QFETCH(tst_messaging::platform, platform);
    QFETCH(tst_messaging::bases, base);
    
    //qDebug() << "Start fetch" << platform << " base: " << base;  
    if(platform == tst_messaging::QMessaging){
      int cnt;
      Q_UNUSED(cnt);
      if(base == tst_messaging::Accounts){
        QMessageAccountIdList list;
        QMessageAccount acc;
        list = m_mgr->queryAccounts();

        if(!list.empty()){
          QBENCHMARK_ONCE { // XXX Maybe a bug here, if you call account a lot system crashes        
            acc = m_mgr->account(list.takeFirst());
          }
        }
        if(m_mgr->error()){
          QFAIL(QString("Failed fetching accounts: %1").arg(m_mgr->error()).toAscii());
        }
      }
      else if(base == tst_messaging::Folders){
        QMessageFolderIdList list;
        QMessageFolder fol;
        list = m_mgr->queryFolders();

        if(!list.empty()) {
          QBENCHMARK {          
            fol = m_mgr->folder(list.takeFirst());          
          }
        }        
      }
      else if(base == tst_messaging::Messages){
        QMessageIdList list;
        QMessage msg;
        list = m_mgr->queryMessages();
        
        if(!list.empty()){
          QBENCHMARK {
            msg = m_mgr->message(list.takeFirst());
          }        
        }
      }
      //qDebug() << "Got cnt: " << cnt;      
    }
    else if(platform == tst_messaging::Native){
#ifdef Q_OS_SYMBIAN
      if(base == tst_messaging::Messages){
        __UHEAP_MARK;
        // Access the Inbox
        QBENCHMARK {

          TMsvSelectionOrdering sort;
          sort.SetSorting(EMsvSortByDateReverse);
          sort.SetShowInvisibleEntries(ETrue);

          CMsvEntry* inboxContext = CMsvEntry::NewL(*m_native->iSession, 
              KMsvGlobalInBoxIndexEntryId, sort);                
          CleanupStack::PushL(inboxContext);

          // Get all entries in the Inbox
          CMsvEntrySelection* entries = inboxContext->ChildrenL();
          CleanupStack::PushL(entries);

          TMsvId entryID = entries->At(0);
          const TUid mtm = inboxContext->ChildDataL(entryID).iMtm;

          if (mtm == KUidMsgTypeSMS) {

            m_native->iSmsMtm->SwitchCurrentEntryL(entryID);
            TRAPD(err, m_native->iSmsMtm->LoadMessageL());
            if(err){
              qDebug() << "LoadMessageL failed: " << err;
              continue;
            }
            CSmsHeader& header = m_native->iSmsMtm->SmsHeader();
          }
          else if (mtm == KUidMsgTypeMultimedia) {

            // TODO None of these have a data store...skip until it can be fixed
            QFAIL("MMS message handeling is broken, change setup to use non-MMS type");
          }
          else if (mtm == KUidMsgTypeIMAP4) {
            m_native->iImap4Mtm->SwitchCurrentEntryL(entryID);
            m_native->iImap4Mtm->LoadMessageL();            
          }
          else {
            qDebug() << "Got Type: " << mtm.iUid;
          }
          CleanupStack::PopAndDestroy(2, inboxContext);
        }
        __UHEAP_MARKEND;        
      }

#endif
    }
//qDebug() <<"End fetch";
}

void tst_messaging::tst_fetchAll_data()
{
    QTest::addColumn<tst_messaging::platform>("platform");
    QTest::addColumn<tst_messaging::bases>("base");

    QTest::newRow("Qt-Accounts") << tst_messaging::QMessaging << tst_messaging::Accounts;
    QTest::newRow("Native-Accounts") << tst_messaging::Native << tst_messaging::Accounts;
//    QTest::newRow("Qt-Folders") << tst_messaging::QMessaging << tst_messaging::Folders;
    QTest::newRow("Native-Folders") << tst_messaging::Native << tst_messaging::Folders;
    QTest::newRow("Qt-Messages") << tst_messaging::QMessaging << tst_messaging::Messages;
    QTest::newRow("Native-Messages") << tst_messaging::Native << tst_messaging::Messages;

}


void tst_messaging::tst_fetchAll()
{
    QFETCH(tst_messaging::platform, platform);
    QFETCH(tst_messaging::bases, base);
    
    if(platform == tst_messaging::QMessaging){      
      if(base == tst_messaging::Accounts){
        QMessageAccountIdList list;
        QMessageAccount acc;
        list = m_mgr->queryAccounts();

        QBENCHMARK {        
          while(!list.empty())
            acc = m_mgr->account(list.takeFirst());
        }
      }
      else if(base == tst_messaging::Folders){
        QMessageFolderIdList list;
        QMessageFolder fol;
        list = m_mgr->queryFolders();

        QBENCHMARK {
          while(!list.empty())
            fol = m_mgr->folder(list.takeFirst());          
        }
      }
      else if(base == tst_messaging::Messages){
        QMessageIdList list;
        QMessage msg;
        list = m_mgr->queryMessages();
        qDebug() << "Total fetched messages: " << list.count(); 
        QBENCHMARK {
          while(!list.empty())
            msg = m_mgr->message(list.takeFirst());
        }
// TODO this selects messages in built "My Folders" which the test for symbian native doesn't.  Fix me.        
//        list = m_mgr->queryMessages();
//        while(!list.empty()) {
//          msg = m_mgr->message(list.takeFirst());
//          qDebug() << "From: " << msg.from().recipient() << " subject: " << msg.subject();
//        }        
        
      }
      //qDebug() << "Got cnt: " << cnt;      
    }
    else if(platform == tst_messaging::Native){
#ifdef Q_OS_SYMBIAN
      if(base == tst_messaging::Messages){
        
        __UHEAP_MARK;
        
        RArray<TMsvId> aFolders;
        int total = 0;
        int skipped = 0;
        
        m_native->getFolders(aFolders);

        // Access the Inbox
        QBENCHMARK {

          for(int i = 0; i < aFolders.Count(); i++){
            TMsvSelectionOrdering sort;
            //sort.SetSorting(EMsvSortByDateReverse);
            sort.SetSorting(EMsvSortByNone);
            sort.SetShowInvisibleEntries(ETrue);
            
            CMsvEntry* inboxContext = CMsvEntry::NewL(*m_native->iSession, 
                aFolders[i], sort);                
            CleanupStack::PushL(inboxContext);

            // Get all entries in the Inbox
            CMsvEntrySelection* entries = inboxContext->ChildrenL();
            CleanupStack::PushL(entries);
            
            for (TInt i = 0; i < entries->Count(); i++) {              
              
              TMsvId entryID = entries->At(i);
              
              const TUid mtm = inboxContext->ChildDataL(entryID).iMtm;
              
//              qDebug() << "Entry: " << i << " mtm: " << hex << mtm.iUid;
              
              if (mtm == KUidMsgTypeSMS) {

                TRAP_IGNORE(m_native->iSmsMtm->SwitchCurrentEntryL(entryID));                
                TRAPD(err, m_native->iSmsMtm->LoadMessageL());
                if(err){
                  qDebug() << "LoadMessageL failed: " << err;
                  continue;
                }                
                //CSmsHeader& header = m_native->iSmsMtm->SmsHeader();                
                total++;
              }
              else if (mtm == KUidMsgTypeMultimedia) {

                // TODO None of these have a data store...skip until it can be fixed 
                
//                                 CMsvEntry* pEntry = NULL;        
//                                 pEntry = m_native->iSession->GetEntryL(entryID);        
//                                 const TMsvEntry& entry = pEntry->Entry();    
//                                 
//                                 QString details = QString::fromUtf16(entry.iDetails.Ptr(),entry.iDetails.Length());
//                                 QString desc = QString::fromUtf16(entry.iDescription.Ptr(),entry.iDescription.Length());
//                                 qDebug() << "Nothing returned for entry: " << entryID << "/" << entry.Id() << " " << details << " - " << desc << " Has store: " << pEntry->HasStoreL();
////                                 m_native->iImap4Mtm->SwitchCurrentEntryL(entry.Id());

                
//                m_native->iMmsMtm->SwitchCurrentEntryL(entryID);
//                TRAPD(err, m_native->iMmsMtm->LoadMessageL());
//                if(err){
//                  qDebug() << "LoadMessageL failed: " << err << "entryId/mtm" << entryID << "/" << mtm.iUid;
//                  continue;
//                }
                skipped++;
              }
              else if (mtm == KUidMsgTypeIMAP4) {                 
                 CMsvEntry* pEntry = NULL;        
                 pEntry = m_native->iSession->GetEntryL(entryID);

                 CImEmailMessage *pMsg = CImEmailMessage::NewLC(*pEntry);                 

                 CMsvStore *store;                 
                 TRAPD(err, store = pEntry->ReadStoreL());
                 if(err){
//                   TPtrC sub;
//                   m_native->iImap4Mtm->SwitchCurrentEntryL(entryID);
//                   m_native->iImap4Mtm->LoadMessageL();                   
//                   TRAP(err,sub.Set(m_native->iImap4Mtm->SubjectL()));
//                   if(err){
//                     qDebug() << "No subject either: " << err;                     
//                   }                   
//                   qDebug() << "Can't read store: " << err << hex << entryID << " Details: " << QString::fromUtf16(sub.Ptr(), sub.Length());
                   skipped++;
                   CleanupStack::PopAndDestroy(pMsg);
                   continue;
                 }
                 CleanupStack::PushL(store);
                 
                 CImHeader* header = CImHeader::NewLC();                 
                 header->RestoreL(*store);
                 
                 //subject buffer contains the "subject" of the mail.
                 TBuf<50> subject = header->Subject();
                  
                 //header buffer contains the "header" of the mail.
                 TBuf<50> from = header->From();

//                 TODO: Find out why we don't select messages from the system My Folder store.
//                 QString qsubject = QString::fromUtf16(subject.Ptr(),subject.Length());
//                 QString qfrom = QString::fromUtf16(from.Ptr(),from.Length());
//                 qDebug() << "From: " << qfrom << " subject: " << qsubject;

                 CleanupStack::PopAndDestroy(header);
                 CleanupStack::PopAndDestroy(store);
                 CleanupStack::PopAndDestroy(pMsg);
                 
                 total++;
               }
              else {
//                qDebug() << "Got Type: " << mtm.iUid;
              }
            }
            CleanupStack::PopAndDestroy(2, inboxContext);           
          }          
        }
        qDebug() << "Total messages fetched: " << total << " skipped: " << skipped;
        __UHEAP_MARKEND;
      }            
#endif
    }

}



void tst_messaging::tst_fetchFilter_data()
{
  QTest::addColumn<tst_messaging::platform>("platform");
  QTest::addColumn<tst_messaging::filter>("filter");
  
  QTest::newRow("Qt-Id") << tst_messaging::QMessaging << tst_messaging::Id;
  QTest::newRow("Qt-Type") << tst_messaging::QMessaging << tst_messaging::Type;
  QTest::newRow("Qt-Sender") << tst_messaging::QMessaging << tst_messaging::Sender;
  QTest::newRow("Qt-Subject") << tst_messaging::QMessaging << tst_messaging::Subject;
  QTest::newRow("Qt-TimeStamp") << tst_messaging::QMessaging << tst_messaging::TimeStamp;
  QTest::newRow("Qt-Status") << tst_messaging::QMessaging << tst_messaging::Status;
  QTest::newRow("Qt-Priority") << tst_messaging::QMessaging << tst_messaging::Priority;
  QTest::newRow("Qt-Size") << tst_messaging::QMessaging << tst_messaging::Size;
  QTest::newRow("Qt-AllId") << tst_messaging::QMessaging << tst_messaging::AllId;
  QTest::newRow("Qt-AllSender") << tst_messaging::QMessaging << tst_messaging::AllSender;
  
  QTest::newRow("Native-Id") << tst_messaging::Native << tst_messaging::Id;
  QTest::newRow("Native-Type") << tst_messaging::Native << tst_messaging::Type;
  QTest::newRow("Native-Sender") << tst_messaging::Native << tst_messaging::Sender;
  QTest::newRow("Native-Subject") << tst_messaging::Native << tst_messaging::Subject;
  QTest::newRow("Native-TimeStamp") << tst_messaging::Native << tst_messaging::TimeStamp;
  QTest::newRow("Native-Status") << tst_messaging::Native << tst_messaging::Status;
  QTest::newRow("Native-Priority") << tst_messaging::Native << tst_messaging::Priority;
  QTest::newRow("Native-Size") << tst_messaging::Native << tst_messaging::Size;
  QTest::newRow("Native-AllId") << tst_messaging::Native << tst_messaging::AllId;
  QTest::newRow("Native-AllSender") << tst_messaging::Native << tst_messaging::AllSender;
  
  // QTest::newRow("Native-Size") << tst_messaging::Native << tst_messaging::Size;
}

void tst_messaging::tst_fetchFilter()
{
  QFETCH(tst_messaging::platform, platform);
  QFETCH(tst_messaging::filter, filter);
  
  if(platform == tst_messaging::QMessaging){

    QMessageId msgId;
    QMessageFilter mf;
    QMessageId id;
    // let's assume we want equal tests for all the filters.
    // So let's try and filter out 1 message from each filter request.    
    if(filter == tst_messaging::Id){
        mf = QMessageFilter::byId(id);
        msg_list.push_back(id);        
    }
    else if(filter == tst_messaging::Type){      
        QMessage *msg = messageTemplate();
        // XXX this segfault
        //msg->setType(QMessage::Sms);
        
        msgId = addMessage(msg);       
        mf = QMessageFilter::byType(QMessage::Sms);
        
    }  
    else if(filter == tst_messaging::Sender){
        QString email = "singletst@boo.com";
        QMessage *msg = messageTemplate();
        QMessageAddress addr;
        addr.setAddressee(email);
        msg->setFrom(addr);
        msgId = addMessage(msg);

        id = msg_list.takeFirst();
        mf = QMessageFilter::bySender(email);
    }
    else if(filter == tst_messaging::TimeStamp){
        QMessage *msg = messageTemplate();
        QDateTime dt = QDateTime::currentDateTime();
        dt.addDays(1);
        msg->setReceivedDate(dt);
        msg->setDate(dt);
        msgId = addMessage(msg);
        
        mf = QMessageFilter::byTimeStamp(dt, QMessageDataComparator::Equal);
    }
    else if(filter == tst_messaging::Status){
        QMessage *msg = messageTemplate();
        msg->setStatus(QMessage::Incoming);
        msgId = addMessage(msg);

        mf = QMessageFilter::byStatus(QMessage::Incoming);
    }
    else if(filter == tst_messaging::Subject){
      QMessage *msg = messageTemplate();
      QString subject = "skdflkdsjfl sdfklke  werewr";
      msg->setSubject(subject);
      msgId = addMessage(msg);
      
      mf = QMessageFilter::bySubject(subject);
    }
    else if(filter == tst_messaging::Priority){
        QMessage *msg = messageTemplate();
        msg->setPriority(QMessage::LowPriority);
        msgId = addMessage(msg);

        mf = QMessageFilter::byPriority(QMessage::LowPriority);
    }
    else if(filter == tst_messaging::Size){
        QString body;
        body.fill('x', 5120);
        QMessage *msg = messageTemplate();
        msg->setBody(body);
        msgId = addMessage(msg);

        mf = QMessageFilter::bySize(5000, QMessageDataComparator::GreaterThan);
    }
    else if(filter == tst_messaging::AllId){      
      mf = QMessageFilter::byId(msg_list);       
    }
    else if(filter == tst_messaging::AllSender){
      id = msg_list.takeFirst();      
      msg_list.push_back(id);   
      QMessage msg = m_mgr->message(id);
      
      mf = QMessageFilter::bySender(msg.from().addressee());
    }
    if(!mf.isSupported()){
        QFAIL("QMessage filter returned unsupported");
    }
    else if(mf.isEmpty()){
      QFAIL("Empty filter provided");
    }
    else {
        QMessageIdList list;
        QMessageSortOrder sortOrder(QMessageSortOrder::byReceptionTimeStamp(Qt::DescendingOrder));
   
        QBENCHMARK {          
            list = m_mgr->queryMessages(mf, sortOrder, 100);
        }
 
        if(list.count() != 1 && filter != tst_messaging::AllId && filter != tst_messaging::AllSender)
            qDebug() << "Wanted 1 message got: " << list.count();
    }

    if(msgId.isValid()){
        m_mgr->removeMessage(msgId);
    }
  }
  else if(platform == tst_messaging::Native){
#ifdef Q_OS_SYMBIAN
    if(filter == tst_messaging::Id){
      // Access the Inbox
      QBENCHMARK {
        TMsvSelectionOrdering sort;
        //sort.SetSorting(EMsvSortByDateReverse);
        sort.SetSorting(EMsvSortById);
        sort.SetShowInvisibleEntries(ETrue);
          
        CMsvEntry* inboxContext = CMsvEntry::NewL(*m_native->iSession, 
            KMsvGlobalInBoxIndexEntryId, sort);                
        CleanupStack::PushL(inboxContext);

        // Get all entries in the Inbox
        CMsvEntrySelection* entries = inboxContext->ChildrenL();
        CleanupStack::PushL(entries);
        
        TMsvId entryID = entries->At(0);

        const TUid mtm = inboxContext->ChildDataL(entryID).iMtm;
      
        CleanupStack::PopAndDestroy(2, inboxContext);
      }
    }
    else if(filter == tst_messaging::Type){ // look for SMS messages
      // Access the Inbox
      RArray<TMsvId> msvids;
      RArray<TMsvId> aFolders;
    
      m_native->getFolders(aFolders);
      
      //qDebug() << "Total folders: " << aFolders.Count();
    
      QBENCHMARK {
        msvids.Close(); // zero it out
        for(int i = 0; i < aFolders.Count(); i++){

          TMsvSelectionOrdering sort;
          //sort.SetSorting(EMsvSortByDateReverse);
          sort.SetSorting(EMsvSortByNone);
          sort.SetShowInvisibleEntries(ETrue);

          CMsvEntry* inboxContext = CMsvEntry::NewL(*m_native->iSession, 
              aFolders[i], sort);                
          CleanupStack::PushL(inboxContext);

          // Get all entries in the Inbox
          CMsvEntrySelection* entries = inboxContext->ChildrenL();
          CleanupStack::PushL(entries);

          for (TInt j = 0; j < entries->Count(); j++) {
            TMsvId entryID = entries->At(j);
            const TUid mtm = inboxContext->ChildDataL(entryID).iMtm;

            if (mtm == KUidMsgTypeSMS) {
              msvids.AppendL(entryID);
            }
          }      
          CleanupStack::PopAndDestroy(2, inboxContext);
        }
      }
      msvids.Close();
    }
    else if(filter == tst_messaging::Sender || 
        filter == tst_messaging::Subject ||
        filter == tst_messaging::TimeStamp){
      // Access the Inbox
        
      TMsvPartList part = KMsvMessagePartDescription;
      TPtrC text = _L("tst");
      
      if(filter == tst_messaging::Sender){
        part = KMsvMessagePartOriginator;
        text.Set(_L("Millicent"));
      }
      else if(filter == tst_messaging::Subject){
        part = KMsvMessagePartDescription;
        text.Set(_L("Free Bottle"));
      }
      else if(filter == tst_messaging::TimeStamp){
        part = KMsvMessagePartDate;
        text.Set(_L("Sep"));
      }

      CMsvOperationActiveSchedulerWait* waiter=CMsvOperationActiveSchedulerWait::NewLC();
      
      CMsvFindOperation *finder = CMsvFindOperation::FindInChildrenL(*m_native->iSession, text, KMsvRootIndexEntryId, part, waiter->iStatus);
      CleanupStack::PushL(finder);

      QBENCHMARK {      
        waiter->Start();
      }
      if(finder->GetFindResult().Count() != 1)
        qDebug() << "Wanted 1 message, got: " << finder->GetFindResult().Count(); 
      
//      qDebug() << "Status: " << finder->GetFindResult().Count();
//      for(int i = 0; i < finder->GetFindResult().Count(); i++){
//        CMsvEntry *pEntry;
//        TRAPD(err, pEntry = m_native->iSession->GetEntryL(finder->GetFindResult().At(i).iId));
//        if(err){
//          qDebug() << "Failed to fetch: " << i << " - " << finder->GetFindResult().At(i).iId;
//          continue;
//        }
//        CleanupStack::PushL(pEntry);
//        TMsvEntry entry = pEntry->Entry();
//        QString details = QString::fromUtf16(entry.iDetails.Ptr(),entry.iDetails.Length());
//        QString desc = QString::fromUtf16(entry.iDescription.Ptr(),entry.iDescription.Length());
//        qDebug() << "Got entry: " << details << " - " << desc;
//        CleanupStack::PopAndDestroy(1); //
//      }
       
      CleanupStack::PopAndDestroy(2, waiter); 
      
    }
    else if(filter == tst_messaging::Priority) {
      RArray<TMsvId> msvids;

      CMsvOperationActiveSchedulerWait* waiter=CMsvOperationActiveSchedulerWait::NewLC();
      
      TBufC<10> null(_L(" "));
      CMsvFindOperation *finder = CMsvFindOperation::FindInChildrenL(*m_native->iSession, null, KMsvRootIndexEntryId, KMsvMessagePartDescription, waiter->iStatus);
      CleanupStack::PushL(finder);

      QBENCHMARK {      
        waiter->Start();
        
        const CMsvFindResultSelection &res = finder->GetFindResult();
        
        for(int i = 0; i < res.Count(); i++){          
          CMsvEntry *pEntry;
          TRAPD(err, pEntry = m_native->iSession->GetEntryL(res.At(i).iId));
          if(err){
            qDebug() << "Failed to fetch: " << i << " - " << res.At(i).iId;
            continue;
          }
          CleanupStack::PushL(pEntry);
          TMsvEntry entry = pEntry->Entry();

          if(entry.Priority() == EMsvLowPriority) 
            msvids.Append(entry.Id());
          
          CleanupStack::PopAndDestroy(1); //
        }
      }
      msvids.Close();
      CleanupStack::PopAndDestroy(2, waiter);
    }
    else if(filter == tst_messaging::Size){
      RArray<TMsvId> msvids;

      CMsvOperationActiveSchedulerWait* waiter=CMsvOperationActiveSchedulerWait::NewLC();
      
      TBufC<10> null(_L(" "));
      CMsvFindOperation *finder = CMsvFindOperation::FindInChildrenL(*m_native->iSession, null, KMsvRootIndexEntryId, KMsvMessagePartDescription, waiter->iStatus);
      CleanupStack::PushL(finder);

      QBENCHMARK {      
        waiter->Start();
        
        const CMsvFindResultSelection &res = finder->GetFindResult();
        
        for(int i = 0; i < res.Count(); i++){          
          CMsvEntry *pEntry;
          TRAPD(err, pEntry = m_native->iSession->GetEntryL(res.At(i).iId));
          if(err){
            qDebug() << "Failed to fetch: " << i << " - " << res.At(i).iId;
            continue;
          }
          CleanupStack::PushL(pEntry);
          TMsvEntry entry = pEntry->Entry();

          if(entry.iSize == 550)
            msvids.Append(entry.Id());          
          
          CleanupStack::PopAndDestroy(1); //
        }
      }
      msvids.Close();
      CleanupStack::PopAndDestroy(2, waiter);      
    }
    if(filter == tst_messaging::AllId){
      // Access the Inbox
      QBENCHMARK {
        RArray<TMsvId> msvids;
        
        TMsvSelectionOrdering sort;
        //sort.SetSorting(EMsvSortByDateReverse);
        sort.SetSorting(EMsvSortById);
        sort.SetShowInvisibleEntries(ETrue);
          
        CMsvEntry* inboxContext = CMsvEntry::NewL(*m_native->iSession, 
            KMsvGlobalInBoxIndexEntryId, sort);                
        CleanupStack::PushL(inboxContext);

        // Get all entries in the Inbox
        CMsvEntrySelection* entries = inboxContext->ChildrenL();
        CleanupStack::PushL(entries);
        
        for(int i = 0; i < entries->Count(); i++){
          msvids.Append(entries->At(i));
        }

        msvids.Close();       
        
        CleanupStack::PopAndDestroy(2, inboxContext);
      }
    }
    else if(filter == tst_messaging::AllSender){
      RArray<TMsvId> msvids;

      CMsvOperationActiveSchedulerWait* waiter=CMsvOperationActiveSchedulerWait::NewLC();
      
      TBufC<10> null(_L("@"));
      CMsvFindOperation *finder = CMsvFindOperation::FindInChildrenL(*m_native->iSession, null, KMsvRootIndexEntryId, KMsvMessagePartOriginator, waiter->iStatus);
      CleanupStack::PushL(finder);

      QBENCHMARK {      
        waiter->Start();
        
        const CMsvFindResultSelection &res = finder->GetFindResult();        
        TMsvSelectionOrdering order;
        
        CMsvEntry *pEntry = CMsvEntry::NewL(*m_native->iSession, KMsvRootIndexEntryId, TMsvSelectionOrdering(KMsvNoGrouping, EMsvSortByNone));
        CleanupStack::PushL(pEntry);
        
        for(int i = 0; i < res.Count(); i++){
          TRAPD(err, pEntry->SetEntryL(res.At(i).iId));          
          if(err){
            qDebug() << "Failed to fetch: " << i << " - " << res.At(i).iId;
            continue;
          }
          TMsvEntry entry = pEntry->Entry();
          
          msvids.Append(entry.Id());          
                  
        }
        
        CleanupStack::PopAndDestroy(pEntry);
      }
      msvids.Close();
      CleanupStack::PopAndDestroy(2, waiter);          
    }
#endif
  }      
}

void tst_messaging::clearMessages()
{
  QMessageId id;
  while(!msg_list.empty())
    m_mgr->removeMessage(msg_list.takeFirst());
}

QMessage *tst_messaging::messageTemplate()
{
  QMessage *msg = new QMessage;
  
  msg->setDate(QDateTime::currentDateTime());
  msg->setSubject("test");
  QMessageAddress addr;
  addr.setAddressee("abr@foo.com");
  addr.setType(QMessageAddress::Email);
  msg->setTo(addr);
  addr.setAddressee("from@bar.com");
  addr.setType(QMessageAddress::Email);
  msg->setFrom(addr);

// XXX one or more of these cause problems 
//  msg->setType(QMessage::Email);
//  msg->setStatus(QMessage::Read);
  
//  msg->setBody("I have a body!");
//  msg->setParentAccountId(m_fol.parentAccountId());
  
  return msg;
}

QMessageId tst_messaging::addMessage(QMessage *msg)
{
  m_mgr->addMessage(msg);  
  msg_list.append(msg->id());

  //qDebug() << "id: " << msg->id().toString();
  
  return msg->id();
}

QMessage *tst_messaging::createMessage()
{
    QMessage *msg = messageTemplate();
    addMessage(msg);
    return msg;
}

int tst_messaging::countMessages()
{
  QMessageIdList list;
  list = m_mgr->queryMessages();
  return list.count();
}

void tst_messaging::tst_addMessage_data()
{
    QTest::addColumn<tst_messaging::platform>("platform");    
    QTest::addColumn<tst_messaging::types>("type");
    
    QTest::newRow("Qt-Email") << tst_messaging::QMessaging << tst_messaging::Email;
    QTest::newRow("Native-SMS") << tst_messaging::Native << tst_messaging::Sms; 
    QTest::newRow("Native-Email") << tst_messaging::Native << tst_messaging::Email;
   
}

void tst_messaging::tst_addMessage()
{
    QFETCH(tst_messaging::platform, platform);
    QFETCH(tst_messaging::types, type);
    
    if(platform == tst_messaging::QMessaging){
      QBENCHMARK {
        QMessage *msg = createMessage();
        addMessage(msg);
      }
    }
    else if(platform == tst_messaging::Native){
#ifdef Q_OS_SYMBIAN
      if(type == tst_messaging::Sms){
        TMsvId id;
        QBENCHMARK {
          id = m_native->makeSMS(KMsvDraftEntryIdValue);
        }
        m_native->iNewMsgs.Append(id);
      }
      else if(type == tst_messaging::Email){
        TMsvId id;
        QBENCHMARK {
          m_native->makeIMAP4(KMsvDraftEntryIdValue);
        }
        m_native->iNewMsgs.Append(id);
      }
#else 
    Q_UNUSED(type);
#endif
    }

}

void tst_messaging::tst_removeMessage_data()
{
  QTest::addColumn<tst_messaging::platform>("platform");    

  QTest::newRow("Qt-remove") << tst_messaging::QMessaging;
  QTest::newRow("Native-remove") << tst_messaging::Native;  
}

void tst_messaging::tst_removeMessage() 
{
  QFETCH(tst_messaging::platform, platform);

  if(platform == tst_messaging::QMessaging){
#ifdef Q_OS_SYMBIAN
      TMsvId id;
      id = m_native->makeIMAP4(KMsvDraftEntryIdValue);
      QString str;
      str.setNum(id);
      QMessageId qmid = str;    
#else
      QMessageId qmid = msg_list.takeFirst();
#endif

   QBENCHMARK_ONCE {
          m_mgr->removeMessage(qmid);
    }
  }  
  else if(platform == tst_messaging::Native){
#ifdef Q_OS_SYMBIAN
      TMsvId id;
      id = m_native->makeIMAP4(KMsvDraftEntryIdValue);      
      CMsvEntry *pEntry = CMsvEntry::NewL(*m_native->iSession, id, TMsvSelectionOrdering());
      CleanupStack::PushL(pEntry);
      QBENCHMARK_ONCE {    // We're only guaranteed one entry to delete.  Not a fast process anyways.s
          TRAPD(err, pEntry->DeleteL(id)); // slightly dangerous since we never want this failing, but it can fail too something, should debug TODO
          if(err){
          QFAIL(QString("Message delete failed with error: " + QString::number(err)).toAscii());
          }
      }
      CleanupStack::PopAndDestroy(pEntry);          
#endif
  }

}

void tst_messaging::tst_removeAllMessage_data()
{
  QTest::addColumn<tst_messaging::platform>("platform");    

  QTest::newRow("Qt-removeAll") << tst_messaging::QMessaging;
  QTest::newRow("Native-removeAll") << tst_messaging::Native;  
}

void tst_messaging::tst_removeAllMessage() 
{
  QFETCH(tst_messaging::platform, platform);

  if(platform == tst_messaging::QMessaging){
    QBENCHMARK {
      while(!msg_list.empty())
        m_mgr->removeMessage(msg_list.takeFirst());
    }
  }
  else if(platform == tst_messaging::Native){
#ifdef Q_OS_SYMBIAN
    // make sure there's enough messages to delete
    while(m_native->iNewMsgs.Count() < 30) {
      TMsvId id;
      id = m_native->makeSMS(KMsvDraftEntryIdValue);      
      m_native->iNewMsgs.Append(id);
    }
    
    QBENCHMARK {      
      CMsvEntry *pEntry;
      TRAPD(err, pEntry = CMsvEntry::NewL(*m_native->iSession, KMsvRootIndexEntryId, TMsvSelectionOrdering()));
      if(err){
        qDebug() << "Failed to init CMsvEntryL " << err;
        return;
      }
      CleanupStack::PushL(pEntry);
      while(m_native->iNewMsgs.Count() != 0) {
        TMsvId id = m_native->iNewMsgs[0];
        m_native->iNewMsgs.Remove(0);    
        //pEntry->SetEntryL(id);
        TRAP_IGNORE(pEntry->DeleteL(id));                
      }
      CleanupStack::PopAndDestroy(pEntry);
    }
#endif
  }

}

#if defined(Q_OS_SYMBIAN)

void OsNative::getFolders(RArray<TMsvId> &folders) {
  __UHEAP_MARK;

  CEmailAccounts *email = CEmailAccounts::NewLC();
  RArray<TPopAccount> aPop;
  RArray<TImapAccount> aImap;
  RArray<TSmtpAccount> aSmtp;

#ifndef KDocumentsEntryIdValue
#define KDocumentsEntryIdValue    0x1008
#endif
  
  folders.Append(KMsvRootIndexEntryId);
  folders.Append(KMsvLocalServiceIndexEntryId);
  folders.Append(KMsvGlobalInBoxIndexEntryId);
  folders.Append(KMsvGlobalOutBoxIndexEntryId);
  folders.Append(KMsvDraftEntryId);
  folders.Append(KMsvSentEntryId);
  folders.Append(KMsvDeletedEntryFolderEntryId);
  folders.Append(KDocumentsEntryIdValue);

  email->GetPopAccountsL(aPop);
  email->GetImapAccountsL(aImap);
  email->GetSmtpAccountsL(aSmtp);

  RArray<TMsvId> aService;

  for(int i = 0; i < aPop.Count(); i++){
    aService.Append(aPop[i].iPopService);
  }
  for(int i = 0; i < aImap.Count(); i++){
    aService.Append(aImap[i].iImapService);
  }
  for(int i = 0; i < aSmtp.Count(); i++){
    aService.Append(aSmtp[i].iSmtpService);
  }
  
  TSmtpAccount sacc;
  if(email->DefaultSmtpAccountL(sacc))
    aService.Append(sacc.iSmtpService);

  if(aService.Count() == 0)
    QFAIL("No folders avaailable to query");

  CMsvEntry* pEntry = NULL;        
  pEntry = iSession->GetEntryL(aService[0]);        
  CleanupStack::PushL(pEntry);

  for(int i = 0; i < aService.Count(); i++){
      TMsvId msvid = aService[i];

      pEntry->SetEntryL(msvid); // faster to call set, saves .2ms out of 2.7ms.

      const TMsvEntry& entry = pEntry->Entry();
 
      CMsvEntryFilter* pFilter = CMsvEntryFilter::NewLC();
      pFilter->SetService(msvid);
      pFilter->SetType(KUidMsvFolderEntry);

      CMsvEntrySelection* pSelection = new(ELeave) CMsvEntrySelection;
      CleanupStack::PushL(pSelection);
      
      if (entry.iMtm == KUidMsgTypeSMS || entry.iMtm == KUidMsgTypeMultimedia || entry.iMtm == KUidMsgTypeSMTP) 
        pEntry->SetEntryL(KDocumentsEntryIdValue);          
      
      //iSession->GetChildIdsL(pEntry->Entry().Id(), *pFilter, *pSelection);
      iSession->GetChildIdsL(pEntry->Entry().Id(), *pFilter, *pSelection);
     
      for(TInt i = 0; i < pSelection->Count(); i++) {
        folders.Append(pSelection->At(i));
      }              
      
      CleanupStack::PopAndDestroy(pSelection);
      CleanupStack::PopAndDestroy(pFilter);

    }

    aPop.Close();
    aImap.Close();
    aSmtp.Close();
    aService.Close();

    CleanupStack::PopAndDestroy(pEntry);        
    CleanupStack::PopAndDestroy(email);
  __UHEAP_MARKEND;
}
#endif 

int main(int argc, char **argv){

    QApplication app(argc, argv);
    
    tst_messaging test1;
    QTest::qExec(&test1, argc, argv);
    
}
//QTEST_MAIN(tst_messaging);


#include "tst_messaging.moc"

