/****************************************************************************
**
** Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** This file is part of the Qt Mobility Components.
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights.  These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** Nokia at qt-info@nokia.com.
**
**
**
**
**
**
**
**
** $QT_END_LICENSE$
**
****************************************************************************/


#include <QtTest/QtTest>
#include <QStringList>

#include "ut_cntsqlsearch.h"
#include "cntsqlsearch.h"

#define WRITE_LOGS
//#define SQL_QT_TEST

#if defined(WRITE_LOGS)
#include <e32debug.h> // RDebug

#define LOG(a)              WriteLog(a, "")
#define LOG2(a, b)          WriteLog(a, b)
#define TEST_BEGIN_LOG(a)   LOG(a##" begins")
#define TEST_PASSED_LOG(a)  LOG(a##" passed")

void WriteLog(const QString a, const QString b);
void WritePart(const TDesC& s);
#else
#define LOG(a)
#define LOG2(a, b)
#define TEST_BEGIN_LOG(a)
#define TEST_PASSED_LOG(a)
#endif


void UT_CntSqlSearch::initTestCase()
{
}

void UT_CntSqlSearch::cleanupTestCase()
{
}


void UT_CntSqlSearch::init()
{
mCntSqlSearch = new CntSqlSearch();
}

void UT_CntSqlSearch::cleanup()
{
    delete mCntSqlSearch;
    mCntSqlSearch = 0;
    
}
void UT_CntSqlSearch::testPredictiveSearch()
{
    TEST_BEGIN_LOG("testPredictiveSearch");
    
    QString pattern = QString("205");
#if defined(SEARCH_FROM_ONE_TABLE)
#if defined(USE_DEMORGAN)
    QString reference("SELECT contact_id FROM predictivesearch2 WHERE NOT(NOT(NOT(NOT(nbr>145522562959409151 AND nbr<145804037936119808) AND NOT(nbr2>145522562959409151 AND nbr2<145804037936119808) AND NOT(nbr3>145522562959409151 AND nbr3<145804037936119808) AND NOT(nbr4>145522562959409151 AND nbr4<145804037936119808))) AND NOT(NOT(NOT(nbr2>360287970189639679 AND nbr2<432345564227567616 AND nbr>144115188075855871 AND nbr<216172782113783808) AND NOT(nbr3>360287970189639679 AND nbr3<432345564227567616 AND nbr>144115188075855871 AND nbr<216172782113783808) AND NOT(nbr3>360287970189639679 AND nbr3<432345564227567616 AND nbr2>144115188075855871 AND nbr2<216172782113783808) AND NOT(nbr4>360287970189639679 AND nbr4<432345564227567616 AND nbr>144115188075855871 AND nbr<216172782113783808) AND NOT(nbr4>360287970189639679 AND nbr4<432345564227567616 AND nbr2>144115188075855871 AND nbr2<216172782113783808) AND NOT(nbr4>360287970189639679 AND nbr4<432345564227567616 AND nbr3>144115188075855871 AND nbr3<216172782113783808))) AND NOT(NOT(NOT(nbr2>144115188075855871 AND nbr2<216172782113783808 AND nbr>360287970189639679 AND nbr<432345564227567616) AND NOT(nbr3>144115188075855871 AND nbr3<216172782113783808 AND nbr>360287970189639679 AND nbr<432345564227567616) AND NOT(nbr3>144115188075855871 AND nbr3<216172782113783808 AND nbr2>360287970189639679 AND nbr2<432345564227567616) AND NOT(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr>360287970189639679 AND nbr<432345564227567616) AND NOT(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr2>360287970189639679 AND nbr2<432345564227567616) AND NOT(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr3>360287970189639679 AND nbr3<432345564227567616)))) ORDER BY predictivesearch2.first_name, predictivesearch2.last_name ASC;");
#else // #if defined(USE_DEMORGAN)
    QString reference("SELECT contact_id FROM predictivesearch2 WHERE \
((nbr>145522562959409151 AND nbr<145804037936119808) OR (nbr2>145522562959409151 AND nbr2<145804037936119808) \
OR (nbr3>145522562959409151 AND nbr3<145804037936119808) OR (nbr4>145522562959409151 AND nbr4<145804037936119808)) OR \
(nbr2>360287970189639679 AND nbr2<432345564227567616 AND nbr>144115188075855871 AND nbr<216172782113783808) OR \
(nbr3>360287970189639679 AND nbr3<432345564227567616 AND nbr>144115188075855871 AND nbr<216172782113783808) OR \
(nbr3>360287970189639679 AND nbr3<432345564227567616 AND nbr2>144115188075855871 AND nbr2<216172782113783808) OR \
(nbr4>360287970189639679 AND nbr4<432345564227567616 AND nbr>144115188075855871 AND nbr<216172782113783808) OR \
(nbr4>360287970189639679 AND nbr4<432345564227567616 AND nbr2>144115188075855871 AND nbr2<216172782113783808) OR \
(nbr4>360287970189639679 AND nbr4<432345564227567616 AND nbr3>144115188075855871 AND nbr3<216172782113783808) OR \
(nbr2>144115188075855871 AND nbr2<216172782113783808 AND nbr>360287970189639679 AND nbr<432345564227567616) OR \
(nbr3>144115188075855871 AND nbr3<216172782113783808 AND nbr>360287970189639679 AND nbr<432345564227567616) OR \
(nbr3>144115188075855871 AND nbr3<216172782113783808 AND nbr2>360287970189639679 AND nbr2<432345564227567616) OR \
(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr>360287970189639679 AND nbr<432345564227567616) OR \
(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr2>360287970189639679 AND nbr2<432345564227567616) OR \
(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr3>360287970189639679 AND nbr3<432345564227567616) \
ORDER BY predictivesearch2.first_name, predictivesearch2.last_name ASC;");
#endif // #if defined(USE_DEMORGAN)
#else // #if defined(SEARCH_FROM_ONE_TABLE) 
    QString reference("SELECT predictivesearch2.contact_id FROM predictivesearch2 WHERE EXISTS (SELECT contact_id FROM predictivesearch5 WHERE predictivesearch2.contact_id = predictivesearch5.contact_id) OR (SELECT contact_id FROM predictivesearch2 WHERE (NOT(NOT(predictivesearch2.nbr>145522562959409151 AND predictivesearch2.nbr<145804037936119808) AND NOT(predictivesearch2.nbr2>145522562959409151 AND predictivesearch2.nbr2<145804037936119808) AND NOT(predictivesearch2.nbr3>145522562959409151 AND predictivesearch2.nbr3<145804037936119808) AND NOT(predictivesearch2.nbr4>145522562959409151 AND predictivesearch2.nbr4<145804037936119808)))) ORDER BY predictivesearch2.first_name, predictivesearch2.last_name ASC;");
#endif // #if defined(SEARCH_FROM_ONE_TABLE)
    QString result = mCntSqlSearch->CreatePredictiveSearch(pattern);
    qDebug() << pattern << "-> result" << result;
    LOG2(pattern, result);
    QVERIFY(!result.compare(reference));

    pattern = QString("101");
#if defined(USE_DEMORGAN)
    reference = QString("SELECT contact_id FROM predictivesearch1 WHERE NOT(NOT(NOT(NOT(nbr>72339069014638591 AND nbr<72620543991349248) AND NOT(nbr2>72339069014638591 AND nbr2<72620543991349248) AND NOT(nbr3>72339069014638591 AND nbr3<72620543991349248) AND NOT(nbr4>72339069014638591 AND nbr4<72620543991349248))) AND NOT(NOT(NOT(nbr2>72057594037927935 AND nbr2<144115188075855872 AND nbr>72057594037927935 AND nbr<144115188075855872) AND NOT(nbr3>72057594037927935 AND nbr3<144115188075855872 AND nbr>72057594037927935 AND nbr<144115188075855872) AND NOT(nbr3>72057594037927935 AND nbr3<144115188075855872 AND nbr2>72057594037927935 AND nbr2<144115188075855872) AND NOT(nbr4>72057594037927935 AND nbr4<144115188075855872 AND nbr>72057594037927935 AND nbr<144115188075855872) AND NOT(nbr4>72057594037927935 AND nbr4<144115188075855872 AND nbr2>72057594037927935 AND nbr2<144115188075855872) AND NOT(nbr4>72057594037927935 AND nbr4<144115188075855872 AND nbr3>72057594037927935 AND nbr3<144115188075855872)))) ORDER BY predictivesearch1.first_name, predictivesearch1.last_name ASC;");
#else
    reference = QString("SELECT contact_id FROM predictivesearch1 WHERE ((nbr>72339069014638591 AND nbr<72620543991349248) OR (nbr2>72339069014638591 AND nbr2<72620543991349248) OR (nbr3>72339069014638591 AND nbr3<72620543991349248) OR (nbr4>72339069014638591 AND nbr4<72620543991349248)) OR (nbr2>72057594037927935 AND nbr2<144115188075855872 AND nbr>72057594037927935 AND nbr<144115188075855872) OR (nbr3>72057594037927935 AND nbr3<144115188075855872 AND nbr>72057594037927935 AND nbr<144115188075855872) OR (nbr3>72057594037927935 AND nbr3<144115188075855872 AND nbr2>72057594037927935 AND nbr2<144115188075855872) OR (nbr4>72057594037927935 AND nbr4<144115188075855872 AND nbr>72057594037927935 AND nbr<144115188075855872) OR (nbr4>72057594037927935 AND nbr4<144115188075855872 AND nbr2>72057594037927935 AND nbr2<144115188075855872) OR (nbr4>72057594037927935 AND nbr4<144115188075855872 AND nbr3>72057594037927935 AND nbr3<144115188075855872) ORDER BY predictivesearch1.first_name, predictivesearch1.last_name ASC;");
#endif
    result = mCntSqlSearch->CreatePredictiveSearch(pattern);
    qDebug() << pattern << " -> result" << result;
    LOG2(pattern, result);
    QVERIFY(!result.compare(reference));

    pattern = QString("202");
#if defined(USE_DEMORGAN)
    reference = QString("SELECT contact_id FROM predictivesearch2 WHERE NOT(NOT(NOT(NOT(nbr>144678138029277183 AND nbr<144959613005987840) AND NOT(nbr2>144678138029277183 AND nbr2<144959613005987840) AND NOT(nbr3>144678138029277183 AND nbr3<144959613005987840) AND NOT(nbr4>144678138029277183 AND nbr4<144959613005987840))) AND NOT(NOT(NOT(nbr2>144115188075855871 AND nbr2<216172782113783808 AND nbr>144115188075855871 AND nbr<216172782113783808) AND NOT(nbr3>144115188075855871 AND nbr3<216172782113783808 AND nbr>144115188075855871 AND nbr<216172782113783808) AND NOT(nbr3>144115188075855871 AND nbr3<216172782113783808 AND nbr2>144115188075855871 AND nbr2<216172782113783808) AND NOT(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr>144115188075855871 AND nbr<216172782113783808) AND NOT(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr2>144115188075855871 AND nbr2<216172782113783808) AND NOT(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr3>144115188075855871 AND nbr3<216172782113783808)))) ORDER BY predictivesearch2.first_name, predictivesearch2.last_name ASC;");
#else
    reference = QString("TODO");
#endif
    result = mCntSqlSearch->CreatePredictiveSearch(pattern);    
    qDebug() << pattern << " -> result" << result;
    LOG2(pattern, result);
    QVERIFY(!result.compare(reference));
        
    pattern = QString("25");
#if defined(USE_DEMORGAN)
    reference = QString("SELECT contact_id FROM predictivesearch2 WHERE (NOT(NOT(nbr>166633186212708351 AND nbr<171136785840078848) AND NOT(nbr2>166633186212708351 AND nbr2<171136785840078848) AND NOT(nbr3>166633186212708351 AND nbr3<171136785840078848) AND NOT(nbr4>166633186212708351 AND nbr4<171136785840078848))) ORDER BY first_name, last_name ASC;");
#else
    reference = QString("SELECT contact_id FROM predictivesearch2 WHERE (NOT(NOT(nbr>166633186212708351 AND nbr<171136785840078848) AND NOT(nbr2>166633186212708351 AND nbr2<171136785840078848) AND NOT(nbr3>166633186212708351 AND nbr3<171136785840078848) AND NOT(nbr4>166633186212708351 AND nbr4<171136785840078848))) ORDER BY first_name, last_name ASC;");
#endif
    result = mCntSqlSearch->CreatePredictiveSearch(pattern);
    qDebug() << pattern << " -> result" << result;
    LOG2(pattern, result);
    QVERIFY(!result.compare( reference));


    pattern = QString("56606");
#if defined(SEARCH_FROM_ONE_TABLE)
#if defined(USE_DEMORGAN)
    reference = QString("SELECT contact_id FROM predictivesearch5 WHERE NOT(NOT(NOT(NOT(nbr>389005014883893247 AND nbr<389006114395521024) AND NOT(nbr2>389005014883893247 AND nbr2<389006114395521024) AND NOT(nbr3>389005014883893247 AND nbr3<389006114395521024) AND NOT(nbr4>389005014883893247 AND nbr4<389006114395521024))) AND NOT(NOT(NOT(nbr2>432345564227567615 AND nbr2<504403158265495552 AND nbr>388998417814126591 AND nbr<389279892790837248) AND NOT(nbr3>432345564227567615 AND nbr3<504403158265495552 AND nbr>388998417814126591 AND nbr<389279892790837248) AND NOT(nbr3>432345564227567615 AND nbr3<504403158265495552 AND nbr2>388998417814126591 AND nbr2<389279892790837248) AND NOT(nbr4>432345564227567615 AND nbr4<504403158265495552 AND nbr>388998417814126591 AND nbr<389279892790837248) AND NOT(nbr4>432345564227567615 AND nbr4<504403158265495552 AND nbr2>388998417814126591 AND nbr2<389279892790837248) AND NOT(nbr4>432345564227567615 AND nbr4<504403158265495552 AND nbr3>388998417814126591 AND nbr3<389279892790837248))) AND NOT(NOT(NOT(nbr2>388998417814126591 AND nbr2<389279892790837248 AND nbr>432345564227567615 AND nbr<504403158265495552) AND NOT(nbr3>388998417814126591 AND nbr3<389279892790837248 AND nbr>432345564227567615 AND nbr<504403158265495552) AND NOT(nbr3>388998417814126591 AND nbr3<389279892790837248 AND nbr2>432345564227567615 AND nbr2<504403158265495552) AND NOT(nbr4>388998417814126591 AND nbr4<389279892790837248 AND nbr>432345564227567615 AND nbr<504403158265495552) AND NOT(nbr4>388998417814126591 AND nbr4<389279892790837248 AND nbr2>432345564227567615 AND nbr2<504403158265495552) AND NOT(nbr4>388998417814126591 AND nbr4<389279892790837248 AND nbr3>432345564227567615 AND nbr3<504403158265495552)))) ORDER BY predictivesearch5.first_name, predictivesearch5.last_name ASC;");
#else // #if defined(USE_DEMORGAN)
    reference = QString("SELECT contact_id FROM predictivesearch5 WHERE \
((nbr>389005014883893247 AND nbr<389006114395521024) OR (nbr2>389005014883893247 AND nbr2<389006114395521024) OR \
(nbr3>389005014883893247 AND nbr3<389006114395521024) OR (nbr4>389005014883893247 AND nbr4<389006114395521024)) OR \
(nbr2>432345564227567615 AND nbr2<504403158265495552 AND nbr>388998417814126591 AND nbr<389279892790837248) OR \
(nbr3>432345564227567615 AND nbr3<504403158265495552 AND nbr>388998417814126591 AND nbr<389279892790837248) OR \
(nbr3>432345564227567615 AND nbr3<504403158265495552 AND nbr2>388998417814126591 AND nbr2<389279892790837248) OR \
(nbr4>432345564227567615 AND nbr4<504403158265495552 AND nbr>388998417814126591 AND nbr<389279892790837248) OR \
(nbr4>432345564227567615 AND nbr4<504403158265495552 AND nbr2>388998417814126591 AND nbr2<389279892790837248) OR \
(nbr4>432345564227567615 AND nbr4<504403158265495552 AND nbr3>388998417814126591 AND nbr3<389279892790837248) OR \
(nbr2>388998417814126591 AND nbr2<389279892790837248 AND nbr>432345564227567615 AND nbr<504403158265495552) OR \
(nbr3>388998417814126591 AND nbr3<389279892790837248 AND nbr>432345564227567615 AND nbr<504403158265495552) OR \
(nbr3>388998417814126591 AND nbr3<389279892790837248 AND nbr2>432345564227567615 AND nbr2<504403158265495552) OR \
(nbr4>388998417814126591 AND nbr4<389279892790837248 AND nbr>432345564227567615 AND nbr<504403158265495552) OR \
(nbr4>388998417814126591 AND nbr4<389279892790837248 AND nbr2>432345564227567615 AND nbr2<504403158265495552) OR \
(nbr4>388998417814126591 AND nbr4<389279892790837248 AND nbr3>432345564227567615 AND nbr3<504403158265495552) \
ORDER BY predictivesearch5.first_name, predictivesearch5.last_name ASC;");
#endif //#if defined(USE_DEMORGAN) 
#else // #if defined(SEARCH_FROM_ONE_TABLE)
    reference = QString("SELECT contact_id FROM (SELECT predictivesearch5.contact_id, predictivesearch5.first_name, predictivesearch5.last_name FROM predictivesearch5 WHERE (NOT(NOT(predictivesearch5.nbr>389005014883893247 AND predictivesearch5.nbr<389006114395521024) AND NOT(predictivesearch5.nbr2>389005014883893247 AND predictivesearch5.nbr2<389006114395521024) AND NOT(predictivesearch5.nbr3>389005014883893247 AND predictivesearch5.nbr3<389006114395521024) AND NOT(predictivesearch5.nbr4>389005014883893247 AND predictivesearch5.nbr4<389006114395521024))) UNION SELECT predictivesearch5.contact_id, predictivesearch5.first_name, predictivesearch5.last_name FROM predictivesearch5 JOIN predictivesearch6 ON predictivesearch5.contact_id = predictivesearch6.contact_id WHERE(NOT(NOT(predictivesearch5.nbr>388998417814126591 AND predictivesearch5.nbr<389279892790837248) AND NOT(predictivesearch5.nbr2>388998417814126591 AND predictivesearch5.nbr2<389279892790837248) AND NOT(predictivesearch5.nbr3>388998417814126591 AND predictivesearch5.nbr3<389279892790837248) AND NOT(predictivesearch5.nbr4>388998417814126591 AND predictivesearch5.nbr4<389279892790837248)))) AS PR ORDER BY PR.first_name, PR.last_name ASC;");
#endif // #if defined(SEARCH_FROM_ONE_TABLE)
    result = mCntSqlSearch->CreatePredictiveSearch(pattern);
    qDebug() << pattern << " -> result" << result;
    LOG2(pattern, result);
    QVERIFY( !result.compare( reference) );

    pattern = QString("3");
    reference = QString ("SELECT contact_id FROM predictivesearch3 ORDER BY first_name, last_name ASC;");
    result = mCntSqlSearch->CreatePredictiveSearch(pattern);
    qDebug() << pattern << " -> result" << result;
    LOG2(pattern, result);
    QVERIFY( !result.compare( reference) );
    
    pattern = QString("0");
    reference = QString ("SELECT contact_id FROM predictivesearch0 ORDER BY first_name, last_name ASC;");
    result = mCntSqlSearch->CreatePredictiveSearch(pattern);
    qDebug() << pattern << " -> result" << result;
    LOG2(pattern, result);
    QVERIFY(!result.compare( reference));

    // TODO: Test this case on HW and verify leading zeros.
    pattern.clear();
    pattern = "0705";
    #if defined(SEARCH_FROM_ONE_TABLE)
#if defined(USE_DEMORGAN)
    reference = QString("SELECT contact_id FROM predictivesearch0 WHERE NOT(NOT(NOT(NOT(nbr>31613158321815551 AND nbr<31630750507859968) AND NOT(nbr2>31613158321815551 AND nbr2<31630750507859968) AND NOT(nbr3>31613158321815551 AND nbr3<31630750507859968) AND NOT(nbr4>31613158321815551 AND nbr4<31630750507859968))) AND NOT(NOT(NOT(nbr2>360287970189639679 AND nbr2<432345564227567616 AND nbr>31525197391593471 AND nbr<36028797018963968) AND NOT(nbr3>360287970189639679 AND nbr3<432345564227567616 AND nbr>31525197391593471 AND nbr<36028797018963968) AND NOT(nbr3>360287970189639679 AND nbr3<432345564227567616 AND nbr2>31525197391593471 AND nbr2<36028797018963968) AND NOT(nbr4>360287970189639679 AND nbr4<432345564227567616 AND nbr>31525197391593471 AND nbr<36028797018963968) AND NOT(nbr4>360287970189639679 AND nbr4<432345564227567616 AND nbr2>31525197391593471 AND nbr2<36028797018963968) AND NOT(nbr4>360287970189639679 AND nbr4<432345564227567616 AND nbr3>31525197391593471 AND nbr3<36028797018963968))) AND NOT(NOT(NOT(nbr2>31525197391593471 AND nbr2<36028797018963968 AND nbr>360287970189639679 AND nbr<432345564227567616) AND NOT(nbr3>31525197391593471 AND nbr3<36028797018963968 AND nbr>360287970189639679 AND nbr<432345564227567616) AND NOT(nbr3>31525197391593471 AND nbr3<36028797018963968 AND nbr2>360287970189639679 AND nbr2<432345564227567616) AND NOT(nbr4>31525197391593471 AND nbr4<36028797018963968 AND nbr>360287970189639679 AND nbr<432345564227567616) AND NOT(nbr4>31525197391593471 AND nbr4<36028797018963968 AND nbr2>360287970189639679 AND nbr2<432345564227567616) AND NOT(nbr4>31525197391593471 AND nbr4<36028797018963968 AND nbr3>360287970189639679 AND nbr3<432345564227567616)))) ORDER BY predictivesearch0.first_name, predictivesearch0.last_name ASC;");
#else // #if defined(USE_DEMORGAN)

#endif //#if defined(USE_DEMORGAN)
#else // #if defined(SEARCH_FROM_ONE_TABLE)
    reference = QString("SELECT contact_id FROM (SELECT predictivesearch0.contact_id, predictivesearch0.first_name, predictivesearch0.last_name FROM predictivesearch0 WHERE (NOT(NOT(predictivesearch0.nbr>31613158321815551 AND predictivesearch0.nbr<31630750507859968) AND NOT(predictivesearch0.nbr2>31613158321815551 AND predictivesearch0.nbr2<31630750507859968) AND NOT(predictivesearch0.nbr3>31613158321815551 AND predictivesearch0.nbr3<31630750507859968) AND NOT(predictivesearch0.nbr4>31613158321815551 AND predictivesearch0.nbr4<31630750507859968))) UNION SELECT predictivesearch0.contact_id, predictivesearch0.first_name, predictivesearch0.last_name FROM predictivesearch0 JOIN predictivesearch5 ON predictivesearch0.contact_id = predictivesearch5.contact_id WHERE(NOT(NOT(predictivesearch0.nbr>31525197391593471 AND predictivesearch0.nbr<36028797018963968) AND NOT(predictivesearch0.nbr2>31525197391593471 AND predictivesearch0.nbr2<36028797018963968) AND NOT(predictivesearch0.nbr3>31525197391593471 AND predictivesearch0.nbr3<36028797018963968) AND NOT(predictivesearch0.nbr4>31525197391593471 AND predictivesearch0.nbr4<36028797018963968)))) AS PR ORDER BY PR.first_name, PR.last_name ASC;");
#endif // #if defined(SEARCH_FROM_ONE_TABLE)

    result = mCntSqlSearch->CreatePredictiveSearch(pattern);
    //qDebug() << pattern << result;
    LOG2(pattern, result);
    QVERIFY(!result.compare(reference));
    
    pattern.clear();
    pattern = "4301";  
#if defined(SEARCH_FROM_ONE_TABLE)
#if defined(USE_DEMORGAN)
    reference = QString("SELECT contact_id FROM predictivesearch4 WHERE NOT(NOT(NOT(NOT(nbr>301758767219867647 AND nbr<301776359405912064) AND NOT(nbr2>301758767219867647 AND nbr2<301776359405912064) AND NOT(nbr3>301758767219867647 AND nbr3<301776359405912064) AND NOT(nbr4>301758767219867647 AND nbr4<301776359405912064))) AND NOT(NOT(NOT(nbr2>72057594037927935 AND nbr2<144115188075855872 AND nbr>301741175033823231 AND nbr<306244774661193728) AND NOT(nbr3>72057594037927935 AND nbr3<144115188075855872 AND nbr>301741175033823231 AND nbr<306244774661193728) AND NOT(nbr3>72057594037927935 AND nbr3<144115188075855872 AND nbr2>301741175033823231 AND nbr2<306244774661193728) AND NOT(nbr4>72057594037927935 AND nbr4<144115188075855872 AND nbr>301741175033823231 AND nbr<306244774661193728) AND NOT(nbr4>72057594037927935 AND nbr4<144115188075855872 AND nbr2>301741175033823231 AND nbr2<306244774661193728) AND NOT(nbr4>72057594037927935 AND nbr4<144115188075855872 AND nbr3>301741175033823231 AND nbr3<306244774661193728))) AND NOT(NOT(NOT(nbr2>301741175033823231 AND nbr2<306244774661193728 AND nbr>72057594037927935 AND nbr<144115188075855872) AND NOT(nbr3>301741175033823231 AND nbr3<306244774661193728 AND nbr>72057594037927935 AND nbr<144115188075855872) AND NOT(nbr3>301741175033823231 AND nbr3<306244774661193728 AND nbr2>72057594037927935 AND nbr2<144115188075855872) AND NOT(nbr4>301741175033823231 AND nbr4<306244774661193728 AND nbr>72057594037927935 AND nbr<144115188075855872) AND NOT(nbr4>301741175033823231 AND nbr4<306244774661193728 AND nbr2>72057594037927935 AND nbr2<144115188075855872) AND NOT(nbr4>301741175033823231 AND nbr4<306244774661193728 AND nbr3>72057594037927935 AND nbr3<144115188075855872)))) ORDER BY predictivesearch4.first_name, predictivesearch4.last_name ASC;");
#else // #if defined(USE_DEMORGAN)

#endif //#if defined(USE_DEMORGAN)
#else // #if defined(SEARCH_FROM_ONE_TABLE)
    reference = QString("SELECT contact_id FROM (SELECT predictivesearch4.contact_id, predictivesearch4.first_name, predictivesearch4.last_name FROM predictivesearch4 WHERE (NOT(NOT(predictivesearch4.nbr>301758767219867647 AND predictivesearch4.nbr<301776359405912064) AND NOT(predictivesearch4.nbr2>301758767219867647 AND predictivesearch4.nbr2<301776359405912064) AND NOT(predictivesearch4.nbr3>301758767219867647 AND predictivesearch4.nbr3<301776359405912064) AND NOT(predictivesearch4.nbr4>301758767219867647 AND predictivesearch4.nbr4<301776359405912064))) UNION SELECT predictivesearch4.contact_id, predictivesearch4.first_name, predictivesearch4.last_name FROM predictivesearch4 JOIN predictivesearch1 ON predictivesearch4.contact_id = predictivesearch1.contact_id WHERE(NOT(NOT(predictivesearch4.nbr>301741175033823231 AND predictivesearch4.nbr<306244774661193728) AND NOT(predictivesearch4.nbr2>301741175033823231 AND predictivesearch4.nbr2<306244774661193728) AND NOT(predictivesearch4.nbr3>301741175033823231 AND predictivesearch4.nbr3<306244774661193728) AND NOT(predictivesearch4.nbr4>301741175033823231 AND predictivesearch4.nbr4<306244774661193728)))) AS PR ORDER BY PR.first_name, PR.last_name ASC;");
#endif // #if defined(SEARCH_FROM_ONE_TABLE)
    result = mCntSqlSearch->CreatePredictiveSearch(pattern);
    //qDebug() << pattern << result;
    LOG2(pattern, result);
    QVERIFY(!result.compare(reference));

    pattern.clear();
    pattern = "4304";
#if defined(USE_DEMORGAN)
    reference = QString("SELECT contact_id FROM predictivesearch4 WHERE NOT(NOT(NOT(NOT(nbr>301811543778000895 AND nbr<301829135964045312) AND NOT(nbr2>301811543778000895 AND nbr2<301829135964045312) AND NOT(nbr3>301811543778000895 AND nbr3<301829135964045312) AND NOT(nbr4>301811543778000895 AND nbr4<301829135964045312))) AND NOT(NOT(NOT(nbr2>288230376151711743 AND nbr2<360287970189639680 AND nbr>301741175033823231 AND nbr<306244774661193728) AND NOT(nbr3>288230376151711743 AND nbr3<360287970189639680 AND nbr>301741175033823231 AND nbr<306244774661193728) AND NOT(nbr3>288230376151711743 AND nbr3<360287970189639680 AND nbr2>301741175033823231 AND nbr2<306244774661193728) AND NOT(nbr4>288230376151711743 AND nbr4<360287970189639680 AND nbr>301741175033823231 AND nbr<306244774661193728) AND NOT(nbr4>288230376151711743 AND nbr4<360287970189639680 AND nbr2>301741175033823231 AND nbr2<306244774661193728) AND NOT(nbr4>288230376151711743 AND nbr4<360287970189639680 AND nbr3>301741175033823231 AND nbr3<306244774661193728))) AND NOT(NOT(NOT(nbr2>301741175033823231 AND nbr2<306244774661193728 AND nbr>288230376151711743 AND nbr<360287970189639680) AND NOT(nbr3>301741175033823231 AND nbr3<306244774661193728 AND nbr>288230376151711743 AND nbr<360287970189639680) AND NOT(nbr3>301741175033823231 AND nbr3<306244774661193728 AND nbr2>288230376151711743 AND nbr2<360287970189639680) AND NOT(nbr4>301741175033823231 AND nbr4<306244774661193728 AND nbr>288230376151711743 AND nbr<360287970189639680) AND NOT(nbr4>301741175033823231 AND nbr4<306244774661193728 AND nbr2>288230376151711743 AND nbr2<360287970189639680) AND NOT(nbr4>301741175033823231 AND nbr4<306244774661193728 AND nbr3>288230376151711743 AND nbr3<360287970189639680)))) ORDER BY predictivesearch4.first_name, predictivesearch4.last_name ASC;");
#else
	//TODO:
#endif
    result = mCntSqlSearch->CreatePredictiveSearch(pattern);
    //qDebug() << pattern << result;
    LOG2(pattern, result);
    QVERIFY(!result.compare(reference));

	pattern.clear();
    pattern = "4043";
#if defined(USE_DEMORGAN)
    reference = QString("SELECT contact_id FROM predictivesearch4 WHERE NOT(NOT(NOT(NOT(nbr>289409052616687615 AND nbr<289426644802732032) AND NOT(nbr2>289409052616687615 AND nbr2<289426644802732032) AND NOT(nbr3>289409052616687615 AND nbr3<289426644802732032) AND NOT(nbr4>289409052616687615 AND nbr4<289426644802732032))) AND NOT(NOT(NOT(nbr2>301741175033823231 AND nbr2<306244774661193728 AND nbr>288230376151711743 AND nbr<360287970189639680) AND NOT(nbr3>301741175033823231 AND nbr3<306244774661193728 AND nbr>288230376151711743 AND nbr<360287970189639680) AND NOT(nbr3>301741175033823231 AND nbr3<306244774661193728 AND nbr2>288230376151711743 AND nbr2<360287970189639680) AND NOT(nbr4>301741175033823231 AND nbr4<306244774661193728 AND nbr>288230376151711743 AND nbr<360287970189639680) AND NOT(nbr4>301741175033823231 AND nbr4<306244774661193728 AND nbr2>288230376151711743 AND nbr2<360287970189639680) AND NOT(nbr4>301741175033823231 AND nbr4<306244774661193728 AND nbr3>288230376151711743 AND nbr3<360287970189639680))) AND NOT(NOT(NOT(nbr2>288230376151711743 AND nbr2<360287970189639680 AND nbr>301741175033823231 AND nbr<306244774661193728) AND NOT(nbr3>288230376151711743 AND nbr3<360287970189639680 AND nbr>301741175033823231 AND nbr<306244774661193728) AND NOT(nbr3>288230376151711743 AND nbr3<360287970189639680 AND nbr2>301741175033823231 AND nbr2<306244774661193728) AND NOT(nbr4>288230376151711743 AND nbr4<360287970189639680 AND nbr>301741175033823231 AND nbr<306244774661193728) AND NOT(nbr4>288230376151711743 AND nbr4<360287970189639680 AND nbr2>301741175033823231 AND nbr2<306244774661193728) AND NOT(nbr4>288230376151711743 AND nbr4<360287970189639680 AND nbr3>301741175033823231 AND nbr3<306244774661193728)))) ORDER BY predictivesearch4.first_name, predictivesearch4.last_name ASC;");
#else
	//TODO:
#endif
    result = mCntSqlSearch->CreatePredictiveSearch(pattern);
    //qDebug() << pattern << result;
    LOG2(pattern, result);
    QVERIFY(!result.compare(reference));

    pattern = QString("03");
#if defined(USE_DEMORGAN)
    reference = QString("SELECT contact_id FROM predictivesearch0 WHERE (NOT(NOT(nbr>13510798882111487 AND nbr<18014398509481984) AND NOT(nbr2>13510798882111487 AND nbr2<18014398509481984) AND NOT(nbr3>13510798882111487 AND nbr3<18014398509481984) AND NOT(nbr4>13510798882111487 AND nbr4<18014398509481984))) ORDER BY first_name, last_name ASC;");
#else
    reference = QString("SELECT contact_id FROM predictivesearch0 WHERE (nbr>13510798882111487 AND nbr<18014398509481984) OR (nbr2>13510798882111487 AND nbr2<18014398509481984) OR (nbr3>13510798882111487 AND nbr3<18014398509481984) OR (nbr4>13510798882111487 AND nbr4<18014398509481984) ORDER BY first_name, last_name ASC;");
#endif
    result = mCntSqlSearch->CreatePredictiveSearch(pattern);
    qDebug() << pattern << " -> result" << result;
    LOG2(pattern, result);
    QVERIFY(!result.compare( reference));

    // Empty pattern
    pattern = QString("");
    result = mCntSqlSearch->CreatePredictiveSearch(pattern);
    qDebug() << pattern << " -> result" << result;
    LOG2(pattern, result);
    QVERIFY(result.length() == 0);
        
    // Too long pattern (16 digits)
    pattern = QString("0123456789012345");
    result = mCntSqlSearch->CreatePredictiveSearch(pattern);
    qDebug() << pattern << " -> result" << result;
    LOG2(pattern, result);
    QVERIFY(result.length() == 0);

    pattern = QString("0000000000000000"); // 16 zeros
    result = mCntSqlSearch->CreatePredictiveSearch(pattern);
    qDebug() << pattern << " -> result" << result;
    LOG2(pattern, result);
    QVERIFY(result.length() == 0);
    
    // Full of zeros
    pattern = QString("000000000000000"); // 15 zeros
#if defined(USE_DEMORGAN)
    reference = QString("SELECT contact_id FROM predictivesearch0 WHERE (NOT(NOT(nbr>-1 AND nbr<1) AND NOT(nbr2>-1 AND nbr2<1) AND NOT(nbr3>-1 AND nbr3<1) AND NOT(nbr4>-1 AND nbr4<1))) ORDER BY first_name, last_name ASC;");
#else
    reference = QString("SELECT contact_id FROM predictivesearch0 WHERE (nbr>-1 AND nbr<1) OR (nbr2>-1 AND nbr2<1) OR (nbr3>-1 AND nbr3<1) OR (nbr4>-1 AND nbr4<1) ORDER BY first_name, last_name ASC;");
#endif
    result = mCntSqlSearch->CreatePredictiveSearch(pattern);
    qDebug() << pattern << " -> result" << result;
    LOG2(pattern, result);
    QVERIFY(!result.compare(reference));
    
    // Full of nines
    pattern = QString("999999999999999"); // 15 nines
#if defined(USE_DEMORGAN)
    reference = QString("SELECT contact_id FROM predictivesearch9 WHERE (NOT(NOT(nbr>691752902764108184 AND nbr<691752902764108186) AND NOT(nbr2>691752902764108184 AND nbr2<691752902764108186) AND NOT(nbr3>691752902764108184 AND nbr3<691752902764108186) AND NOT(nbr4>691752902764108184 AND nbr4<691752902764108186))) ORDER BY first_name, last_name ASC;");
#else
    reference = QString("SELECT contact_id FROM predictivesearch9 WHERE (nbr>691752902764108184 AND nbr<691752902764108186) OR (nbr2>691752902764108184 AND nbr2<691752902764108186) OR (nbr3>691752902764108184 AND nbr3<691752902764108186) OR (nbr4>691752902764108184 AND nbr4<691752902764108186) ORDER BY first_name, last_name ASC;");
#endif
    result = mCntSqlSearch->CreatePredictiveSearch(pattern);
    qDebug() << pattern << " -> result" << result;
    LOG2(pattern, result);
    QVERIFY(!result.compare(reference));

    // Leading zeros
    pattern = QString("001100");
#if defined(USE_DEMORGAN)
    reference = QString("SELECT contact_id FROM predictivesearch0 WHERE (NOT(NOT(nbr>299067162755071 AND nbr<299135882231808) AND NOT(nbr2>299067162755071 AND nbr2<299135882231808) AND NOT(nbr3>299067162755071 AND nbr3<299135882231808) AND NOT(nbr4>299067162755071 AND nbr4<299135882231808))) ORDER BY first_name, last_name ASC;");
#else
    reference = QString("SELECT contact_id FROM predictivesearch0 WHERE (nbr>299067162755071 AND nbr<299135882231808) OR (nbr2>299067162755071 AND nbr2<299135882231808) OR (nbr3>299067162755071 AND nbr3<299135882231808) OR (nbr4>299067162755071 AND nbr4<299135882231808) ORDER BY first_name, last_name ASC;");
#endif
    result = mCntSqlSearch->CreatePredictiveSearch(pattern);
    qDebug() << pattern << " -> result" << result;
    LOG2(pattern, result);
    QVERIFY(!result.compare(reference));
    
    pattern = QString("43043");
    reference = QString("SELECT contact_id FROM predictivesearch4 WHERE NOT(NOT(NOT(NOT(nbr>301814842312884223 AND nbr<301815941824512000) AND NOT(nbr2>301814842312884223 AND nbr2<301815941824512000) AND NOT(nbr3>301814842312884223 AND nbr3<301815941824512000) AND NOT(nbr4>301814842312884223 AND nbr4<301815941824512000))) AND NOT(NOT(NOT(nbr2>301741175033823231 AND nbr2<306244774661193728 AND nbr>301741175033823231 AND nbr<306244774661193728) AND NOT(nbr3>301741175033823231 AND nbr3<306244774661193728 AND nbr>301741175033823231 AND nbr<306244774661193728) AND NOT(nbr3>301741175033823231 AND nbr3<306244774661193728 AND nbr2>301741175033823231 AND nbr2<306244774661193728) AND NOT(nbr4>301741175033823231 AND nbr4<306244774661193728 AND nbr>301741175033823231 AND nbr<306244774661193728) AND NOT(nbr4>301741175033823231 AND nbr4<306244774661193728 AND nbr2>301741175033823231 AND nbr2<306244774661193728) AND NOT(nbr4>301741175033823231 AND nbr4<306244774661193728 AND nbr3>301741175033823231 AND nbr3<306244774661193728)))) ORDER BY predictivesearch4.first_name, predictivesearch4.last_name ASC;");
    result = mCntSqlSearch->CreatePredictiveSearch(pattern);
    qDebug() << pattern << " -> result" << result;
    LOG2(pattern, result);
    QVERIFY(!result.compare(reference));

    pattern = QString("0020030");
#if defined(USE_DEMORGAN)
    reference = QString("SELECT contact_id FROM predictivesearch0 WHERE NOT(NOT(NOT(NOT(nbr>563156111851519 AND nbr<563160406818816) AND NOT(nbr2>563156111851519 AND nbr2<563160406818816) AND NOT(nbr3>563156111851519 AND nbr3<563160406818816) AND NOT(nbr4>563156111851519 AND nbr4<563160406818816))) AND NOT(NOT(NOT(nbr2>216172782113783807 AND nbr2<220676381741154304 AND nbr>562949953421311 AND nbr<844424930131968) AND NOT(nbr3>216172782113783807 AND nbr3<220676381741154304 AND nbr>562949953421311 AND nbr<844424930131968) AND NOT(nbr3>216172782113783807 AND nbr3<220676381741154304 AND nbr2>562949953421311 AND nbr2<844424930131968) AND NOT(nbr4>216172782113783807 AND nbr4<220676381741154304 AND nbr>562949953421311 AND nbr<844424930131968) AND NOT(nbr4>216172782113783807 AND nbr4<220676381741154304 AND nbr2>562949953421311 AND nbr2<844424930131968) AND NOT(nbr4>216172782113783807 AND nbr4<220676381741154304 AND nbr3>562949953421311 AND nbr3<844424930131968))) AND NOT(NOT(NOT(nbr2>562949953421311 AND nbr2<844424930131968 AND nbr>216172782113783807 AND nbr<220676381741154304) AND NOT(nbr3>562949953421311 AND nbr3<844424930131968 AND nbr>216172782113783807 AND nbr<220676381741154304) AND NOT(nbr3>562949953421311 AND nbr3<844424930131968 AND nbr2>216172782113783807 AND nbr2<220676381741154304) AND NOT(nbr4>562949953421311 AND nbr4<844424930131968 AND nbr>216172782113783807 AND nbr<220676381741154304) AND NOT(nbr4>562949953421311 AND nbr4<844424930131968 AND nbr2>216172782113783807 AND nbr2<220676381741154304) AND NOT(nbr4>562949953421311 AND nbr4<844424930131968 AND nbr3>216172782113783807 AND nbr3<220676381741154304)))) ORDER BY predictivesearch0.first_name, predictivesearch0.last_name ASC;");
#else
    // TODO: add non-De Morgan case
#endif
    result = mCntSqlSearch->CreatePredictiveSearch(pattern);
    qDebug() << pattern << " -> result" << result;
    LOG2(pattern, result);
    QVERIFY(!result.compare(reference));
    
    pattern = QString("00430001020");
#if defined(USE_DEMORGAN)
    reference = QString("SELECT contact_id FROM predictivesearch0 WHERE NOT(NOT(NOT(NOT(nbr>1178676735508479 AND nbr<1178676735574016) AND NOT(nbr2>1178676735508479 AND nbr2<1178676735574016) AND NOT(nbr3>1178676735508479 AND nbr3<1178676735574016) AND NOT(nbr4>1178676735508479 AND nbr4<1178676735574016))) AND NOT(NOT(NOT(nbr2>72620543991349247 AND nbr2<72638136177393664 AND nbr>1178676464975871 AND nbr<1196268651020288) AND NOT(nbr3>72620543991349247 AND nbr3<72638136177393664 AND nbr>1178676464975871 AND nbr<1196268651020288) AND NOT(nbr3>72620543991349247 AND nbr3<72638136177393664 AND nbr2>1178676464975871 AND nbr2<1196268651020288) AND NOT(nbr4>72620543991349247 AND nbr4<72638136177393664 AND nbr>1178676464975871 AND nbr<1196268651020288) AND NOT(nbr4>72620543991349247 AND nbr4<72638136177393664 AND nbr2>1178676464975871 AND nbr2<1196268651020288) AND NOT(nbr4>72620543991349247 AND nbr4<72638136177393664 AND nbr3>1178676464975871 AND nbr3<1196268651020288))) AND NOT(NOT(NOT(nbr2>1178676464975871 AND nbr2<1196268651020288 AND nbr>72620543991349247 AND nbr<72638136177393664) AND NOT(nbr3>1178676464975871 AND nbr3<1196268651020288 AND nbr>72620543991349247 AND nbr<72638136177393664) AND NOT(nbr3>1178676464975871 AND nbr3<1196268651020288 AND nbr2>72620543991349247 AND nbr2<72638136177393664) AND NOT(nbr4>1178676464975871 AND nbr4<1196268651020288 AND nbr>72620543991349247 AND nbr<72638136177393664) AND NOT(nbr4>1178676464975871 AND nbr4<1196268651020288 AND nbr2>72620543991349247 AND nbr2<72638136177393664) AND NOT(nbr4>1178676464975871 AND nbr4<1196268651020288 AND nbr3>72620543991349247 AND nbr3<72638136177393664)))) ORDER BY predictivesearch0.first_name, predictivesearch0.last_name ASC;");
#else
    // TODO: add non-De Morgan case
#endif
    result = mCntSqlSearch->CreatePredictiveSearch(pattern);
    qDebug() << pattern << " -> result" << result;
    LOG2(pattern, result);
    QVERIFY(!result.compare(reference));
    
    pattern = QString("227264583788306"); // 15 digits
#if defined(USE_DEMORGAN)
    reference = QString("SELECT contact_id FROM predictivesearch2 WHERE NOT(NOT(NOT(NOT(nbr>155134792167883525 AND nbr<155134792167883527) AND NOT(nbr2>155134792167883525 AND nbr2<155134792167883527) AND NOT(nbr3>155134792167883525 AND nbr3<155134792167883527) AND NOT(nbr4>155134792167883525 AND nbr4<155134792167883527))) AND NOT(NOT(NOT(nbr2>432345564227567615 AND nbr2<504403158265495552 AND nbr>155134792167883519 AND nbr<155134792167883776) AND NOT(nbr3>432345564227567615 AND nbr3<504403158265495552 AND nbr>155134792167883519 AND nbr<155134792167883776) AND NOT(nbr3>432345564227567615 AND nbr3<504403158265495552 AND nbr2>155134792167883519 AND nbr2<155134792167883776) AND NOT(nbr4>432345564227567615 AND nbr4<504403158265495552 AND nbr>155134792167883519 AND nbr<155134792167883776) AND NOT(nbr4>432345564227567615 AND nbr4<504403158265495552 AND nbr2>155134792167883519 AND nbr2<155134792167883776) AND NOT(nbr4>432345564227567615 AND nbr4<504403158265495552 AND nbr3>155134792167883519 AND nbr3<155134792167883776))) AND NOT(NOT(NOT(nbr2>155134792167883519 AND nbr2<155134792167883776 AND nbr>432345564227567615 AND nbr<504403158265495552) AND NOT(nbr3>155134792167883519 AND nbr3<155134792167883776 AND nbr>432345564227567615 AND nbr<504403158265495552) AND NOT(nbr3>155134792167883519 AND nbr3<155134792167883776 AND nbr2>432345564227567615 AND nbr2<504403158265495552) AND NOT(nbr4>155134792167883519 AND nbr4<155134792167883776 AND nbr>432345564227567615 AND nbr<504403158265495552) AND NOT(nbr4>155134792167883519 AND nbr4<155134792167883776 AND nbr2>432345564227567615 AND nbr2<504403158265495552) AND NOT(nbr4>155134792167883519 AND nbr4<155134792167883776 AND nbr3>432345564227567615 AND nbr3<504403158265495552)))) ORDER BY predictivesearch2.first_name, predictivesearch2.last_name ASC;");
#else
    // TODO: add non-De Morgan case
#endif
    result = mCntSqlSearch->CreatePredictiveSearch(pattern);
    qDebug() << pattern << " -> result" << result;
    LOG2(pattern, result);
    QVERIFY(!result.compare(reference));
 
    
    pattern = QString("34096");
#if defined(USE_DEMORGAN)
    reference = QString("SELECT contact_id FROM predictivesearch3 WHERE NOT(NOT(NOT(NOT(nbr>234352107367432191 AND nbr<234353206879059968) AND NOT(nbr2>234352107367432191 AND nbr2<234353206879059968) AND NOT(nbr3>234352107367432191 AND nbr3<234353206879059968) AND NOT(nbr4>234352107367432191 AND nbr4<234353206879059968))) AND NOT(NOT(NOT(nbr2>675539944105574399 AND nbr2<680043543732944896 AND nbr>234187180623265791 AND nbr<238690780250636288) AND NOT(nbr3>675539944105574399 AND nbr3<680043543732944896 AND nbr>234187180623265791 AND nbr<238690780250636288) AND NOT(nbr3>675539944105574399 AND nbr3<680043543732944896 AND nbr2>234187180623265791 AND nbr2<238690780250636288) AND NOT(nbr4>675539944105574399 AND nbr4<680043543732944896 AND nbr>234187180623265791 AND nbr<238690780250636288) AND NOT(nbr4>675539944105574399 AND nbr4<680043543732944896 AND nbr2>234187180623265791 AND nbr2<238690780250636288) AND NOT(nbr4>675539944105574399 AND nbr4<680043543732944896 AND nbr3>234187180623265791 AND nbr3<238690780250636288))) AND NOT(NOT(NOT(nbr2>234187180623265791 AND nbr2<238690780250636288 AND nbr>675539944105574399 AND nbr<680043543732944896) AND NOT(nbr3>234187180623265791 AND nbr3<238690780250636288 AND nbr>675539944105574399 AND nbr<680043543732944896) AND NOT(nbr3>234187180623265791 AND nbr3<238690780250636288 AND nbr2>675539944105574399 AND nbr2<680043543732944896) AND NOT(nbr4>234187180623265791 AND nbr4<238690780250636288 AND nbr>675539944105574399 AND nbr<680043543732944896) AND NOT(nbr4>234187180623265791 AND nbr4<238690780250636288 AND nbr2>675539944105574399 AND nbr2<680043543732944896) AND NOT(nbr4>234187180623265791 AND nbr4<238690780250636288 AND nbr3>675539944105574399 AND nbr3<680043543732944896)))) ORDER BY predictivesearch3.first_name, predictivesearch3.last_name ASC;");
#else
    // TODO: add non-De Morgan case
#endif
    result = mCntSqlSearch->CreatePredictiveSearch(pattern);
    qDebug() << pattern << " -> result" << result;
    LOG2(pattern, result);
    QVERIFY(!result.compare(reference));

	pattern = QString("522000000000007"); // 15 digits
#if defined(USE_DEMORGAN)
	reference = QString("SELECT contact_id FROM predictivesearch5 WHERE NOT(NOT(NOT(NOT(nbr>369858119397801990 AND nbr<369858119397801992) AND NOT(nbr2>369858119397801990 AND nbr2<369858119397801992) AND NOT(nbr3>369858119397801990 AND nbr3<369858119397801992) AND NOT(nbr4>369858119397801990 AND nbr4<369858119397801992))) AND NOT(NOT(NOT(nbr2>504403158265495551 AND nbr2<576460752303423488 AND nbr>369858119397801983 AND nbr<370139594374512640) AND NOT(nbr3>504403158265495551 AND nbr3<576460752303423488 AND nbr>369858119397801983 AND nbr<370139594374512640) AND NOT(nbr3>504403158265495551 AND nbr3<576460752303423488 AND nbr2>369858119397801983 AND nbr2<370139594374512640) AND NOT(nbr4>504403158265495551 AND nbr4<576460752303423488 AND nbr>369858119397801983 AND nbr<370139594374512640) AND NOT(nbr4>504403158265495551 AND nbr4<576460752303423488 AND nbr2>369858119397801983 AND nbr2<370139594374512640) AND NOT(nbr4>504403158265495551 AND nbr4<576460752303423488 AND nbr3>369858119397801983 AND nbr3<370139594374512640))) AND NOT(NOT(NOT(nbr2>369858119397801983 AND nbr2<370139594374512640 AND nbr>504403158265495551 AND nbr<576460752303423488) AND NOT(nbr3>369858119397801983 AND nbr3<370139594374512640 AND nbr>504403158265495551 AND nbr<576460752303423488) AND NOT(nbr3>369858119397801983 AND nbr3<370139594374512640 AND nbr2>504403158265495551 AND nbr2<576460752303423488) AND NOT(nbr4>369858119397801983 AND nbr4<370139594374512640 AND nbr>504403158265495551 AND nbr<576460752303423488) AND NOT(nbr4>369858119397801983 AND nbr4<370139594374512640 AND nbr2>504403158265495551 AND nbr2<576460752303423488) AND NOT(nbr4>369858119397801983 AND nbr4<370139594374512640 AND nbr3>504403158265495551 AND nbr3<576460752303423488)))) ORDER BY predictivesearch5.first_name, predictivesearch5.last_name ASC;");
#else
    // TODO: add non-De Morgan case
#endif
    result = mCntSqlSearch->CreatePredictiveSearch(pattern);
    qDebug() << pattern << " -> result" << result;
    LOG2(pattern, result);
    QVERIFY(!result.compare(reference));

    TEST_PASSED_LOG("testPredictiveSearch");
}

void UT_CntSqlSearch::testSelectTableView()
{
    TEST_BEGIN_LOG("testSelectTableView");
    
    QString pattern = QString("0");
    QString reference = QString("predictivesearch0");
    QString result = mCntSqlSearch->SelectTable(pattern);
    QVERIFY( !result.compare( reference) );

    pattern = QString("1");
    reference = QString("predictivesearch1");
    result = mCntSqlSearch->SelectTable(pattern);
    QVERIFY( !result.compare( reference) );

    pattern = QString("2");
    reference = QString("predictivesearch2");
    result = mCntSqlSearch->SelectTable(pattern);
    QVERIFY( !result.compare( reference) );

    pattern = QString("3");
    reference = QString("predictivesearch3");
    result = mCntSqlSearch->SelectTable(pattern);
    QVERIFY( !result.compare( reference) );

    pattern = QString("4");
    reference = QString("predictivesearch4");
    result = mCntSqlSearch->SelectTable(pattern);
    QVERIFY( !result.compare( reference) );

    pattern = QString("5");
    reference = QString("predictivesearch5");
    result = mCntSqlSearch->SelectTable(pattern);
    QVERIFY( !result.compare( reference) );

    pattern = QString("6");
    reference = QString("predictivesearch6");
    result = mCntSqlSearch->SelectTable(pattern);
    QVERIFY( !result.compare( reference) );

    pattern = QString("7");
    reference = QString("predictivesearch7");
    result = mCntSqlSearch->SelectTable(pattern);
    QVERIFY( !result.compare( reference) );

    pattern = QString("8");
    reference = QString("predictivesearch8");
    result = mCntSqlSearch->SelectTable(pattern);
    QVERIFY( !result.compare( reference) );

    pattern = QString("9");
    reference = QString("predictivesearch9");
    result = mCntSqlSearch->SelectTable(pattern);
    QVERIFY( !result.compare( reference) );

    pattern = QString("09");
    reference = QString("predictivesearch0");
    result = mCntSqlSearch->SelectTable(pattern);
    QVERIFY( !result.compare( reference) );

    pattern = QString("090");
    reference = QString("predictivesearch0");
    result = mCntSqlSearch->SelectTable(pattern);
    QVERIFY( !result.compare( reference) );

    pattern = QString("909");
    reference = QString("predictivesearch9");
    result = mCntSqlSearch->SelectTable(pattern);
    QVERIFY( !result.compare( reference) );

    pattern = QString("99");
    reference = QString("predictivesearch9");
    result = mCntSqlSearch->SelectTable(pattern);
    QVERIFY( !result.compare( reference) );

    pattern = QString("000");
    reference = QString("predictivesearch0");
    result = mCntSqlSearch->SelectTable(pattern);
    QVERIFY( !result.compare( reference) );
    
    TEST_PASSED_LOG("testSelectTableView");
}

void UT_CntSqlSearch::testCreateQuery()
{   
    TEST_BEGIN_LOG("testCreateQuery");
    QString pattern = QString("102");

#if defined(SEARCH_FROM_ONE_TABLE)
#if defined(USE_DEMORGAN)
    QString reference("SELECT contact_id FROM predictivesearch1 WHERE NOT(NOT(NOT(NOT(nbr>72620543991349247 AND nbr<72902018968059904) AND NOT(nbr2>72620543991349247 AND nbr2<72902018968059904) AND NOT(nbr3>72620543991349247 AND nbr3<72902018968059904) AND NOT(nbr4>72620543991349247 AND nbr4<72902018968059904))) AND NOT(NOT(NOT(nbr2>144115188075855871 AND nbr2<216172782113783808 AND nbr>72057594037927935 AND nbr<144115188075855872) AND NOT(nbr3>144115188075855871 AND nbr3<216172782113783808 AND nbr>72057594037927935 AND nbr<144115188075855872) AND NOT(nbr3>144115188075855871 AND nbr3<216172782113783808 AND nbr2>72057594037927935 AND nbr2<144115188075855872) AND NOT(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr>72057594037927935 AND nbr<144115188075855872) AND NOT(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr2>72057594037927935 AND nbr2<144115188075855872) AND NOT(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr3>72057594037927935 AND nbr3<144115188075855872))) AND NOT(NOT(NOT(nbr2>72057594037927935 AND nbr2<144115188075855872 AND nbr>144115188075855871 AND nbr<216172782113783808) AND NOT(nbr3>72057594037927935 AND nbr3<144115188075855872 AND nbr>144115188075855871 AND nbr<216172782113783808) AND NOT(nbr3>72057594037927935 AND nbr3<144115188075855872 AND nbr2>144115188075855871 AND nbr2<216172782113783808) AND NOT(nbr4>72057594037927935 AND nbr4<144115188075855872 AND nbr>144115188075855871 AND nbr<216172782113783808) AND NOT(nbr4>72057594037927935 AND nbr4<144115188075855872 AND nbr2>144115188075855871 AND nbr2<216172782113783808) AND NOT(nbr4>72057594037927935 AND nbr4<144115188075855872 AND nbr3>144115188075855871 AND nbr3<216172782113783808)))) ORDER BY predictivesearch1.first_name, predictivesearch1.last_name ASC;");
#else // #if defined(USE_DEMORGAN)
    QString reference("SELECT contact_id FROM predictivesearch1 WHERE \
((nbr>72620543991349247 AND nbr<72902018968059904) OR \
(nbr2>72620543991349247 AND nbr2<72902018968059904) OR \
(nbr3>72620543991349247 AND nbr3<72902018968059904) OR \
(nbr4>72620543991349247 AND nbr4<72902018968059904)) OR \
(nbr2>144115188075855871 AND nbr2<216172782113783808 AND nbr>72057594037927935 AND nbr<144115188075855872) OR \
(nbr3>144115188075855871 AND nbr3<216172782113783808 AND nbr>72057594037927935 AND nbr<144115188075855872) OR \
(nbr3>144115188075855871 AND nbr3<216172782113783808 AND nbr2>72057594037927935 AND nbr2<144115188075855872) OR \
(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr>72057594037927935 AND nbr<144115188075855872) OR \
(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr2>72057594037927935 AND nbr2<144115188075855872) OR \
(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr3>72057594037927935 AND nbr3<144115188075855872) OR \
(nbr2>72057594037927935 AND nbr2<144115188075855872 AND nbr>144115188075855871 AND nbr<216172782113783808) OR \
(nbr3>72057594037927935 AND nbr3<144115188075855872 AND nbr>144115188075855871 AND nbr<216172782113783808) OR \
(nbr3>72057594037927935 AND nbr3<144115188075855872 AND nbr2>144115188075855871 AND nbr2<216172782113783808) OR \
(nbr4>72057594037927935 AND nbr4<144115188075855872 AND nbr>144115188075855871 AND nbr<216172782113783808) OR \
(nbr4>72057594037927935 AND nbr4<144115188075855872 AND nbr2>144115188075855871 AND nbr2<216172782113783808) OR \
(nbr4>72057594037927935 AND nbr4<144115188075855872 AND nbr3>144115188075855871 AND nbr3<216172782113783808) \
ORDER BY predictivesearch1.first_name, predictivesearch1.last_name ASC;");
#endif // #if defined(USE_DEMORGAN)
#else // #if defined(SEARCH_FROM_ONE_TABLE)
    QString reference("SELECT predictivesearch1.contact_id FROM predictivesearch1 WHERE EXISTS (SELECT contact_id FROM predictivesearch2 WHERE predictivesearch1.contact_id = predictivesearch2.contact_id) OR (SELECT contact_id FROM predictivesearch1 WHERE (NOT(NOT(predictivesearch1.nbr>72620543991349247 AND predictivesearch1.nbr<72902018968059904) AND NOT(predictivesearch1.nbr2>72620543991349247 AND predictivesearch1.nbr2<72902018968059904) AND NOT(predictivesearch1.nbr3>72620543991349247 AND predictivesearch1.nbr3<72902018968059904) AND NOT(predictivesearch1.nbr4>72620543991349247 AND predictivesearch1.nbr4<72902018968059904)))) ORDER BY predictivesearch1.first_name, predictivesearch1.last_name ASC;");
#endif // #if defined(SEARCH_FROM_ONE_TABLE)
    QString result = mCntSqlSearch->CreateQuery(pattern);
    //qDebug() << pattern << " -> result" << result;
	//TODO: Fix test result
    LOG2(pattern, result);
    QVERIFY(!result.compare(reference));

    pattern = QString("00202");
#if defined(SEARCH_FROM_ONE_TABLE)
#if defined(USE_DEMORGAN)
    reference = QString("SELECT contact_id FROM predictivesearch0 WHERE NOT(NOT(NOT(NOT(nbr>565148976676863 AND nbr<566248488304640) AND NOT(nbr2>565148976676863 AND nbr2<566248488304640) AND NOT(nbr3>565148976676863 AND nbr3<566248488304640) AND NOT(nbr4>565148976676863 AND nbr4<566248488304640))) AND NOT(NOT(NOT(nbr2>144115188075855871 AND nbr2<216172782113783808 AND nbr>562949953421311 AND nbr<844424930131968) AND NOT(nbr3>144115188075855871 AND nbr3<216172782113783808 AND nbr>562949953421311 AND nbr<844424930131968) AND NOT(nbr3>144115188075855871 AND nbr3<216172782113783808 AND nbr2>562949953421311 AND nbr2<844424930131968) AND NOT(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr>562949953421311 AND nbr<844424930131968) AND NOT(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr2>562949953421311 AND nbr2<844424930131968) AND NOT(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr3>562949953421311 AND nbr3<844424930131968))) AND NOT(NOT(NOT(nbr2>562949953421311 AND nbr2<844424930131968 AND nbr>144115188075855871 AND nbr<216172782113783808) AND NOT(nbr3>562949953421311 AND nbr3<844424930131968 AND nbr>144115188075855871 AND nbr<216172782113783808) AND NOT(nbr3>562949953421311 AND nbr3<844424930131968 AND nbr2>144115188075855871 AND nbr2<216172782113783808) AND NOT(nbr4>562949953421311 AND nbr4<844424930131968 AND nbr>144115188075855871 AND nbr<216172782113783808) AND NOT(nbr4>562949953421311 AND nbr4<844424930131968 AND nbr2>144115188075855871 AND nbr2<216172782113783808) AND NOT(nbr4>562949953421311 AND nbr4<844424930131968 AND nbr3>144115188075855871 AND nbr3<216172782113783808)))) ORDER BY predictivesearch0.first_name, predictivesearch0.last_name ASC;");
#else // #if defined(USE_DEMORGAN)
    reference = QString("SELECT contact_id FROM predictivesearch0 WHERE \
((nbr>565148976676863 AND nbr<566248488304640) OR \
(nbr2>565148976676863 AND nbr2<566248488304640) OR \
(nbr3>565148976676863 AND nbr3<566248488304640) OR \
(nbr4>565148976676863 AND nbr4<566248488304640)) OR \
(nbr2>144115188075855871 AND nbr2<216172782113783808 AND nbr>562949953421311 AND nbr<844424930131968) OR \
(nbr3>144115188075855871 AND nbr3<216172782113783808 AND nbr>562949953421311 AND nbr<844424930131968) OR \
(nbr3>144115188075855871 AND nbr3<216172782113783808 AND nbr2>562949953421311 AND nbr2<844424930131968) OR \
(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr>562949953421311 AND nbr<844424930131968) OR \
(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr2>562949953421311 AND nbr2<844424930131968) OR \
(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr3>562949953421311 AND nbr3<844424930131968) OR \
(nbr2>562949953421311 AND nbr2<844424930131968 AND nbr>144115188075855871 AND nbr<216172782113783808) OR \
(nbr3>562949953421311 AND nbr3<844424930131968 AND nbr>144115188075855871 AND nbr<216172782113783808) OR \
(nbr3>562949953421311 AND nbr3<844424930131968 AND nbr2>144115188075855871 AND nbr2<216172782113783808) OR \
(nbr4>562949953421311 AND nbr4<844424930131968 AND nbr>144115188075855871 AND nbr<216172782113783808) OR \
(nbr4>562949953421311 AND nbr4<844424930131968 AND nbr2>144115188075855871 AND nbr2<216172782113783808) OR \
(nbr4>562949953421311 AND nbr4<844424930131968 AND nbr3>144115188075855871 AND nbr3<216172782113783808) \
ORDER BY predictivesearch0.first_name, predictivesearch0.last_name ASC;");
#endif // #if defined(USE_DEMORGAN)
#else // #if defined(SEARCH_FROM_ONE_TABLE)
    // TODO: Test this case on HW and verify leading zeros.
    reference = QString("SELECT contact_id FROM (SELECT predictivesearch0.contact_id, predictivesearch0.first_name, predictivesearch0.last_name FROM predictivesearch0 WHERE (NOT(NOT(predictivesearch0.nbr>565148976676863 AND predictivesearch0.nbr<566248488304640) AND NOT(predictivesearch0.nbr2>565148976676863 AND predictivesearch0.nbr2<566248488304640) AND NOT(predictivesearch0.nbr3>565148976676863 AND predictivesearch0.nbr3<566248488304640) AND NOT(predictivesearch0.nbr4>565148976676863 AND predictivesearch0.nbr4<566248488304640))) UNION SELECT predictivesearch0.contact_id, predictivesearch0.first_name, predictivesearch0.last_name FROM predictivesearch0 JOIN predictivesearch2 ON predictivesearch0.contact_id = predictivesearch2.contact_id WHERE(NOT(NOT(predictivesearch0.nbr>562949953421311 AND predictivesearch0.nbr<844424930131968) AND NOT(predictivesearch0.nbr2>562949953421311 AND predictivesearch0.nbr2<844424930131968) AND NOT(predictivesearch0.nbr3>562949953421311 AND predictivesearch0.nbr3<844424930131968) AND NOT(predictivesearch0.nbr4>562949953421311 AND predictivesearch0.nbr4<844424930131968)))) AS PR ORDER BY PR.first_name, PR.last_name ASC;");
#endif // #if defined(SEARCH_FROM_ONE_TABLE)
    result = mCntSqlSearch->CreateQuery(pattern);
    qDebug() << pattern << " -> result" << result;
    LOG2(pattern, result);
    QVERIFY( !result.compare( reference) );

    pattern = QString("202000");
#if defined(USE_DEMORGAN)
    // TODO: Test this case on HW and verify trailing zeros.
	reference = QString("SELECT contact_id FROM predictivesearch2 WHERE NOT(NOT(NOT(NOT(nbr>144678138029277183 AND nbr<144678206748753920) AND NOT(nbr2>144678138029277183 AND nbr2<144678206748753920) AND NOT(nbr3>144678138029277183 AND nbr3<144678206748753920) AND NOT(nbr4>144678138029277183 AND nbr4<144678206748753920))) AND NOT(NOT(NOT(nbr2>144115188075855871 AND nbr2<144132780261900288 AND nbr>144115188075855871 AND nbr<216172782113783808) AND NOT(nbr3>144115188075855871 AND nbr3<144132780261900288 AND nbr>144115188075855871 AND nbr<216172782113783808) AND NOT(nbr3>144115188075855871 AND nbr3<144132780261900288 AND nbr2>144115188075855871 AND nbr2<216172782113783808) AND NOT(nbr4>144115188075855871 AND nbr4<144132780261900288 AND nbr>144115188075855871 AND nbr<216172782113783808) AND NOT(nbr4>144115188075855871 AND nbr4<144132780261900288 AND nbr2>144115188075855871 AND nbr2<216172782113783808) AND NOT(nbr4>144115188075855871 AND nbr4<144132780261900288 AND nbr3>144115188075855871 AND nbr3<216172782113783808))) AND NOT(NOT(NOT(nbr2>144115188075855871 AND nbr2<216172782113783808 AND nbr>144115188075855871 AND nbr<144132780261900288) AND NOT(nbr3>144115188075855871 AND nbr3<216172782113783808 AND nbr>144115188075855871 AND nbr<144132780261900288) AND NOT(nbr3>144115188075855871 AND nbr3<216172782113783808 AND nbr2>144115188075855871 AND nbr2<144132780261900288) AND NOT(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr>144115188075855871 AND nbr<144132780261900288) AND NOT(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr2>144115188075855871 AND nbr2<144132780261900288) AND NOT(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr3>144115188075855871 AND nbr3<144132780261900288)))) ORDER BY predictivesearch2.first_name, predictivesearch2.last_name ASC;");
#else
	// TODO: add non-De Morgan version
#endif    

    /*reference = QString("SELECT contact_id FROM predictivesearch2 WHERE \
((nbr>144678138029277183 AND nbr<144678206748753920) OR (nbr2>144678138029277183 AND nbr2<144678206748753920) OR \
(nbr3>144678138029277183 AND nbr3<144678206748753920) OR (nbr4>144678138029277183 AND nbr4<144678206748753920)) OR \
(nbr2>144115188075855871 AND nbr2<144132780261900288 AND nbr>144115188075855871 AND nbr<216172782113783808) OR \
(nbr3>144115188075855871 AND nbr3<144132780261900288 AND nbr>144115188075855871 AND nbr<216172782113783808) OR \
(nbr3>144115188075855871 AND nbr3<144132780261900288 AND nbr2>144115188075855871 AND nbr2<216172782113783808) OR \
(nbr4>144115188075855871 AND nbr4<144132780261900288 AND nbr>144115188075855871 AND nbr<216172782113783808) OR \
(nbr4>144115188075855871 AND nbr4<144132780261900288 AND nbr2>144115188075855871 AND nbr2<216172782113783808) OR \
(nbr4>144115188075855871 AND nbr4<144132780261900288 AND nbr3>144115188075855871 AND nbr3<216172782113783808) OR \
(nbr2>144115188075855871 AND nbr2<216172782113783808 AND nbr>144115188075855871 AND nbr<144132780261900288) OR \
(nbr3>144115188075855871 AND nbr3<216172782113783808 AND nbr>144115188075855871 AND nbr<144132780261900288) OR \
(nbr3>144115188075855871 AND nbr3<216172782113783808 AND nbr2>144115188075855871 AND nbr2<144132780261900288) OR \
(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr>144115188075855871 AND nbr<144132780261900288) OR \
(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr2>144115188075855871 AND nbr2<144132780261900288) OR \
(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr3>144115188075855871 AND nbr3<144132780261900288) \
ORDER BY predictivesearch2.first_name, predictivesearch2.last_name ASC;");*/

    result = mCntSqlSearch->CreateQuery(pattern);
    qDebug() << pattern << " -> result" << result;
    LOG2(pattern, result);
    QVERIFY( !result.compare( reference) );

    pattern = QString("0020200");
#if defined(SEARCH_FROM_ONE_TABLE)
#if defined(USE_DEMORGAN)
    reference = QString("SELECT contact_id FROM predictivesearch0 WHERE NOT(NOT(NOT(NOT(nbr>565148976676863 AND nbr<565153271644160) AND NOT(nbr2>565148976676863 AND nbr2<565153271644160) AND NOT(nbr3>565148976676863 AND nbr3<565153271644160) AND NOT(nbr4>565148976676863 AND nbr4<565153271644160))) AND NOT(NOT(NOT(nbr2>144115188075855871 AND nbr2<144396663052566528 AND nbr>562949953421311 AND nbr<844424930131968) AND NOT(nbr3>144115188075855871 AND nbr3<144396663052566528 AND nbr>562949953421311 AND nbr<844424930131968) AND NOT(nbr3>144115188075855871 AND nbr3<144396663052566528 AND nbr2>562949953421311 AND nbr2<844424930131968) AND NOT(nbr4>144115188075855871 AND nbr4<144396663052566528 AND nbr>562949953421311 AND nbr<844424930131968) AND NOT(nbr4>144115188075855871 AND nbr4<144396663052566528 AND nbr2>562949953421311 AND nbr2<844424930131968) AND NOT(nbr4>144115188075855871 AND nbr4<144396663052566528 AND nbr3>562949953421311 AND nbr3<844424930131968))) AND NOT(NOT(NOT(nbr2>562949953421311 AND nbr2<844424930131968 AND nbr>144115188075855871 AND nbr<144396663052566528) AND NOT(nbr3>562949953421311 AND nbr3<844424930131968 AND nbr>144115188075855871 AND nbr<144396663052566528) AND NOT(nbr3>562949953421311 AND nbr3<844424930131968 AND nbr2>144115188075855871 AND nbr2<144396663052566528) AND NOT(nbr4>562949953421311 AND nbr4<844424930131968 AND nbr>144115188075855871 AND nbr<144396663052566528) AND NOT(nbr4>562949953421311 AND nbr4<844424930131968 AND nbr2>144115188075855871 AND nbr2<144396663052566528) AND NOT(nbr4>562949953421311 AND nbr4<844424930131968 AND nbr3>144115188075855871 AND nbr3<144396663052566528)))) ORDER BY predictivesearch0.first_name, predictivesearch0.last_name ASC;");
#else // #if defined(USE_DEMORGAN)
    reference = QString("SELECT contact_id FROM predictivesearch0 WHERE \
((nbr>565148976676863 AND nbr<565153271644160) OR (nbr2>565148976676863 AND nbr2<565153271644160) OR \
(nbr3>565148976676863 AND nbr3<565153271644160) OR (nbr4>565148976676863 AND nbr4<565153271644160)) OR \
(nbr2>144115188075855871 AND nbr2<144396663052566528 AND nbr>562949953421311 AND nbr<844424930131968) OR \
(nbr3>144115188075855871 AND nbr3<144396663052566528 AND nbr>562949953421311 AND nbr<844424930131968) OR \
(nbr3>144115188075855871 AND nbr3<144396663052566528 AND nbr2>562949953421311 AND nbr2<844424930131968) OR \
(nbr4>144115188075855871 AND nbr4<144396663052566528 AND nbr>562949953421311 AND nbr<844424930131968) OR \
(nbr4>144115188075855871 AND nbr4<144396663052566528 AND nbr2>562949953421311 AND nbr2<844424930131968) OR \
(nbr4>144115188075855871 AND nbr4<144396663052566528 AND nbr3>562949953421311 AND nbr3<844424930131968) OR \
(nbr2>562949953421311 AND nbr2<844424930131968 AND nbr>144115188075855871 AND nbr<144396663052566528) OR \
(nbr3>562949953421311 AND nbr3<844424930131968 AND nbr>144115188075855871 AND nbr<144396663052566528) OR \
(nbr3>562949953421311 AND nbr3<844424930131968 AND nbr2>144115188075855871 AND nbr2<144396663052566528) OR \
(nbr4>562949953421311 AND nbr4<844424930131968 AND nbr>144115188075855871 AND nbr<144396663052566528) OR \
(nbr4>562949953421311 AND nbr4<844424930131968 AND nbr2>144115188075855871 AND nbr2<144396663052566528) OR \
(nbr4>562949953421311 AND nbr4<844424930131968 AND nbr3>144115188075855871 AND nbr3<144396663052566528) \
ORDER BY predictivesearch0.first_name, predictivesearch0.last_name ASC;");
#endif // #if defined(USE_DEMORGAN)
#else // #if defined(SEARCH_FROM_ONE_TABLE)
    // TODO: Test this case on HW and verify leading zeros.
    reference = QString("SELECT contact_id FROM (SELECT predictivesearch0.contact_id, predictivesearch0.first_name, predictivesearch0.last_name FROM predictivesearch0 WHERE (NOT(NOT(predictivesearch0.nbr>565148976676863 AND predictivesearch0.nbr<565153271644160) AND NOT(predictivesearch0.nbr2>565148976676863 AND predictivesearch0.nbr2<565153271644160) AND NOT(predictivesearch0.nbr3>565148976676863 AND predictivesearch0.nbr3<565153271644160) AND NOT(predictivesearch0.nbr4>565148976676863 AND predictivesearch0.nbr4<565153271644160))) UNION SELECT predictivesearch0.contact_id, predictivesearch0.first_name, predictivesearch0.last_name FROM predictivesearch0 JOIN predictivesearch2 ON predictivesearch0.contact_id = predictivesearch2.contact_id WHERE((NOT(NOT(predictivesearch0.nbr>562949953421311 AND predictivesearch0.nbr<844424930131968) AND NOT(predictivesearch0.nbr2>562949953421311 AND predictivesearch0.nbr2<844424930131968) AND NOT(predictivesearch0.nbr3>562949953421311 AND predictivesearch0.nbr3<844424930131968) AND NOT(predictivesearch0.nbr4>562949953421311 AND predictivesearch0.nbr4<844424930131968))) AND (NOT(NOT(predictivesearch2.nbr>144115188075855871 AND predictivesearch2.nbr<144396663052566528) AND NOT(predictivesearch2.nbr2>144115188075855871 AND predictivesearch2.nbr2<144396663052566528) AND NOT(predictivesearch2.nbr3>144115188075855871 AND predictivesearch2.nbr3<144396663052566528) AND NOT(predictivesearch2.nbr4>144115188075855871 AND predictivesearch2.nbr4<144396663052566528))))) AS PR ORDER BY PR.first_name, PR.last_name ASC;");
#endif //#if defined(SEARCH_FROM_ONE_TABLE) 
    result = mCntSqlSearch->CreateQuery(pattern);
    qDebug() << pattern << " -> result" << result;
    LOG2(pattern, result);
    QVERIFY( !result.compare( reference) );

    pattern = QString("20322");
#if defined(SEARCH_FROM_ONE_TABLE)
#if defined(USE_DEMORGAN)
    reference = QString("SELECT contact_id FROM predictivesearch2 WHERE NOT(NOT(NOT(NOT(nbr>144996996401332223 AND nbr<144998095912960000) AND NOT(nbr2>144996996401332223 AND nbr2<144998095912960000) AND NOT(nbr3>144996996401332223 AND nbr3<144998095912960000) AND NOT(nbr4>144996996401332223 AND nbr4<144998095912960000))) AND NOT(NOT(NOT(nbr2>225742931321946111 AND nbr2<226024406298656768 AND nbr>144115188075855871 AND nbr<216172782113783808) AND NOT(nbr3>225742931321946111 AND nbr3<226024406298656768 AND nbr>144115188075855871 AND nbr<216172782113783808) AND NOT(nbr3>225742931321946111 AND nbr3<226024406298656768 AND nbr2>144115188075855871 AND nbr2<216172782113783808) AND NOT(nbr4>225742931321946111 AND nbr4<226024406298656768 AND nbr>144115188075855871 AND nbr<216172782113783808) AND NOT(nbr4>225742931321946111 AND nbr4<226024406298656768 AND nbr2>144115188075855871 AND nbr2<216172782113783808) AND NOT(nbr4>225742931321946111 AND nbr4<226024406298656768 AND nbr3>144115188075855871 AND nbr3<216172782113783808))) AND NOT(NOT(NOT(nbr2>144115188075855871 AND nbr2<216172782113783808 AND nbr>225742931321946111 AND nbr<226024406298656768) AND NOT(nbr3>144115188075855871 AND nbr3<216172782113783808 AND nbr>225742931321946111 AND nbr<226024406298656768) AND NOT(nbr3>144115188075855871 AND nbr3<216172782113783808 AND nbr2>225742931321946111 AND nbr2<226024406298656768) AND NOT(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr>225742931321946111 AND nbr<226024406298656768) AND NOT(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr2>225742931321946111 AND nbr2<226024406298656768) AND NOT(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr3>225742931321946111 AND nbr3<226024406298656768)))) ORDER BY predictivesearch2.first_name, predictivesearch2.last_name ASC;");
#else // #if defined(USE_DEMORGAN)
    reference = QString("SELECT contact_id FROM predictivesearch2 WHERE \
((nbr>144996996401332223 AND nbr<144998095912960000) OR (nbr2>144996996401332223 AND nbr2<144998095912960000) OR \
(nbr3>144996996401332223 AND nbr3<144998095912960000) OR (nbr4>144996996401332223 AND nbr4<144998095912960000)) OR \
(nbr2>225742931321946111 AND nbr2<226024406298656768 AND nbr>144115188075855871 AND nbr<216172782113783808) OR \
(nbr3>225742931321946111 AND nbr3<226024406298656768 AND nbr>144115188075855871 AND nbr<216172782113783808) OR \
(nbr3>225742931321946111 AND nbr3<226024406298656768 AND nbr2>144115188075855871 AND nbr2<216172782113783808) OR \
(nbr4>225742931321946111 AND nbr4<226024406298656768 AND nbr>144115188075855871 AND nbr<216172782113783808) OR \
(nbr4>225742931321946111 AND nbr4<226024406298656768 AND nbr2>144115188075855871 AND nbr2<216172782113783808) OR \
(nbr4>225742931321946111 AND nbr4<226024406298656768 AND nbr3>144115188075855871 AND nbr3<216172782113783808) OR \
(nbr2>144115188075855871 AND nbr2<216172782113783808 AND nbr>225742931321946111 AND nbr<226024406298656768) OR \
(nbr3>144115188075855871 AND nbr3<216172782113783808 AND nbr>225742931321946111 AND nbr<226024406298656768) OR \
(nbr3>144115188075855871 AND nbr3<216172782113783808 AND nbr2>225742931321946111 AND nbr2<226024406298656768) OR \
(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr>225742931321946111 AND nbr<226024406298656768) OR \
(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr2>225742931321946111 AND nbr2<226024406298656768) OR \
(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr3>225742931321946111 AND nbr3<226024406298656768) \
ORDER BY predictivesearch2.first_name, predictivesearch2.last_name ASC;"); 
#endif // #if defined(USE_DEMORGAN)
#else // #if defined(SEARCH_FROM_ONE_TABLE)
    reference = QString("SELECT contact_id FROM (SELECT predictivesearch2.contact_id, predictivesearch2.first_name, predictivesearch2.last_name FROM predictivesearch2 WHERE (NOT(NOT(predictivesearch2.nbr>144996996401332223 AND predictivesearch2.nbr<144998095912960000) AND NOT(predictivesearch2.nbr2>144996996401332223 AND predictivesearch2.nbr2<144998095912960000) AND NOT(predictivesearch2.nbr3>144996996401332223 AND predictivesearch2.nbr3<144998095912960000) AND NOT(predictivesearch2.nbr4>144996996401332223 AND predictivesearch2.nbr4<144998095912960000))) UNION SELECT predictivesearch2.contact_id, predictivesearch2.first_name, predictivesearch2.last_name FROM predictivesearch2 JOIN predictivesearch3 ON predictivesearch2.contact_id = predictivesearch3.contact_id WHERE(NOT(NOT(predictivesearch3.nbr>225742931321946111 AND predictivesearch3.nbr<226024406298656768) AND NOT(predictivesearch3.nbr2>225742931321946111 AND predictivesearch3.nbr2<226024406298656768) AND NOT(predictivesearch3.nbr3>225742931321946111 AND predictivesearch3.nbr3<226024406298656768) AND NOT(predictivesearch3.nbr4>225742931321946111 AND predictivesearch3.nbr4<226024406298656768)))) AS PR ORDER BY PR.first_name, PR.last_name ASC;");
#endif // #if defined(SEARCH_FROM_ONE_TABLE)
    result = mCntSqlSearch->CreateQuery(pattern);
    qDebug() << pattern << " -> result" << result;
    LOG2(pattern, result);
    QVERIFY( !result.compare( reference) );
    
    TEST_PASSED_LOG("testCreateQuery");
}

void UT_CntSqlSearch::testExactMatchSearch()
{
    TEST_BEGIN_LOG("testExactMatchSearch");

    QString pattern("120");
#if defined(USE_DEMORGAN)
    QString reference("SELECT contact_id FROM predictivesearch1 WHERE (NOT(NOT(nbr>81064793292668927 AND nbr<81346268269379584) AND NOT(nbr2>81064793292668927 AND nbr2<81346268269379584) AND NOT(nbr3>81064793292668927 AND nbr3<81346268269379584) AND NOT(nbr4>81064793292668927 AND nbr4<81346268269379584)))");
#else // #if defined(USE_DEMORGAN)
    QString reference("SELECT contact_id FROM predictivesearch1 WHERE (nbr>81064793292668927 AND nbr<81346268269379584) OR (nbr2>81064793292668927 AND nbr2<81346268269379584) OR (nbr3>81064793292668927 AND nbr3<81346268269379584) OR (nbr4>81064793292668927 AND nbr4<81346268269379584)");
#endif // #if defined(USE_DEMORGAN)
    QString result = mCntSqlSearch->ExactMatchSearch(pattern);
//    qDebug() << pattern << " -> result" << result;
    LOG2(pattern, result);
    QVERIFY(result == reference);
    

    pattern = QString("5");
#if defined(USE_DEMORGAN)
    reference = "SELECT contact_id FROM predictivesearch5 WHERE (NOT(NOT(nbr>360287970189639679 AND nbr<432345564227567616) AND NOT(nbr2>360287970189639679 AND nbr2<432345564227567616) AND NOT(nbr3>360287970189639679 AND nbr3<432345564227567616) AND NOT(nbr4>360287970189639679 AND nbr4<432345564227567616)))";
#else // #if defined(USE_DEMORGAN)
    reference = "SELECT contact_id FROM predictivesearch5 WHERE (nbr>360287970189639679 AND nbr<432345564227567616) OR (nbr2>360287970189639679 AND nbr2<432345564227567616) OR (nbr3>360287970189639679 AND nbr3<432345564227567616) OR (nbr4>360287970189639679 AND nbr4<432345564227567616)";
#endif // #if defined(USE_DEMORGAN)
    result = mCntSqlSearch->ExactMatchSearch(pattern);
//    qDebug() << pattern << " -> result" << result;
    LOG2(pattern, result);
    QVERIFY(result == reference);

    
    pattern = QString("25");
#if defined(USE_DEMORGAN)
    reference = "SELECT contact_id FROM predictivesearch2 WHERE (NOT(NOT(nbr>166633186212708351 AND nbr<171136785840078848) AND NOT(nbr2>166633186212708351 AND nbr2<171136785840078848) AND NOT(nbr3>166633186212708351 AND nbr3<171136785840078848) AND NOT(nbr4>166633186212708351 AND nbr4<171136785840078848)))";
#else // #if defined(USE_DEMORGAN)
    reference = "SELECT contact_id FROM predictivesearch2 WHERE (nbr>166633186212708351 AND nbr<171136785840078848) OR (nbr2>166633186212708351 AND nbr2<171136785840078848) OR (nbr3>166633186212708351 AND nbr3<171136785840078848) OR (nbr4>166633186212708351 AND nbr4<171136785840078848)";
#endif // #if defined(USE_DEMORGAN)
    result = mCntSqlSearch->ExactMatchSearch(pattern);
//    qDebug() << pattern << " -> result" << result;
    LOG2(pattern, result);
    QVERIFY(result == reference);
    
    TEST_PASSED_LOG("testExactMatchSearch");
}

void UT_CntSqlSearch::testIntersectionSearch()
{
    TEST_BEGIN_LOG("testIntersectionSearch");

    QString pattern("205");
    QStringList tokens;
    tokens << "2" << "5";
#if defined(SEARCH_FROM_ONE_TABLE)
#if defined(USE_DEMORGAN)
    QString reference("SELECT contact_id FROM predictivesearch2 WHERE NOT(NOT(NOT(NOT(nbr>145522562959409151 AND nbr<145804037936119808) AND NOT(nbr2>145522562959409151 AND nbr2<145804037936119808) AND NOT(nbr3>145522562959409151 AND nbr3<145804037936119808) AND NOT(nbr4>145522562959409151 AND nbr4<145804037936119808))) AND NOT(NOT(NOT(nbr2>360287970189639679 AND nbr2<432345564227567616 AND nbr>144115188075855871 AND nbr<216172782113783808) AND NOT(nbr3>360287970189639679 AND nbr3<432345564227567616 AND nbr>144115188075855871 AND nbr<216172782113783808) AND NOT(nbr3>360287970189639679 AND nbr3<432345564227567616 AND nbr2>144115188075855871 AND nbr2<216172782113783808) AND NOT(nbr4>360287970189639679 AND nbr4<432345564227567616 AND nbr>144115188075855871 AND nbr<216172782113783808) AND NOT(nbr4>360287970189639679 AND nbr4<432345564227567616 AND nbr2>144115188075855871 AND nbr2<216172782113783808) AND NOT(nbr4>360287970189639679 AND nbr4<432345564227567616 AND nbr3>144115188075855871 AND nbr3<216172782113783808))) AND NOT(NOT(NOT(nbr2>144115188075855871 AND nbr2<216172782113783808 AND nbr>360287970189639679 AND nbr<432345564227567616) AND NOT(nbr3>144115188075855871 AND nbr3<216172782113783808 AND nbr>360287970189639679 AND nbr<432345564227567616) AND NOT(nbr3>144115188075855871 AND nbr3<216172782113783808 AND nbr2>360287970189639679 AND nbr2<432345564227567616) AND NOT(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr>360287970189639679 AND nbr<432345564227567616) AND NOT(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr2>360287970189639679 AND nbr2<432345564227567616) AND NOT(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr3>360287970189639679 AND nbr3<432345564227567616)))) ORDER BY predictivesearch2.first_name, predictivesearch2.last_name ASC;");
#else // #if defined(USE_DEMORGAN)
    QString reference("SELECT contact_id FROM predictivesearch2 WHERE \
((nbr>145522562959409151 AND nbr<145804037936119808) OR (nbr2>145522562959409151 AND nbr2<145804037936119808) OR \
(nbr3>145522562959409151 AND nbr3<145804037936119808) OR (nbr4>145522562959409151 AND nbr4<145804037936119808)) OR \
(nbr2>360287970189639679 AND nbr2<432345564227567616 AND nbr>144115188075855871 AND nbr<216172782113783808) OR \
(nbr3>360287970189639679 AND nbr3<432345564227567616 AND nbr>144115188075855871 AND nbr<216172782113783808) OR \
(nbr3>360287970189639679 AND nbr3<432345564227567616 AND nbr2>144115188075855871 AND nbr2<216172782113783808) OR \
(nbr4>360287970189639679 AND nbr4<432345564227567616 AND nbr>144115188075855871 AND nbr<216172782113783808) OR \
(nbr4>360287970189639679 AND nbr4<432345564227567616 AND nbr2>144115188075855871 AND nbr2<216172782113783808) OR \
(nbr4>360287970189639679 AND nbr4<432345564227567616 AND nbr3>144115188075855871 AND nbr3<216172782113783808) OR \
(nbr2>144115188075855871 AND nbr2<216172782113783808 AND nbr>360287970189639679 AND nbr<432345564227567616) OR \
(nbr3>144115188075855871 AND nbr3<216172782113783808 AND nbr>360287970189639679 AND nbr<432345564227567616) OR \
(nbr3>144115188075855871 AND nbr3<216172782113783808 AND nbr2>360287970189639679 AND nbr2<432345564227567616) OR \
(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr>360287970189639679 AND nbr<432345564227567616) OR \
(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr2>360287970189639679 AND nbr2<432345564227567616) OR \
(nbr4>144115188075855871 AND nbr4<216172782113783808 AND nbr3>360287970189639679 AND nbr3<432345564227567616) \
ORDER BY predictivesearch2.first_name, predictivesearch2.last_name ASC;");
#endif // #if defined(USE_DEMORGAN)
#else // #if defined(SEARCH_FROM_ONE_TABLE)
    QString reference("SELECT predictivesearch2.contact_id FROM predictivesearch2 WHERE EXISTS (SELECT contact_id FROM predictivesearch5 WHERE predictivesearch2.contact_id = predictivesearch5.contact_id) OR (SELECT contact_id FROM predictivesearch2 WHERE (NOT(NOT(predictivesearch2.nbr>145522562959409151 AND predictivesearch2.nbr<145804037936119808) AND NOT(predictivesearch2.nbr2>145522562959409151 AND predictivesearch2.nbr2<145804037936119808) AND NOT(predictivesearch2.nbr3>145522562959409151 AND predictivesearch2.nbr3<145804037936119808) AND NOT(predictivesearch2.nbr4>145522562959409151 AND predictivesearch2.nbr4<145804037936119808)))) ORDER BY predictivesearch2.first_name, predictivesearch2.last_name ASC;");
#endif // #if defined(SEARCH_FROM_ONE_TABLE)
    QString result = mCntSqlSearch->IntersectionSearch(pattern, tokens);
//    qDebug() << pattern << " -> result" << result;
    LOG2(pattern, result);
    QVERIFY( !result.compare( reference) );
    
    TEST_PASSED_LOG("testIntersectionSearch");
}

void UT_CntSqlSearch::testExactMatch()
{
    TEST_BEGIN_LOG("testExactMatch");

    QString pattern("25");
#if defined(USE_DEMORGAN)
    QString reference("(NOT(NOT(nbr>166633186212708351 AND nbr<171136785840078848) AND NOT(nbr2>166633186212708351 AND nbr2<171136785840078848) AND NOT(nbr3>166633186212708351 AND nbr3<171136785840078848) AND NOT(nbr4>166633186212708351 AND nbr4<171136785840078848)))");
#else // #if defined(USE_DEMORGAN)
    QString reference("(nbr>166633186212708351 AND nbr<171136785840078848) OR (nbr2>166633186212708351 AND nbr2<171136785840078848) OR (nbr3>166633186212708351 AND nbr3<171136785840078848) OR (nbr4>166633186212708351 AND nbr4<171136785840078848)");
#endif // #if defined(USE_DEMORGAN)
    QString result = mCntSqlSearch->ExactMatch(pattern);
//    LOG2(pattern, result);
    QVERIFY(!result.compare(reference));

    TEST_PASSED_LOG("testExactMatch");
}

void UT_CntSqlSearch::testCreateJoinTableSearch()
{
    TEST_BEGIN_LOG("testCreateJoinTableSearch");
    
    QString pattern("5606");
    QStringList tokens;
    tokens << "56" << "6";
#if defined(USE_DEMORGAN)
    QString reference("SELECT contact_id FROM (SELECT predictivesearch5.contact_id, predictivesearch5.first_name, predictivesearch5.last_name FROM predictivesearch5 WHERE (NOT(NOT(predictivesearch5.nbr>387415121070129151 AND predictivesearch5.nbr<387432713256173568) AND NOT(predictivesearch5.nbr2>387415121070129151 AND predictivesearch5.nbr2<387432713256173568) AND NOT(predictivesearch5.nbr3>387415121070129151 AND predictivesearch5.nbr3<387432713256173568) AND NOT(predictivesearch5.nbr4>387415121070129151 AND predictivesearch5.nbr4<387432713256173568))) UNION SELECT predictivesearch5.contact_id, predictivesearch5.first_name, predictivesearch5.last_name FROM predictivesearch5 JOIN predictivesearch6 ON predictivesearch5.contact_id = predictivesearch6.contact_id WHERE(NOT(NOT(predictivesearch5.nbr>387309567953862655 AND predictivesearch5.nbr<391813167581233152) AND NOT(predictivesearch5.nbr2>387309567953862655 AND predictivesearch5.nbr2<391813167581233152) AND NOT(predictivesearch5.nbr3>387309567953862655 AND predictivesearch5.nbr3<391813167581233152) AND NOT(predictivesearch5.nbr4>387309567953862655 AND predictivesearch5.nbr4<391813167581233152)))) AS PR ORDER BY PR.first_name, PR.last_name ASC;");
#else // #if defined(USE_DEMORGAN)
    // TODO: add non-De Morgan cases
#endif // #if defined(USE_DEMORGAN)
    QString result = mCntSqlSearch->CreateJoinTableSearch(pattern, tokens);
    //qDebug() << pattern << " -> result" << result;
    LOG2(pattern, result);
    QVERIFY(!result.compare(reference));

    pattern = QString ("250052");
    tokens.clear();
    tokens << "25" << "52";
#if defined(USE_DEMORGAN)
    reference = QString("SELECT contact_id FROM (SELECT predictivesearch2.contact_id, predictivesearch2.first_name, predictivesearch2.last_name FROM predictivesearch2 WHERE (NOT(NOT(predictivesearch2.nbr>166638821209800703 AND predictivesearch2.nbr<166638889929277440) AND NOT(predictivesearch2.nbr2>166638821209800703 AND predictivesearch2.nbr2<166638889929277440) AND NOT(predictivesearch2.nbr3>166638821209800703 AND predictivesearch2.nbr3<166638889929277440) AND NOT(predictivesearch2.nbr4>166638821209800703 AND predictivesearch2.nbr4<166638889929277440))) UNION SELECT predictivesearch2.contact_id, predictivesearch2.first_name, predictivesearch2.last_name FROM predictivesearch2 JOIN predictivesearch5 ON predictivesearch2.contact_id = predictivesearch5.contact_id WHERE((NOT(NOT(predictivesearch2.nbr>166633186212708351 AND predictivesearch2.nbr<171136785840078848) AND NOT(predictivesearch2.nbr2>166633186212708351 AND predictivesearch2.nbr2<171136785840078848) AND NOT(predictivesearch2.nbr3>166633186212708351 AND predictivesearch2.nbr3<171136785840078848) AND NOT(predictivesearch2.nbr4>166633186212708351 AND predictivesearch2.nbr4<171136785840078848))) AND (NOT(NOT(predictivesearch5.nbr>369295169444380671 AND predictivesearch5.nbr<373798769071751168) AND NOT(predictivesearch5.nbr2>369295169444380671 AND predictivesearch5.nbr2<373798769071751168) AND NOT(predictivesearch5.nbr3>369295169444380671 AND predictivesearch5.nbr3<373798769071751168) AND NOT(predictivesearch5.nbr4>369295169444380671 AND predictivesearch5.nbr4<373798769071751168))))) AS PR ORDER BY PR.first_name, PR.last_name ASC;");
#else // #if defined(USE_DEMORGAN)
    // TODO: add non-De Morgan cases
#endif // #if defined(USE_DEMORGAN)
    result = mCntSqlSearch->CreateJoinTableSearch(pattern, tokens);
    //qDebug() << pattern << " -> result" << result;
    LOG2(pattern, result);
    QVERIFY(!result.compare(reference));

    pattern.clear();
    pattern = "2505";
    tokens.clear();
    tokens << "25" << "5";
#if defined(USE_DEMORGAN)
    reference = QString("SELECT contact_id FROM (SELECT predictivesearch2.contact_id, predictivesearch2.first_name, predictivesearch2.last_name FROM predictivesearch2 WHERE (NOT(NOT(predictivesearch2.nbr>166721147142930431 AND predictivesearch2.nbr<166738739328974848) AND NOT(predictivesearch2.nbr2>166721147142930431 AND predictivesearch2.nbr2<166738739328974848) AND NOT(predictivesearch2.nbr3>166721147142930431 AND predictivesearch2.nbr3<166738739328974848) AND NOT(predictivesearch2.nbr4>166721147142930431 AND predictivesearch2.nbr4<166738739328974848))) UNION SELECT predictivesearch2.contact_id, predictivesearch2.first_name, predictivesearch2.last_name FROM predictivesearch2 JOIN predictivesearch5 ON predictivesearch2.contact_id = predictivesearch5.contact_id WHERE(NOT(NOT(predictivesearch2.nbr>166633186212708351 AND predictivesearch2.nbr<171136785840078848) AND NOT(predictivesearch2.nbr2>166633186212708351 AND predictivesearch2.nbr2<171136785840078848) AND NOT(predictivesearch2.nbr3>166633186212708351 AND predictivesearch2.nbr3<171136785840078848) AND NOT(predictivesearch2.nbr4>166633186212708351 AND predictivesearch2.nbr4<171136785840078848)))) AS PR ORDER BY PR.first_name, PR.last_name ASC;");
#else // #if defined(USE_DEMORGAN)
    // TODO: add non-De Morgan cases
#endif // #if defined(USE_DEMORGAN)
    result = mCntSqlSearch->CreateJoinTableSearch(pattern, tokens);
    //qDebug() << pattern << " -> result" << result;
    LOG2(pattern, result);
    QVERIFY(!result.compare(reference));

    // TODO: Test this case on HW and verify leading zeros.
    pattern.clear();
    pattern = "0705";
    tokens.clear();
    tokens << "7" << "5";
#if defined(USE_DEMORGAN)
    reference = QString("SELECT contact_id FROM (SELECT predictivesearch2.contact_id, predictivesearch2.first_name, predictivesearch2.last_name FROM predictivesearch2 WHERE (NOT(NOT(predictivesearch2.nbr>145557747331497983 AND predictivesearch2.nbr<145575339517542400) AND NOT(predictivesearch2.nbr2>145557747331497983 AND predictivesearch2.nbr2<145575339517542400) AND NOT(predictivesearch2.nbr3>145557747331497983 AND predictivesearch2.nbr3<145575339517542400) AND NOT(predictivesearch2.nbr4>145557747331497983 AND predictivesearch2.nbr4<145575339517542400))) UNION SELECT predictivesearch2.contact_id, predictivesearch2.first_name, predictivesearch2.last_name FROM predictivesearch2 JOIN predictivesearch5 ON predictivesearch2.contact_id = predictivesearch5.contact_id WHERE(NOT(NOT(predictivesearch5.nbr>369295169444380671 AND predictivesearch5.nbr<373798769071751168) AND NOT(predictivesearch5.nbr2>369295169444380671 AND predictivesearch5.nbr2<373798769071751168) AND NOT(predictivesearch5.nbr3>369295169444380671 AND predictivesearch5.nbr3<373798769071751168) AND NOT(predictivesearch5.nbr4>369295169444380671 AND predictivesearch5.nbr4<373798769071751168)))) AS PR ORDER BY PR.first_name, PR.last_name ASC");
#else // #if defined(USE_DEMORGAN)
    // TODO: add non-De Morgan cases
#endif // #if defined(USE_DEMORGAN)
    result = mCntSqlSearch->CreateJoinTableSearch(pattern, tokens);
    //qDebug() << pattern << result;
    LOG2(pattern, result);
    QVERIFY(!result.compare(result));

    pattern.clear();
    pattern = "2052";
    tokens.clear();
    tokens << "2" << "52";
#if defined(USE_DEMORGAN)
    reference = QString("SELECT contact_id FROM (SELECT predictivesearch2.contact_id, predictivesearch2.first_name, predictivesearch2.last_name FROM predictivesearch2 WHERE (NOT(NOT(predictivesearch2.nbr>145557747331497983 AND predictivesearch2.nbr<145575339517542400) AND NOT(predictivesearch2.nbr2>145557747331497983 AND predictivesearch2.nbr2<145575339517542400) AND NOT(predictivesearch2.nbr3>145557747331497983 AND predictivesearch2.nbr3<145575339517542400) AND NOT(predictivesearch2.nbr4>145557747331497983 AND predictivesearch2.nbr4<145575339517542400))) UNION SELECT predictivesearch2.contact_id, predictivesearch2.first_name, predictivesearch2.last_name FROM predictivesearch2 JOIN predictivesearch5 ON predictivesearch2.contact_id = predictivesearch5.contact_id WHERE(NOT(NOT(predictivesearch5.nbr>369295169444380671 AND predictivesearch5.nbr<373798769071751168) AND NOT(predictivesearch5.nbr2>369295169444380671 AND predictivesearch5.nbr2<373798769071751168) AND NOT(predictivesearch5.nbr3>369295169444380671 AND predictivesearch5.nbr3<373798769071751168) AND NOT(predictivesearch5.nbr4>369295169444380671 AND predictivesearch5.nbr4<373798769071751168)))) AS PR ORDER BY PR.first_name, PR.last_name ASC");
#else // #if defined(USE_DEMORGAN)
    // TODO: add non-De Morgan cases
#endif // #if defined(USE_DEMORGAN)
    result = mCntSqlSearch->CreateJoinTableSearch(pattern, tokens);
    //qDebug() << "pattern " << result;
    LOG2(pattern, result);
    QVERIFY(!result.compare(result));
    
    TEST_PASSED_LOG("testCreateJoinTableSearch");
}

void UT_CntSqlSearch::testUpperLimit()
{
    TEST_BEGIN_LOG("testUpperLimit");
    
    QString pattern("234");
    QString result;
    QString reference("159033361841520640"); 
    result = mCntSqlSearch->UpperLimit(pattern);
    qDebug() << pattern << " -> result" << result;
    QVERIFY( result == reference );
    
    pattern = QString("234456576687687");
    reference = QString("158828188945381000");
    result = mCntSqlSearch->UpperLimit(pattern);
    qDebug() << pattern << " -> result" << result;
    QVERIFY( result == reference );
    
    // Same result as above case, characters beyond 15th are ignored
    pattern = QString("2344565766876874906754968");
    result = mCntSqlSearch->UpperLimit(pattern);
    qDebug() << pattern << " -> result" << result;
    QVERIFY( result == reference );

    pattern = QString("004456");
    reference = QString("1202247245496320");
    result = mCntSqlSearch->UpperLimit(pattern);
    qDebug() << pattern << " -> result" << result;
    QVERIFY( result == reference );
    
    pattern = QString("");
    reference = QString("1152921504606846976");
    result = mCntSqlSearch->UpperLimit(pattern);
    qDebug() << pattern << " -> result" << result;
    QVERIFY( result == reference );
    
    
    pattern = QString("000000000000000");
    reference = QString("1");
    result = mCntSqlSearch->UpperLimit(pattern);
    qDebug() << pattern << " -> result" << result;
    QVERIFY( result == reference );
    
    pattern = QString("0000000000000");
    reference = QString("256");
    result = mCntSqlSearch->UpperLimit(pattern);
    qDebug() << pattern << " -> result" << result;
    QVERIFY( result == reference );
    
    TEST_PASSED_LOG("testUpperLimit");
}

void UT_CntSqlSearch::testLowerLimit()
{
    TEST_BEGIN_LOG("testLowerLimit");
    
    QString pattern("234");
    QString result;
    QString reference("158751886864809983");
    result = mCntSqlSearch->LowerLimit(pattern);
    qDebug() << pattern << " -> result" << result;
    QVERIFY( result == reference );
    
    pattern = QString("234456576687687");
    reference = QString("158828188945380998");
    result = mCntSqlSearch->LowerLimit(pattern);
    qDebug() << pattern << " -> result" << result;
    QVERIFY( result == reference );
    
    // Same result as above case, characters beyond 15th are ignored
    pattern = QString("23445657668768749067549685");
    result = mCntSqlSearch->LowerLimit(pattern);
    qDebug() << pattern << " -> result" << result;
    QVERIFY( result == reference );

    pattern = QString("001021");
    reference = QString("283742719442943");
    result = mCntSqlSearch->LowerLimit(pattern);
    qDebug() << pattern << " -> result" << result;
    QVERIFY( result == reference );

    pattern = QString("1021500");
    reference = QString("72643633735532543");
    result = mCntSqlSearch->LowerLimit(pattern);
    qDebug() << pattern << " -> result" << result;
    QVERIFY( result == reference );
    
    pattern = QString("");
    reference = QString("-1");
    result = mCntSqlSearch->LowerLimit(pattern);
    qDebug() << pattern << " -> result" << result;
    QVERIFY( result == reference );
        
    // Lower limit for this is -1
    pattern = QString("000000000000000");
    reference = QString("-1"); // Lower limit is now zero minus one
    result = mCntSqlSearch->LowerLimit(pattern);
    qDebug() << pattern << " -> result" << result;
    QVERIFY( result == reference );
    
    // Lower limit for this is -1
    pattern = QString("00");
    reference = QString("-1");
    result = mCntSqlSearch->LowerLimit(pattern);
    qDebug() << pattern << " -> result" << result;
    QVERIFY( result == reference );
    
    TEST_PASSED_LOG("testLowerLimit");
}

void UT_CntSqlSearch::testGetTokens()
    {
    TEST_BEGIN_LOG("testGetTokens");
    
    QStringList tokens = mCntSqlSearch->GetTokens("");
    QVERIFY(tokens.count() == 0);
        
    tokens = mCntSqlSearch->GetTokens("0");
    QVERIFY(tokens.count() == 0);
    
    tokens = mCntSqlSearch->GetTokens("00");
    QVERIFY(tokens.count() == 0);

    tokens = mCntSqlSearch->GetTokens("000000000000000000000000");
    QVERIFY(tokens.count() == 0);
        
    tokens = mCntSqlSearch->GetTokens("1");
    QVERIFY(tokens.count() == 1);
    QVERIFY(tokens.at(0) == "1");
    
    tokens = mCntSqlSearch->GetTokens("01");
    QVERIFY(tokens.count() == 1);
    QVERIFY(tokens.at(0) == "1");
    
    tokens = mCntSqlSearch->GetTokens("1");
    QVERIFY(tokens.count() == 1);
    QVERIFY(tokens.at(0) == "1");
    
    tokens = mCntSqlSearch->GetTokens("000028");
    QVERIFY(tokens.count() == 1);
    QVERIFY(tokens.at(0) == "28");
    
    tokens = mCntSqlSearch->GetTokens("000019700");
    QVERIFY(tokens.count() == 1);
    QVERIFY(tokens.at(0) == "197");

    tokens = mCntSqlSearch->GetTokens("101");
    QVERIFY(tokens.count() == 2);
    QVERIFY(tokens.at(0) == "1");
    QVERIFY(tokens.at(1) == "1");
    
    tokens = mCntSqlSearch->GetTokens("1203");
    QVERIFY(tokens.count() == 2);
    QVERIFY(tokens.at(0) == "12");
    QVERIFY(tokens.at(1) == "3");
    
    tokens = mCntSqlSearch->GetTokens("000012013");
    QVERIFY(tokens.count() == 2);
    QVERIFY(tokens.at(0) == "000012");
    QVERIFY(tokens.at(1) == "13");
    
    tokens = mCntSqlSearch->GetTokens("00206");
    QVERIFY(tokens.count() == 2);
    QVERIFY(tokens.at(0) == "002");
    QVERIFY(tokens.at(1) == "6");
    
    tokens = mCntSqlSearch->GetTokens("001230045067800900");
    QVERIFY(tokens.count() == 2);
    QVERIFY(tokens.at(0) == "00123");
    QVERIFY(tokens.at(1) == "45067800900");
    
    tokens = mCntSqlSearch->GetTokens("1000002030405060708090011");
    QVERIFY(tokens.count() == 2);
    QVERIFY(tokens.at(0) == "1");
    QVERIFY(tokens.at(1) == "2030405060708090011");
    
    tokens = mCntSqlSearch->GetTokens("4304");
    QVERIFY(tokens.count() == 2);
    QVERIFY(tokens.at(0) == "43");
    QVERIFY(tokens.at(1) == "4");
    
    tokens = mCntSqlSearch->GetTokens("010203040506070809011001200130014001500");
    QVERIFY(tokens.count() == 2);
    QVERIFY(tokens.at(0) == "01");
    QVERIFY(tokens.at(1) == "203040506070809011001200130014001500");

    TEST_PASSED_LOG("testGetTokens");
    }

#if defined(WRITE_LOGS)
void WriteLog(const QString a, const QString b)
    {
    TPtrC16 ptr(reinterpret_cast<const TUint16*>(a.utf16()));
    WritePart(ptr);
    
    if (b.size() > 0)
        {
        TPtrC16 ptr2(reinterpret_cast<const TUint16*>(b.utf16()));
        WritePart(ptr2);
        }
    }

void WritePart(const TDesC& s)
    {
    // RDebug::Print() only writes first 256 chars
    const TInt KMaxLength = 255;
        
    TInt pos(0);
    TInt len = s.Length();  
    while (pos < len)
        {
        TInt partLength = KMaxLength;
        if (pos + partLength > len)
            {
            partLength = len - pos;
            }
        TPtrC16 part = s.Mid(pos, partLength);
        RDebug::Print(part);
        pos += KMaxLength;
        }
    }
#endif // #if defined(WRITE_LOGS)


#ifdef SQL_QT_TEST
QTEST_MAIN(UT_CntSqlSearch)
#endif

