/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef JSConsole_h
#define JSConsole_h

#include "JSDOMBinding.h"
#include <runtime/JSGlobalObject.h>
#include <runtime/JSObjectWithGlobalObject.h>
#include <runtime/ObjectPrototype.h>

namespace WebCore {

class Console;

class JSConsole : public DOMObjectWithGlobalPointer {
    typedef DOMObjectWithGlobalPointer Base;
public:
    JSConsole(NonNullPassRefPtr<JSC::Structure>, JSDOMGlobalObject*, PassRefPtr<Console>);
    virtual ~JSConsole();
    static JSC::JSObject* createPrototype(JSC::ExecState*, JSC::JSGlobalObject*);
    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier& propertyName, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier& propertyName, JSC::PropertyDescriptor&);
    virtual const JSC::ClassInfo* classInfo() const { return &s_info; }
    static const JSC::ClassInfo s_info;

    static PassRefPtr<JSC::Structure> createStructure(JSC::JSValue prototype)
    {
        return JSC::Structure::create(prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), AnonymousSlotCount);
    }


    // Custom attributes
    JSC::JSValue profiles(JSC::ExecState*) const;
    Console* impl() const { return m_impl.get(); }

private:
    RefPtr<Console> m_impl;
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | Base::StructureFlags;
};

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject*, Console*);
Console* toConsole(JSC::JSValue);

class JSConsolePrototype : public JSC::JSObjectWithGlobalObject {
    typedef JSC::JSObjectWithGlobalObject Base;
public:
    static JSC::JSObject* self(JSC::ExecState*, JSC::JSGlobalObject*);
    virtual const JSC::ClassInfo* classInfo() const { return &s_info; }
    static const JSC::ClassInfo s_info;
    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static PassRefPtr<JSC::Structure> createStructure(JSC::JSValue prototype)
    {
        return JSC::Structure::create(prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), AnonymousSlotCount);
    }
    JSConsolePrototype(JSC::JSGlobalObject* globalObject, NonNullPassRefPtr<JSC::Structure> structure) : JSC::JSObjectWithGlobalObject(globalObject, structure) { }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | Base::StructureFlags;
};

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsConsolePrototypeFunctionDebug(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsConsolePrototypeFunctionError(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsConsolePrototypeFunctionInfo(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsConsolePrototypeFunctionLog(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsConsolePrototypeFunctionWarn(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsConsolePrototypeFunctionDir(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsConsolePrototypeFunctionDirxml(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsConsolePrototypeFunctionTrace(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsConsolePrototypeFunctionAssert(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsConsolePrototypeFunctionCount(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsConsolePrototypeFunctionMarkTimeline(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsConsolePrototypeFunctionProfile(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsConsolePrototypeFunctionProfileEnd(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsConsolePrototypeFunctionTime(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsConsolePrototypeFunctionTimeEnd(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsConsolePrototypeFunctionGroup(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsConsolePrototypeFunctionGroupCollapsed(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsConsolePrototypeFunctionGroupEnd(JSC::ExecState*);
// Attributes

JSC::JSValue jsConsoleProfiles(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsConsoleMemory(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);

} // namespace WebCore

#endif
