/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(NOTIFICATIONS)

#include "JSNotification.h"

#include "Event.h"
#include "EventListener.h"
#include "JSEvent.h"
#include "JSEventListener.h"
#include "KURL.h"
#include "Notification.h"
#include "RegisteredEventListener.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSNotification);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSNotificationTableValues[6] =
{
    { "ondisplay", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNotificationOndisplay), (intptr_t)setJSNotificationOndisplay THUNK_GENERATOR(0) },
    { "onerror", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNotificationOnerror), (intptr_t)setJSNotificationOnerror THUNK_GENERATOR(0) },
    { "onclose", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNotificationOnclose), (intptr_t)setJSNotificationOnclose THUNK_GENERATOR(0) },
    { "dir", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNotificationDir), (intptr_t)setJSNotificationDir THUNK_GENERATOR(0) },
    { "replaceId", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNotificationReplaceId), (intptr_t)setJSNotificationReplaceId THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSNotificationTable = { 17, 15, JSNotificationTableValues, 0 };
/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSNotificationPrototypeTableValues[6] =
{
    { "show", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsNotificationPrototypeFunctionShow), (intptr_t)0 THUNK_GENERATOR(0) },
    { "cancel", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsNotificationPrototypeFunctionCancel), (intptr_t)0 THUNK_GENERATOR(0) },
    { "addEventListener", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsNotificationPrototypeFunctionAddEventListener), (intptr_t)3 THUNK_GENERATOR(0) },
    { "removeEventListener", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsNotificationPrototypeFunctionRemoveEventListener), (intptr_t)3 THUNK_GENERATOR(0) },
    { "dispatchEvent", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsNotificationPrototypeFunctionDispatchEvent), (intptr_t)1 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSNotificationPrototypeTable = { 16, 15, JSNotificationPrototypeTableValues, 0 };
const ClassInfo JSNotificationPrototype::s_info = { "NotificationPrototype", 0, &JSNotificationPrototypeTable, 0 };

JSObject* JSNotificationPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSNotification>(exec, globalObject);
}

bool JSNotificationPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSNotificationPrototypeTable, this, propertyName, slot);
}

bool JSNotificationPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSNotificationPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSNotification::s_info = { "Notification", 0, &JSNotificationTable, 0 };

JSNotification::JSNotification(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<Notification> impl)
    : DOMObjectWithGlobalPointer(structure, globalObject)
    , m_impl(impl)
{
}

JSNotification::~JSNotification()
{
    impl()->invalidateJSEventListeners(this);
    forgetDOMObject(this, impl());
}

void JSNotification::markChildren(MarkStack& markStack)
{
    Base::markChildren(markStack);
    impl()->markJSEventListeners(markStack);
}

JSObject* JSNotification::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSNotificationPrototype(globalObject, JSNotificationPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSNotification::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSNotification, Base>(exec, &JSNotificationTable, this, propertyName, slot);
}

bool JSNotification::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSNotification, Base>(exec, &JSNotificationTable, this, propertyName, descriptor);
}

JSValue jsNotificationOndisplay(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSNotification* castedThis = static_cast<JSNotification*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Notification* imp = static_cast<Notification*>(castedThis->impl());
    if (EventListener* listener = imp->ondisplay()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsNotificationOnerror(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSNotification* castedThis = static_cast<JSNotification*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Notification* imp = static_cast<Notification*>(castedThis->impl());
    if (EventListener* listener = imp->onerror()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsNotificationOnclose(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSNotification* castedThis = static_cast<JSNotification*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Notification* imp = static_cast<Notification*>(castedThis->impl());
    if (EventListener* listener = imp->onclose()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsNotificationDir(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSNotification* castedThis = static_cast<JSNotification*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Notification* imp = static_cast<Notification*>(castedThis->impl());
    JSValue result = jsString(exec, imp->dir());
    return result;
}

JSValue jsNotificationReplaceId(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSNotification* castedThis = static_cast<JSNotification*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Notification* imp = static_cast<Notification*>(castedThis->impl());
    JSValue result = jsString(exec, imp->replaceId());
    return result;
}

void JSNotification::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSNotification, Base>(exec, propertyName, value, &JSNotificationTable, this, slot);
}

void setJSNotificationOndisplay(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Notification* imp = static_cast<Notification*>(static_cast<JSNotification*>(thisObject)->impl());
    imp->setOndisplay(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSNotificationOnerror(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Notification* imp = static_cast<Notification*>(static_cast<JSNotification*>(thisObject)->impl());
    imp->setOnerror(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSNotificationOnclose(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Notification* imp = static_cast<Notification*>(static_cast<JSNotification*>(thisObject)->impl());
    imp->setOnclose(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSNotificationDir(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSNotification* castedThis = static_cast<JSNotification*>(thisObject);
    Notification* imp = static_cast<Notification*>(castedThis->impl());
    imp->setDir(ustringToString(value.toString(exec)));
}

void setJSNotificationReplaceId(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSNotification* castedThis = static_cast<JSNotification*>(thisObject);
    Notification* imp = static_cast<Notification*>(castedThis->impl());
    imp->setReplaceId(ustringToString(value.toString(exec)));
}

EncodedJSValue JSC_HOST_CALL jsNotificationPrototypeFunctionShow(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSNotification::s_info))
        return throwVMTypeError(exec);
    JSNotification* castedThis = static_cast<JSNotification*>(asObject(thisValue));
    Notification* imp = static_cast<Notification*>(castedThis->impl());

    imp->show();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsNotificationPrototypeFunctionCancel(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSNotification::s_info))
        return throwVMTypeError(exec);
    JSNotification* castedThis = static_cast<JSNotification*>(asObject(thisValue));
    Notification* imp = static_cast<Notification*>(castedThis->impl());

    imp->cancel();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsNotificationPrototypeFunctionAddEventListener(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSNotification::s_info))
        return throwVMTypeError(exec);
    JSNotification* castedThis = static_cast<JSNotification*>(asObject(thisValue));
    Notification* imp = static_cast<Notification*>(castedThis->impl());
    JSValue listener = exec->argument(1);
    if (!listener.isObject())
        return JSValue::encode(jsUndefined());
    imp->addEventListener(ustringToAtomicString(exec->argument(0).toString(exec)), JSEventListener::create(asObject(listener), castedThis, false, currentWorld(exec)), exec->argument(2).toBoolean(exec));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsNotificationPrototypeFunctionRemoveEventListener(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSNotification::s_info))
        return throwVMTypeError(exec);
    JSNotification* castedThis = static_cast<JSNotification*>(asObject(thisValue));
    Notification* imp = static_cast<Notification*>(castedThis->impl());
    JSValue listener = exec->argument(1);
    if (!listener.isObject())
        return JSValue::encode(jsUndefined());
    imp->removeEventListener(ustringToAtomicString(exec->argument(0).toString(exec)), JSEventListener::create(asObject(listener), castedThis, false, currentWorld(exec)).get(), exec->argument(2).toBoolean(exec));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsNotificationPrototypeFunctionDispatchEvent(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSNotification::s_info))
        return throwVMTypeError(exec);
    JSNotification* castedThis = static_cast<JSNotification*>(asObject(thisValue));
    Notification* imp = static_cast<Notification*>(castedThis->impl());
    ExceptionCode ec = 0;
    Event* evt = toEvent(exec->argument(0));


    JSC::JSValue result = jsBoolean(imp->dispatchEvent(evt, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, Notification* object)
{
    return getDOMObjectWrapper<JSNotification>(exec, globalObject, object);
}
Notification* toNotification(JSC::JSValue value)
{
    return value.inherits(&JSNotification::s_info) ? static_cast<JSNotification*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(NOTIFICATIONS)
