/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(DATABASE)

#include "JSDatabaseSync.h"

#include "DatabaseSync.h"
#include "KURL.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSDatabaseSync);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSDatabaseSyncTableValues[2] =
{
    { "version", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDatabaseSyncVersion), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSDatabaseSyncTable = { 2, 1, JSDatabaseSyncTableValues, 0 };
/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSDatabaseSyncPrototypeTableValues[4] =
{
    { "changeVersion", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDatabaseSyncPrototypeFunctionChangeVersion), (intptr_t)3 THUNK_GENERATOR(0) },
    { "transaction", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDatabaseSyncPrototypeFunctionTransaction), (intptr_t)1 THUNK_GENERATOR(0) },
    { "readTransaction", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDatabaseSyncPrototypeFunctionReadTransaction), (intptr_t)1 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSDatabaseSyncPrototypeTable = { 8, 7, JSDatabaseSyncPrototypeTableValues, 0 };
static const HashTable* getJSDatabaseSyncPrototypeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSDatabaseSyncPrototypeTable);
}
const ClassInfo JSDatabaseSyncPrototype::s_info = { "DatabaseSyncPrototype", 0, 0, getJSDatabaseSyncPrototypeTable };

JSObject* JSDatabaseSyncPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSDatabaseSync>(exec, globalObject);
}

bool JSDatabaseSyncPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, getJSDatabaseSyncPrototypeTable(exec), this, propertyName, slot);
}

bool JSDatabaseSyncPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, getJSDatabaseSyncPrototypeTable(exec), this, propertyName, descriptor);
}

static const HashTable* getJSDatabaseSyncTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSDatabaseSyncTable);
}
const ClassInfo JSDatabaseSync::s_info = { "DatabaseSync", 0, 0, getJSDatabaseSyncTable };

JSDatabaseSync::JSDatabaseSync(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<DatabaseSync> impl)
    : DOMObjectWithGlobalPointer(structure, globalObject)
    , m_impl(impl)
{
}

JSDatabaseSync::~JSDatabaseSync()
{
    forgetDOMObject(this, impl());
}

JSObject* JSDatabaseSync::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSDatabaseSyncPrototype(globalObject, JSDatabaseSyncPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSDatabaseSync::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSDatabaseSync, Base>(exec, getJSDatabaseSyncTable(exec), this, propertyName, slot);
}

bool JSDatabaseSync::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSDatabaseSync, Base>(exec, getJSDatabaseSyncTable(exec), this, propertyName, descriptor);
}

JSValue jsDatabaseSyncVersion(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDatabaseSync* castedThis = static_cast<JSDatabaseSync*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    DatabaseSync* imp = static_cast<DatabaseSync*>(castedThis->impl());
    JSValue result = jsString(exec, imp->version());
    return result;
}

EncodedJSValue JSC_HOST_CALL jsDatabaseSyncPrototypeFunctionChangeVersion(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDatabaseSync::s_info))
        return throwVMTypeError(exec);
    JSDatabaseSync* castedThis = static_cast<JSDatabaseSync*>(asObject(thisValue));
    return JSValue::encode(castedThis->changeVersion(exec));
}

EncodedJSValue JSC_HOST_CALL jsDatabaseSyncPrototypeFunctionTransaction(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDatabaseSync::s_info))
        return throwVMTypeError(exec);
    JSDatabaseSync* castedThis = static_cast<JSDatabaseSync*>(asObject(thisValue));
    return JSValue::encode(castedThis->transaction(exec));
}

EncodedJSValue JSC_HOST_CALL jsDatabaseSyncPrototypeFunctionReadTransaction(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDatabaseSync::s_info))
        return throwVMTypeError(exec);
    JSDatabaseSync* castedThis = static_cast<JSDatabaseSync*>(asObject(thisValue));
    return JSValue::encode(castedThis->readTransaction(exec));
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, DatabaseSync* object)
{
    return getDOMObjectWrapper<JSDatabaseSync>(exec, globalObject, object);
}
DatabaseSync* toDatabaseSync(JSC::JSValue value)
{
    return value.inherits(&JSDatabaseSync::s_info) ? static_cast<JSDatabaseSync*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(DATABASE)
