/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(INSPECTOR)

#include "JSInspectorBackend.h"

#include "InspectorBackend.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSInspectorBackend);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSInspectorBackendTableValues[2] =
{
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsInspectorBackendConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSInspectorBackendTable = { 2, 1, JSInspectorBackendTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSInspectorBackendConstructorTableValues[1] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSInspectorBackendConstructorTable = { 1, 0, JSInspectorBackendConstructorTableValues, 0 };
class JSInspectorBackendConstructor : public DOMConstructorObject {
public:
    JSInspectorBackendConstructor(JSC::ExecState*, JSDOMGlobalObject*);

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    virtual const JSC::ClassInfo* classInfo() const { return &s_info; }
    static const JSC::ClassInfo s_info;
    static PassRefPtr<JSC::Structure> createStructure(JSC::JSValue prototype)
    {
        return JSC::Structure::create(prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), AnonymousSlotCount);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSInspectorBackendConstructor::s_info = { "InspectorBackendConstructor", 0, &JSInspectorBackendConstructorTable, 0 };

JSInspectorBackendConstructor::JSInspectorBackendConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(JSInspectorBackendConstructor::createStructure(globalObject->objectPrototype()), globalObject)
{
    putDirect(exec->propertyNames().prototype, JSInspectorBackendPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSInspectorBackendConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSInspectorBackendConstructor, DOMObject>(exec, &JSInspectorBackendConstructorTable, this, propertyName, slot);
}

bool JSInspectorBackendConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSInspectorBackendConstructor, DOMObject>(exec, &JSInspectorBackendConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSInspectorBackendPrototypeTableValues[79] =
{
    { "storeLastActivePanel", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionStoreLastActivePanel), (intptr_t)1 THUNK_GENERATOR(0) },
    { "saveApplicationSettings", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionSaveApplicationSettings), (intptr_t)1 THUNK_GENERATOR(0) },
    { "saveSessionSettings", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionSaveSessionSettings), (intptr_t)1 THUNK_GENERATOR(0) },
    { "enableSearchingForNode", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionEnableSearchingForNode), (intptr_t)0 THUNK_GENERATOR(0) },
    { "disableSearchingForNode", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionDisableSearchingForNode), (intptr_t)0 THUNK_GENERATOR(0) },
    { "enableMonitoringXHR", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionEnableMonitoringXHR), (intptr_t)0 THUNK_GENERATOR(0) },
    { "disableMonitoringXHR", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionDisableMonitoringXHR), (intptr_t)0 THUNK_GENERATOR(0) },
    { "enableResourceTracking", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionEnableResourceTracking), (intptr_t)1 THUNK_GENERATOR(0) },
    { "disableResourceTracking", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionDisableResourceTracking), (intptr_t)1 THUNK_GENERATOR(0) },
    { "getResourceContent", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionGetResourceContent), (intptr_t)2 THUNK_GENERATOR(0) },
    { "reloadPage", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionReloadPage), (intptr_t)0 THUNK_GENERATOR(0) },
    { "startTimelineProfiler", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionStartTimelineProfiler), (intptr_t)0 THUNK_GENERATOR(0) },
    { "stopTimelineProfiler", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionStopTimelineProfiler), (intptr_t)0 THUNK_GENERATOR(0) },
    { "enableDebugger", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionEnableDebugger), (intptr_t)1 THUNK_GENERATOR(0) },
    { "disableDebugger", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionDisableDebugger), (intptr_t)1 THUNK_GENERATOR(0) },
    { "setBreakpoint", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionSetBreakpoint), (intptr_t)5 THUNK_GENERATOR(0) },
    { "removeBreakpoint", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionRemoveBreakpoint), (intptr_t)2 THUNK_GENERATOR(0) },
    { "activateBreakpoints", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionActivateBreakpoints), (intptr_t)0 THUNK_GENERATOR(0) },
    { "deactivateBreakpoints", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionDeactivateBreakpoints), (intptr_t)0 THUNK_GENERATOR(0) },
    { "pause", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionPause), (intptr_t)0 THUNK_GENERATOR(0) },
    { "resume", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionResume), (intptr_t)0 THUNK_GENERATOR(0) },
    { "stepOverStatement", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionStepOverStatement), (intptr_t)0 THUNK_GENERATOR(0) },
    { "stepIntoStatement", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionStepIntoStatement), (intptr_t)0 THUNK_GENERATOR(0) },
    { "stepOutOfFunction", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionStepOutOfFunction), (intptr_t)0 THUNK_GENERATOR(0) },
    { "setPauseOnExceptionsState", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionSetPauseOnExceptionsState), (intptr_t)1 THUNK_GENERATOR(0) },
    { "editScriptSource", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionEditScriptSource), (intptr_t)3 THUNK_GENERATOR(0) },
    { "getScriptSource", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionGetScriptSource), (intptr_t)2 THUNK_GENERATOR(0) },
    { "enableProfiler", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionEnableProfiler), (intptr_t)1 THUNK_GENERATOR(0) },
    { "disableProfiler", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionDisableProfiler), (intptr_t)1 THUNK_GENERATOR(0) },
    { "startProfiling", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionStartProfiling), (intptr_t)0 THUNK_GENERATOR(0) },
    { "stopProfiling", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionStopProfiling), (intptr_t)0 THUNK_GENERATOR(0) },
    { "getProfileHeaders", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionGetProfileHeaders), (intptr_t)1 THUNK_GENERATOR(0) },
    { "getProfile", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionGetProfile), (intptr_t)2 THUNK_GENERATOR(0) },
    { "removeProfile", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionRemoveProfile), (intptr_t)1 THUNK_GENERATOR(0) },
    { "clearProfiles", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionClearProfiles), (intptr_t)0 THUNK_GENERATOR(0) },
    { "takeHeapSnapshot", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionTakeHeapSnapshot), (intptr_t)0 THUNK_GENERATOR(0) },
    { "setInjectedScriptSource", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionSetInjectedScriptSource), (intptr_t)1 THUNK_GENERATOR(0) },
    { "dispatchOnInjectedScript", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionDispatchOnInjectedScript), (intptr_t)5 THUNK_GENERATOR(0) },
    { "addScriptToEvaluateOnLoad", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionAddScriptToEvaluateOnLoad), (intptr_t)1 THUNK_GENERATOR(0) },
    { "removeAllScriptsToEvaluateOnLoad", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionRemoveAllScriptsToEvaluateOnLoad), (intptr_t)0 THUNK_GENERATOR(0) },
    { "getChildNodes", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionGetChildNodes), (intptr_t)2 THUNK_GENERATOR(0) },
    { "setAttribute", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionSetAttribute), (intptr_t)4 THUNK_GENERATOR(0) },
    { "removeAttribute", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionRemoveAttribute), (intptr_t)3 THUNK_GENERATOR(0) },
    { "setTextNodeValue", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionSetTextNodeValue), (intptr_t)3 THUNK_GENERATOR(0) },
    { "getEventListenersForNode", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionGetEventListenersForNode), (intptr_t)2 THUNK_GENERATOR(0) },
    { "copyNode", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionCopyNode), (intptr_t)1 THUNK_GENERATOR(0) },
    { "removeNode", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionRemoveNode), (intptr_t)2 THUNK_GENERATOR(0) },
    { "changeTagName", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionChangeTagName), (intptr_t)3 THUNK_GENERATOR(0) },
    { "getOuterHTML", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionGetOuterHTML), (intptr_t)2 THUNK_GENERATOR(0) },
    { "setOuterHTML", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionSetOuterHTML), (intptr_t)3 THUNK_GENERATOR(0) },
    { "addInspectedNode", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionAddInspectedNode), (intptr_t)1 THUNK_GENERATOR(0) },
    { "performSearch", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionPerformSearch), (intptr_t)2 THUNK_GENERATOR(0) },
    { "searchCanceled", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionSearchCanceled), (intptr_t)0 THUNK_GENERATOR(0) },
    { "pushNodeByPathToFrontend", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionPushNodeByPathToFrontend), (intptr_t)2 THUNK_GENERATOR(0) },
    { "clearConsoleMessages", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionClearConsoleMessages), (intptr_t)0 THUNK_GENERATOR(0) },
    { "highlightDOMNode", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionHighlightDOMNode), (intptr_t)1 THUNK_GENERATOR(0) },
    { "hideDOMNodeHighlight", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionHideDOMNodeHighlight), (intptr_t)0 THUNK_GENERATOR(0) },
    { "getStyles", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionGetStyles), (intptr_t)3 THUNK_GENERATOR(0) },
    { "getAllStyles", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionGetAllStyles), (intptr_t)1 THUNK_GENERATOR(0) },
    { "getInlineStyle", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionGetInlineStyle), (intptr_t)2 THUNK_GENERATOR(0) },
    { "getComputedStyle", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionGetComputedStyle), (intptr_t)2 THUNK_GENERATOR(0) },
    { "getStyleSheet", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionGetStyleSheet), (intptr_t)2 THUNK_GENERATOR(0) },
    { "getRuleRangesForStyleSheetId", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionGetRuleRangesForStyleSheetId), (intptr_t)2 THUNK_GENERATOR(0) },
    { "applyStyleText", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionApplyStyleText), (intptr_t)4 THUNK_GENERATOR(0) },
    { "setStyleText", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionSetStyleText), (intptr_t)3 THUNK_GENERATOR(0) },
    { "setStyleProperty", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionSetStyleProperty), (intptr_t)4 THUNK_GENERATOR(0) },
    { "toggleStyleEnabled", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionToggleStyleEnabled), (intptr_t)4 THUNK_GENERATOR(0) },
    { "setRuleSelector", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionSetRuleSelector), (intptr_t)4 THUNK_GENERATOR(0) },
    { "addRule", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionAddRule), (intptr_t)3 THUNK_GENERATOR(0) },
    { "getCookies", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionGetCookies), (intptr_t)1 THUNK_GENERATOR(0) },
    { "deleteCookie", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionDeleteCookie), (intptr_t)2 THUNK_GENERATOR(0) },
    { "getApplicationCaches", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionGetApplicationCaches), (intptr_t)1 THUNK_GENERATOR(0) },
    { "releaseWrapperObjectGroup", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionReleaseWrapperObjectGroup), (intptr_t)2 THUNK_GENERATOR(0) },
    { "didEvaluateForTestInFrontend", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionDidEvaluateForTestInFrontend), (intptr_t)2 THUNK_GENERATOR(0) },
    { "getDatabaseTableNames", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionGetDatabaseTableNames), (intptr_t)2 THUNK_GENERATOR(0) },
    { "getDOMStorageEntries", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionGetDOMStorageEntries), (intptr_t)2 THUNK_GENERATOR(0) },
    { "setDOMStorageItem", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionSetDOMStorageItem), (intptr_t)4 THUNK_GENERATOR(0) },
    { "removeDOMStorageItem", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInspectorBackendPrototypeFunctionRemoveDOMStorageItem), (intptr_t)3 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSInspectorBackendPrototypeTable = { 263, 255, JSInspectorBackendPrototypeTableValues, 0 };
const ClassInfo JSInspectorBackendPrototype::s_info = { "InspectorBackendPrototype", 0, &JSInspectorBackendPrototypeTable, 0 };

JSObject* JSInspectorBackendPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSInspectorBackend>(exec, globalObject);
}

bool JSInspectorBackendPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSInspectorBackendPrototypeTable, this, propertyName, slot);
}

bool JSInspectorBackendPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSInspectorBackendPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSInspectorBackend::s_info = { "InspectorBackend", 0, &JSInspectorBackendTable, 0 };

JSInspectorBackend::JSInspectorBackend(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<InspectorBackend> impl)
    : DOMObjectWithGlobalPointer(structure, globalObject)
    , m_impl(impl)
{
}

JSInspectorBackend::~JSInspectorBackend()
{
    forgetDOMObject(this, impl());
}

JSObject* JSInspectorBackend::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSInspectorBackendPrototype(globalObject, JSInspectorBackendPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSInspectorBackend::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSInspectorBackend, Base>(exec, &JSInspectorBackendTable, this, propertyName, slot);
}

bool JSInspectorBackend::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSInspectorBackend, Base>(exec, &JSInspectorBackendTable, this, propertyName, descriptor);
}

JSValue jsInspectorBackendConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSInspectorBackend* domObject = static_cast<JSInspectorBackend*>(asObject(slotBase));
    return JSInspectorBackend::getConstructor(exec, domObject->globalObject());
}
JSValue JSInspectorBackend::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSInspectorBackendConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionStoreLastActivePanel(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());
    const String& panelName = ustringToString(exec->argument(0).toString(exec));

    imp->storeLastActivePanel(panelName);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionSaveApplicationSettings(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());
    const String& settings = ustringToString(exec->argument(0).toString(exec));

    imp->saveApplicationSettings(settings);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionSaveSessionSettings(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());
    const String& settings = ustringToString(exec->argument(0).toString(exec));

    imp->saveSessionSettings(settings);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionEnableSearchingForNode(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());

    imp->enableSearchingForNode();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionDisableSearchingForNode(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());

    imp->disableSearchingForNode();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionEnableMonitoringXHR(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());

    imp->enableMonitoringXHR();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionDisableMonitoringXHR(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());

    imp->disableMonitoringXHR();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionEnableResourceTracking(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());
    bool always = exec->argument(0).toBoolean(exec);

    imp->enableResourceTracking(always);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionDisableResourceTracking(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());
    bool always = exec->argument(0).toBoolean(exec);

    imp->disableResourceTracking(always);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionGetResourceContent(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());
    int callId = exec->argument(0).toInt32(exec);
    unsigned identifier = exec->argument(1).toInt32(exec);

    imp->getResourceContent(callId, identifier);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionReloadPage(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());

    imp->reloadPage();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionStartTimelineProfiler(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());

    imp->startTimelineProfiler();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionStopTimelineProfiler(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());

    imp->stopTimelineProfiler();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionEnableDebugger(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());
    bool always = exec->argument(0).toBoolean(exec);

    imp->enableDebugger(always);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionDisableDebugger(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());
    bool always = exec->argument(0).toBoolean(exec);

    imp->disableDebugger(always);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionSetBreakpoint(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());
    int callId = exec->argument(0).toInt32(exec);
    const String& sourceID = ustringToString(exec->argument(1).toString(exec));
    unsigned lineNumber = exec->argument(2).toInt32(exec);
    bool enabled = exec->argument(3).toBoolean(exec);
    const String& condition = ustringToString(exec->argument(4).toString(exec));

    imp->setBreakpoint(callId, sourceID, lineNumber, enabled, condition);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionRemoveBreakpoint(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());
    const String& sourceID = ustringToString(exec->argument(0).toString(exec));
    unsigned lineNumber = exec->argument(1).toInt32(exec);

    imp->removeBreakpoint(sourceID, lineNumber);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionActivateBreakpoints(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());

    imp->activateBreakpoints();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionDeactivateBreakpoints(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());

    imp->deactivateBreakpoints();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionPause(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());

    imp->pause();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionResume(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());

    imp->resume();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionStepOverStatement(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());

    imp->stepOverStatement();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionStepIntoStatement(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());

    imp->stepIntoStatement();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionStepOutOfFunction(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());

    imp->stepOutOfFunction();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionSetPauseOnExceptionsState(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());
    int pauseOnExceptionsState = exec->argument(0).toInt32(exec);

    imp->setPauseOnExceptionsState(pauseOnExceptionsState);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionEditScriptSource(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());
    int callId = exec->argument(0).toInt32(exec);
    const String& sourceID = ustringToString(exec->argument(1).toString(exec));
    const String& newContent = ustringToString(exec->argument(2).toString(exec));

    imp->editScriptSource(callId, sourceID, newContent);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionGetScriptSource(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());
    int callId = exec->argument(0).toInt32(exec);
    const String& sourceID = ustringToString(exec->argument(1).toString(exec));

    imp->getScriptSource(callId, sourceID);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionEnableProfiler(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());
    bool always = exec->argument(0).toBoolean(exec);

    imp->enableProfiler(always);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionDisableProfiler(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());
    bool always = exec->argument(0).toBoolean(exec);

    imp->disableProfiler(always);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionStartProfiling(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());

    imp->startProfiling();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionStopProfiling(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());

    imp->stopProfiling();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionGetProfileHeaders(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());
    int callId = exec->argument(0).toInt32(exec);

    imp->getProfileHeaders(callId);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionGetProfile(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());
    int callId = exec->argument(0).toInt32(exec);
    unsigned uid = exec->argument(1).toInt32(exec);

    imp->getProfile(callId, uid);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionRemoveProfile(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());
    unsigned uid = exec->argument(0).toInt32(exec);

    imp->removeProfile(uid);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionClearProfiles(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());

    imp->clearProfiles();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionTakeHeapSnapshot(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());

    imp->takeHeapSnapshot();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionSetInjectedScriptSource(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());
    const String& scriptSource = ustringToString(exec->argument(0).toString(exec));

    imp->setInjectedScriptSource(scriptSource);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionDispatchOnInjectedScript(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());
    int callId = exec->argument(0).toInt32(exec);
    int injectedScriptId = exec->argument(1).toInt32(exec);
    const String& methodName = ustringToString(exec->argument(2).toString(exec));
    const String& arguments = ustringToString(exec->argument(3).toString(exec));
    bool async = exec->argument(4).toBoolean(exec);

    imp->dispatchOnInjectedScript(callId, injectedScriptId, methodName, arguments, async);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionAddScriptToEvaluateOnLoad(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());
    const String& scriptSource = ustringToString(exec->argument(0).toString(exec));

    imp->addScriptToEvaluateOnLoad(scriptSource);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionRemoveAllScriptsToEvaluateOnLoad(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());

    imp->removeAllScriptsToEvaluateOnLoad();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionGetChildNodes(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());
    int callId = exec->argument(0).toInt32(exec);
    int nodeId = exec->argument(1).toInt32(exec);

    imp->getChildNodes(callId, nodeId);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionSetAttribute(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());
    int callId = exec->argument(0).toInt32(exec);
    int elementId = exec->argument(1).toInt32(exec);
    const String& name = ustringToString(exec->argument(2).toString(exec));
    const String& value = ustringToString(exec->argument(3).toString(exec));

    imp->setAttribute(callId, elementId, name, value);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionRemoveAttribute(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());
    int callId = exec->argument(0).toInt32(exec);
    int elementId = exec->argument(1).toInt32(exec);
    const String& name = ustringToString(exec->argument(2).toString(exec));

    imp->removeAttribute(callId, elementId, name);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionSetTextNodeValue(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());
    int callId = exec->argument(0).toInt32(exec);
    int nodeId = exec->argument(1).toInt32(exec);
    const String& value = ustringToString(exec->argument(2).toString(exec));

    imp->setTextNodeValue(callId, nodeId, value);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionGetEventListenersForNode(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());
    int callId = exec->argument(0).toInt32(exec);
    int nodeId = exec->argument(1).toInt32(exec);

    imp->getEventListenersForNode(callId, nodeId);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionCopyNode(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());
    int nodeId = exec->argument(0).toInt32(exec);

    imp->copyNode(nodeId);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionRemoveNode(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());
    int callId = exec->argument(0).toInt32(exec);
    int nodeId = exec->argument(1).toInt32(exec);

    imp->removeNode(callId, nodeId);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionChangeTagName(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());
    int callId = exec->argument(0).toInt32(exec);
    int nodeId = exec->argument(1).toInt32(exec);
    const String& newTagName = ustringToString(exec->argument(2).toString(exec));

    imp->changeTagName(callId, nodeId, newTagName);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionGetOuterHTML(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());
    int callId = exec->argument(0).toInt32(exec);
    int nodeId = exec->argument(1).toInt32(exec);

    imp->getOuterHTML(callId, nodeId);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionSetOuterHTML(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());
    int callId = exec->argument(0).toInt32(exec);
    int nodeId = exec->argument(1).toInt32(exec);
    const String& outerHTML = ustringToString(exec->argument(2).toString(exec));

    imp->setOuterHTML(callId, nodeId, outerHTML);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionAddInspectedNode(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());
    int nodeId = exec->argument(0).toInt32(exec);

    imp->addInspectedNode(nodeId);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionPerformSearch(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());
    const String& query = ustringToString(exec->argument(0).toString(exec));
    bool runSynchronously = exec->argument(1).toBoolean(exec);

    imp->performSearch(query, runSynchronously);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionSearchCanceled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());

    imp->searchCanceled();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionPushNodeByPathToFrontend(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());
    int callId = exec->argument(0).toInt32(exec);
    const String& path = ustringToString(exec->argument(1).toString(exec));

    imp->pushNodeByPathToFrontend(callId, path);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionClearConsoleMessages(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());

    imp->clearConsoleMessages();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionHighlightDOMNode(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());
    int nodeId = exec->argument(0).toInt32(exec);

    imp->highlightDOMNode(nodeId);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionHideDOMNodeHighlight(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());

    imp->hideDOMNodeHighlight();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionGetStyles(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());
    int callId = exec->argument(0).toInt32(exec);
    int nodeId = exec->argument(1).toInt32(exec);
    bool authOnly = exec->argument(2).toBoolean(exec);

    imp->getStyles(callId, nodeId, authOnly);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionGetAllStyles(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());
    int callId = exec->argument(0).toInt32(exec);

    imp->getAllStyles(callId);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionGetInlineStyle(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());
    int callId = exec->argument(0).toInt32(exec);
    int nodeId = exec->argument(1).toInt32(exec);

    imp->getInlineStyle(callId, nodeId);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionGetComputedStyle(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());
    int callId = exec->argument(0).toInt32(exec);
    int nodeId = exec->argument(1).toInt32(exec);

    imp->getComputedStyle(callId, nodeId);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionGetStyleSheet(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());
    int callId = exec->argument(0).toInt32(exec);
    int styleSheetId = exec->argument(1).toInt32(exec);

    imp->getStyleSheet(callId, styleSheetId);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionGetRuleRangesForStyleSheetId(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());
    int callId = exec->argument(0).toInt32(exec);
    int styleSheetId = exec->argument(1).toInt32(exec);

    imp->getRuleRangesForStyleSheetId(callId, styleSheetId);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionApplyStyleText(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());
    int callId = exec->argument(0).toInt32(exec);
    int styleId = exec->argument(1).toInt32(exec);
    const String& styleText = ustringToString(exec->argument(2).toString(exec));
    const String& propertyName = ustringToString(exec->argument(3).toString(exec));

    imp->applyStyleText(callId, styleId, styleText, propertyName);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionSetStyleText(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());
    int callId = exec->argument(0).toInt32(exec);
    int styleId = exec->argument(1).toInt32(exec);
    const String& styleText = ustringToString(exec->argument(2).toString(exec));

    imp->setStyleText(callId, styleId, styleText);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionSetStyleProperty(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());
    int callId = exec->argument(0).toInt32(exec);
    int styleId = exec->argument(1).toInt32(exec);
    const String& name = ustringToString(exec->argument(2).toString(exec));
    const String& value = ustringToString(exec->argument(3).toString(exec));

    imp->setStyleProperty(callId, styleId, name, value);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionToggleStyleEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());
    int callId = exec->argument(0).toInt32(exec);
    int styleId = exec->argument(1).toInt32(exec);
    const String& propertyName = ustringToString(exec->argument(2).toString(exec));
    bool disabled = exec->argument(3).toBoolean(exec);

    imp->toggleStyleEnabled(callId, styleId, propertyName, disabled);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionSetRuleSelector(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());
    int callId = exec->argument(0).toInt32(exec);
    int ruleId = exec->argument(1).toInt32(exec);
    const String& selector = ustringToString(exec->argument(2).toString(exec));
    int selectedNodeId = exec->argument(3).toInt32(exec);

    imp->setRuleSelector(callId, ruleId, selector, selectedNodeId);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionAddRule(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());
    int callId = exec->argument(0).toInt32(exec);
    const String& selector = ustringToString(exec->argument(1).toString(exec));
    int selectedNodeId = exec->argument(2).toInt32(exec);

    imp->addRule(callId, selector, selectedNodeId);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionGetCookies(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());
    int callId = exec->argument(0).toInt32(exec);

    imp->getCookies(callId);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionDeleteCookie(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());
    const String& cookieName = ustringToString(exec->argument(0).toString(exec));
    const String& domain = ustringToString(exec->argument(1).toString(exec));

    imp->deleteCookie(cookieName, domain);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionGetApplicationCaches(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());
    int callId = exec->argument(0).toInt32(exec);

    imp->getApplicationCaches(callId);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionReleaseWrapperObjectGroup(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());
    int injectedScriptId = exec->argument(0).toInt32(exec);
    const String& objectGroup = ustringToString(exec->argument(1).toString(exec));

    imp->releaseWrapperObjectGroup(injectedScriptId, objectGroup);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionDidEvaluateForTestInFrontend(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());
    int callId = exec->argument(0).toInt32(exec);
    const String& jsonResult = ustringToString(exec->argument(1).toString(exec));

    imp->didEvaluateForTestInFrontend(callId, jsonResult);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionGetDatabaseTableNames(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());
    int callId = exec->argument(0).toInt32(exec);
    int databaseId = exec->argument(1).toInt32(exec);

    imp->getDatabaseTableNames(callId, databaseId);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionGetDOMStorageEntries(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());
    int callId = exec->argument(0).toInt32(exec);
    int storageId = exec->argument(1).toInt32(exec);

    imp->getDOMStorageEntries(callId, storageId);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionSetDOMStorageItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());
    int callId = exec->argument(0).toInt32(exec);
    int storageId = exec->argument(1).toInt32(exec);
    const String& key = ustringToString(exec->argument(2).toString(exec));
    const String& value = ustringToString(exec->argument(3).toString(exec));

    imp->setDOMStorageItem(callId, storageId, key, value);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionRemoveDOMStorageItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwVMTypeError(exec);
    JSInspectorBackend* castedThis = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThis->impl());
    int callId = exec->argument(0).toInt32(exec);
    int storageId = exec->argument(1).toInt32(exec);
    const String& key = ustringToString(exec->argument(2).toString(exec));

    imp->removeDOMStorageItem(callId, storageId, key);
    return JSValue::encode(jsUndefined());
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, InspectorBackend* object)
{
    return getDOMObjectWrapper<JSInspectorBackend>(exec, globalObject, object);
}
InspectorBackend* toInspectorBackend(JSC::JSValue value)
{
    return value.inherits(&JSInspectorBackend::s_info) ? static_cast<JSInspectorBackend*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(INSPECTOR)
