/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCSSStyleDeclaration.h"

#include "AtomicString.h"
#include "CSSRule.h"
#include "CSSStyleDeclaration.h"
#include "CSSValue.h"
#include "JSCSSRule.h"
#include "JSCSSStyleDeclarationCustom.h"
#include "JSCSSValue.h"
#include "KURL.h"
#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>
#include <runtime/JSString.h>
#include <runtime/PropertyNameArray.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSCSSStyleDeclaration);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSCSSStyleDeclarationTableValues[5] =
{
    { "cssText", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSStyleDeclarationCssText), (intptr_t)setJSCSSStyleDeclarationCssText THUNK_GENERATOR(0) },
    { "length", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSStyleDeclarationLength), (intptr_t)0 THUNK_GENERATOR(0) },
    { "parentRule", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSStyleDeclarationParentRule), (intptr_t)0 THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSStyleDeclarationConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSCSSStyleDeclarationTable = { 10, 7, JSCSSStyleDeclarationTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSCSSStyleDeclarationConstructorTableValues[1] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSCSSStyleDeclarationConstructorTable = { 1, 0, JSCSSStyleDeclarationConstructorTableValues, 0 };
class JSCSSStyleDeclarationConstructor : public DOMConstructorObject {
public:
    JSCSSStyleDeclarationConstructor(JSC::ExecState*, JSDOMGlobalObject*);

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    virtual const JSC::ClassInfo* classInfo() const { return &s_info; }
    static const JSC::ClassInfo s_info;
    static PassRefPtr<JSC::Structure> createStructure(JSC::JSValue prototype)
    {
        return JSC::Structure::create(prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), AnonymousSlotCount);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSCSSStyleDeclarationConstructor::s_info = { "CSSStyleDeclarationConstructor", 0, &JSCSSStyleDeclarationConstructorTable, 0 };

JSCSSStyleDeclarationConstructor::JSCSSStyleDeclarationConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(JSCSSStyleDeclarationConstructor::createStructure(globalObject->objectPrototype()), globalObject)
{
    putDirect(exec->propertyNames().prototype, JSCSSStyleDeclarationPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSCSSStyleDeclarationConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCSSStyleDeclarationConstructor, DOMObject>(exec, &JSCSSStyleDeclarationConstructorTable, this, propertyName, slot);
}

bool JSCSSStyleDeclarationConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSCSSStyleDeclarationConstructor, DOMObject>(exec, &JSCSSStyleDeclarationConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSCSSStyleDeclarationPrototypeTableValues[9] =
{
    { "getPropertyValue", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsCSSStyleDeclarationPrototypeFunctionGetPropertyValue), (intptr_t)1 THUNK_GENERATOR(0) },
    { "getPropertyCSSValue", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsCSSStyleDeclarationPrototypeFunctionGetPropertyCSSValue), (intptr_t)1 THUNK_GENERATOR(0) },
    { "removeProperty", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsCSSStyleDeclarationPrototypeFunctionRemoveProperty), (intptr_t)1 THUNK_GENERATOR(0) },
    { "getPropertyPriority", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsCSSStyleDeclarationPrototypeFunctionGetPropertyPriority), (intptr_t)1 THUNK_GENERATOR(0) },
    { "setProperty", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsCSSStyleDeclarationPrototypeFunctionSetProperty), (intptr_t)3 THUNK_GENERATOR(0) },
    { "item", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsCSSStyleDeclarationPrototypeFunctionItem), (intptr_t)1 THUNK_GENERATOR(0) },
    { "getPropertyShorthand", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsCSSStyleDeclarationPrototypeFunctionGetPropertyShorthand), (intptr_t)1 THUNK_GENERATOR(0) },
    { "isPropertyImplicit", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsCSSStyleDeclarationPrototypeFunctionIsPropertyImplicit), (intptr_t)1 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSCSSStyleDeclarationPrototypeTable = { 17, 15, JSCSSStyleDeclarationPrototypeTableValues, 0 };
const ClassInfo JSCSSStyleDeclarationPrototype::s_info = { "CSSStyleDeclarationPrototype", 0, &JSCSSStyleDeclarationPrototypeTable, 0 };

JSObject* JSCSSStyleDeclarationPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSCSSStyleDeclaration>(exec, globalObject);
}

bool JSCSSStyleDeclarationPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSCSSStyleDeclarationPrototypeTable, this, propertyName, slot);
}

bool JSCSSStyleDeclarationPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSCSSStyleDeclarationPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSCSSStyleDeclaration::s_info = { "CSSStyleDeclaration", 0, &JSCSSStyleDeclarationTable, 0 };

JSCSSStyleDeclaration::JSCSSStyleDeclaration(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<CSSStyleDeclaration> impl)
    : DOMObjectWithGlobalPointer(structure, globalObject)
    , m_impl(impl)
{
}

JSCSSStyleDeclaration::~JSCSSStyleDeclaration()
{
    forgetDOMObject(this, impl());
}

JSObject* JSCSSStyleDeclaration::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSCSSStyleDeclarationPrototype(globalObject, JSCSSStyleDeclarationPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSCSSStyleDeclaration::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    const HashEntry* entry = JSCSSStyleDeclarationTable.entry(exec, propertyName);
    if (entry) {
        slot.setCustom(this, entry->propertyGetter());
        return true;
    }
    bool ok;
    unsigned index = propertyName.toUInt32(&ok, false);
    if (ok) {
        slot.setCustomIndex(this, index, indexGetter);
        return true;
    }
    if (canGetItemsForName(exec, static_cast<CSSStyleDeclaration*>(impl()), propertyName)) {
        slot.setCustom(this, nameGetter);
        return true;
    }
    return getStaticValueSlot<JSCSSStyleDeclaration, Base>(exec, &JSCSSStyleDeclarationTable, this, propertyName, slot);
}

bool JSCSSStyleDeclaration::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    const HashEntry* entry = JSCSSStyleDeclarationTable.entry(exec, propertyName);
    if (entry) {
        PropertySlot slot;
        slot.setCustom(this, entry->propertyGetter());
        descriptor.setDescriptor(slot.getValue(exec, propertyName), entry->attributes());
        return true;
    }
    bool ok;
    unsigned index = propertyName.toUInt32(&ok, false);
    if (ok && index < static_cast<CSSStyleDeclaration*>(impl())->length()) {
        PropertySlot slot;
        slot.setCustomIndex(this, index, indexGetter);
        descriptor.setDescriptor(slot.getValue(exec, propertyName), DontDelete | ReadOnly);
        return true;
    }
    if (canGetItemsForName(exec, static_cast<CSSStyleDeclaration*>(impl()), propertyName)) {
        PropertySlot slot;
        slot.setCustom(this, nameGetter);
        descriptor.setDescriptor(slot.getValue(exec, propertyName), ReadOnly | DontDelete | DontEnum);
        return true;
    }
    return getStaticValueDescriptor<JSCSSStyleDeclaration, Base>(exec, &JSCSSStyleDeclarationTable, this, propertyName, descriptor);
}

bool JSCSSStyleDeclaration::getOwnPropertySlot(ExecState* exec, unsigned propertyName, PropertySlot& slot)
{
    if (propertyName < static_cast<CSSStyleDeclaration*>(impl())->length()) {
        slot.setCustomIndex(this, propertyName, indexGetter);
        return true;
    }
    return getOwnPropertySlot(exec, Identifier::from(exec, propertyName), slot);
}

JSValue jsCSSStyleDeclarationCssText(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSCSSStyleDeclaration* castedThis = static_cast<JSCSSStyleDeclaration*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CSSStyleDeclaration* imp = static_cast<CSSStyleDeclaration*>(castedThis->impl());
    JSValue result = jsStringOrNull(exec, imp->cssText());
    return result;
}

JSValue jsCSSStyleDeclarationLength(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSCSSStyleDeclaration* castedThis = static_cast<JSCSSStyleDeclaration*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CSSStyleDeclaration* imp = static_cast<CSSStyleDeclaration*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->length());
    return result;
}

JSValue jsCSSStyleDeclarationParentRule(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSCSSStyleDeclaration* castedThis = static_cast<JSCSSStyleDeclaration*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CSSStyleDeclaration* imp = static_cast<CSSStyleDeclaration*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->parentRule()));
    return result;
}

JSValue jsCSSStyleDeclarationConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSCSSStyleDeclaration* domObject = static_cast<JSCSSStyleDeclaration*>(asObject(slotBase));
    return JSCSSStyleDeclaration::getConstructor(exec, domObject->globalObject());
}
void JSCSSStyleDeclaration::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    if (putDelegate(exec, propertyName, value, slot))
        return;
    lookupPut<JSCSSStyleDeclaration, Base>(exec, propertyName, value, &JSCSSStyleDeclarationTable, this, slot);
}

void setJSCSSStyleDeclarationCssText(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSCSSStyleDeclaration* castedThis = static_cast<JSCSSStyleDeclaration*>(thisObject);
    CSSStyleDeclaration* imp = static_cast<CSSStyleDeclaration*>(castedThis->impl());
    ExceptionCode ec = 0;
    imp->setCssText(valueToStringWithNullCheck(exec, value), ec);
    setDOMException(exec, ec);
}

void JSCSSStyleDeclaration::getOwnPropertyNames(ExecState* exec, PropertyNameArray& propertyNames, EnumerationMode mode)
{
    for (unsigned i = 0; i < static_cast<CSSStyleDeclaration*>(impl())->length(); ++i)
        propertyNames.add(Identifier::from(exec, i));
     Base::getOwnPropertyNames(exec, propertyNames, mode);
}

JSValue JSCSSStyleDeclaration::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCSSStyleDeclarationConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsCSSStyleDeclarationPrototypeFunctionGetPropertyValue(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCSSStyleDeclaration::s_info))
        return throwVMTypeError(exec);
    JSCSSStyleDeclaration* castedThis = static_cast<JSCSSStyleDeclaration*>(asObject(thisValue));
    CSSStyleDeclaration* imp = static_cast<CSSStyleDeclaration*>(castedThis->impl());
    const String& propertyName = ustringToString(exec->argument(0).toString(exec));


    JSC::JSValue result = jsStringOrNull(exec, imp->getPropertyValue(propertyName));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsCSSStyleDeclarationPrototypeFunctionGetPropertyCSSValue(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCSSStyleDeclaration::s_info))
        return throwVMTypeError(exec);
    JSCSSStyleDeclaration* castedThis = static_cast<JSCSSStyleDeclaration*>(asObject(thisValue));
    CSSStyleDeclaration* imp = static_cast<CSSStyleDeclaration*>(castedThis->impl());
    const String& propertyName = ustringToString(exec->argument(0).toString(exec));


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->getPropertyCSSValue(propertyName)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsCSSStyleDeclarationPrototypeFunctionRemoveProperty(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCSSStyleDeclaration::s_info))
        return throwVMTypeError(exec);
    JSCSSStyleDeclaration* castedThis = static_cast<JSCSSStyleDeclaration*>(asObject(thisValue));
    CSSStyleDeclaration* imp = static_cast<CSSStyleDeclaration*>(castedThis->impl());
    ExceptionCode ec = 0;
    const String& propertyName = ustringToString(exec->argument(0).toString(exec));


    JSC::JSValue result = jsStringOrNull(exec, imp->removeProperty(propertyName, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsCSSStyleDeclarationPrototypeFunctionGetPropertyPriority(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCSSStyleDeclaration::s_info))
        return throwVMTypeError(exec);
    JSCSSStyleDeclaration* castedThis = static_cast<JSCSSStyleDeclaration*>(asObject(thisValue));
    CSSStyleDeclaration* imp = static_cast<CSSStyleDeclaration*>(castedThis->impl());
    const String& propertyName = ustringToString(exec->argument(0).toString(exec));


    JSC::JSValue result = jsStringOrNull(exec, imp->getPropertyPriority(propertyName));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsCSSStyleDeclarationPrototypeFunctionSetProperty(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCSSStyleDeclaration::s_info))
        return throwVMTypeError(exec);
    JSCSSStyleDeclaration* castedThis = static_cast<JSCSSStyleDeclaration*>(asObject(thisValue));
    CSSStyleDeclaration* imp = static_cast<CSSStyleDeclaration*>(castedThis->impl());
    ExceptionCode ec = 0;
    const String& propertyName = ustringToString(exec->argument(0).toString(exec));
    const String& value = valueToStringWithNullCheck(exec, exec->argument(1));
    const String& priority = ustringToString(exec->argument(2).toString(exec));

    imp->setProperty(propertyName, value, priority, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCSSStyleDeclarationPrototypeFunctionItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCSSStyleDeclaration::s_info))
        return throwVMTypeError(exec);
    JSCSSStyleDeclaration* castedThis = static_cast<JSCSSStyleDeclaration*>(asObject(thisValue));
    CSSStyleDeclaration* imp = static_cast<CSSStyleDeclaration*>(castedThis->impl());
    unsigned index = exec->argument(0).toInt32(exec);


    JSC::JSValue result = jsString(exec, imp->item(index));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsCSSStyleDeclarationPrototypeFunctionGetPropertyShorthand(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCSSStyleDeclaration::s_info))
        return throwVMTypeError(exec);
    JSCSSStyleDeclaration* castedThis = static_cast<JSCSSStyleDeclaration*>(asObject(thisValue));
    CSSStyleDeclaration* imp = static_cast<CSSStyleDeclaration*>(castedThis->impl());
    const String& propertyName = ustringToString(exec->argument(0).toString(exec));


    JSC::JSValue result = jsStringOrNull(exec, imp->getPropertyShorthand(propertyName));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsCSSStyleDeclarationPrototypeFunctionIsPropertyImplicit(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCSSStyleDeclaration::s_info))
        return throwVMTypeError(exec);
    JSCSSStyleDeclaration* castedThis = static_cast<JSCSSStyleDeclaration*>(asObject(thisValue));
    CSSStyleDeclaration* imp = static_cast<CSSStyleDeclaration*>(castedThis->impl());
    const String& propertyName = ustringToString(exec->argument(0).toString(exec));


    JSC::JSValue result = jsBoolean(imp->isPropertyImplicit(propertyName));
    return JSValue::encode(result);
}


JSValue JSCSSStyleDeclaration::indexGetter(ExecState* exec, JSValue slotBase, unsigned index)
{
    JSCSSStyleDeclaration* thisObj = static_cast<JSCSSStyleDeclaration*>(asObject(slotBase));
    return jsStringOrNull(exec, thisObj->impl()->item(index));
}
JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, CSSStyleDeclaration* object)
{
    return getDOMObjectWrapper<JSCSSStyleDeclaration>(exec, globalObject, object);
}
CSSStyleDeclaration* toCSSStyleDeclaration(JSC::JSValue value)
{
    return value.inherits(&JSCSSStyleDeclaration::s_info) ? static_cast<JSCSSStyleDeclaration*>(asObject(value))->impl() : 0;
}

}
