/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef JSIDBObjectStoreRequest_h
#define JSIDBObjectStoreRequest_h

#if ENABLE(INDEXED_DATABASE)

#include "JSDOMBinding.h"
#include <runtime/JSGlobalObject.h>
#include <runtime/JSObjectWithGlobalObject.h>
#include <runtime/ObjectPrototype.h>

namespace WebCore {

class IDBObjectStoreRequest;

class JSIDBObjectStoreRequest : public DOMObjectWithGlobalPointer {
    typedef DOMObjectWithGlobalPointer Base;
public:
    JSIDBObjectStoreRequest(NonNullPassRefPtr<JSC::Structure>, JSDOMGlobalObject*, PassRefPtr<IDBObjectStoreRequest>);
    virtual ~JSIDBObjectStoreRequest();
    static JSC::JSObject* createPrototype(JSC::ExecState*, JSC::JSGlobalObject*);
    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier& propertyName, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier& propertyName, JSC::PropertyDescriptor&);
    virtual const JSC::ClassInfo* classInfo() const { return &s_info; }
    static const JSC::ClassInfo s_info;

    static PassRefPtr<JSC::Structure> createStructure(JSC::JSValue prototype)
    {
        return JSC::Structure::create(prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), AnonymousSlotCount);
    }

    static JSC::JSValue getConstructor(JSC::ExecState*, JSC::JSGlobalObject*);
    IDBObjectStoreRequest* impl() const { return m_impl.get(); }

private:
    RefPtr<IDBObjectStoreRequest> m_impl;
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | Base::StructureFlags;
};

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject*, IDBObjectStoreRequest*);
IDBObjectStoreRequest* toIDBObjectStoreRequest(JSC::JSValue);

class JSIDBObjectStoreRequestPrototype : public JSC::JSObjectWithGlobalObject {
    typedef JSC::JSObjectWithGlobalObject Base;
public:
    static JSC::JSObject* self(JSC::ExecState*, JSC::JSGlobalObject*);
    virtual const JSC::ClassInfo* classInfo() const { return &s_info; }
    static const JSC::ClassInfo s_info;
    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static PassRefPtr<JSC::Structure> createStructure(JSC::JSValue prototype)
    {
        return JSC::Structure::create(prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), AnonymousSlotCount);
    }
    JSIDBObjectStoreRequestPrototype(JSC::JSGlobalObject* globalObject, NonNullPassRefPtr<JSC::Structure> structure) : JSC::JSObjectWithGlobalObject(globalObject, structure) { }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | Base::StructureFlags;
};

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsIDBObjectStoreRequestPrototypeFunctionGet(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsIDBObjectStoreRequestPrototypeFunctionAdd(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsIDBObjectStoreRequestPrototypeFunctionPut(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsIDBObjectStoreRequestPrototypeFunctionRemove(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsIDBObjectStoreRequestPrototypeFunctionCreateIndex(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsIDBObjectStoreRequestPrototypeFunctionIndex(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsIDBObjectStoreRequestPrototypeFunctionRemoveIndex(JSC::ExecState*);
// Attributes

JSC::JSValue jsIDBObjectStoreRequestName(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsIDBObjectStoreRequestKeyPath(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsIDBObjectStoreRequestIndexNames(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsIDBObjectStoreRequestConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);

} // namespace WebCore

#endif // ENABLE(INDEXED_DATABASE)

#endif
