/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCSSStyleSheet.h"

#include "CSSRule.h"
#include "CSSRuleList.h"
#include "CSSStyleSheet.h"
#include "JSCSSRule.h"
#include "JSCSSRuleList.h"
#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSCSSStyleSheet);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSCSSStyleSheetTableValues[5] =
{
    { "ownerRule", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSStyleSheetOwnerRule), (intptr_t)0 THUNK_GENERATOR(0) },
    { "cssRules", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSStyleSheetCssRules), (intptr_t)0 THUNK_GENERATOR(0) },
    { "rules", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSStyleSheetRules), (intptr_t)0 THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSStyleSheetConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSCSSStyleSheetTable = { 9, 7, JSCSSStyleSheetTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSCSSStyleSheetConstructorTableValues[1] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSCSSStyleSheetConstructorTable = { 1, 0, JSCSSStyleSheetConstructorTableValues, 0 };
class JSCSSStyleSheetConstructor : public DOMConstructorObject {
public:
    JSCSSStyleSheetConstructor(JSC::ExecState*, JSDOMGlobalObject*);

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    virtual const JSC::ClassInfo* classInfo() const { return &s_info; }
    static const JSC::ClassInfo s_info;
    static PassRefPtr<JSC::Structure> createStructure(JSC::JSValue prototype)
    {
        return JSC::Structure::create(prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), AnonymousSlotCount);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSCSSStyleSheetConstructor::s_info = { "CSSStyleSheetConstructor", 0, &JSCSSStyleSheetConstructorTable, 0 };

JSCSSStyleSheetConstructor::JSCSSStyleSheetConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(JSCSSStyleSheetConstructor::createStructure(globalObject->objectPrototype()), globalObject)
{
    putDirect(exec->propertyNames().prototype, JSCSSStyleSheetPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSCSSStyleSheetConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCSSStyleSheetConstructor, DOMObject>(exec, &JSCSSStyleSheetConstructorTable, this, propertyName, slot);
}

bool JSCSSStyleSheetConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSCSSStyleSheetConstructor, DOMObject>(exec, &JSCSSStyleSheetConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSCSSStyleSheetPrototypeTableValues[5] =
{
    { "insertRule", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsCSSStyleSheetPrototypeFunctionInsertRule), (intptr_t)2 THUNK_GENERATOR(0) },
    { "deleteRule", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsCSSStyleSheetPrototypeFunctionDeleteRule), (intptr_t)1 THUNK_GENERATOR(0) },
    { "addRule", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsCSSStyleSheetPrototypeFunctionAddRule), (intptr_t)3 THUNK_GENERATOR(0) },
    { "removeRule", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsCSSStyleSheetPrototypeFunctionRemoveRule), (intptr_t)1 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSCSSStyleSheetPrototypeTable = { 8, 7, JSCSSStyleSheetPrototypeTableValues, 0 };
const ClassInfo JSCSSStyleSheetPrototype::s_info = { "CSSStyleSheetPrototype", 0, &JSCSSStyleSheetPrototypeTable, 0 };

JSObject* JSCSSStyleSheetPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSCSSStyleSheet>(exec, globalObject);
}

bool JSCSSStyleSheetPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSCSSStyleSheetPrototypeTable, this, propertyName, slot);
}

bool JSCSSStyleSheetPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSCSSStyleSheetPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSCSSStyleSheet::s_info = { "CSSStyleSheet", &JSStyleSheet::s_info, &JSCSSStyleSheetTable, 0 };

JSCSSStyleSheet::JSCSSStyleSheet(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<CSSStyleSheet> impl)
    : JSStyleSheet(structure, globalObject, impl)
{
}

JSObject* JSCSSStyleSheet::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSCSSStyleSheetPrototype(globalObject, JSCSSStyleSheetPrototype::createStructure(JSStyleSheetPrototype::self(exec, globalObject)));
}

bool JSCSSStyleSheet::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCSSStyleSheet, Base>(exec, &JSCSSStyleSheetTable, this, propertyName, slot);
}

bool JSCSSStyleSheet::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSCSSStyleSheet, Base>(exec, &JSCSSStyleSheetTable, this, propertyName, descriptor);
}

JSValue jsCSSStyleSheetOwnerRule(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSCSSStyleSheet* castedThis = static_cast<JSCSSStyleSheet*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CSSStyleSheet* imp = static_cast<CSSStyleSheet*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->ownerRule()));
    return result;
}

JSValue jsCSSStyleSheetCssRules(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSCSSStyleSheet* castedThis = static_cast<JSCSSStyleSheet*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CSSStyleSheet* imp = static_cast<CSSStyleSheet*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->cssRules()));
    return result;
}

JSValue jsCSSStyleSheetRules(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSCSSStyleSheet* castedThis = static_cast<JSCSSStyleSheet*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CSSStyleSheet* imp = static_cast<CSSStyleSheet*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->rules()));
    return result;
}

JSValue jsCSSStyleSheetConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSCSSStyleSheet* domObject = static_cast<JSCSSStyleSheet*>(asObject(slotBase));
    return JSCSSStyleSheet::getConstructor(exec, domObject->globalObject());
}
JSValue JSCSSStyleSheet::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCSSStyleSheetConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsCSSStyleSheetPrototypeFunctionInsertRule(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCSSStyleSheet::s_info))
        return throwVMTypeError(exec);
    JSCSSStyleSheet* castedThis = static_cast<JSCSSStyleSheet*>(asObject(thisValue));
    CSSStyleSheet* imp = static_cast<CSSStyleSheet*>(castedThis->impl());
    ExceptionCode ec = 0;
    const String& rule = ustringToString(exec->argument(0).toString(exec));
    unsigned index = exec->argument(1).toInt32(exec);


    JSC::JSValue result = jsNumber(exec, imp->insertRule(rule, index, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsCSSStyleSheetPrototypeFunctionDeleteRule(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCSSStyleSheet::s_info))
        return throwVMTypeError(exec);
    JSCSSStyleSheet* castedThis = static_cast<JSCSSStyleSheet*>(asObject(thisValue));
    CSSStyleSheet* imp = static_cast<CSSStyleSheet*>(castedThis->impl());
    ExceptionCode ec = 0;
    unsigned index = exec->argument(0).toInt32(exec);

    imp->deleteRule(index, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCSSStyleSheetPrototypeFunctionAddRule(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCSSStyleSheet::s_info))
        return throwVMTypeError(exec);
    JSCSSStyleSheet* castedThis = static_cast<JSCSSStyleSheet*>(asObject(thisValue));
    CSSStyleSheet* imp = static_cast<CSSStyleSheet*>(castedThis->impl());
    ExceptionCode ec = 0;
    const String& selector = ustringToString(exec->argument(0).toString(exec));
    const String& style = ustringToString(exec->argument(1).toString(exec));

    int argsCount = exec->argumentCount();
    if (argsCount < 3) {

        JSC::JSValue result = jsNumber(exec, imp->addRule(selector, style, ec));
        setDOMException(exec, ec);
        return JSValue::encode(result);
    }

    unsigned index = exec->argument(2).toInt32(exec);


    JSC::JSValue result = jsNumber(exec, imp->addRule(selector, style, index, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsCSSStyleSheetPrototypeFunctionRemoveRule(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCSSStyleSheet::s_info))
        return throwVMTypeError(exec);
    JSCSSStyleSheet* castedThis = static_cast<JSCSSStyleSheet*>(asObject(thisValue));
    CSSStyleSheet* imp = static_cast<CSSStyleSheet*>(castedThis->impl());
    ExceptionCode ec = 0;
    unsigned index = exec->argument(0).toInt32(exec);

    imp->removeRule(index, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}


}
