/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSClipboard.h"

#include "Clipboard.h"
#include "FileList.h"
#include "JSFileList.h"
#include "KURL.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSClipboard);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSClipboardTableValues[6] =
{
    { "dropEffect", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsClipboardDropEffect), (intptr_t)setJSClipboardDropEffect THUNK_GENERATOR(0) },
    { "effectAllowed", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsClipboardEffectAllowed), (intptr_t)setJSClipboardEffectAllowed THUNK_GENERATOR(0) },
    { "types", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsClipboardTypes), (intptr_t)0 THUNK_GENERATOR(0) },
    { "files", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsClipboardFiles), (intptr_t)0 THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsClipboardConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSClipboardTable = { 17, 15, JSClipboardTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSClipboardConstructorTableValues[1] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSClipboardConstructorTable = { 1, 0, JSClipboardConstructorTableValues, 0 };
class JSClipboardConstructor : public DOMConstructorObject {
public:
    JSClipboardConstructor(JSC::ExecState*, JSDOMGlobalObject*);

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    virtual const JSC::ClassInfo* classInfo() const { return &s_info; }
    static const JSC::ClassInfo s_info;
    static PassRefPtr<JSC::Structure> createStructure(JSC::JSValue prototype)
    {
        return JSC::Structure::create(prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), AnonymousSlotCount);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSClipboardConstructor::s_info = { "ClipboardConstructor", 0, &JSClipboardConstructorTable, 0 };

JSClipboardConstructor::JSClipboardConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(JSClipboardConstructor::createStructure(globalObject->objectPrototype()), globalObject)
{
    putDirect(exec->propertyNames().prototype, JSClipboardPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSClipboardConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSClipboardConstructor, DOMObject>(exec, &JSClipboardConstructorTable, this, propertyName, slot);
}

bool JSClipboardConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSClipboardConstructor, DOMObject>(exec, &JSClipboardConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSClipboardPrototypeTableValues[5] =
{
    { "clearData", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsClipboardPrototypeFunctionClearData), (intptr_t)1 THUNK_GENERATOR(0) },
    { "getData", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsClipboardPrototypeFunctionGetData), (intptr_t)1 THUNK_GENERATOR(0) },
    { "setData", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsClipboardPrototypeFunctionSetData), (intptr_t)2 THUNK_GENERATOR(0) },
    { "setDragImage", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsClipboardPrototypeFunctionSetDragImage), (intptr_t)3 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSClipboardPrototypeTable = { 8, 7, JSClipboardPrototypeTableValues, 0 };
const ClassInfo JSClipboardPrototype::s_info = { "ClipboardPrototype", 0, &JSClipboardPrototypeTable, 0 };

JSObject* JSClipboardPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSClipboard>(exec, globalObject);
}

bool JSClipboardPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSClipboardPrototypeTable, this, propertyName, slot);
}

bool JSClipboardPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSClipboardPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSClipboard::s_info = { "Clipboard", 0, &JSClipboardTable, 0 };

JSClipboard::JSClipboard(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<Clipboard> impl)
    : DOMObjectWithGlobalPointer(structure, globalObject)
    , m_impl(impl)
{
}

JSClipboard::~JSClipboard()
{
    forgetDOMObject(this, impl());
}

JSObject* JSClipboard::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSClipboardPrototype(globalObject, JSClipboardPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSClipboard::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSClipboard, Base>(exec, &JSClipboardTable, this, propertyName, slot);
}

bool JSClipboard::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSClipboard, Base>(exec, &JSClipboardTable, this, propertyName, descriptor);
}

JSValue jsClipboardDropEffect(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSClipboard* castedThis = static_cast<JSClipboard*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Clipboard* imp = static_cast<Clipboard*>(castedThis->impl());
    JSValue result = jsStringOrUndefined(exec, imp->dropEffect());
    return result;
}

JSValue jsClipboardEffectAllowed(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSClipboard* castedThis = static_cast<JSClipboard*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Clipboard* imp = static_cast<Clipboard*>(castedThis->impl());
    JSValue result = jsStringOrUndefined(exec, imp->effectAllowed());
    return result;
}

JSValue jsClipboardTypes(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSClipboard* castedThis = static_cast<JSClipboard*>(asObject(slotBase));
    return castedThis->types(exec);
}

JSValue jsClipboardFiles(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSClipboard* castedThis = static_cast<JSClipboard*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Clipboard* imp = static_cast<Clipboard*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->files()));
    return result;
}

JSValue jsClipboardConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSClipboard* domObject = static_cast<JSClipboard*>(asObject(slotBase));
    return JSClipboard::getConstructor(exec, domObject->globalObject());
}
void JSClipboard::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSClipboard, Base>(exec, propertyName, value, &JSClipboardTable, this, slot);
}

void setJSClipboardDropEffect(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSClipboard* castedThis = static_cast<JSClipboard*>(thisObject);
    Clipboard* imp = static_cast<Clipboard*>(castedThis->impl());
    imp->setDropEffect(ustringToString(value.toString(exec)));
}

void setJSClipboardEffectAllowed(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSClipboard* castedThis = static_cast<JSClipboard*>(thisObject);
    Clipboard* imp = static_cast<Clipboard*>(castedThis->impl());
    imp->setEffectAllowed(ustringToString(value.toString(exec)));
}

JSValue JSClipboard::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSClipboardConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsClipboardPrototypeFunctionClearData(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSClipboard::s_info))
        return throwVMTypeError(exec);
    JSClipboard* castedThis = static_cast<JSClipboard*>(asObject(thisValue));
    return JSValue::encode(castedThis->clearData(exec));
}

EncodedJSValue JSC_HOST_CALL jsClipboardPrototypeFunctionGetData(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSClipboard::s_info))
        return throwVMTypeError(exec);
    JSClipboard* castedThis = static_cast<JSClipboard*>(asObject(thisValue));
    return JSValue::encode(castedThis->getData(exec));
}

EncodedJSValue JSC_HOST_CALL jsClipboardPrototypeFunctionSetData(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSClipboard::s_info))
        return throwVMTypeError(exec);
    JSClipboard* castedThis = static_cast<JSClipboard*>(asObject(thisValue));
    Clipboard* imp = static_cast<Clipboard*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return JSValue::encode(jsUndefined());
    const String& type = ustringToString(exec->argument(0).toString(exec));
    const String& data = ustringToString(exec->argument(1).toString(exec));


    JSC::JSValue result = jsBoolean(imp->setData(type, data));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsClipboardPrototypeFunctionSetDragImage(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSClipboard::s_info))
        return throwVMTypeError(exec);
    JSClipboard* castedThis = static_cast<JSClipboard*>(asObject(thisValue));
    return JSValue::encode(castedThis->setDragImage(exec));
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, Clipboard* object)
{
    return getDOMObjectWrapper<JSClipboard>(exec, globalObject, object);
}
Clipboard* toClipboard(JSC::JSValue value)
{
    return value.inherits(&JSClipboard::s_info) ? static_cast<JSClipboard*>(asObject(value))->impl() : 0;
}

}
