/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(INDEXED_DATABASE)

#include "JSIDBDatabaseException.h"

#include "IDBDatabaseException.h"
#include "KURL.h"
#include <runtime/JSNumberCell.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSIDBDatabaseException);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSIDBDatabaseExceptionTableValues[4] =
{
    { "code", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBDatabaseExceptionCode), (intptr_t)setJSIDBDatabaseExceptionCode THUNK_GENERATOR(0) },
    { "message", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBDatabaseExceptionMessage), (intptr_t)setJSIDBDatabaseExceptionMessage THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBDatabaseExceptionConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSIDBDatabaseExceptionTable = { 9, 7, JSIDBDatabaseExceptionTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSIDBDatabaseExceptionConstructorTableValues[12] =
{
    { "UNKNOWN_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBDatabaseExceptionUNKNOWN_ERR), (intptr_t)0 THUNK_GENERATOR(0) },
    { "NON_TRANSIENT_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBDatabaseExceptionNON_TRANSIENT_ERR), (intptr_t)0 THUNK_GENERATOR(0) },
    { "NOT_FOUND_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBDatabaseExceptionNOT_FOUND_ERR), (intptr_t)0 THUNK_GENERATOR(0) },
    { "CONSTRAINT_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBDatabaseExceptionCONSTRAINT_ERR), (intptr_t)0 THUNK_GENERATOR(0) },
    { "DATA_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBDatabaseExceptionDATA_ERR), (intptr_t)0 THUNK_GENERATOR(0) },
    { "NOT_ALLOWED_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBDatabaseExceptionNOT_ALLOWED_ERR), (intptr_t)0 THUNK_GENERATOR(0) },
    { "SERIAL_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBDatabaseExceptionSERIAL_ERR), (intptr_t)0 THUNK_GENERATOR(0) },
    { "RECOVERABLE_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBDatabaseExceptionRECOVERABLE_ERR), (intptr_t)0 THUNK_GENERATOR(0) },
    { "TRANSIENT_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBDatabaseExceptionTRANSIENT_ERR), (intptr_t)0 THUNK_GENERATOR(0) },
    { "TIMEOUT_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBDatabaseExceptionTIMEOUT_ERR), (intptr_t)0 THUNK_GENERATOR(0) },
    { "DEADLOCK_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBDatabaseExceptionDEADLOCK_ERR), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSIDBDatabaseExceptionConstructorTable = { 34, 31, JSIDBDatabaseExceptionConstructorTableValues, 0 };

COMPILE_ASSERT(0 == IDBDatabaseException::UNKNOWN_ERR, IDBDatabaseExceptionEnumUNKNOWN_ERRIsWrongUseDontCheckEnums);
COMPILE_ASSERT(1 == IDBDatabaseException::NON_TRANSIENT_ERR, IDBDatabaseExceptionEnumNON_TRANSIENT_ERRIsWrongUseDontCheckEnums);
COMPILE_ASSERT(2 == IDBDatabaseException::NOT_FOUND_ERR, IDBDatabaseExceptionEnumNOT_FOUND_ERRIsWrongUseDontCheckEnums);
COMPILE_ASSERT(3 == IDBDatabaseException::CONSTRAINT_ERR, IDBDatabaseExceptionEnumCONSTRAINT_ERRIsWrongUseDontCheckEnums);
COMPILE_ASSERT(4 == IDBDatabaseException::DATA_ERR, IDBDatabaseExceptionEnumDATA_ERRIsWrongUseDontCheckEnums);
COMPILE_ASSERT(5 == IDBDatabaseException::NOT_ALLOWED_ERR, IDBDatabaseExceptionEnumNOT_ALLOWED_ERRIsWrongUseDontCheckEnums);
COMPILE_ASSERT(11 == IDBDatabaseException::SERIAL_ERR, IDBDatabaseExceptionEnumSERIAL_ERRIsWrongUseDontCheckEnums);
COMPILE_ASSERT(21 == IDBDatabaseException::RECOVERABLE_ERR, IDBDatabaseExceptionEnumRECOVERABLE_ERRIsWrongUseDontCheckEnums);
COMPILE_ASSERT(31 == IDBDatabaseException::TRANSIENT_ERR, IDBDatabaseExceptionEnumTRANSIENT_ERRIsWrongUseDontCheckEnums);
COMPILE_ASSERT(32 == IDBDatabaseException::TIMEOUT_ERR, IDBDatabaseExceptionEnumTIMEOUT_ERRIsWrongUseDontCheckEnums);
COMPILE_ASSERT(33 == IDBDatabaseException::DEADLOCK_ERR, IDBDatabaseExceptionEnumDEADLOCK_ERRIsWrongUseDontCheckEnums);

class JSIDBDatabaseExceptionConstructor : public DOMConstructorObject {
public:
    JSIDBDatabaseExceptionConstructor(JSC::ExecState*, JSDOMGlobalObject*);

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    virtual const JSC::ClassInfo* classInfo() const { return &s_info; }
    static const JSC::ClassInfo s_info;
    static PassRefPtr<JSC::Structure> createStructure(JSC::JSValue prototype)
    {
        return JSC::Structure::create(prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), AnonymousSlotCount);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSIDBDatabaseExceptionConstructor::s_info = { "IDBDatabaseExceptionConstructor", 0, &JSIDBDatabaseExceptionConstructorTable, 0 };

JSIDBDatabaseExceptionConstructor::JSIDBDatabaseExceptionConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(JSIDBDatabaseExceptionConstructor::createStructure(globalObject->objectPrototype()), globalObject)
{
    putDirect(exec->propertyNames().prototype, JSIDBDatabaseExceptionPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSIDBDatabaseExceptionConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSIDBDatabaseExceptionConstructor, DOMObject>(exec, &JSIDBDatabaseExceptionConstructorTable, this, propertyName, slot);
}

bool JSIDBDatabaseExceptionConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSIDBDatabaseExceptionConstructor, DOMObject>(exec, &JSIDBDatabaseExceptionConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSIDBDatabaseExceptionPrototypeTableValues[12] =
{
    { "UNKNOWN_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBDatabaseExceptionUNKNOWN_ERR), (intptr_t)0 THUNK_GENERATOR(0) },
    { "NON_TRANSIENT_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBDatabaseExceptionNON_TRANSIENT_ERR), (intptr_t)0 THUNK_GENERATOR(0) },
    { "NOT_FOUND_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBDatabaseExceptionNOT_FOUND_ERR), (intptr_t)0 THUNK_GENERATOR(0) },
    { "CONSTRAINT_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBDatabaseExceptionCONSTRAINT_ERR), (intptr_t)0 THUNK_GENERATOR(0) },
    { "DATA_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBDatabaseExceptionDATA_ERR), (intptr_t)0 THUNK_GENERATOR(0) },
    { "NOT_ALLOWED_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBDatabaseExceptionNOT_ALLOWED_ERR), (intptr_t)0 THUNK_GENERATOR(0) },
    { "SERIAL_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBDatabaseExceptionSERIAL_ERR), (intptr_t)0 THUNK_GENERATOR(0) },
    { "RECOVERABLE_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBDatabaseExceptionRECOVERABLE_ERR), (intptr_t)0 THUNK_GENERATOR(0) },
    { "TRANSIENT_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBDatabaseExceptionTRANSIENT_ERR), (intptr_t)0 THUNK_GENERATOR(0) },
    { "TIMEOUT_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBDatabaseExceptionTIMEOUT_ERR), (intptr_t)0 THUNK_GENERATOR(0) },
    { "DEADLOCK_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBDatabaseExceptionDEADLOCK_ERR), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSIDBDatabaseExceptionPrototypeTable = { 34, 31, JSIDBDatabaseExceptionPrototypeTableValues, 0 };
const ClassInfo JSIDBDatabaseExceptionPrototype::s_info = { "IDBDatabaseExceptionPrototype", 0, &JSIDBDatabaseExceptionPrototypeTable, 0 };

JSObject* JSIDBDatabaseExceptionPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSIDBDatabaseException>(exec, globalObject);
}

bool JSIDBDatabaseExceptionPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSIDBDatabaseExceptionPrototype, JSObject>(exec, &JSIDBDatabaseExceptionPrototypeTable, this, propertyName, slot);
}

bool JSIDBDatabaseExceptionPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSIDBDatabaseExceptionPrototype, JSObject>(exec, &JSIDBDatabaseExceptionPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSIDBDatabaseException::s_info = { "IDBDatabaseException", 0, &JSIDBDatabaseExceptionTable, 0 };

JSIDBDatabaseException::JSIDBDatabaseException(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<IDBDatabaseException> impl)
    : DOMObjectWithGlobalPointer(structure, globalObject)
    , m_impl(impl)
{
}

JSIDBDatabaseException::~JSIDBDatabaseException()
{
    forgetDOMObject(this, impl());
}

JSObject* JSIDBDatabaseException::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSIDBDatabaseExceptionPrototype(globalObject, JSIDBDatabaseExceptionPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSIDBDatabaseException::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSIDBDatabaseException, Base>(exec, &JSIDBDatabaseExceptionTable, this, propertyName, slot);
}

bool JSIDBDatabaseException::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSIDBDatabaseException, Base>(exec, &JSIDBDatabaseExceptionTable, this, propertyName, descriptor);
}

JSValue jsIDBDatabaseExceptionCode(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSIDBDatabaseException* castedThis = static_cast<JSIDBDatabaseException*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    IDBDatabaseException* imp = static_cast<IDBDatabaseException*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->code());
    return result;
}

JSValue jsIDBDatabaseExceptionMessage(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSIDBDatabaseException* castedThis = static_cast<JSIDBDatabaseException*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    IDBDatabaseException* imp = static_cast<IDBDatabaseException*>(castedThis->impl());
    JSValue result = jsString(exec, imp->message());
    return result;
}

JSValue jsIDBDatabaseExceptionConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSIDBDatabaseException* domObject = static_cast<JSIDBDatabaseException*>(asObject(slotBase));
    return JSIDBDatabaseException::getConstructor(exec, domObject->globalObject());
}
void JSIDBDatabaseException::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSIDBDatabaseException, Base>(exec, propertyName, value, &JSIDBDatabaseExceptionTable, this, slot);
}

void setJSIDBDatabaseExceptionCode(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSIDBDatabaseException* castedThis = static_cast<JSIDBDatabaseException*>(thisObject);
    IDBDatabaseException* imp = static_cast<IDBDatabaseException*>(castedThis->impl());
    imp->setCode(value.toInt32(exec));
}

void setJSIDBDatabaseExceptionMessage(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSIDBDatabaseException* castedThis = static_cast<JSIDBDatabaseException*>(thisObject);
    IDBDatabaseException* imp = static_cast<IDBDatabaseException*>(castedThis->impl());
    imp->setMessage(ustringToString(value.toString(exec)));
}

JSValue JSIDBDatabaseException::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSIDBDatabaseExceptionConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

// Constant getters

JSValue jsIDBDatabaseExceptionUNKNOWN_ERR(ExecState* exec, JSValue, const Identifier&)
{
    return jsNumber(exec, static_cast<int>(0));
}

JSValue jsIDBDatabaseExceptionNON_TRANSIENT_ERR(ExecState* exec, JSValue, const Identifier&)
{
    return jsNumber(exec, static_cast<int>(1));
}

JSValue jsIDBDatabaseExceptionNOT_FOUND_ERR(ExecState* exec, JSValue, const Identifier&)
{
    return jsNumber(exec, static_cast<int>(2));
}

JSValue jsIDBDatabaseExceptionCONSTRAINT_ERR(ExecState* exec, JSValue, const Identifier&)
{
    return jsNumber(exec, static_cast<int>(3));
}

JSValue jsIDBDatabaseExceptionDATA_ERR(ExecState* exec, JSValue, const Identifier&)
{
    return jsNumber(exec, static_cast<int>(4));
}

JSValue jsIDBDatabaseExceptionNOT_ALLOWED_ERR(ExecState* exec, JSValue, const Identifier&)
{
    return jsNumber(exec, static_cast<int>(5));
}

JSValue jsIDBDatabaseExceptionSERIAL_ERR(ExecState* exec, JSValue, const Identifier&)
{
    return jsNumber(exec, static_cast<int>(11));
}

JSValue jsIDBDatabaseExceptionRECOVERABLE_ERR(ExecState* exec, JSValue, const Identifier&)
{
    return jsNumber(exec, static_cast<int>(21));
}

JSValue jsIDBDatabaseExceptionTRANSIENT_ERR(ExecState* exec, JSValue, const Identifier&)
{
    return jsNumber(exec, static_cast<int>(31));
}

JSValue jsIDBDatabaseExceptionTIMEOUT_ERR(ExecState* exec, JSValue, const Identifier&)
{
    return jsNumber(exec, static_cast<int>(32));
}

JSValue jsIDBDatabaseExceptionDEADLOCK_ERR(ExecState* exec, JSValue, const Identifier&)
{
    return jsNumber(exec, static_cast<int>(33));
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, IDBDatabaseException* object)
{
    return getDOMObjectWrapper<JSIDBDatabaseException>(exec, globalObject, object);
}
IDBDatabaseException* toIDBDatabaseException(JSC::JSValue value)
{
    return value.inherits(&JSIDBDatabaseException::s_info) ? static_cast<JSIDBDatabaseException*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(INDEXED_DATABASE)
