/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSPopStateEvent.h"

#include "PopStateEvent.h"
#include "SerializedScriptValue.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSPopStateEvent);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSPopStateEventTableValues[3] =
{
    { "state", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPopStateEventState), (intptr_t)0 THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPopStateEventConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSPopStateEventTable = { 5, 3, JSPopStateEventTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSPopStateEventConstructorTableValues[1] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSPopStateEventConstructorTable = { 1, 0, JSPopStateEventConstructorTableValues, 0 };
class JSPopStateEventConstructor : public DOMConstructorObject {
public:
    JSPopStateEventConstructor(JSC::ExecState*, JSDOMGlobalObject*);

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    virtual const JSC::ClassInfo* classInfo() const { return &s_info; }
    static const JSC::ClassInfo s_info;
    static PassRefPtr<JSC::Structure> createStructure(JSC::JSValue prototype)
    {
        return JSC::Structure::create(prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), AnonymousSlotCount);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSPopStateEventConstructor::s_info = { "PopStateEventConstructor", 0, &JSPopStateEventConstructorTable, 0 };

JSPopStateEventConstructor::JSPopStateEventConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(JSPopStateEventConstructor::createStructure(globalObject->objectPrototype()), globalObject)
{
    putDirect(exec->propertyNames().prototype, JSPopStateEventPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSPopStateEventConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSPopStateEventConstructor, DOMObject>(exec, &JSPopStateEventConstructorTable, this, propertyName, slot);
}

bool JSPopStateEventConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSPopStateEventConstructor, DOMObject>(exec, &JSPopStateEventConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSPopStateEventPrototypeTableValues[2] =
{
    { "initPopStateEvent", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsPopStateEventPrototypeFunctionInitPopStateEvent), (intptr_t)4 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSPopStateEventPrototypeTable = { 2, 1, JSPopStateEventPrototypeTableValues, 0 };
const ClassInfo JSPopStateEventPrototype::s_info = { "PopStateEventPrototype", 0, &JSPopStateEventPrototypeTable, 0 };

JSObject* JSPopStateEventPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSPopStateEvent>(exec, globalObject);
}

bool JSPopStateEventPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSPopStateEventPrototypeTable, this, propertyName, slot);
}

bool JSPopStateEventPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSPopStateEventPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSPopStateEvent::s_info = { "PopStateEvent", &JSEvent::s_info, &JSPopStateEventTable, 0 };

JSPopStateEvent::JSPopStateEvent(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<PopStateEvent> impl)
    : JSEvent(structure, globalObject, impl)
{
}

JSObject* JSPopStateEvent::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSPopStateEventPrototype(globalObject, JSPopStateEventPrototype::createStructure(JSEventPrototype::self(exec, globalObject)));
}

bool JSPopStateEvent::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSPopStateEvent, Base>(exec, &JSPopStateEventTable, this, propertyName, slot);
}

bool JSPopStateEvent::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSPopStateEvent, Base>(exec, &JSPopStateEventTable, this, propertyName, descriptor);
}

JSValue jsPopStateEventState(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSPopStateEvent* castedThis = static_cast<JSPopStateEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    PopStateEvent* imp = static_cast<PopStateEvent*>(castedThis->impl());
    JSValue result = imp->state() ? imp->state()->deserialize(exec, castedThis->globalObject()) : jsNull();
    return result;
}

JSValue jsPopStateEventConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSPopStateEvent* domObject = static_cast<JSPopStateEvent*>(asObject(slotBase));
    return JSPopStateEvent::getConstructor(exec, domObject->globalObject());
}
JSValue JSPopStateEvent::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSPopStateEventConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsPopStateEventPrototypeFunctionInitPopStateEvent(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSPopStateEvent::s_info))
        return throwVMTypeError(exec);
    JSPopStateEvent* castedThis = static_cast<JSPopStateEvent*>(asObject(thisValue));
    PopStateEvent* imp = static_cast<PopStateEvent*>(castedThis->impl());
    const String& typeArg = ustringToString(exec->argument(0).toString(exec));
    bool canBubbleArg = exec->argument(1).toBoolean(exec);
    bool cancelableArg = exec->argument(2).toBoolean(exec);
    RefPtr<SerializedScriptValue> stateArg = SerializedScriptValue::create(exec, exec->argument(3));

    imp->initPopStateEvent(typeArg, canBubbleArg, cancelableArg, stateArg);
    return JSValue::encode(jsUndefined());
}


}
