/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLHeadElement.h"

#include "HTMLHeadElement.h"
#include "HTMLNames.h"
#include "KURL.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLHeadElement);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSHTMLHeadElementTableValues[3] =
{
    { "profile", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLHeadElementProfile), (intptr_t)setJSHTMLHeadElementProfile THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLHeadElementConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSHTMLHeadElementTable = { 5, 3, JSHTMLHeadElementTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSHTMLHeadElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSHTMLHeadElementConstructorTable = { 1, 0, JSHTMLHeadElementConstructorTableValues, 0 };
class JSHTMLHeadElementConstructor : public DOMConstructorObject {
public:
    JSHTMLHeadElementConstructor(JSC::ExecState*, JSDOMGlobalObject*);

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    virtual const JSC::ClassInfo* classInfo() const { return &s_info; }
    static const JSC::ClassInfo s_info;
    static PassRefPtr<JSC::Structure> createStructure(JSC::JSValue prototype)
    {
        return JSC::Structure::create(prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), AnonymousSlotCount);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSHTMLHeadElementConstructor::s_info = { "HTMLHeadElementConstructor", 0, &JSHTMLHeadElementConstructorTable, 0 };

JSHTMLHeadElementConstructor::JSHTMLHeadElementConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(JSHTMLHeadElementConstructor::createStructure(globalObject->objectPrototype()), globalObject)
{
    putDirect(exec->propertyNames().prototype, JSHTMLHeadElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSHTMLHeadElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLHeadElementConstructor, DOMObject>(exec, &JSHTMLHeadElementConstructorTable, this, propertyName, slot);
}

bool JSHTMLHeadElementConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLHeadElementConstructor, DOMObject>(exec, &JSHTMLHeadElementConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSHTMLHeadElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSHTMLHeadElementPrototypeTable = { 1, 0, JSHTMLHeadElementPrototypeTableValues, 0 };
const ClassInfo JSHTMLHeadElementPrototype::s_info = { "HTMLHeadElementPrototype", 0, &JSHTMLHeadElementPrototypeTable, 0 };

JSObject* JSHTMLHeadElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLHeadElement>(exec, globalObject);
}

const ClassInfo JSHTMLHeadElement::s_info = { "HTMLHeadElement", &JSHTMLElement::s_info, &JSHTMLHeadElementTable, 0 };

JSHTMLHeadElement::JSHTMLHeadElement(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLHeadElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

JSObject* JSHTMLHeadElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSHTMLHeadElementPrototype(globalObject, JSHTMLHeadElementPrototype::createStructure(JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLHeadElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLHeadElement, Base>(exec, &JSHTMLHeadElementTable, this, propertyName, slot);
}

bool JSHTMLHeadElement::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLHeadElement, Base>(exec, &JSHTMLHeadElementTable, this, propertyName, descriptor);
}

JSValue jsHTMLHeadElementProfile(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLHeadElement* castedThis = static_cast<JSHTMLHeadElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLHeadElement* imp = static_cast<HTMLHeadElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->getAttribute(WebCore::HTMLNames::profileAttr));
    return result;
}

JSValue jsHTMLHeadElementConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLHeadElement* domObject = static_cast<JSHTMLHeadElement*>(asObject(slotBase));
    return JSHTMLHeadElement::getConstructor(exec, domObject->globalObject());
}
void JSHTMLHeadElement::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSHTMLHeadElement, Base>(exec, propertyName, value, &JSHTMLHeadElementTable, this, slot);
}

void setJSHTMLHeadElementProfile(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLHeadElement* castedThis = static_cast<JSHTMLHeadElement*>(thisObject);
    HTMLHeadElement* imp = static_cast<HTMLHeadElement*>(castedThis->impl());
    imp->setAttribute(WebCore::HTMLNames::profileAttr, valueToStringWithNullCheck(exec, value));
}

JSValue JSHTMLHeadElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLHeadElementConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}


}
