/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(INDEXED_DATABASE)

#include "JSIDBSuccessEvent.h"

#include "IDBAny.h"
#include "IDBSuccessEvent.h"
#include "JSIDBAny.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSIDBSuccessEvent);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSIDBSuccessEventTableValues[3] =
{
    { "result", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBSuccessEventResult), (intptr_t)0 THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBSuccessEventConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSIDBSuccessEventTable = { 4, 3, JSIDBSuccessEventTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSIDBSuccessEventConstructorTableValues[1] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSIDBSuccessEventConstructorTable = { 1, 0, JSIDBSuccessEventConstructorTableValues, 0 };
class JSIDBSuccessEventConstructor : public DOMConstructorObject {
public:
    JSIDBSuccessEventConstructor(JSC::ExecState*, JSDOMGlobalObject*);

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    virtual const JSC::ClassInfo* classInfo() const { return &s_info; }
    static const JSC::ClassInfo s_info;
    static PassRefPtr<JSC::Structure> createStructure(JSC::JSValue prototype)
    {
        return JSC::Structure::create(prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), AnonymousSlotCount);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSIDBSuccessEventConstructor::s_info = { "IDBSuccessEventConstructor", 0, &JSIDBSuccessEventConstructorTable, 0 };

JSIDBSuccessEventConstructor::JSIDBSuccessEventConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(JSIDBSuccessEventConstructor::createStructure(globalObject->objectPrototype()), globalObject)
{
    putDirect(exec->propertyNames().prototype, JSIDBSuccessEventPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSIDBSuccessEventConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSIDBSuccessEventConstructor, DOMObject>(exec, &JSIDBSuccessEventConstructorTable, this, propertyName, slot);
}

bool JSIDBSuccessEventConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSIDBSuccessEventConstructor, DOMObject>(exec, &JSIDBSuccessEventConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSIDBSuccessEventPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSIDBSuccessEventPrototypeTable = { 1, 0, JSIDBSuccessEventPrototypeTableValues, 0 };
const ClassInfo JSIDBSuccessEventPrototype::s_info = { "IDBSuccessEventPrototype", 0, &JSIDBSuccessEventPrototypeTable, 0 };

JSObject* JSIDBSuccessEventPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSIDBSuccessEvent>(exec, globalObject);
}

const ClassInfo JSIDBSuccessEvent::s_info = { "IDBSuccessEvent", &JSIDBEvent::s_info, &JSIDBSuccessEventTable, 0 };

JSIDBSuccessEvent::JSIDBSuccessEvent(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<IDBSuccessEvent> impl)
    : JSIDBEvent(structure, globalObject, impl)
{
}

JSObject* JSIDBSuccessEvent::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSIDBSuccessEventPrototype(globalObject, JSIDBSuccessEventPrototype::createStructure(JSIDBEventPrototype::self(exec, globalObject)));
}

bool JSIDBSuccessEvent::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSIDBSuccessEvent, Base>(exec, &JSIDBSuccessEventTable, this, propertyName, slot);
}

bool JSIDBSuccessEvent::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSIDBSuccessEvent, Base>(exec, &JSIDBSuccessEventTable, this, propertyName, descriptor);
}

JSValue jsIDBSuccessEventResult(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSIDBSuccessEvent* castedThis = static_cast<JSIDBSuccessEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    IDBSuccessEvent* imp = static_cast<IDBSuccessEvent*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->result()));
    return result;
}

JSValue jsIDBSuccessEventConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSIDBSuccessEvent* domObject = static_cast<JSIDBSuccessEvent*>(asObject(slotBase));
    return JSIDBSuccessEvent::getConstructor(exec, domObject->globalObject());
}
JSValue JSIDBSuccessEvent::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSIDBSuccessEventConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}


}

#endif // ENABLE(INDEXED_DATABASE)
