/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSValidityState.h"

#include "ValidityState.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSValidityState);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSValidityStateTableValues[10] =
{
    { "valueMissing", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsValidityStateValueMissing), (intptr_t)0 THUNK_GENERATOR(0) },
    { "typeMismatch", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsValidityStateTypeMismatch), (intptr_t)0 THUNK_GENERATOR(0) },
    { "patternMismatch", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsValidityStatePatternMismatch), (intptr_t)0 THUNK_GENERATOR(0) },
    { "tooLong", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsValidityStateTooLong), (intptr_t)0 THUNK_GENERATOR(0) },
    { "rangeUnderflow", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsValidityStateRangeUnderflow), (intptr_t)0 THUNK_GENERATOR(0) },
    { "rangeOverflow", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsValidityStateRangeOverflow), (intptr_t)0 THUNK_GENERATOR(0) },
    { "stepMismatch", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsValidityStateStepMismatch), (intptr_t)0 THUNK_GENERATOR(0) },
    { "customError", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsValidityStateCustomError), (intptr_t)0 THUNK_GENERATOR(0) },
    { "valid", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsValidityStateValid), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSValidityStateTable = { 34, 31, JSValidityStateTableValues, 0 };
/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSValidityStatePrototypeTableValues[1] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSValidityStatePrototypeTable = { 1, 0, JSValidityStatePrototypeTableValues, 0 };
const ClassInfo JSValidityStatePrototype::s_info = { "ValidityStatePrototype", 0, &JSValidityStatePrototypeTable, 0 };

JSObject* JSValidityStatePrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSValidityState>(exec, globalObject);
}

const ClassInfo JSValidityState::s_info = { "ValidityState", 0, &JSValidityStateTable, 0 };

JSValidityState::JSValidityState(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<ValidityState> impl)
    : DOMObjectWithGlobalPointer(structure, globalObject)
    , m_impl(impl)
{
}

JSValidityState::~JSValidityState()
{
    forgetDOMObject(this, impl());
}

JSObject* JSValidityState::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSValidityStatePrototype(globalObject, JSValidityStatePrototype::createStructure(globalObject->objectPrototype()));
}

bool JSValidityState::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSValidityState, Base>(exec, &JSValidityStateTable, this, propertyName, slot);
}

bool JSValidityState::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSValidityState, Base>(exec, &JSValidityStateTable, this, propertyName, descriptor);
}

JSValue jsValidityStateValueMissing(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSValidityState* castedThis = static_cast<JSValidityState*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    ValidityState* imp = static_cast<ValidityState*>(castedThis->impl());
    JSValue result = jsBoolean(imp->valueMissing());
    return result;
}

JSValue jsValidityStateTypeMismatch(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSValidityState* castedThis = static_cast<JSValidityState*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    ValidityState* imp = static_cast<ValidityState*>(castedThis->impl());
    JSValue result = jsBoolean(imp->typeMismatch());
    return result;
}

JSValue jsValidityStatePatternMismatch(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSValidityState* castedThis = static_cast<JSValidityState*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    ValidityState* imp = static_cast<ValidityState*>(castedThis->impl());
    JSValue result = jsBoolean(imp->patternMismatch());
    return result;
}

JSValue jsValidityStateTooLong(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSValidityState* castedThis = static_cast<JSValidityState*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    ValidityState* imp = static_cast<ValidityState*>(castedThis->impl());
    JSValue result = jsBoolean(imp->tooLong());
    return result;
}

JSValue jsValidityStateRangeUnderflow(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSValidityState* castedThis = static_cast<JSValidityState*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    ValidityState* imp = static_cast<ValidityState*>(castedThis->impl());
    JSValue result = jsBoolean(imp->rangeUnderflow());
    return result;
}

JSValue jsValidityStateRangeOverflow(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSValidityState* castedThis = static_cast<JSValidityState*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    ValidityState* imp = static_cast<ValidityState*>(castedThis->impl());
    JSValue result = jsBoolean(imp->rangeOverflow());
    return result;
}

JSValue jsValidityStateStepMismatch(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSValidityState* castedThis = static_cast<JSValidityState*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    ValidityState* imp = static_cast<ValidityState*>(castedThis->impl());
    JSValue result = jsBoolean(imp->stepMismatch());
    return result;
}

JSValue jsValidityStateCustomError(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSValidityState* castedThis = static_cast<JSValidityState*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    ValidityState* imp = static_cast<ValidityState*>(castedThis->impl());
    JSValue result = jsBoolean(imp->customError());
    return result;
}

JSValue jsValidityStateValid(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSValidityState* castedThis = static_cast<JSValidityState*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    ValidityState* imp = static_cast<ValidityState*>(castedThis->impl());
    JSValue result = jsBoolean(imp->valid());
    return result;
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, ValidityState* object)
{
    return getDOMObjectWrapper<JSValidityState>(exec, globalObject, object);
}
ValidityState* toValidityState(JSC::JSValue value)
{
    return value.inherits(&JSValidityState::s_info) ? static_cast<JSValidityState*>(asObject(value))->impl() : 0;
}

}
