/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDOMPluginArray.h"

#include "AtomicString.h"
#include "DOMPlugin.h"
#include "DOMPluginArray.h"
#include "JSDOMPlugin.h"
#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>
#include <runtime/PropertyNameArray.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSDOMPluginArray);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSDOMPluginArrayTableValues[3] =
{
    { "length", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMPluginArrayLength), (intptr_t)0 THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMPluginArrayConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSDOMPluginArrayTable = { 5, 3, JSDOMPluginArrayTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSDOMPluginArrayConstructorTableValues[1] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSDOMPluginArrayConstructorTable = { 1, 0, JSDOMPluginArrayConstructorTableValues, 0 };
class JSDOMPluginArrayConstructor : public DOMConstructorObject {
public:
    JSDOMPluginArrayConstructor(JSC::ExecState*, JSDOMGlobalObject*);

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    virtual const JSC::ClassInfo* classInfo() const { return &s_info; }
    static const JSC::ClassInfo s_info;
    static PassRefPtr<JSC::Structure> createStructure(JSC::JSValue prototype)
    {
        return JSC::Structure::create(prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), AnonymousSlotCount);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSDOMPluginArrayConstructor::s_info = { "PluginArrayConstructor", 0, &JSDOMPluginArrayConstructorTable, 0 };

JSDOMPluginArrayConstructor::JSDOMPluginArrayConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(JSDOMPluginArrayConstructor::createStructure(globalObject->objectPrototype()), globalObject)
{
    putDirect(exec->propertyNames().prototype, JSDOMPluginArrayPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSDOMPluginArrayConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSDOMPluginArrayConstructor, DOMObject>(exec, &JSDOMPluginArrayConstructorTable, this, propertyName, slot);
}

bool JSDOMPluginArrayConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSDOMPluginArrayConstructor, DOMObject>(exec, &JSDOMPluginArrayConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSDOMPluginArrayPrototypeTableValues[4] =
{
    { "item", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDOMPluginArrayPrototypeFunctionItem), (intptr_t)1 THUNK_GENERATOR(0) },
    { "namedItem", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDOMPluginArrayPrototypeFunctionNamedItem), (intptr_t)1 THUNK_GENERATOR(0) },
    { "refresh", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDOMPluginArrayPrototypeFunctionRefresh), (intptr_t)1 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSDOMPluginArrayPrototypeTable = { 8, 7, JSDOMPluginArrayPrototypeTableValues, 0 };
const ClassInfo JSDOMPluginArrayPrototype::s_info = { "PluginArrayPrototype", 0, &JSDOMPluginArrayPrototypeTable, 0 };

JSObject* JSDOMPluginArrayPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSDOMPluginArray>(exec, globalObject);
}

bool JSDOMPluginArrayPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSDOMPluginArrayPrototypeTable, this, propertyName, slot);
}

bool JSDOMPluginArrayPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSDOMPluginArrayPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSDOMPluginArray::s_info = { "PluginArray", 0, &JSDOMPluginArrayTable, 0 };

JSDOMPluginArray::JSDOMPluginArray(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<DOMPluginArray> impl)
    : DOMObjectWithGlobalPointer(structure, globalObject)
    , m_impl(impl)
{
}

JSDOMPluginArray::~JSDOMPluginArray()
{
    forgetDOMObject(this, impl());
}

JSObject* JSDOMPluginArray::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSDOMPluginArrayPrototype(globalObject, JSDOMPluginArrayPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSDOMPluginArray::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    const HashEntry* entry = JSDOMPluginArrayTable.entry(exec, propertyName);
    if (entry) {
        slot.setCustom(this, entry->propertyGetter());
        return true;
    }
    bool ok;
    unsigned index = propertyName.toUInt32(&ok, false);
    if (ok && index < static_cast<DOMPluginArray*>(impl())->length()) {
        slot.setCustomIndex(this, index, indexGetter);
        return true;
    }
    if (canGetItemsForName(exec, static_cast<DOMPluginArray*>(impl()), propertyName)) {
        slot.setCustom(this, nameGetter);
        return true;
    }
    return getStaticValueSlot<JSDOMPluginArray, Base>(exec, &JSDOMPluginArrayTable, this, propertyName, slot);
}

bool JSDOMPluginArray::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    const HashEntry* entry = JSDOMPluginArrayTable.entry(exec, propertyName);
    if (entry) {
        PropertySlot slot;
        slot.setCustom(this, entry->propertyGetter());
        descriptor.setDescriptor(slot.getValue(exec, propertyName), entry->attributes());
        return true;
    }
    bool ok;
    unsigned index = propertyName.toUInt32(&ok, false);
    if (ok && index < static_cast<DOMPluginArray*>(impl())->length()) {
        PropertySlot slot;
        slot.setCustomIndex(this, index, indexGetter);
        descriptor.setDescriptor(slot.getValue(exec, propertyName), DontDelete | ReadOnly);
        return true;
    }
    if (canGetItemsForName(exec, static_cast<DOMPluginArray*>(impl()), propertyName)) {
        PropertySlot slot;
        slot.setCustom(this, nameGetter);
        descriptor.setDescriptor(slot.getValue(exec, propertyName), ReadOnly | DontDelete | DontEnum);
        return true;
    }
    return getStaticValueDescriptor<JSDOMPluginArray, Base>(exec, &JSDOMPluginArrayTable, this, propertyName, descriptor);
}

bool JSDOMPluginArray::getOwnPropertySlot(ExecState* exec, unsigned propertyName, PropertySlot& slot)
{
    if (propertyName < static_cast<DOMPluginArray*>(impl())->length()) {
        slot.setCustomIndex(this, propertyName, indexGetter);
        return true;
    }
    return getOwnPropertySlot(exec, Identifier::from(exec, propertyName), slot);
}

JSValue jsDOMPluginArrayLength(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDOMPluginArray* castedThis = static_cast<JSDOMPluginArray*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    DOMPluginArray* imp = static_cast<DOMPluginArray*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->length());
    return result;
}

JSValue jsDOMPluginArrayConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDOMPluginArray* domObject = static_cast<JSDOMPluginArray*>(asObject(slotBase));
    return JSDOMPluginArray::getConstructor(exec, domObject->globalObject());
}
void JSDOMPluginArray::getOwnPropertyNames(ExecState* exec, PropertyNameArray& propertyNames, EnumerationMode mode)
{
    for (unsigned i = 0; i < static_cast<DOMPluginArray*>(impl())->length(); ++i)
        propertyNames.add(Identifier::from(exec, i));
     Base::getOwnPropertyNames(exec, propertyNames, mode);
}

JSValue JSDOMPluginArray::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDOMPluginArrayConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsDOMPluginArrayPrototypeFunctionItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDOMPluginArray::s_info))
        return throwVMTypeError(exec);
    JSDOMPluginArray* castedThis = static_cast<JSDOMPluginArray*>(asObject(thisValue));
    DOMPluginArray* imp = static_cast<DOMPluginArray*>(castedThis->impl());
    unsigned index = exec->argument(0).toInt32(exec);


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->item(index)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDOMPluginArrayPrototypeFunctionNamedItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDOMPluginArray::s_info))
        return throwVMTypeError(exec);
    JSDOMPluginArray* castedThis = static_cast<JSDOMPluginArray*>(asObject(thisValue));
    DOMPluginArray* imp = static_cast<DOMPluginArray*>(castedThis->impl());
    const String& name = ustringToString(exec->argument(0).toString(exec));


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->namedItem(name)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDOMPluginArrayPrototypeFunctionRefresh(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDOMPluginArray::s_info))
        return throwVMTypeError(exec);
    JSDOMPluginArray* castedThis = static_cast<JSDOMPluginArray*>(asObject(thisValue));
    DOMPluginArray* imp = static_cast<DOMPluginArray*>(castedThis->impl());
    bool reload = exec->argument(0).toBoolean(exec);

    imp->refresh(reload);
    return JSValue::encode(jsUndefined());
}


JSValue JSDOMPluginArray::indexGetter(ExecState* exec, JSValue slotBase, unsigned index)
{
    JSDOMPluginArray* thisObj = static_cast<JSDOMPluginArray*>(asObject(slotBase));
    return toJS(exec, thisObj->globalObject(), static_cast<DOMPluginArray*>(thisObj->impl())->item(index));
}
JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, DOMPluginArray* object)
{
    return getDOMObjectWrapper<JSDOMPluginArray>(exec, globalObject, object);
}
DOMPluginArray* toDOMPluginArray(JSC::JSValue value)
{
    return value.inherits(&JSDOMPluginArray::s_info) ? static_cast<JSDOMPluginArray*>(asObject(value))->impl() : 0;
}

}
