/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGMatrix.h"

#include "JSSVGMatrix.h"
#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGMatrix);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSSVGMatrixTableValues[8] =
{
    { "a", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGMatrixA), (intptr_t)setJSSVGMatrixA THUNK_GENERATOR(0) },
    { "b", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGMatrixB), (intptr_t)setJSSVGMatrixB THUNK_GENERATOR(0) },
    { "c", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGMatrixC), (intptr_t)setJSSVGMatrixC THUNK_GENERATOR(0) },
    { "d", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGMatrixD), (intptr_t)setJSSVGMatrixD THUNK_GENERATOR(0) },
    { "e", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGMatrixE), (intptr_t)setJSSVGMatrixE THUNK_GENERATOR(0) },
    { "f", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGMatrixF), (intptr_t)setJSSVGMatrixF THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGMatrixConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSSVGMatrixTable = { 17, 15, JSSVGMatrixTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSSVGMatrixConstructorTableValues[1] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSSVGMatrixConstructorTable = { 1, 0, JSSVGMatrixConstructorTableValues, 0 };
class JSSVGMatrixConstructor : public DOMConstructorObject {
public:
    JSSVGMatrixConstructor(JSC::ExecState*, JSDOMGlobalObject*);

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    virtual const JSC::ClassInfo* classInfo() const { return &s_info; }
    static const JSC::ClassInfo s_info;
    static PassRefPtr<JSC::Structure> createStructure(JSC::JSValue prototype)
    {
        return JSC::Structure::create(prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), AnonymousSlotCount);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSSVGMatrixConstructor::s_info = { "SVGMatrixConstructor", 0, &JSSVGMatrixConstructorTable, 0 };

JSSVGMatrixConstructor::JSSVGMatrixConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(JSSVGMatrixConstructor::createStructure(globalObject->objectPrototype()), globalObject)
{
    putDirect(exec->propertyNames().prototype, JSSVGMatrixPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSSVGMatrixConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGMatrixConstructor, DOMObject>(exec, &JSSVGMatrixConstructorTable, this, propertyName, slot);
}

bool JSSVGMatrixConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGMatrixConstructor, DOMObject>(exec, &JSSVGMatrixConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSSVGMatrixPrototypeTableValues[12] =
{
    { "multiply", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsSVGMatrixPrototypeFunctionMultiply), (intptr_t)1 THUNK_GENERATOR(0) },
    { "inverse", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsSVGMatrixPrototypeFunctionInverse), (intptr_t)0 THUNK_GENERATOR(0) },
    { "translate", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsSVGMatrixPrototypeFunctionTranslate), (intptr_t)2 THUNK_GENERATOR(0) },
    { "scale", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsSVGMatrixPrototypeFunctionScale), (intptr_t)1 THUNK_GENERATOR(0) },
    { "scaleNonUniform", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsSVGMatrixPrototypeFunctionScaleNonUniform), (intptr_t)2 THUNK_GENERATOR(0) },
    { "rotate", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsSVGMatrixPrototypeFunctionRotate), (intptr_t)1 THUNK_GENERATOR(0) },
    { "rotateFromVector", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsSVGMatrixPrototypeFunctionRotateFromVector), (intptr_t)2 THUNK_GENERATOR(0) },
    { "flipX", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsSVGMatrixPrototypeFunctionFlipX), (intptr_t)0 THUNK_GENERATOR(0) },
    { "flipY", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsSVGMatrixPrototypeFunctionFlipY), (intptr_t)0 THUNK_GENERATOR(0) },
    { "skewX", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsSVGMatrixPrototypeFunctionSkewX), (intptr_t)1 THUNK_GENERATOR(0) },
    { "skewY", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsSVGMatrixPrototypeFunctionSkewY), (intptr_t)1 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSSVGMatrixPrototypeTable = { 33, 31, JSSVGMatrixPrototypeTableValues, 0 };
const ClassInfo JSSVGMatrixPrototype::s_info = { "SVGMatrixPrototype", 0, &JSSVGMatrixPrototypeTable, 0 };

JSObject* JSSVGMatrixPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGMatrix>(exec, globalObject);
}

bool JSSVGMatrixPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGMatrixPrototypeTable, this, propertyName, slot);
}

bool JSSVGMatrixPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSSVGMatrixPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSSVGMatrix::s_info = { "SVGMatrix", 0, &JSSVGMatrixTable, 0 };

JSSVGMatrix::JSSVGMatrix(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<JSSVGPODTypeWrapper<AffineTransform> > impl)
    : DOMObjectWithGlobalPointer(structure, globalObject)
    , m_impl(impl)
{
}

JSSVGMatrix::~JSSVGMatrix()
{
    forgetDOMObject(this, impl());
    JSSVGContextCache::forgetWrapper(this);
}

JSObject* JSSVGMatrix::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSSVGMatrixPrototype(globalObject, JSSVGMatrixPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSSVGMatrix::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGMatrix, Base>(exec, &JSSVGMatrixTable, this, propertyName, slot);
}

bool JSSVGMatrix::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGMatrix, Base>(exec, &JSSVGMatrixTable, this, propertyName, descriptor);
}

JSValue jsSVGMatrixA(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGMatrix* castedThis = static_cast<JSSVGMatrix*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    AffineTransform imp(*castedThis->impl());
    JSValue result =  jsNumber(exec, imp.a());
    return result;
}

JSValue jsSVGMatrixB(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGMatrix* castedThis = static_cast<JSSVGMatrix*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    AffineTransform imp(*castedThis->impl());
    JSValue result =  jsNumber(exec, imp.b());
    return result;
}

JSValue jsSVGMatrixC(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGMatrix* castedThis = static_cast<JSSVGMatrix*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    AffineTransform imp(*castedThis->impl());
    JSValue result =  jsNumber(exec, imp.c());
    return result;
}

JSValue jsSVGMatrixD(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGMatrix* castedThis = static_cast<JSSVGMatrix*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    AffineTransform imp(*castedThis->impl());
    JSValue result =  jsNumber(exec, imp.d());
    return result;
}

JSValue jsSVGMatrixE(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGMatrix* castedThis = static_cast<JSSVGMatrix*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    AffineTransform imp(*castedThis->impl());
    JSValue result =  jsNumber(exec, imp.e());
    return result;
}

JSValue jsSVGMatrixF(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGMatrix* castedThis = static_cast<JSSVGMatrix*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    AffineTransform imp(*castedThis->impl());
    JSValue result =  jsNumber(exec, imp.f());
    return result;
}

JSValue jsSVGMatrixConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGMatrix* domObject = static_cast<JSSVGMatrix*>(asObject(slotBase));
    return JSSVGMatrix::getConstructor(exec, domObject->globalObject());
}
void JSSVGMatrix::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSSVGMatrix, Base>(exec, propertyName, value, &JSSVGMatrixTable, this, slot);
}

void setJSSVGMatrixA(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSSVGMatrix* castedThis = static_cast<JSSVGMatrix*>(thisObject);
    JSSVGPODTypeWrapper<AffineTransform> * imp = static_cast<JSSVGPODTypeWrapper<AffineTransform> *>(castedThis->impl());
    AffineTransform podImp(*imp);
    podImp.setA(value.toNumber(exec));
    imp->commitChange(podImp, castedThis);
}

void setJSSVGMatrixB(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSSVGMatrix* castedThis = static_cast<JSSVGMatrix*>(thisObject);
    JSSVGPODTypeWrapper<AffineTransform> * imp = static_cast<JSSVGPODTypeWrapper<AffineTransform> *>(castedThis->impl());
    AffineTransform podImp(*imp);
    podImp.setB(value.toNumber(exec));
    imp->commitChange(podImp, castedThis);
}

void setJSSVGMatrixC(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSSVGMatrix* castedThis = static_cast<JSSVGMatrix*>(thisObject);
    JSSVGPODTypeWrapper<AffineTransform> * imp = static_cast<JSSVGPODTypeWrapper<AffineTransform> *>(castedThis->impl());
    AffineTransform podImp(*imp);
    podImp.setC(value.toNumber(exec));
    imp->commitChange(podImp, castedThis);
}

void setJSSVGMatrixD(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSSVGMatrix* castedThis = static_cast<JSSVGMatrix*>(thisObject);
    JSSVGPODTypeWrapper<AffineTransform> * imp = static_cast<JSSVGPODTypeWrapper<AffineTransform> *>(castedThis->impl());
    AffineTransform podImp(*imp);
    podImp.setD(value.toNumber(exec));
    imp->commitChange(podImp, castedThis);
}

void setJSSVGMatrixE(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSSVGMatrix* castedThis = static_cast<JSSVGMatrix*>(thisObject);
    JSSVGPODTypeWrapper<AffineTransform> * imp = static_cast<JSSVGPODTypeWrapper<AffineTransform> *>(castedThis->impl());
    AffineTransform podImp(*imp);
    podImp.setE(value.toNumber(exec));
    imp->commitChange(podImp, castedThis);
}

void setJSSVGMatrixF(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSSVGMatrix* castedThis = static_cast<JSSVGMatrix*>(thisObject);
    JSSVGPODTypeWrapper<AffineTransform> * imp = static_cast<JSSVGPODTypeWrapper<AffineTransform> *>(castedThis->impl());
    AffineTransform podImp(*imp);
    podImp.setF(value.toNumber(exec));
    imp->commitChange(podImp, castedThis);
}

JSValue JSSVGMatrix::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGMatrixConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsSVGMatrixPrototypeFunctionMultiply(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGMatrix::s_info))
        return throwVMTypeError(exec);
    JSSVGMatrix* castedThis = static_cast<JSSVGMatrix*>(asObject(thisValue));
    return JSValue::encode(castedThis->multiply(exec));
}

EncodedJSValue JSC_HOST_CALL jsSVGMatrixPrototypeFunctionInverse(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGMatrix::s_info))
        return throwVMTypeError(exec);
    JSSVGMatrix* castedThis = static_cast<JSSVGMatrix*>(asObject(thisValue));
    return JSValue::encode(castedThis->inverse(exec));
}

EncodedJSValue JSC_HOST_CALL jsSVGMatrixPrototypeFunctionTranslate(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGMatrix::s_info))
        return throwVMTypeError(exec);
    JSSVGMatrix* castedThis = static_cast<JSSVGMatrix*>(asObject(thisValue));
    JSSVGPODTypeWrapper<AffineTransform> * imp = static_cast<JSSVGPODTypeWrapper<AffineTransform> *>(castedThis->impl());
    AffineTransform podImp(*imp);
    float x = exec->argument(0).toFloat(exec);
    float y = exec->argument(1).toFloat(exec);


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), JSSVGStaticPODTypeWrapper<AffineTransform>::create(podImp.translate(x, y)).get(), 0 /* no context on purpose */);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGMatrixPrototypeFunctionScale(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGMatrix::s_info))
        return throwVMTypeError(exec);
    JSSVGMatrix* castedThis = static_cast<JSSVGMatrix*>(asObject(thisValue));
    JSSVGPODTypeWrapper<AffineTransform> * imp = static_cast<JSSVGPODTypeWrapper<AffineTransform> *>(castedThis->impl());
    AffineTransform podImp(*imp);
    float scaleFactor = exec->argument(0).toFloat(exec);


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), JSSVGStaticPODTypeWrapper<AffineTransform>::create(podImp.scale(scaleFactor)).get(), 0 /* no context on purpose */);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGMatrixPrototypeFunctionScaleNonUniform(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGMatrix::s_info))
        return throwVMTypeError(exec);
    JSSVGMatrix* castedThis = static_cast<JSSVGMatrix*>(asObject(thisValue));
    JSSVGPODTypeWrapper<AffineTransform> * imp = static_cast<JSSVGPODTypeWrapper<AffineTransform> *>(castedThis->impl());
    AffineTransform podImp(*imp);
    float scaleFactorX = exec->argument(0).toFloat(exec);
    float scaleFactorY = exec->argument(1).toFloat(exec);


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), JSSVGStaticPODTypeWrapper<AffineTransform>::create(podImp.scaleNonUniform(scaleFactorX, scaleFactorY)).get(), 0 /* no context on purpose */);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGMatrixPrototypeFunctionRotate(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGMatrix::s_info))
        return throwVMTypeError(exec);
    JSSVGMatrix* castedThis = static_cast<JSSVGMatrix*>(asObject(thisValue));
    JSSVGPODTypeWrapper<AffineTransform> * imp = static_cast<JSSVGPODTypeWrapper<AffineTransform> *>(castedThis->impl());
    AffineTransform podImp(*imp);
    float angle = exec->argument(0).toFloat(exec);


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), JSSVGStaticPODTypeWrapper<AffineTransform>::create(podImp.rotate(angle)).get(), 0 /* no context on purpose */);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGMatrixPrototypeFunctionRotateFromVector(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGMatrix::s_info))
        return throwVMTypeError(exec);
    JSSVGMatrix* castedThis = static_cast<JSSVGMatrix*>(asObject(thisValue));
    return JSValue::encode(castedThis->rotateFromVector(exec));
}

EncodedJSValue JSC_HOST_CALL jsSVGMatrixPrototypeFunctionFlipX(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGMatrix::s_info))
        return throwVMTypeError(exec);
    JSSVGMatrix* castedThis = static_cast<JSSVGMatrix*>(asObject(thisValue));
    JSSVGPODTypeWrapper<AffineTransform> * imp = static_cast<JSSVGPODTypeWrapper<AffineTransform> *>(castedThis->impl());
    AffineTransform podImp(*imp);


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), JSSVGStaticPODTypeWrapper<AffineTransform>::create(podImp.flipX()).get(), 0 /* no context on purpose */);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGMatrixPrototypeFunctionFlipY(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGMatrix::s_info))
        return throwVMTypeError(exec);
    JSSVGMatrix* castedThis = static_cast<JSSVGMatrix*>(asObject(thisValue));
    JSSVGPODTypeWrapper<AffineTransform> * imp = static_cast<JSSVGPODTypeWrapper<AffineTransform> *>(castedThis->impl());
    AffineTransform podImp(*imp);


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), JSSVGStaticPODTypeWrapper<AffineTransform>::create(podImp.flipY()).get(), 0 /* no context on purpose */);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGMatrixPrototypeFunctionSkewX(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGMatrix::s_info))
        return throwVMTypeError(exec);
    JSSVGMatrix* castedThis = static_cast<JSSVGMatrix*>(asObject(thisValue));
    JSSVGPODTypeWrapper<AffineTransform> * imp = static_cast<JSSVGPODTypeWrapper<AffineTransform> *>(castedThis->impl());
    AffineTransform podImp(*imp);
    float angle = exec->argument(0).toFloat(exec);


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), JSSVGStaticPODTypeWrapper<AffineTransform>::create(podImp.skewX(angle)).get(), 0 /* no context on purpose */);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGMatrixPrototypeFunctionSkewY(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGMatrix::s_info))
        return throwVMTypeError(exec);
    JSSVGMatrix* castedThis = static_cast<JSSVGMatrix*>(asObject(thisValue));
    JSSVGPODTypeWrapper<AffineTransform> * imp = static_cast<JSSVGPODTypeWrapper<AffineTransform> *>(castedThis->impl());
    AffineTransform podImp(*imp);
    float angle = exec->argument(0).toFloat(exec);


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), JSSVGStaticPODTypeWrapper<AffineTransform>::create(podImp.skewY(angle)).get(), 0 /* no context on purpose */);
    return JSValue::encode(result);
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, JSSVGPODTypeWrapper<AffineTransform>* object, SVGElement* context)
{
    return getDOMObjectWrapper<JSSVGMatrix, JSSVGPODTypeWrapper<AffineTransform> >(exec, globalObject, object, context);
}
AffineTransform toSVGMatrix(JSC::JSValue value)
{
    return value.inherits(&JSSVGMatrix::s_info) ? (AffineTransform) *static_cast<JSSVGMatrix*>(asObject(value))->impl() : AffineTransform();
}

}

#endif // ENABLE(SVG)
