/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCanvasRenderingContext2D.h"

#include "CanvasGradient.h"
#include "CanvasPattern.h"
#include "CanvasRenderingContext2D.h"
#include "CanvasStyle.h"
#include "ImageData.h"
#include "JSCanvasGradient.h"
#include "JSImageData.h"
#include "JSTextMetrics.h"
#include "KURL.h"
#include "PlatformString.h"
#include "TextMetrics.h"
#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSCanvasRenderingContext2D);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSCanvasRenderingContext2DTableValues[17] =
{
    { "globalAlpha", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DGlobalAlpha), (intptr_t)setJSCanvasRenderingContext2DGlobalAlpha THUNK_GENERATOR(0) },
    { "globalCompositeOperation", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DGlobalCompositeOperation), (intptr_t)setJSCanvasRenderingContext2DGlobalCompositeOperation THUNK_GENERATOR(0) },
    { "lineWidth", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DLineWidth), (intptr_t)setJSCanvasRenderingContext2DLineWidth THUNK_GENERATOR(0) },
    { "lineCap", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DLineCap), (intptr_t)setJSCanvasRenderingContext2DLineCap THUNK_GENERATOR(0) },
    { "lineJoin", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DLineJoin), (intptr_t)setJSCanvasRenderingContext2DLineJoin THUNK_GENERATOR(0) },
    { "miterLimit", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DMiterLimit), (intptr_t)setJSCanvasRenderingContext2DMiterLimit THUNK_GENERATOR(0) },
    { "shadowOffsetX", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DShadowOffsetX), (intptr_t)setJSCanvasRenderingContext2DShadowOffsetX THUNK_GENERATOR(0) },
    { "shadowOffsetY", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DShadowOffsetY), (intptr_t)setJSCanvasRenderingContext2DShadowOffsetY THUNK_GENERATOR(0) },
    { "shadowBlur", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DShadowBlur), (intptr_t)setJSCanvasRenderingContext2DShadowBlur THUNK_GENERATOR(0) },
    { "shadowColor", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DShadowColor), (intptr_t)setJSCanvasRenderingContext2DShadowColor THUNK_GENERATOR(0) },
    { "font", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DFont), (intptr_t)setJSCanvasRenderingContext2DFont THUNK_GENERATOR(0) },
    { "textAlign", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DTextAlign), (intptr_t)setJSCanvasRenderingContext2DTextAlign THUNK_GENERATOR(0) },
    { "textBaseline", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DTextBaseline), (intptr_t)setJSCanvasRenderingContext2DTextBaseline THUNK_GENERATOR(0) },
    { "strokeStyle", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DStrokeStyle), (intptr_t)setJSCanvasRenderingContext2DStrokeStyle THUNK_GENERATOR(0) },
    { "fillStyle", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DFillStyle), (intptr_t)setJSCanvasRenderingContext2DFillStyle THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSCanvasRenderingContext2DTable = { 36, 31, JSCanvasRenderingContext2DTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSCanvasRenderingContext2DConstructorTableValues[1] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSCanvasRenderingContext2DConstructorTable = { 1, 0, JSCanvasRenderingContext2DConstructorTableValues, 0 };
class JSCanvasRenderingContext2DConstructor : public DOMConstructorObject {
public:
    JSCanvasRenderingContext2DConstructor(JSC::ExecState*, JSDOMGlobalObject*);

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    virtual const JSC::ClassInfo* classInfo() const { return &s_info; }
    static const JSC::ClassInfo s_info;
    static PassRefPtr<JSC::Structure> createStructure(JSC::JSValue prototype)
    {
        return JSC::Structure::create(prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), AnonymousSlotCount);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSCanvasRenderingContext2DConstructor::s_info = { "CanvasRenderingContext2DConstructor", 0, &JSCanvasRenderingContext2DConstructorTable, 0 };

JSCanvasRenderingContext2DConstructor::JSCanvasRenderingContext2DConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(JSCanvasRenderingContext2DConstructor::createStructure(globalObject->objectPrototype()), globalObject)
{
    putDirect(exec->propertyNames().prototype, JSCanvasRenderingContext2DPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSCanvasRenderingContext2DConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCanvasRenderingContext2DConstructor, DOMObject>(exec, &JSCanvasRenderingContext2DConstructorTable, this, propertyName, slot);
}

bool JSCanvasRenderingContext2DConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSCanvasRenderingContext2DConstructor, DOMObject>(exec, &JSCanvasRenderingContext2DConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSCanvasRenderingContext2DPrototypeTableValues[45] =
{
    { "save", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionSave), (intptr_t)0 THUNK_GENERATOR(0) },
    { "restore", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionRestore), (intptr_t)0 THUNK_GENERATOR(0) },
    { "scale", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionScale), (intptr_t)2 THUNK_GENERATOR(0) },
    { "rotate", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionRotate), (intptr_t)1 THUNK_GENERATOR(0) },
    { "translate", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionTranslate), (intptr_t)2 THUNK_GENERATOR(0) },
    { "transform", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionTransform), (intptr_t)6 THUNK_GENERATOR(0) },
    { "setTransform", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionSetTransform), (intptr_t)6 THUNK_GENERATOR(0) },
    { "createLinearGradient", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionCreateLinearGradient), (intptr_t)4 THUNK_GENERATOR(0) },
    { "createRadialGradient", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionCreateRadialGradient), (intptr_t)6 THUNK_GENERATOR(0) },
    { "clearRect", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionClearRect), (intptr_t)4 THUNK_GENERATOR(0) },
    { "fillRect", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionFillRect), (intptr_t)4 THUNK_GENERATOR(0) },
    { "beginPath", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionBeginPath), (intptr_t)0 THUNK_GENERATOR(0) },
    { "closePath", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionClosePath), (intptr_t)0 THUNK_GENERATOR(0) },
    { "moveTo", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionMoveTo), (intptr_t)2 THUNK_GENERATOR(0) },
    { "lineTo", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionLineTo), (intptr_t)2 THUNK_GENERATOR(0) },
    { "quadraticCurveTo", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionQuadraticCurveTo), (intptr_t)4 THUNK_GENERATOR(0) },
    { "bezierCurveTo", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionBezierCurveTo), (intptr_t)6 THUNK_GENERATOR(0) },
    { "arcTo", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionArcTo), (intptr_t)5 THUNK_GENERATOR(0) },
    { "rect", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionRect), (intptr_t)4 THUNK_GENERATOR(0) },
    { "arc", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionArc), (intptr_t)6 THUNK_GENERATOR(0) },
    { "fill", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionFill), (intptr_t)0 THUNK_GENERATOR(0) },
    { "stroke", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionStroke), (intptr_t)0 THUNK_GENERATOR(0) },
    { "clip", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionClip), (intptr_t)0 THUNK_GENERATOR(0) },
    { "isPointInPath", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionIsPointInPath), (intptr_t)2 THUNK_GENERATOR(0) },
    { "measureText", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionMeasureText), (intptr_t)1 THUNK_GENERATOR(0) },
    { "setAlpha", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionSetAlpha), (intptr_t)1 THUNK_GENERATOR(0) },
    { "setCompositeOperation", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionSetCompositeOperation), (intptr_t)1 THUNK_GENERATOR(0) },
    { "setLineWidth", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionSetLineWidth), (intptr_t)1 THUNK_GENERATOR(0) },
    { "setLineCap", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionSetLineCap), (intptr_t)1 THUNK_GENERATOR(0) },
    { "setLineJoin", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionSetLineJoin), (intptr_t)1 THUNK_GENERATOR(0) },
    { "setMiterLimit", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionSetMiterLimit), (intptr_t)1 THUNK_GENERATOR(0) },
    { "clearShadow", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionClearShadow), (intptr_t)0 THUNK_GENERATOR(0) },
    { "fillText", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionFillText), (intptr_t)0 THUNK_GENERATOR(0) },
    { "strokeText", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionStrokeText), (intptr_t)0 THUNK_GENERATOR(0) },
    { "setStrokeColor", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionSetStrokeColor), (intptr_t)0 THUNK_GENERATOR(0) },
    { "setFillColor", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionSetFillColor), (intptr_t)0 THUNK_GENERATOR(0) },
    { "strokeRect", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionStrokeRect), (intptr_t)0 THUNK_GENERATOR(0) },
    { "drawImage", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionDrawImage), (intptr_t)0 THUNK_GENERATOR(0) },
    { "drawImageFromRect", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionDrawImageFromRect), (intptr_t)0 THUNK_GENERATOR(0) },
    { "setShadow", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionSetShadow), (intptr_t)0 THUNK_GENERATOR(0) },
    { "createPattern", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionCreatePattern), (intptr_t)0 THUNK_GENERATOR(0) },
    { "putImageData", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionPutImageData), (intptr_t)0 THUNK_GENERATOR(0) },
    { "createImageData", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionCreateImageData), (intptr_t)0 THUNK_GENERATOR(0) },
    { "getImageData", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionGetImageData), (intptr_t)4 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSCanvasRenderingContext2DPrototypeTable = { 134, 127, JSCanvasRenderingContext2DPrototypeTableValues, 0 };
const ClassInfo JSCanvasRenderingContext2DPrototype::s_info = { "CanvasRenderingContext2DPrototype", 0, &JSCanvasRenderingContext2DPrototypeTable, 0 };

JSObject* JSCanvasRenderingContext2DPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSCanvasRenderingContext2D>(exec, globalObject);
}

bool JSCanvasRenderingContext2DPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSCanvasRenderingContext2DPrototypeTable, this, propertyName, slot);
}

bool JSCanvasRenderingContext2DPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSCanvasRenderingContext2DPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSCanvasRenderingContext2D::s_info = { "CanvasRenderingContext2D", &JSCanvasRenderingContext::s_info, &JSCanvasRenderingContext2DTable, 0 };

JSCanvasRenderingContext2D::JSCanvasRenderingContext2D(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<CanvasRenderingContext2D> impl)
    : JSCanvasRenderingContext(structure, globalObject, impl)
{
}

JSObject* JSCanvasRenderingContext2D::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSCanvasRenderingContext2DPrototype(globalObject, JSCanvasRenderingContext2DPrototype::createStructure(JSCanvasRenderingContextPrototype::self(exec, globalObject)));
}

bool JSCanvasRenderingContext2D::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCanvasRenderingContext2D, Base>(exec, &JSCanvasRenderingContext2DTable, this, propertyName, slot);
}

bool JSCanvasRenderingContext2D::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSCanvasRenderingContext2D, Base>(exec, &JSCanvasRenderingContext2DTable, this, propertyName, descriptor);
}

JSValue jsCanvasRenderingContext2DGlobalAlpha(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->globalAlpha());
    return result;
}

JSValue jsCanvasRenderingContext2DGlobalCompositeOperation(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    JSValue result = jsString(exec, imp->globalCompositeOperation());
    return result;
}

JSValue jsCanvasRenderingContext2DLineWidth(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->lineWidth());
    return result;
}

JSValue jsCanvasRenderingContext2DLineCap(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    JSValue result = jsString(exec, imp->lineCap());
    return result;
}

JSValue jsCanvasRenderingContext2DLineJoin(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    JSValue result = jsString(exec, imp->lineJoin());
    return result;
}

JSValue jsCanvasRenderingContext2DMiterLimit(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->miterLimit());
    return result;
}

JSValue jsCanvasRenderingContext2DShadowOffsetX(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->shadowOffsetX());
    return result;
}

JSValue jsCanvasRenderingContext2DShadowOffsetY(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->shadowOffsetY());
    return result;
}

JSValue jsCanvasRenderingContext2DShadowBlur(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->shadowBlur());
    return result;
}

JSValue jsCanvasRenderingContext2DShadowColor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    JSValue result = jsString(exec, imp->shadowColor());
    return result;
}

JSValue jsCanvasRenderingContext2DFont(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    JSValue result = jsString(exec, imp->font());
    return result;
}

JSValue jsCanvasRenderingContext2DTextAlign(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    JSValue result = jsString(exec, imp->textAlign());
    return result;
}

JSValue jsCanvasRenderingContext2DTextBaseline(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    JSValue result = jsString(exec, imp->textBaseline());
    return result;
}

JSValue jsCanvasRenderingContext2DStrokeStyle(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(asObject(slotBase));
    return castedThis->strokeStyle(exec);
}

JSValue jsCanvasRenderingContext2DFillStyle(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(asObject(slotBase));
    return castedThis->fillStyle(exec);
}

JSValue jsCanvasRenderingContext2DConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSCanvasRenderingContext2D* domObject = static_cast<JSCanvasRenderingContext2D*>(asObject(slotBase));
    return JSCanvasRenderingContext2D::getConstructor(exec, domObject->globalObject());
}
void JSCanvasRenderingContext2D::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSCanvasRenderingContext2D, Base>(exec, propertyName, value, &JSCanvasRenderingContext2DTable, this, slot);
}

void setJSCanvasRenderingContext2DGlobalAlpha(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(thisObject);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    imp->setGlobalAlpha(value.toFloat(exec));
}

void setJSCanvasRenderingContext2DGlobalCompositeOperation(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(thisObject);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    imp->setGlobalCompositeOperation(valueToStringWithNullCheck(exec, value));
}

void setJSCanvasRenderingContext2DLineWidth(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(thisObject);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    imp->setLineWidth(value.toFloat(exec));
}

void setJSCanvasRenderingContext2DLineCap(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(thisObject);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    imp->setLineCap(valueToStringWithNullCheck(exec, value));
}

void setJSCanvasRenderingContext2DLineJoin(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(thisObject);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    imp->setLineJoin(valueToStringWithNullCheck(exec, value));
}

void setJSCanvasRenderingContext2DMiterLimit(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(thisObject);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    imp->setMiterLimit(value.toFloat(exec));
}

void setJSCanvasRenderingContext2DShadowOffsetX(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(thisObject);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    imp->setShadowOffsetX(value.toFloat(exec));
}

void setJSCanvasRenderingContext2DShadowOffsetY(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(thisObject);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    imp->setShadowOffsetY(value.toFloat(exec));
}

void setJSCanvasRenderingContext2DShadowBlur(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(thisObject);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    imp->setShadowBlur(value.toFloat(exec));
}

void setJSCanvasRenderingContext2DShadowColor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(thisObject);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    imp->setShadowColor(valueToStringWithNullCheck(exec, value));
}

void setJSCanvasRenderingContext2DFont(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(thisObject);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    imp->setFont(ustringToString(value.toString(exec)));
}

void setJSCanvasRenderingContext2DTextAlign(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(thisObject);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    imp->setTextAlign(ustringToString(value.toString(exec)));
}

void setJSCanvasRenderingContext2DTextBaseline(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(thisObject);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    imp->setTextBaseline(ustringToString(value.toString(exec)));
}

void setJSCanvasRenderingContext2DStrokeStyle(ExecState* exec, JSObject* thisObject, JSValue value)
{
    static_cast<JSCanvasRenderingContext2D*>(thisObject)->setStrokeStyle(exec, value);
}

void setJSCanvasRenderingContext2DFillStyle(ExecState* exec, JSObject* thisObject, JSValue value)
{
    static_cast<JSCanvasRenderingContext2D*>(thisObject)->setFillStyle(exec, value);
}

JSValue JSCanvasRenderingContext2D::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCanvasRenderingContext2DConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSave(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThis->impl());

    imp->save();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionRestore(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThis->impl());

    imp->restore();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionScale(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    float sx = exec->argument(0).toFloat(exec);
    float sy = exec->argument(1).toFloat(exec);

    imp->scale(sx, sy);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionRotate(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    float angle = exec->argument(0).toFloat(exec);

    imp->rotate(angle);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionTranslate(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    float tx = exec->argument(0).toFloat(exec);
    float ty = exec->argument(1).toFloat(exec);

    imp->translate(tx, ty);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionTransform(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    float m11 = exec->argument(0).toFloat(exec);
    float m12 = exec->argument(1).toFloat(exec);
    float m21 = exec->argument(2).toFloat(exec);
    float m22 = exec->argument(3).toFloat(exec);
    float dx = exec->argument(4).toFloat(exec);
    float dy = exec->argument(5).toFloat(exec);

    imp->transform(m11, m12, m21, m22, dx, dy);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetTransform(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    float m11 = exec->argument(0).toFloat(exec);
    float m12 = exec->argument(1).toFloat(exec);
    float m21 = exec->argument(2).toFloat(exec);
    float m22 = exec->argument(3).toFloat(exec);
    float dx = exec->argument(4).toFloat(exec);
    float dy = exec->argument(5).toFloat(exec);

    imp->setTransform(m11, m12, m21, m22, dx, dy);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionCreateLinearGradient(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    ExceptionCode ec = 0;
    float x0 = exec->argument(0).toFloat(exec);
    float y0 = exec->argument(1).toFloat(exec);
    float x1 = exec->argument(2).toFloat(exec);
    float y1 = exec->argument(3).toFloat(exec);


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->createLinearGradient(x0, y0, x1, y1, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionCreateRadialGradient(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    ExceptionCode ec = 0;
    float x0 = exec->argument(0).toFloat(exec);
    float y0 = exec->argument(1).toFloat(exec);
    float r0 = exec->argument(2).toFloat(exec);
    float x1 = exec->argument(3).toFloat(exec);
    float y1 = exec->argument(4).toFloat(exec);
    float r1 = exec->argument(5).toFloat(exec);


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->createRadialGradient(x0, y0, r0, x1, y1, r1, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionClearRect(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    float x = exec->argument(0).toFloat(exec);
    float y = exec->argument(1).toFloat(exec);
    float width = exec->argument(2).toFloat(exec);
    float height = exec->argument(3).toFloat(exec);

    imp->clearRect(x, y, width, height);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionFillRect(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    float x = exec->argument(0).toFloat(exec);
    float y = exec->argument(1).toFloat(exec);
    float width = exec->argument(2).toFloat(exec);
    float height = exec->argument(3).toFloat(exec);

    imp->fillRect(x, y, width, height);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionBeginPath(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThis->impl());

    imp->beginPath();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionClosePath(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThis->impl());

    imp->closePath();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionMoveTo(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    float x = exec->argument(0).toFloat(exec);
    float y = exec->argument(1).toFloat(exec);

    imp->moveTo(x, y);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionLineTo(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    float x = exec->argument(0).toFloat(exec);
    float y = exec->argument(1).toFloat(exec);

    imp->lineTo(x, y);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionQuadraticCurveTo(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    float cpx = exec->argument(0).toFloat(exec);
    float cpy = exec->argument(1).toFloat(exec);
    float x = exec->argument(2).toFloat(exec);
    float y = exec->argument(3).toFloat(exec);

    imp->quadraticCurveTo(cpx, cpy, x, y);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionBezierCurveTo(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    float cp1x = exec->argument(0).toFloat(exec);
    float cp1y = exec->argument(1).toFloat(exec);
    float cp2x = exec->argument(2).toFloat(exec);
    float cp2y = exec->argument(3).toFloat(exec);
    float x = exec->argument(4).toFloat(exec);
    float y = exec->argument(5).toFloat(exec);

    imp->bezierCurveTo(cp1x, cp1y, cp2x, cp2y, x, y);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionArcTo(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    ExceptionCode ec = 0;
    float x1 = exec->argument(0).toFloat(exec);
    float y1 = exec->argument(1).toFloat(exec);
    float x2 = exec->argument(2).toFloat(exec);
    float y2 = exec->argument(3).toFloat(exec);
    float radius = exec->argument(4).toFloat(exec);

    imp->arcTo(x1, y1, x2, y2, radius, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionRect(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    float x = exec->argument(0).toFloat(exec);
    float y = exec->argument(1).toFloat(exec);
    float width = exec->argument(2).toFloat(exec);
    float height = exec->argument(3).toFloat(exec);

    imp->rect(x, y, width, height);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionArc(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    ExceptionCode ec = 0;
    float x = exec->argument(0).toFloat(exec);
    float y = exec->argument(1).toFloat(exec);
    float radius = exec->argument(2).toFloat(exec);
    float startAngle = exec->argument(3).toFloat(exec);
    float endAngle = exec->argument(4).toFloat(exec);
    bool anticlockwise = exec->argument(5).toBoolean(exec);

    imp->arc(x, y, radius, startAngle, endAngle, anticlockwise, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionFill(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThis->impl());

    imp->fill();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionStroke(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThis->impl());

    imp->stroke();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionClip(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThis->impl());

    imp->clip();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionIsPointInPath(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    float x = exec->argument(0).toFloat(exec);
    float y = exec->argument(1).toFloat(exec);


    JSC::JSValue result = jsBoolean(imp->isPointInPath(x, y));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionMeasureText(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    const String& text = ustringToString(exec->argument(0).toString(exec));


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->measureText(text)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetAlpha(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    float alpha = exec->argument(0).toFloat(exec);

    imp->setAlpha(alpha);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetCompositeOperation(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    const String& compositeOperation = ustringToString(exec->argument(0).toString(exec));

    imp->setCompositeOperation(compositeOperation);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetLineWidth(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    float width = exec->argument(0).toFloat(exec);

    imp->setLineWidth(width);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetLineCap(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    const String& cap = ustringToString(exec->argument(0).toString(exec));

    imp->setLineCap(cap);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetLineJoin(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    const String& join = ustringToString(exec->argument(0).toString(exec));

    imp->setLineJoin(join);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetMiterLimit(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    float limit = exec->argument(0).toFloat(exec);

    imp->setMiterLimit(limit);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionClearShadow(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThis->impl());

    imp->clearShadow();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionFillText(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    return JSValue::encode(castedThis->fillText(exec));
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionStrokeText(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    return JSValue::encode(castedThis->strokeText(exec));
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetStrokeColor(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    return JSValue::encode(castedThis->setStrokeColor(exec));
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetFillColor(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    return JSValue::encode(castedThis->setFillColor(exec));
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionStrokeRect(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    return JSValue::encode(castedThis->strokeRect(exec));
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionDrawImage(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    return JSValue::encode(castedThis->drawImage(exec));
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionDrawImageFromRect(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    return JSValue::encode(castedThis->drawImageFromRect(exec));
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetShadow(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    return JSValue::encode(castedThis->setShadow(exec));
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionCreatePattern(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    return JSValue::encode(castedThis->createPattern(exec));
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionPutImageData(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    return JSValue::encode(castedThis->putImageData(exec));
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionCreateImageData(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    return JSValue::encode(castedThis->createImageData(exec));
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionGetImageData(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    ExceptionCode ec = 0;
    float sx = exec->argument(0).toFloat(exec);
    float sy = exec->argument(1).toFloat(exec);
    float sw = exec->argument(2).toFloat(exec);
    float sh = exec->argument(3).toFloat(exec);


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->getImageData(sx, sy, sw, sh, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}


}
