/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(TRANSFORMACTION_EVENTS)

#include "JSTransformActionEvent.h"

#include "JSDOMWindow.h"
#include "TransformActionEvent.h"
#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSTransformActionEvent);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSTransformActionEventTableValues[20] =
{
    { "screenX", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTransformActionEventScreenX), (intptr_t)0 THUNK_GENERATOR(0) },
    { "screenY", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTransformActionEventScreenY), (intptr_t)0 THUNK_GENERATOR(0) },
    { "clientX", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTransformActionEventClientX), (intptr_t)0 THUNK_GENERATOR(0) },
    { "clientY", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTransformActionEventClientY), (intptr_t)0 THUNK_GENERATOR(0) },
    { "offsetX", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTransformActionEventOffsetX), (intptr_t)0 THUNK_GENERATOR(0) },
    { "offsetY", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTransformActionEventOffsetY), (intptr_t)0 THUNK_GENERATOR(0) },
    { "ctrlKey", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTransformActionEventCtrlKey), (intptr_t)0 THUNK_GENERATOR(0) },
    { "altKey", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTransformActionEventAltKey), (intptr_t)0 THUNK_GENERATOR(0) },
    { "shiftKey", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTransformActionEventShiftKey), (intptr_t)0 THUNK_GENERATOR(0) },
    { "metaKey", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTransformActionEventMetaKey), (intptr_t)0 THUNK_GENERATOR(0) },
    { "translateX", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTransformActionEventTranslateX), (intptr_t)0 THUNK_GENERATOR(0) },
    { "translateY", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTransformActionEventTranslateY), (intptr_t)0 THUNK_GENERATOR(0) },
    { "translateSpeedX", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTransformActionEventTranslateSpeedX), (intptr_t)0 THUNK_GENERATOR(0) },
    { "translateSpeedY", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTransformActionEventTranslateSpeedY), (intptr_t)0 THUNK_GENERATOR(0) },
    { "scale", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTransformActionEventScale), (intptr_t)0 THUNK_GENERATOR(0) },
    { "scaleSpeed", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTransformActionEventScaleSpeed), (intptr_t)0 THUNK_GENERATOR(0) },
    { "rotate", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTransformActionEventRotate), (intptr_t)0 THUNK_GENERATOR(0) },
    { "rotateSpeed", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTransformActionEventRotateSpeed), (intptr_t)0 THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTransformActionEventConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSTransformActionEventTable = { 68, 63, JSTransformActionEventTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSTransformActionEventConstructorTableValues[1] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSTransformActionEventConstructorTable = { 1, 0, JSTransformActionEventConstructorTableValues, 0 };
class JSTransformActionEventConstructor : public DOMConstructorObject {
public:
    JSTransformActionEventConstructor(JSC::ExecState*, JSDOMGlobalObject*);

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    virtual const JSC::ClassInfo* classInfo() const { return &s_info; }
    static const JSC::ClassInfo s_info;
    static PassRefPtr<JSC::Structure> createStructure(JSC::JSValue prototype)
    {
        return JSC::Structure::create(prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), AnonymousSlotCount);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSTransformActionEventConstructor::s_info = { "TransformActionEventConstructor", 0, &JSTransformActionEventConstructorTable, 0 };

JSTransformActionEventConstructor::JSTransformActionEventConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(JSTransformActionEventConstructor::createStructure(globalObject->objectPrototype()), globalObject)
{
    putDirect(exec->propertyNames().prototype, JSTransformActionEventPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSTransformActionEventConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSTransformActionEventConstructor, DOMObject>(exec, &JSTransformActionEventConstructorTable, this, propertyName, slot);
}

bool JSTransformActionEventConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSTransformActionEventConstructor, DOMObject>(exec, &JSTransformActionEventConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSTransformActionEventPrototypeTableValues[2] =
{
    { "initTransformActionEvent", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsTransformActionEventPrototypeFunctionInitTransformActionEvent), (intptr_t)20 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSTransformActionEventPrototypeTable = { 2, 1, JSTransformActionEventPrototypeTableValues, 0 };
const ClassInfo JSTransformActionEventPrototype::s_info = { "TransformActionEventPrototype", 0, &JSTransformActionEventPrototypeTable, 0 };

JSObject* JSTransformActionEventPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSTransformActionEvent>(exec, globalObject);
}

bool JSTransformActionEventPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSTransformActionEventPrototypeTable, this, propertyName, slot);
}

bool JSTransformActionEventPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSTransformActionEventPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSTransformActionEvent::s_info = { "TransformActionEvent", &JSUIEvent::s_info, &JSTransformActionEventTable, 0 };

JSTransformActionEvent::JSTransformActionEvent(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<TransformActionEvent> impl)
    : JSUIEvent(structure, globalObject, impl)
{
}

JSObject* JSTransformActionEvent::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSTransformActionEventPrototype(globalObject, JSTransformActionEventPrototype::createStructure(JSUIEventPrototype::self(exec, globalObject)));
}

bool JSTransformActionEvent::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSTransformActionEvent, Base>(exec, &JSTransformActionEventTable, this, propertyName, slot);
}

bool JSTransformActionEvent::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSTransformActionEvent, Base>(exec, &JSTransformActionEventTable, this, propertyName, descriptor);
}

JSValue jsTransformActionEventScreenX(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSTransformActionEvent* castedThis = static_cast<JSTransformActionEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    TransformActionEvent* imp = static_cast<TransformActionEvent*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->screenX());
    return result;
}

JSValue jsTransformActionEventScreenY(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSTransformActionEvent* castedThis = static_cast<JSTransformActionEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    TransformActionEvent* imp = static_cast<TransformActionEvent*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->screenY());
    return result;
}

JSValue jsTransformActionEventClientX(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSTransformActionEvent* castedThis = static_cast<JSTransformActionEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    TransformActionEvent* imp = static_cast<TransformActionEvent*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->clientX());
    return result;
}

JSValue jsTransformActionEventClientY(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSTransformActionEvent* castedThis = static_cast<JSTransformActionEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    TransformActionEvent* imp = static_cast<TransformActionEvent*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->clientY());
    return result;
}

JSValue jsTransformActionEventOffsetX(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSTransformActionEvent* castedThis = static_cast<JSTransformActionEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    TransformActionEvent* imp = static_cast<TransformActionEvent*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->offsetX());
    return result;
}

JSValue jsTransformActionEventOffsetY(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSTransformActionEvent* castedThis = static_cast<JSTransformActionEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    TransformActionEvent* imp = static_cast<TransformActionEvent*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->offsetY());
    return result;
}

JSValue jsTransformActionEventCtrlKey(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSTransformActionEvent* castedThis = static_cast<JSTransformActionEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    TransformActionEvent* imp = static_cast<TransformActionEvent*>(castedThis->impl());
    JSValue result = jsBoolean(imp->ctrlKey());
    return result;
}

JSValue jsTransformActionEventAltKey(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSTransformActionEvent* castedThis = static_cast<JSTransformActionEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    TransformActionEvent* imp = static_cast<TransformActionEvent*>(castedThis->impl());
    JSValue result = jsBoolean(imp->altKey());
    return result;
}

JSValue jsTransformActionEventShiftKey(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSTransformActionEvent* castedThis = static_cast<JSTransformActionEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    TransformActionEvent* imp = static_cast<TransformActionEvent*>(castedThis->impl());
    JSValue result = jsBoolean(imp->shiftKey());
    return result;
}

JSValue jsTransformActionEventMetaKey(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSTransformActionEvent* castedThis = static_cast<JSTransformActionEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    TransformActionEvent* imp = static_cast<TransformActionEvent*>(castedThis->impl());
    JSValue result = jsBoolean(imp->metaKey());
    return result;
}

JSValue jsTransformActionEventTranslateX(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSTransformActionEvent* castedThis = static_cast<JSTransformActionEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    TransformActionEvent* imp = static_cast<TransformActionEvent*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->translateX());
    return result;
}

JSValue jsTransformActionEventTranslateY(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSTransformActionEvent* castedThis = static_cast<JSTransformActionEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    TransformActionEvent* imp = static_cast<TransformActionEvent*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->translateY());
    return result;
}

JSValue jsTransformActionEventTranslateSpeedX(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSTransformActionEvent* castedThis = static_cast<JSTransformActionEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    TransformActionEvent* imp = static_cast<TransformActionEvent*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->translateSpeedX());
    return result;
}

JSValue jsTransformActionEventTranslateSpeedY(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSTransformActionEvent* castedThis = static_cast<JSTransformActionEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    TransformActionEvent* imp = static_cast<TransformActionEvent*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->translateSpeedY());
    return result;
}

JSValue jsTransformActionEventScale(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSTransformActionEvent* castedThis = static_cast<JSTransformActionEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    TransformActionEvent* imp = static_cast<TransformActionEvent*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->scale());
    return result;
}

JSValue jsTransformActionEventScaleSpeed(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSTransformActionEvent* castedThis = static_cast<JSTransformActionEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    TransformActionEvent* imp = static_cast<TransformActionEvent*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->scaleSpeed());
    return result;
}

JSValue jsTransformActionEventRotate(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSTransformActionEvent* castedThis = static_cast<JSTransformActionEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    TransformActionEvent* imp = static_cast<TransformActionEvent*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->rotate());
    return result;
}

JSValue jsTransformActionEventRotateSpeed(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSTransformActionEvent* castedThis = static_cast<JSTransformActionEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    TransformActionEvent* imp = static_cast<TransformActionEvent*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->rotateSpeed());
    return result;
}

JSValue jsTransformActionEventConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSTransformActionEvent* domObject = static_cast<JSTransformActionEvent*>(asObject(slotBase));
    return JSTransformActionEvent::getConstructor(exec, domObject->globalObject());
}
JSValue JSTransformActionEvent::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSTransformActionEventConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsTransformActionEventPrototypeFunctionInitTransformActionEvent(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSTransformActionEvent::s_info))
        return throwVMTypeError(exec);
    JSTransformActionEvent* castedThis = static_cast<JSTransformActionEvent*>(asObject(thisValue));
    TransformActionEvent* imp = static_cast<TransformActionEvent*>(castedThis->impl());
    const String& type = ustringToString(exec->argument(0).toString(exec));
    bool canBubble = exec->argument(1).toBoolean(exec);
    bool cancelable = exec->argument(2).toBoolean(exec);
    DOMWindow* view = toDOMWindow(exec->argument(3));
    int screenX = exec->argument(4).toInt32(exec);
    int screenY = exec->argument(5).toInt32(exec);
    int clientX = exec->argument(6).toInt32(exec);
    int clientY = exec->argument(7).toInt32(exec);
    bool ctrlKey = exec->argument(8).toBoolean(exec);
    bool altKey = exec->argument(9).toBoolean(exec);
    bool shiftKey = exec->argument(10).toBoolean(exec);
    bool metaKey = exec->argument(11).toBoolean(exec);
    int translateX = exec->argument(12).toInt32(exec);
    int translateY = exec->argument(13).toInt32(exec);
    int translateSpeedX = exec->argument(14).toInt32(exec);
    int translateSpeedY = exec->argument(15).toInt32(exec);
    float scale = exec->argument(16).toFloat(exec);
    float scaleSpeed = exec->argument(17).toFloat(exec);
    float rotate = exec->argument(18).toFloat(exec);
    float rotateSpeed = exec->argument(19).toFloat(exec);

    imp->initTransformActionEvent(type, canBubble, cancelable, view, screenX, screenY, clientX, clientY, ctrlKey, altKey, shiftKey, metaKey, translateX, translateY, translateSpeedX, translateSpeedY, scale, scaleSpeed, rotate, rotateSpeed);
    return JSValue::encode(jsUndefined());
}


}

#endif // ENABLE(TRANSFORMACTION_EVENTS)
