/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef JSDOMWindow_h
#define JSDOMWindow_h

#include "DOMWindow.h"
#include "JSDOMWindowBase.h"
#include <runtime/JSObjectWithGlobalObject.h>

namespace WebCore {

class DOMWindow;

class JSDOMWindowShell;

class JSDOMWindow : public JSDOMWindowBase {
    typedef JSDOMWindowBase Base;
public:
    JSDOMWindow(NonNullPassRefPtr<JSC::Structure>, PassRefPtr<DOMWindow>, JSDOMWindowShell*);
    virtual ~JSDOMWindow();
    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier& propertyName, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier& propertyName, JSC::PropertyDescriptor&);
    virtual void put(JSC::ExecState*, const JSC::Identifier& propertyName, JSC::JSValue, JSC::PutPropertySlot&);
    virtual const JSC::ClassInfo* classInfo() const { return &s_info; }
    static const JSC::ClassInfo s_info;

    static PassRefPtr<JSC::Structure> createStructure(JSC::JSValue prototype)
    {
        return JSC::Structure::create(prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), AnonymousSlotCount);
    }

    virtual void markChildren(JSC::MarkStack&);

    virtual bool deleteProperty(JSC::ExecState*, const JSC::Identifier&);
    virtual void getPropertyNames(JSC::ExecState*, JSC::PropertyNameArray&, JSC::EnumerationMode mode = JSC::ExcludeDontEnumProperties);
    virtual bool defineOwnProperty(JSC::ExecState*, const JSC::Identifier& propertyName, JSC::PropertyDescriptor&, bool shouldThrow);
    virtual void getOwnPropertyNames(JSC::ExecState*, JSC::PropertyNameArray&, JSC::EnumerationMode mode = JSC::ExcludeDontEnumProperties);
    virtual void defineGetter(JSC::ExecState*, const JSC::Identifier& propertyName, JSC::JSObject* getterFunction, unsigned attributes);
    virtual void defineSetter(JSC::ExecState*, const JSC::Identifier& propertyName, JSC::JSObject* setterFunction, unsigned attributes);
    virtual JSC::JSValue lookupGetter(JSC::ExecState*, const JSC::Identifier& propertyName);
    virtual JSC::JSValue lookupSetter(JSC::ExecState*, const JSC::Identifier& propertyName);

    // Custom attributes
    JSC::JSValue history(JSC::ExecState*) const;
    JSC::JSValue location(JSC::ExecState*) const;
    void setLocation(JSC::ExecState*, JSC::JSValue);
    JSC::JSValue event(JSC::ExecState*) const;
    JSC::JSValue crypto(JSC::ExecState*) const;
    JSC::JSValue image(JSC::ExecState*) const;
    JSC::JSValue option(JSC::ExecState*) const;
    JSC::JSValue arrayBuffer(JSC::ExecState*) const;
    JSC::JSValue int8Array(JSC::ExecState*) const;
    JSC::JSValue uint8Array(JSC::ExecState*) const;
    JSC::JSValue int16Array(JSC::ExecState*) const;
    JSC::JSValue uint16Array(JSC::ExecState*) const;
    JSC::JSValue int32Array(JSC::ExecState*) const;
    JSC::JSValue uint32Array(JSC::ExecState*) const;
    JSC::JSValue float32Array(JSC::ExecState*) const;
    JSC::JSValue webGLArrayBuffer(JSC::ExecState*) const;
    JSC::JSValue webGLByteArray(JSC::ExecState*) const;
    JSC::JSValue webGLUnsignedByteArray(JSC::ExecState*) const;
    JSC::JSValue webGLShortArray(JSC::ExecState*) const;
    JSC::JSValue webGLUnsignedShortArray(JSC::ExecState*) const;
    JSC::JSValue webGLIntArray(JSC::ExecState*) const;
    JSC::JSValue webGLUnsignedIntArray(JSC::ExecState*) const;
    JSC::JSValue webGLFloatArray(JSC::ExecState*) const;
    JSC::JSValue webKitCSSMatrix(JSC::ExecState*) const;
    JSC::JSValue webKitPoint(JSC::ExecState*) const;
    JSC::JSValue eventSource(JSC::ExecState*) const;
    JSC::JSValue xmlHttpRequest(JSC::ExecState*) const;
    JSC::JSValue xsltProcessor(JSC::ExecState*) const;
    JSC::JSValue messageChannel(JSC::ExecState*) const;
    JSC::JSValue worker(JSC::ExecState*) const;
    JSC::JSValue sharedWorker(JSC::ExecState*) const;
    JSC::JSValue webSocket(JSC::ExecState*) const;
    JSC::JSValue audio(JSC::ExecState*) const;

    // Custom functions
    JSC::JSValue open(JSC::ExecState*);
    JSC::JSValue showModalDialog(JSC::ExecState*);
    JSC::JSValue openDatabase(JSC::ExecState*);
    JSC::JSValue postMessage(JSC::ExecState*);
    JSC::JSValue setTimeout(JSC::ExecState*);
    JSC::JSValue setInterval(JSC::ExecState*);
    JSC::JSValue addEventListener(JSC::ExecState*);
    JSC::JSValue removeEventListener(JSC::ExecState*);
    DOMWindow* impl() const
    {
        return static_cast<DOMWindow*>(Base::impl());
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesMarkChildren | JSC::OverridesGetPropertyNames | JSC::ImplementsHasInstance | JSC::NeedsThisConversion | JSC::OverridesGetOwnPropertySlot | Base::StructureFlags;
};

DOMWindow* toDOMWindow(JSC::JSValue);

class JSDOMWindowPrototype : public JSC::JSObjectWithGlobalObject {
    typedef JSC::JSObjectWithGlobalObject Base;
public:
    void* operator new(size_t);
    virtual const JSC::ClassInfo* classInfo() const { return &s_info; }
    static const JSC::ClassInfo s_info;
    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static PassRefPtr<JSC::Structure> createStructure(JSC::JSValue prototype)
    {
        return JSC::Structure::create(prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), AnonymousSlotCount);
    }
    JSDOMWindowPrototype(JSC::JSGlobalObject* globalObject, NonNullPassRefPtr<JSC::Structure> structure) : JSC::JSObjectWithGlobalObject(globalObject, structure) { }
protected:
    static const unsigned StructureFlags = JSC::OverridesMarkChildren | JSC::OverridesGetOwnPropertySlot | Base::StructureFlags;
};

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionGetSelection(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionFocus(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionBlur(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionClose(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionPrint(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionStop(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionOpen(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionShowModalDialog(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionAlert(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionConfirm(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionPrompt(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionFind(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionScrollBy(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionScrollTo(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionScroll(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionMoveBy(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionMoveTo(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionResizeBy(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionResizeTo(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionGetComputedStyle(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionGetMatchedCSSRules(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionWebkitConvertPointFromPageToNode(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionWebkitConvertPointFromNodeToPage(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionOpenDatabase(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionPostMessage(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionSetTimeout(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionClearTimeout(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionSetInterval(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionClearInterval(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionAtob(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionBtoa(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionAddEventListener(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionRemoveEventListener(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionDispatchEvent(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionCaptureEvents(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionReleaseEvents(JSC::ExecState*);
// Attributes

JSC::JSValue jsDOMWindowScreen(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsDOMWindowHistory(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsDOMWindowLocationbar(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowLocationbar(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowMenubar(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowMenubar(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowPersonalbar(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowPersonalbar(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowScrollbars(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowScrollbars(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowStatusbar(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowStatusbar(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowToolbar(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowToolbar(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowNavigator(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowNavigator(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowClientInformation(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowClientInformation(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowLocation(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowLocation(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowEvent(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowEvent(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowCrypto(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsDOMWindowFrameElement(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsDOMWindowOffscreenBuffering(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOffscreenBuffering(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOuterHeight(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOuterHeight(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOuterWidth(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOuterWidth(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowInnerHeight(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowInnerHeight(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowInnerWidth(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowInnerWidth(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowScreenX(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowScreenX(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowScreenY(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowScreenY(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowScreenLeft(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowScreenLeft(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowScreenTop(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowScreenTop(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowScrollX(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowScrollX(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowScrollY(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowScrollY(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowPageXOffset(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsDOMWindowPageYOffset(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsDOMWindowClosed(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsDOMWindowLength(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowLength(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowName(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowName(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowStatus(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowStatus(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowDefaultStatus(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowDefaultStatus(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowDefaultstatus(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowDefaultstatus(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSelf(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSelf(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowWindow(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsDOMWindowFrames(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowFrames(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOpener(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOpener(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowParent(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowParent(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowTop(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowTop(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowDocument(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsDOMWindowStyleMedia(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsDOMWindowDevicePixelRatio(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowDevicePixelRatio(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowApplicationCache(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsDOMWindowSessionStorage(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsDOMWindowLocalStorage(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsDOMWindowWebkitNotifications(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsDOMWindowConsole(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowConsole(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnabort(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOnabort(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnbeforeunload(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOnbeforeunload(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnblur(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOnblur(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOncanplay(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOncanplay(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOncanplaythrough(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOncanplaythrough(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnchange(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOnchange(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnclick(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOnclick(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOncontextmenu(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOncontextmenu(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOndblclick(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOndblclick(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOndrag(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOndrag(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOndragend(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOndragend(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOndragenter(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOndragenter(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOndragleave(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOndragleave(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOndragover(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOndragover(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOndragstart(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOndragstart(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOndrop(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOndrop(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOndurationchange(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOndurationchange(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnemptied(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOnemptied(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnended(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOnended(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnerror(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOnerror(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnfocus(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOnfocus(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnhashchange(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOnhashchange(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOninput(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOninput(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOninvalid(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOninvalid(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnkeydown(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOnkeydown(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnkeypress(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOnkeypress(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnkeyup(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOnkeyup(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnload(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOnload(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnloadeddata(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOnloadeddata(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnloadedmetadata(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOnloadedmetadata(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnloadstart(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOnloadstart(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnmessage(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOnmessage(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnmousedown(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOnmousedown(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnmousemove(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOnmousemove(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnmouseout(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOnmouseout(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnmouseover(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOnmouseover(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnmouseup(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOnmouseup(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnmousewheel(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOnmousewheel(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnoffline(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOnoffline(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnonline(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOnonline(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnpagehide(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOnpagehide(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnpageshow(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOnpageshow(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnpause(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOnpause(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnplay(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOnplay(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnplaying(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOnplaying(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnpopstate(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOnpopstate(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnprogress(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOnprogress(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnratechange(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOnratechange(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnresize(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOnresize(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnscroll(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOnscroll(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnseeked(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOnseeked(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnseeking(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOnseeking(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnselect(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOnselect(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnstalled(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOnstalled(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnstorage(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOnstorage(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnsubmit(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOnsubmit(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnsuspend(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOnsuspend(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOntimeupdate(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOntimeupdate(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnunload(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOnunload(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnvolumechange(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOnvolumechange(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnwaiting(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOnwaiting(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnreset(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOnreset(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnsearch(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOnsearch(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnwebkitanimationend(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOnwebkitanimationend(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnwebkitanimationiteration(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOnwebkitanimationiteration(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnwebkitanimationstart(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOnwebkitanimationstart(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnwebkittransitionend(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOnwebkittransitionend(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOntouchstart(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOntouchstart(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOntouchmove(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOntouchmove(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOntouchend(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOntouchend(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOntouchcancel(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOntouchcancel(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOntransformactionstart(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOntransformactionstart(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOntransformactionupdate(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOntransformactionupdate(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOntransformactionend(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOntransformactionend(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowDeviceOrientationEventConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowDeviceOrientationEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOndeviceorientation(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOndeviceorientation(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowStyleSheetConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowStyleSheetConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowCSSStyleSheetConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowCSSStyleSheetConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowCSSValueConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowCSSValueConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowCSSPrimitiveValueConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowCSSPrimitiveValueConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowCSSValueListConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowCSSValueListConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowWebKitCSSTransformValueConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowWebKitCSSTransformValueConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowCSSRuleConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowCSSRuleConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowCSSCharsetRuleConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowCSSCharsetRuleConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowCSSFontFaceRuleConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowCSSFontFaceRuleConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowCSSImportRuleConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowCSSImportRuleConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowCSSMediaRuleConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowCSSMediaRuleConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowCSSPageRuleConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowCSSPageRuleConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowCSSStyleRuleConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowCSSStyleRuleConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowCSSVariablesRuleConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowCSSVariablesRuleConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowCSSVariablesDeclarationConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowCSSVariablesDeclarationConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowCSSStyleDeclarationConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowCSSStyleDeclarationConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowMediaListConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowMediaListConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowCounterConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowCounterConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowCSSRuleListConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowCSSRuleListConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowRectConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowRectConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowRGBColorConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowRGBColorConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowStyleSheetListConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowStyleSheetListConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowDOMExceptionConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowDOMExceptionConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowDOMStringListConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowDOMStringListConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowDOMImplementationConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowDOMImplementationConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowDocumentFragmentConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowDocumentFragmentConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowDocumentConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowDocumentConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowNodeConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowNodeConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowNodeListConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowNodeListConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowNamedNodeMapConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowNamedNodeMapConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowCharacterDataConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowCharacterDataConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowAttrConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowAttrConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowTextConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowTextConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowCommentConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowCommentConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowCDATASectionConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowCDATASectionConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowDocumentTypeConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowDocumentTypeConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowNotationConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowNotationConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowEntityConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowEntityConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowEntityReferenceConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowEntityReferenceConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowProcessingInstructionConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowProcessingInstructionConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLDocumentConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowHTMLDocumentConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowHTMLElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLAnchorElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowHTMLAnchorElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLAppletElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowHTMLAppletElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLAreaElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowHTMLAreaElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLBRElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowHTMLBRElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLBaseElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowHTMLBaseElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLBaseFontElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowHTMLBaseFontElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLBlockquoteElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowHTMLBlockquoteElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLBodyElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowHTMLBodyElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLButtonElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowHTMLButtonElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLCanvasElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowHTMLCanvasElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLDataGridElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowHTMLDataGridElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLDataGridCellElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowHTMLDataGridCellElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLDataGridColElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowHTMLDataGridColElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLDListElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowHTMLDListElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLDirectoryElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowHTMLDirectoryElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLDivElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowHTMLDivElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLEmbedElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowHTMLEmbedElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLFieldSetElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowHTMLFieldSetElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLFontElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowHTMLFontElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLFormElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowHTMLFormElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLFrameElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowHTMLFrameElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLFrameSetElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowHTMLFrameSetElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLHRElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowHTMLHRElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLHeadElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowHTMLHeadElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLHeadingElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowHTMLHeadingElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLHtmlElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowHTMLHtmlElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLIFrameElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowHTMLIFrameElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLImageElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowHTMLImageElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLInputElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowHTMLInputElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLIsIndexElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowHTMLIsIndexElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLLIElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowHTMLLIElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLLabelElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowHTMLLabelElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLLegendElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowHTMLLegendElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLLinkElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowHTMLLinkElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLMapElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowHTMLMapElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLMarqueeElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowHTMLMarqueeElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLMenuElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowHTMLMenuElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLMetaElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowHTMLMetaElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLMeterElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowHTMLMeterElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLModElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowHTMLModElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLOListElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowHTMLOListElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLObjectElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowHTMLObjectElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLOptGroupElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowHTMLOptGroupElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLOptionElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowHTMLOptionElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLParagraphElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowHTMLParagraphElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLParamElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowHTMLParamElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLPreElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowHTMLPreElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLProgressElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowHTMLProgressElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLQuoteElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowHTMLQuoteElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLScriptElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowHTMLScriptElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLSelectElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowHTMLSelectElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLStyleElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowHTMLStyleElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLTableCaptionElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowHTMLTableCaptionElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLTableCellElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowHTMLTableCellElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLTableColElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowHTMLTableColElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLTableElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowHTMLTableElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLTableRowElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowHTMLTableRowElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLTableSectionElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowHTMLTableSectionElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLTextAreaElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowHTMLTextAreaElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLTitleElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowHTMLTitleElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLUListElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowHTMLUListElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLCollectionConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowHTMLCollectionConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLAllCollectionConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowHTMLAllCollectionConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowImageConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowImageConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOptionConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOptionConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowCanvasPatternConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowCanvasPatternConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowCanvasGradientConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowCanvasGradientConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowCanvasRenderingContext2DConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowCanvasRenderingContext2DConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowImageDataConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowImageDataConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowWebGLRenderingContextConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowWebGLRenderingContextConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowTextMetricsConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowTextMetricsConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowDOMStringMapConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowDOMStringMapConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowArrayBufferConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowArrayBufferConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowInt8ArrayConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowInt8ArrayConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowUint8ArrayConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowUint8ArrayConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowInt16ArrayConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowInt16ArrayConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowUint16ArrayConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowUint16ArrayConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowInt32ArrayConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowInt32ArrayConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowUint32ArrayConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowUint32ArrayConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowFloat32ArrayConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowFloat32ArrayConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowWebGLArrayBufferConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowWebGLArrayBufferConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowWebGLByteArrayConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowWebGLByteArrayConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowWebGLUnsignedByteArrayConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowWebGLUnsignedByteArrayConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowWebGLShortArrayConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowWebGLShortArrayConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowWebGLUnsignedShortArrayConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowWebGLUnsignedShortArrayConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowWebGLIntArrayConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowWebGLIntArrayConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowWebGLUnsignedIntArrayConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowWebGLUnsignedIntArrayConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowWebGLFloatArrayConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowWebGLFloatArrayConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowEventConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowBeforeLoadEventConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowBeforeLoadEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowKeyboardEventConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowKeyboardEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowMouseEventConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowMouseEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowMutationEventConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowMutationEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOverflowEventConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowOverflowEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowPageTransitionEventConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowPageTransitionEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowProgressEventConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowProgressEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowTextEventConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowTextEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowUIEventConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowUIEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowWebKitAnimationEventConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowWebKitAnimationEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowWebKitTransitionEventConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowWebKitTransitionEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowWheelEventConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowWheelEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowMessageEventConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowMessageEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowEventExceptionConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowEventExceptionConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowWebKitCSSKeyframeRuleConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowWebKitCSSKeyframeRuleConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowWebKitCSSKeyframesRuleConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowWebKitCSSKeyframesRuleConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowWebKitCSSMatrixConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowWebKitCSSMatrixConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowWebKitPointConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowWebKitPointConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowClipboardConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowClipboardConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowFileConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowFileConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowFileListConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowFileListConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowBlobConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowBlobConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowNodeFilterConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowNodeFilterConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowRangeConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowRangeConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowRangeExceptionConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowRangeExceptionConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowEventSourceConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowEventSourceConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowXMLDocumentConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowXMLDocumentConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowDOMParserConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowDOMParserConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowXMLSerializerConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowXMLSerializerConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowXMLHttpRequestConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowXMLHttpRequestConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowXMLHttpRequestUploadConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowXMLHttpRequestUploadConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowXMLHttpRequestExceptionConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowXMLHttpRequestExceptionConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowXSLTProcessorConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowXSLTProcessorConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowMessagePortConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowMessagePortConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowMessageChannelConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowMessageChannelConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowWorkerConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowWorkerConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSharedWorkerConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSharedWorkerConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowWebSocketConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowWebSocketConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowPluginConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowPluginConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowPluginArrayConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowPluginArrayConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowMimeTypeConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowMimeTypeConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowMimeTypeArrayConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowMimeTypeArrayConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowClientRectConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowClientRectConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowClientRectListConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowClientRectListConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowStorageConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowStorageConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowStorageEventConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowStorageEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowAudioConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowAudioConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLAudioElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowHTMLAudioElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLMediaElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowHTMLMediaElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLVideoElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowHTMLVideoElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowMediaErrorConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowMediaErrorConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowTimeRangesConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowTimeRangesConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowXPathEvaluatorConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowXPathEvaluatorConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowXPathResultConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowXPathResultConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowXPathExceptionConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowXPathExceptionConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGAElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGAElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGAngleConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGAngleConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGAnimatedAngleConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGAnimatedAngleConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGAnimatedBooleanConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGAnimatedBooleanConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGAnimatedEnumerationConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGAnimatedEnumerationConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGAnimatedIntegerConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGAnimatedIntegerConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGAnimatedLengthConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGAnimatedLengthConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGAnimatedLengthListConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGAnimatedLengthListConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGAnimatedNumberConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGAnimatedNumberConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGAnimatedNumberListConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGAnimatedNumberListConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGAnimatedPreserveAspectRatioConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGAnimatedPreserveAspectRatioConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGAnimatedRectConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGAnimatedRectConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGAnimatedStringConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGAnimatedStringConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGAnimatedTransformListConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGAnimatedTransformListConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGCircleElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGCircleElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGClipPathElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGClipPathElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGColorConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGColorConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGCursorElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGCursorElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGDefsElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGDefsElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGDescElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGDescElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGDocumentConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGDocumentConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGElementInstanceConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGElementInstanceConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGElementInstanceListConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGElementInstanceListConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGEllipseElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGEllipseElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGExceptionConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGExceptionConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGGElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGGElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGGradientElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGGradientElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGImageElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGImageElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGLengthConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGLengthConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGLengthListConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGLengthListConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGLinearGradientElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGLinearGradientElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGLineElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGLineElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGMarkerElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGMarkerElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGMaskElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGMaskElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGMatrixConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGMatrixConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGMetadataElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGMetadataElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGNumberConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGNumberConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGNumberListConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGNumberListConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGPaintConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGPaintConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGPathElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGPathElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGPathSegConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGPathSegConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGPathSegArcAbsConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGPathSegArcAbsConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGPathSegArcRelConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGPathSegArcRelConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGPathSegClosePathConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGPathSegClosePathConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGPathSegCurvetoCubicAbsConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGPathSegCurvetoCubicAbsConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGPathSegCurvetoCubicRelConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGPathSegCurvetoCubicRelConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGPathSegCurvetoCubicSmoothAbsConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGPathSegCurvetoCubicSmoothAbsConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGPathSegCurvetoCubicSmoothRelConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGPathSegCurvetoCubicSmoothRelConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGPathSegCurvetoQuadraticAbsConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGPathSegCurvetoQuadraticAbsConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGPathSegCurvetoQuadraticRelConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGPathSegCurvetoQuadraticRelConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGPathSegCurvetoQuadraticSmoothAbsConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGPathSegCurvetoQuadraticSmoothAbsConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGPathSegCurvetoQuadraticSmoothRelConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGPathSegCurvetoQuadraticSmoothRelConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGPathSegLinetoAbsConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGPathSegLinetoAbsConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGPathSegLinetoHorizontalAbsConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGPathSegLinetoHorizontalAbsConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGPathSegLinetoHorizontalRelConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGPathSegLinetoHorizontalRelConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGPathSegLinetoRelConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGPathSegLinetoRelConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGPathSegLinetoVerticalAbsConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGPathSegLinetoVerticalAbsConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGPathSegLinetoVerticalRelConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGPathSegLinetoVerticalRelConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGPathSegListConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGPathSegListConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGPathSegMovetoAbsConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGPathSegMovetoAbsConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGPathSegMovetoRelConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGPathSegMovetoRelConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGPatternElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGPatternElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGPointConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGPointConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGPointListConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGPointListConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGPolygonElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGPolygonElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGPolylineElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGPolylineElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGPreserveAspectRatioConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGPreserveAspectRatioConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGRadialGradientElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGRadialGradientElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGRectConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGRectConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGRectElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGRectElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGRenderingIntentConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGRenderingIntentConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGScriptElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGScriptElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGStopElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGStopElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGStringListConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGStringListConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGStyleElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGStyleElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGSVGElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGSVGElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGSwitchElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGSwitchElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGSymbolElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGSymbolElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGTextContentElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGTextContentElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGTextElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGTextElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGTextPathElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGTextPathElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGTextPositioningElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGTextPositioningElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGTitleElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGTitleElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGTransformConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGTransformConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGTransformListConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGTransformListConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGTRefElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGTRefElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGTSpanElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGTSpanElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGUnitTypesConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGUnitTypesConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGUseElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGUseElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGViewElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGViewElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGZoomEventConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGZoomEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGComponentTransferFunctionElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGComponentTransferFunctionElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGFEBlendElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGFEBlendElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGFEColorMatrixElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGFEColorMatrixElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGFEComponentTransferElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGFEComponentTransferElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGFECompositeElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGFECompositeElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGFEConvolveMatrixElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGFEConvolveMatrixElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGFEDiffuseLightingElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGFEDiffuseLightingElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGFEDisplacementMapElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGFEDisplacementMapElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGFEDistantLightElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGFEDistantLightElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGFEFloodElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGFEFloodElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGFEFuncAElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGFEFuncAElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGFEFuncBElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGFEFuncBElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGFEFuncGElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGFEFuncGElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGFEFuncRElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGFEFuncRElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGFEGaussianBlurElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGFEGaussianBlurElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGFEImageElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGFEImageElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGFEMergeElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGFEMergeElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGFEMergeNodeElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGFEMergeNodeElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGFEMorphologyElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGFEMorphologyElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGFEOffsetElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGFEOffsetElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGFEPointLightElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGFEPointLightElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGFESpecularLightingElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGFESpecularLightingElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGFESpotLightElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGFESpotLightElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGFETileElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGFETileElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGFETurbulenceElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGFETurbulenceElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGFilterElementConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSVGFilterElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSQLExceptionConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowSQLExceptionConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowTouchEventConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowTouchEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowTransformActionEventConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowTransformActionEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowFormDataConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowFormDataConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowFileErrorConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowFileErrorConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowFileReaderConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowFileReaderConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowBlobBuilderConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSDOMWindowBlobBuilderConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);

} // namespace WebCore

#endif
