/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef JSDatabaseCallback_h
#define JSDatabaseCallback_h

#if ENABLE(DATABASE)

#include "DatabaseCallback.h"
#include "JSCallbackData.h"
#include <wtf/Forward.h>

namespace WebCore {

class JSDatabaseCallback : public DatabaseCallback {
public:
    static PassRefPtr<JSDatabaseCallback> create(JSC::JSObject* callback, JSDOMGlobalObject* globalObject)
    {
        return adoptRef(new JSDatabaseCallback(callback, globalObject));
    }

    virtual ~JSDatabaseCallback();

    // Functions
    virtual bool handleEvent(ScriptExecutionContext*, Database* database);
    virtual bool handleEvent(ScriptExecutionContext*, DatabaseSync* database);

private:
    JSDatabaseCallback(JSC::JSObject* callback, JSDOMGlobalObject*);

    JSCallbackData* m_data;
    RefPtr<DOMWrapperWorld> m_isolatedWorld;
    ScriptExecutionContext* m_scriptExecutionContext;
};

} // namespace WebCore

#endif // ENABLE(DATABASE)

#endif
