/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSBlobBuilder.h"

#include "Blob.h"
#include "BlobBuilder.h"
#include "JSBlob.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSBlobBuilder);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSBlobBuilderTableValues[2] =
{
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsBlobBuilderConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSBlobBuilderTable = { 2, 1, JSBlobBuilderTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSBlobBuilderConstructorTableValues[1] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSBlobBuilderConstructorTable = { 1, 0, JSBlobBuilderConstructorTableValues, 0 };
class JSBlobBuilderConstructor : public DOMConstructorObject {
public:
    JSBlobBuilderConstructor(JSC::ExecState*, JSDOMGlobalObject*);

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    virtual const JSC::ClassInfo* classInfo() const { return &s_info; }
    static const JSC::ClassInfo s_info;
    static PassRefPtr<JSC::Structure> createStructure(JSC::JSValue prototype)
    {
        return JSC::Structure::create(prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), AnonymousSlotCount);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
    static JSC::EncodedJSValue JSC_HOST_CALL constructJSBlobBuilder(JSC::ExecState*);
    virtual JSC::ConstructType getConstructData(JSC::ConstructData&);
};

const ClassInfo JSBlobBuilderConstructor::s_info = { "BlobBuilderConstructor", 0, &JSBlobBuilderConstructorTable, 0 };

JSBlobBuilderConstructor::JSBlobBuilderConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(JSBlobBuilderConstructor::createStructure(globalObject->objectPrototype()), globalObject)
{
    putDirect(exec->propertyNames().prototype, JSBlobBuilderPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSBlobBuilderConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSBlobBuilderConstructor, DOMObject>(exec, &JSBlobBuilderConstructorTable, this, propertyName, slot);
}

bool JSBlobBuilderConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSBlobBuilderConstructor, DOMObject>(exec, &JSBlobBuilderConstructorTable, this, propertyName, descriptor);
}

EncodedJSValue JSC_HOST_CALL JSBlobBuilderConstructor::constructJSBlobBuilder(ExecState* exec)
{
    return JSValue::encode(asObject(toJS(exec, static_cast<JSBlobBuilderConstructor*>(exec->callee())->globalObject(), BlobBuilder::create())));
}

ConstructType JSBlobBuilderConstructor::getConstructData(ConstructData& constructData)
{
    constructData.native.function = constructJSBlobBuilder;
    return ConstructTypeHost;
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSBlobBuilderPrototypeTableValues[3] =
{
    { "getBlob", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsBlobBuilderPrototypeFunctionGetBlob), (intptr_t)1 THUNK_GENERATOR(0) },
    { "append", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsBlobBuilderPrototypeFunctionAppend), (intptr_t)1 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSBlobBuilderPrototypeTable = { 8, 7, JSBlobBuilderPrototypeTableValues, 0 };
static const HashTable* getJSBlobBuilderPrototypeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSBlobBuilderPrototypeTable);
}
const ClassInfo JSBlobBuilderPrototype::s_info = { "BlobBuilderPrototype", 0, 0, getJSBlobBuilderPrototypeTable };

JSObject* JSBlobBuilderPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSBlobBuilder>(exec, globalObject);
}

bool JSBlobBuilderPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, getJSBlobBuilderPrototypeTable(exec), this, propertyName, slot);
}

bool JSBlobBuilderPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, getJSBlobBuilderPrototypeTable(exec), this, propertyName, descriptor);
}

static const HashTable* getJSBlobBuilderTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSBlobBuilderTable);
}
const ClassInfo JSBlobBuilder::s_info = { "BlobBuilder", 0, 0, getJSBlobBuilderTable };

JSBlobBuilder::JSBlobBuilder(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<BlobBuilder> impl)
    : DOMObjectWithGlobalPointer(structure, globalObject)
    , m_impl(impl)
{
}

JSBlobBuilder::~JSBlobBuilder()
{
    forgetDOMObject(this, impl());
}

JSObject* JSBlobBuilder::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSBlobBuilderPrototype(globalObject, JSBlobBuilderPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSBlobBuilder::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSBlobBuilder, Base>(exec, getJSBlobBuilderTable(exec), this, propertyName, slot);
}

bool JSBlobBuilder::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSBlobBuilder, Base>(exec, getJSBlobBuilderTable(exec), this, propertyName, descriptor);
}

JSValue jsBlobBuilderConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSBlobBuilder* domObject = static_cast<JSBlobBuilder*>(asObject(slotBase));
    return JSBlobBuilder::getConstructor(exec, domObject->globalObject());
}
JSValue JSBlobBuilder::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSBlobBuilderConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsBlobBuilderPrototypeFunctionGetBlob(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSBlobBuilder::s_info))
        return throwVMTypeError(exec);
    JSBlobBuilder* castedThis = static_cast<JSBlobBuilder*>(asObject(thisValue));
    BlobBuilder* imp = static_cast<BlobBuilder*>(castedThis->impl());

    int argsCount = exec->argumentCount();
    if (argsCount < 1) {

        JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->getBlob()));
        return JSValue::encode(result);
    }

    const String& contentType = valueToStringWithUndefinedOrNullCheck(exec, exec->argument(0));


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->getBlob(contentType)));
    return JSValue::encode(result);
}

static EncodedJSValue JSC_HOST_CALL jsBlobBuilderPrototypeFunctionAppend1(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSBlobBuilder::s_info))
        return throwVMTypeError(exec);
    JSBlobBuilder* castedThis = static_cast<JSBlobBuilder*>(asObject(thisValue));
    BlobBuilder* imp = static_cast<BlobBuilder*>(castedThis->impl());
    Blob* blob = toBlob(exec->argument(0));

    imp->append(blob);
    return JSValue::encode(jsUndefined());
}

static EncodedJSValue JSC_HOST_CALL jsBlobBuilderPrototypeFunctionAppend2(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSBlobBuilder::s_info))
        return throwVMTypeError(exec);
    JSBlobBuilder* castedThis = static_cast<JSBlobBuilder*>(asObject(thisValue));
    BlobBuilder* imp = static_cast<BlobBuilder*>(castedThis->impl());
    ExceptionCode ec = 0;
    const String& value = ustringToString(exec->argument(0).toString(exec));

    int argsCount = exec->argumentCount();
    if (argsCount < 2) {
        imp->append(value, ec);
        setDOMException(exec, ec);
        return JSValue::encode(jsUndefined());
    }

    const String& endings = valueToStringWithUndefinedOrNullCheck(exec, exec->argument(1));

    imp->append(value, endings, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsBlobBuilderPrototypeFunctionAppend(ExecState* exec)
{
    if ((exec->argumentCount() == 1 && (exec->argument(0).isNull() || exec->argument(0).isObject() && asObject(exec->argument(0))->inherits(&JSBlob::s_info))))
        return jsBlobBuilderPrototypeFunctionAppend1(exec);
    if ((exec->argumentCount() == 1 && (exec->argument(0).isNull() || exec->argument(0).isUndefined() || exec->argument(0).isString() || exec->argument(0).isObject())) || (exec->argumentCount() == 2 && (exec->argument(0).isNull() || exec->argument(0).isUndefined() || exec->argument(0).isString() || exec->argument(0).isObject()) && (exec->argument(1).isNull() || exec->argument(1).isUndefined() || exec->argument(1).isString() || exec->argument(1).isObject())))
        return jsBlobBuilderPrototypeFunctionAppend2(exec);
    return throwVMTypeError(exec);
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, BlobBuilder* object)
{
    return getDOMObjectWrapper<JSBlobBuilder>(exec, globalObject, object);
}
BlobBuilder* toBlobBuilder(JSC::JSValue value)
{
    return value.inherits(&JSBlobBuilder::s_info) ? static_cast<JSBlobBuilder*>(asObject(value))->impl() : 0;
}

}
