/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDOMStringList.h"

#include "DOMStringList.h"
#include "ExceptionCode.h"
#include "KURL.h"
#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>
#include <runtime/JSString.h>
#include <runtime/PropertyNameArray.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSDOMStringList);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSDOMStringListTableValues[3] =
{
    { "length", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMStringListLength), (intptr_t)0 THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMStringListConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSDOMStringListTable = { 5, 3, JSDOMStringListTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSDOMStringListConstructorTableValues[1] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSDOMStringListConstructorTable = { 1, 0, JSDOMStringListConstructorTableValues, 0 };
class JSDOMStringListConstructor : public DOMConstructorObject {
public:
    JSDOMStringListConstructor(JSC::ExecState*, JSDOMGlobalObject*);

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    virtual const JSC::ClassInfo* classInfo() const { return &s_info; }
    static const JSC::ClassInfo s_info;
    static PassRefPtr<JSC::Structure> createStructure(JSC::JSValue prototype)
    {
        return JSC::Structure::create(prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), AnonymousSlotCount);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSDOMStringListConstructor::s_info = { "DOMStringListConstructor", 0, &JSDOMStringListConstructorTable, 0 };

JSDOMStringListConstructor::JSDOMStringListConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(JSDOMStringListConstructor::createStructure(globalObject->objectPrototype()), globalObject)
{
    putDirect(exec->propertyNames().prototype, JSDOMStringListPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSDOMStringListConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSDOMStringListConstructor, DOMObject>(exec, &JSDOMStringListConstructorTable, this, propertyName, slot);
}

bool JSDOMStringListConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSDOMStringListConstructor, DOMObject>(exec, &JSDOMStringListConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSDOMStringListPrototypeTableValues[3] =
{
    { "item", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDOMStringListPrototypeFunctionItem), (intptr_t)1 THUNK_GENERATOR(0) },
    { "contains", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDOMStringListPrototypeFunctionContains), (intptr_t)1 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSDOMStringListPrototypeTable = { 4, 3, JSDOMStringListPrototypeTableValues, 0 };
const ClassInfo JSDOMStringListPrototype::s_info = { "DOMStringListPrototype", 0, &JSDOMStringListPrototypeTable, 0 };

JSObject* JSDOMStringListPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSDOMStringList>(exec, globalObject);
}

bool JSDOMStringListPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSDOMStringListPrototypeTable, this, propertyName, slot);
}

bool JSDOMStringListPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSDOMStringListPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSDOMStringList::s_info = { "DOMStringList", 0, &JSDOMStringListTable, 0 };

JSDOMStringList::JSDOMStringList(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<DOMStringList> impl)
    : DOMObjectWithGlobalPointer(structure, globalObject)
    , m_impl(impl)
{
}

JSDOMStringList::~JSDOMStringList()
{
    forgetDOMObject(this, impl());
}

JSObject* JSDOMStringList::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSDOMStringListPrototype(globalObject, JSDOMStringListPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSDOMStringList::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    const HashEntry* entry = JSDOMStringListTable.entry(exec, propertyName);
    if (entry) {
        slot.setCustom(this, entry->propertyGetter());
        return true;
    }
    bool ok;
    unsigned index = propertyName.toUInt32(&ok, false);
    if (ok) {
        slot.setCustomIndex(this, index, indexGetter);
        return true;
    }
    return getStaticValueSlot<JSDOMStringList, Base>(exec, &JSDOMStringListTable, this, propertyName, slot);
}

bool JSDOMStringList::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    const HashEntry* entry = JSDOMStringListTable.entry(exec, propertyName);
    if (entry) {
        PropertySlot slot;
        slot.setCustom(this, entry->propertyGetter());
        descriptor.setDescriptor(slot.getValue(exec, propertyName), entry->attributes());
        return true;
    }
    bool ok;
    unsigned index = propertyName.toUInt32(&ok, false);
    if (ok && index < static_cast<DOMStringList*>(impl())->length()) {
        PropertySlot slot;
        slot.setCustomIndex(this, index, indexGetter);
        descriptor.setDescriptor(slot.getValue(exec, propertyName), DontDelete | ReadOnly);
        return true;
    }
    return getStaticValueDescriptor<JSDOMStringList, Base>(exec, &JSDOMStringListTable, this, propertyName, descriptor);
}

bool JSDOMStringList::getOwnPropertySlot(ExecState* exec, unsigned propertyName, PropertySlot& slot)
{
    if (propertyName < static_cast<DOMStringList*>(impl())->length()) {
        slot.setCustomIndex(this, propertyName, indexGetter);
        return true;
    }
    return getOwnPropertySlot(exec, Identifier::from(exec, propertyName), slot);
}

JSValue jsDOMStringListLength(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDOMStringList* castedThis = static_cast<JSDOMStringList*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    DOMStringList* imp = static_cast<DOMStringList*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->length());
    return result;
}

JSValue jsDOMStringListConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDOMStringList* domObject = static_cast<JSDOMStringList*>(asObject(slotBase));
    return JSDOMStringList::getConstructor(exec, domObject->globalObject());
}
void JSDOMStringList::getOwnPropertyNames(ExecState* exec, PropertyNameArray& propertyNames, EnumerationMode mode)
{
    for (unsigned i = 0; i < static_cast<DOMStringList*>(impl())->length(); ++i)
        propertyNames.add(Identifier::from(exec, i));
     Base::getOwnPropertyNames(exec, propertyNames, mode);
}

JSValue JSDOMStringList::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDOMStringListConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsDOMStringListPrototypeFunctionItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDOMStringList::s_info))
        return throwVMTypeError(exec);
    JSDOMStringList* castedThis = static_cast<JSDOMStringList*>(asObject(thisValue));
    DOMStringList* imp = static_cast<DOMStringList*>(castedThis->impl());
    int index = exec->argument(0).toInt32(exec);
    if (index < 0) {
        setDOMException(exec, INDEX_SIZE_ERR);
        return JSValue::encode(jsUndefined());
    }


    JSC::JSValue result = jsString(exec, imp->item(index));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDOMStringListPrototypeFunctionContains(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDOMStringList::s_info))
        return throwVMTypeError(exec);
    JSDOMStringList* castedThis = static_cast<JSDOMStringList*>(asObject(thisValue));
    DOMStringList* imp = static_cast<DOMStringList*>(castedThis->impl());
    const String& string = ustringToString(exec->argument(0).toString(exec));


    JSC::JSValue result = jsBoolean(imp->contains(string));
    return JSValue::encode(result);
}


JSValue JSDOMStringList::indexGetter(ExecState* exec, JSValue slotBase, unsigned index)
{
    JSDOMStringList* thisObj = static_cast<JSDOMStringList*>(asObject(slotBase));
    return jsStringOrNull(exec, thisObj->impl()->item(index));
}
JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, DOMStringList* object)
{
    return getDOMObjectWrapper<JSDOMStringList>(exec, globalObject, object);
}
DOMStringList* toDOMStringList(JSC::JSValue value)
{
    return value.inherits(&JSDOMStringList::s_info) ? static_cast<JSDOMStringList*>(asObject(value))->impl() : 0;
}

}
