/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLMapElement.h"

#include "HTMLCollection.h"
#include "HTMLMapElement.h"
#include "HTMLNames.h"
#include "JSHTMLCollection.h"
#include "KURL.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLMapElement);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSHTMLMapElementTableValues[4] =
{
    { "areas", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMapElementAreas), (intptr_t)0 THUNK_GENERATOR(0) },
    { "name", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMapElementName), (intptr_t)setJSHTMLMapElementName THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMapElementConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSHTMLMapElementTable = { 9, 7, JSHTMLMapElementTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSHTMLMapElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSHTMLMapElementConstructorTable = { 1, 0, JSHTMLMapElementConstructorTableValues, 0 };
class JSHTMLMapElementConstructor : public DOMConstructorObject {
public:
    JSHTMLMapElementConstructor(JSC::ExecState*, JSDOMGlobalObject*);

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    virtual const JSC::ClassInfo* classInfo() const { return &s_info; }
    static const JSC::ClassInfo s_info;
    static PassRefPtr<JSC::Structure> createStructure(JSC::JSValue prototype)
    {
        return JSC::Structure::create(prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), AnonymousSlotCount);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSHTMLMapElementConstructor::s_info = { "HTMLMapElementConstructor", 0, &JSHTMLMapElementConstructorTable, 0 };

JSHTMLMapElementConstructor::JSHTMLMapElementConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(JSHTMLMapElementConstructor::createStructure(globalObject->objectPrototype()), globalObject)
{
    putDirect(exec->propertyNames().prototype, JSHTMLMapElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSHTMLMapElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLMapElementConstructor, DOMObject>(exec, &JSHTMLMapElementConstructorTable, this, propertyName, slot);
}

bool JSHTMLMapElementConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLMapElementConstructor, DOMObject>(exec, &JSHTMLMapElementConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSHTMLMapElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSHTMLMapElementPrototypeTable = { 1, 0, JSHTMLMapElementPrototypeTableValues, 0 };
const ClassInfo JSHTMLMapElementPrototype::s_info = { "HTMLMapElementPrototype", 0, &JSHTMLMapElementPrototypeTable, 0 };

JSObject* JSHTMLMapElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLMapElement>(exec, globalObject);
}

const ClassInfo JSHTMLMapElement::s_info = { "HTMLMapElement", &JSHTMLElement::s_info, &JSHTMLMapElementTable, 0 };

JSHTMLMapElement::JSHTMLMapElement(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLMapElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

JSObject* JSHTMLMapElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSHTMLMapElementPrototype(globalObject, JSHTMLMapElementPrototype::createStructure(JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLMapElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLMapElement, Base>(exec, &JSHTMLMapElementTable, this, propertyName, slot);
}

bool JSHTMLMapElement::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLMapElement, Base>(exec, &JSHTMLMapElementTable, this, propertyName, descriptor);
}

JSValue jsHTMLMapElementAreas(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLMapElement* castedThis = static_cast<JSHTMLMapElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLMapElement* imp = static_cast<HTMLMapElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->areas()));
    return result;
}

JSValue jsHTMLMapElementName(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLMapElement* castedThis = static_cast<JSHTMLMapElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLMapElement* imp = static_cast<HTMLMapElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->getAttribute(WebCore::HTMLNames::nameAttr));
    return result;
}

JSValue jsHTMLMapElementConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLMapElement* domObject = static_cast<JSHTMLMapElement*>(asObject(slotBase));
    return JSHTMLMapElement::getConstructor(exec, domObject->globalObject());
}
void JSHTMLMapElement::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSHTMLMapElement, Base>(exec, propertyName, value, &JSHTMLMapElementTable, this, slot);
}

void setJSHTMLMapElementName(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLMapElement* castedThis = static_cast<JSHTMLMapElement*>(thisObject);
    HTMLMapElement* imp = static_cast<HTMLMapElement*>(castedThis->impl());
    imp->setAttribute(WebCore::HTMLNames::nameAttr, valueToStringWithNullCheck(exec, value));
}

JSValue JSHTMLMapElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLMapElementConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}


}
