/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCanvasRenderingContext.h"

#include "CanvasRenderingContext.h"
#include "HTMLCanvasElement.h"
#include "JSHTMLCanvasElement.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSCanvasRenderingContext);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSCanvasRenderingContextTableValues[3] =
{
    { "canvas", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContextCanvas), (intptr_t)0 THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContextConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSCanvasRenderingContextTable = { 4, 3, JSCanvasRenderingContextTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSCanvasRenderingContextConstructorTableValues[1] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSCanvasRenderingContextConstructorTable = { 1, 0, JSCanvasRenderingContextConstructorTableValues, 0 };
class JSCanvasRenderingContextConstructor : public DOMConstructorObject {
public:
    JSCanvasRenderingContextConstructor(JSC::ExecState*, JSDOMGlobalObject*);

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    virtual const JSC::ClassInfo* classInfo() const { return &s_info; }
    static const JSC::ClassInfo s_info;
    static PassRefPtr<JSC::Structure> createStructure(JSC::JSValue prototype)
    {
        return JSC::Structure::create(prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), AnonymousSlotCount);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSCanvasRenderingContextConstructor::s_info = { "CanvasRenderingContextConstructor", 0, &JSCanvasRenderingContextConstructorTable, 0 };

JSCanvasRenderingContextConstructor::JSCanvasRenderingContextConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(JSCanvasRenderingContextConstructor::createStructure(globalObject->objectPrototype()), globalObject)
{
    putDirect(exec->propertyNames().prototype, JSCanvasRenderingContextPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSCanvasRenderingContextConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCanvasRenderingContextConstructor, DOMObject>(exec, &JSCanvasRenderingContextConstructorTable, this, propertyName, slot);
}

bool JSCanvasRenderingContextConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSCanvasRenderingContextConstructor, DOMObject>(exec, &JSCanvasRenderingContextConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSCanvasRenderingContextPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSCanvasRenderingContextPrototypeTable = { 1, 0, JSCanvasRenderingContextPrototypeTableValues, 0 };
const ClassInfo JSCanvasRenderingContextPrototype::s_info = { "CanvasRenderingContextPrototype", 0, &JSCanvasRenderingContextPrototypeTable, 0 };

JSObject* JSCanvasRenderingContextPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSCanvasRenderingContext>(exec, globalObject);
}

const ClassInfo JSCanvasRenderingContext::s_info = { "CanvasRenderingContext", 0, &JSCanvasRenderingContextTable, 0 };

JSCanvasRenderingContext::JSCanvasRenderingContext(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<CanvasRenderingContext> impl)
    : DOMObjectWithGlobalPointer(structure, globalObject)
    , m_impl(impl)
{
}

JSCanvasRenderingContext::~JSCanvasRenderingContext()
{
    forgetDOMObject(this, impl());
}

JSObject* JSCanvasRenderingContext::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSCanvasRenderingContextPrototype(globalObject, JSCanvasRenderingContextPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSCanvasRenderingContext::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCanvasRenderingContext, Base>(exec, &JSCanvasRenderingContextTable, this, propertyName, slot);
}

bool JSCanvasRenderingContext::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSCanvasRenderingContext, Base>(exec, &JSCanvasRenderingContextTable, this, propertyName, descriptor);
}

JSValue jsCanvasRenderingContextCanvas(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSCanvasRenderingContext* castedThis = static_cast<JSCanvasRenderingContext*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CanvasRenderingContext* imp = static_cast<CanvasRenderingContext*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->canvas()));
    return result;
}

JSValue jsCanvasRenderingContextConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSCanvasRenderingContext* domObject = static_cast<JSCanvasRenderingContext*>(asObject(slotBase));
    return JSCanvasRenderingContext::getConstructor(exec, domObject->globalObject());
}
JSValue JSCanvasRenderingContext::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCanvasRenderingContextConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

CanvasRenderingContext* toCanvasRenderingContext(JSC::JSValue value)
{
    return value.inherits(&JSCanvasRenderingContext::s_info) ? static_cast<JSCanvasRenderingContext*>(asObject(value))->impl() : 0;
}

}
