/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(INDEXED_DATABASE)

#include "JSIDBIndexRequest.h"

#include "IDBIndexRequest.h"
#include "KURL.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSIDBIndexRequest);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSIDBIndexRequestTableValues[5] =
{
    { "name", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBIndexRequestName), (intptr_t)0 THUNK_GENERATOR(0) },
    { "keyPath", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBIndexRequestKeyPath), (intptr_t)0 THUNK_GENERATOR(0) },
    { "unique", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBIndexRequestUnique), (intptr_t)0 THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBIndexRequestConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSIDBIndexRequestTable = { 9, 7, JSIDBIndexRequestTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSIDBIndexRequestConstructorTableValues[1] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSIDBIndexRequestConstructorTable = { 1, 0, JSIDBIndexRequestConstructorTableValues, 0 };
class JSIDBIndexRequestConstructor : public DOMConstructorObject {
public:
    JSIDBIndexRequestConstructor(JSC::ExecState*, JSDOMGlobalObject*);

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    virtual const JSC::ClassInfo* classInfo() const { return &s_info; }
    static const JSC::ClassInfo s_info;
    static PassRefPtr<JSC::Structure> createStructure(JSC::JSValue prototype)
    {
        return JSC::Structure::create(prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), AnonymousSlotCount);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSIDBIndexRequestConstructor::s_info = { "IDBIndexRequestConstructor", 0, &JSIDBIndexRequestConstructorTable, 0 };

JSIDBIndexRequestConstructor::JSIDBIndexRequestConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(JSIDBIndexRequestConstructor::createStructure(globalObject->objectPrototype()), globalObject)
{
    putDirect(exec->propertyNames().prototype, JSIDBIndexRequestPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSIDBIndexRequestConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSIDBIndexRequestConstructor, DOMObject>(exec, &JSIDBIndexRequestConstructorTable, this, propertyName, slot);
}

bool JSIDBIndexRequestConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSIDBIndexRequestConstructor, DOMObject>(exec, &JSIDBIndexRequestConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSIDBIndexRequestPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSIDBIndexRequestPrototypeTable = { 1, 0, JSIDBIndexRequestPrototypeTableValues, 0 };
const ClassInfo JSIDBIndexRequestPrototype::s_info = { "IDBIndexRequestPrototype", 0, &JSIDBIndexRequestPrototypeTable, 0 };

JSObject* JSIDBIndexRequestPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSIDBIndexRequest>(exec, globalObject);
}

const ClassInfo JSIDBIndexRequest::s_info = { "IDBIndexRequest", 0, &JSIDBIndexRequestTable, 0 };

JSIDBIndexRequest::JSIDBIndexRequest(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<IDBIndexRequest> impl)
    : DOMObjectWithGlobalPointer(structure, globalObject)
    , m_impl(impl)
{
}

JSIDBIndexRequest::~JSIDBIndexRequest()
{
    forgetDOMObject(this, impl());
}

JSObject* JSIDBIndexRequest::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSIDBIndexRequestPrototype(globalObject, JSIDBIndexRequestPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSIDBIndexRequest::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSIDBIndexRequest, Base>(exec, &JSIDBIndexRequestTable, this, propertyName, slot);
}

bool JSIDBIndexRequest::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSIDBIndexRequest, Base>(exec, &JSIDBIndexRequestTable, this, propertyName, descriptor);
}

JSValue jsIDBIndexRequestName(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSIDBIndexRequest* castedThis = static_cast<JSIDBIndexRequest*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    IDBIndexRequest* imp = static_cast<IDBIndexRequest*>(castedThis->impl());
    JSValue result = jsString(exec, imp->name());
    return result;
}

JSValue jsIDBIndexRequestKeyPath(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSIDBIndexRequest* castedThis = static_cast<JSIDBIndexRequest*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    IDBIndexRequest* imp = static_cast<IDBIndexRequest*>(castedThis->impl());
    JSValue result = jsString(exec, imp->keyPath());
    return result;
}

JSValue jsIDBIndexRequestUnique(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSIDBIndexRequest* castedThis = static_cast<JSIDBIndexRequest*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    IDBIndexRequest* imp = static_cast<IDBIndexRequest*>(castedThis->impl());
    JSValue result = jsBoolean(imp->unique());
    return result;
}

JSValue jsIDBIndexRequestConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSIDBIndexRequest* domObject = static_cast<JSIDBIndexRequest*>(asObject(slotBase));
    return JSIDBIndexRequest::getConstructor(exec, domObject->globalObject());
}
JSValue JSIDBIndexRequest::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSIDBIndexRequestConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, IDBIndexRequest* object)
{
    return getDOMObjectWrapper<JSIDBIndexRequest>(exec, globalObject, object);
}
IDBIndexRequest* toIDBIndexRequest(JSC::JSValue value)
{
    return value.inherits(&JSIDBIndexRequest::s_info) ? static_cast<JSIDBIndexRequest*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(INDEXED_DATABASE)
