/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDOMSelection.h"

#include "DOMSelection.h"
#include "JSNode.h"
#include "JSRange.h"
#include "KURL.h"
#include "Node.h"
#include "Range.h"
#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSDOMSelection);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSDOMSelectionTableValues[12] =
{
    { "anchorNode", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMSelectionAnchorNode), (intptr_t)0 THUNK_GENERATOR(0) },
    { "anchorOffset", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMSelectionAnchorOffset), (intptr_t)0 THUNK_GENERATOR(0) },
    { "focusNode", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMSelectionFocusNode), (intptr_t)0 THUNK_GENERATOR(0) },
    { "focusOffset", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMSelectionFocusOffset), (intptr_t)0 THUNK_GENERATOR(0) },
    { "isCollapsed", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMSelectionIsCollapsed), (intptr_t)0 THUNK_GENERATOR(0) },
    { "rangeCount", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMSelectionRangeCount), (intptr_t)0 THUNK_GENERATOR(0) },
    { "baseNode", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMSelectionBaseNode), (intptr_t)0 THUNK_GENERATOR(0) },
    { "baseOffset", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMSelectionBaseOffset), (intptr_t)0 THUNK_GENERATOR(0) },
    { "extentNode", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMSelectionExtentNode), (intptr_t)0 THUNK_GENERATOR(0) },
    { "extentOffset", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMSelectionExtentOffset), (intptr_t)0 THUNK_GENERATOR(0) },
    { "type", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMSelectionType), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSDOMSelectionTable = { 34, 31, JSDOMSelectionTableValues, 0 };
/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSDOMSelectionPrototypeTableValues[16] =
{
    { "collapse", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDOMSelectionPrototypeFunctionCollapse), (intptr_t)2 THUNK_GENERATOR(0) },
    { "collapseToEnd", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDOMSelectionPrototypeFunctionCollapseToEnd), (intptr_t)0 THUNK_GENERATOR(0) },
    { "collapseToStart", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDOMSelectionPrototypeFunctionCollapseToStart), (intptr_t)0 THUNK_GENERATOR(0) },
    { "deleteFromDocument", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDOMSelectionPrototypeFunctionDeleteFromDocument), (intptr_t)0 THUNK_GENERATOR(0) },
    { "containsNode", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDOMSelectionPrototypeFunctionContainsNode), (intptr_t)2 THUNK_GENERATOR(0) },
    { "selectAllChildren", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDOMSelectionPrototypeFunctionSelectAllChildren), (intptr_t)1 THUNK_GENERATOR(0) },
    { "extend", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDOMSelectionPrototypeFunctionExtend), (intptr_t)2 THUNK_GENERATOR(0) },
    { "getRangeAt", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDOMSelectionPrototypeFunctionGetRangeAt), (intptr_t)1 THUNK_GENERATOR(0) },
    { "removeAllRanges", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDOMSelectionPrototypeFunctionRemoveAllRanges), (intptr_t)0 THUNK_GENERATOR(0) },
    { "addRange", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDOMSelectionPrototypeFunctionAddRange), (intptr_t)1 THUNK_GENERATOR(0) },
    { "toString", DontDelete | DontEnum | Function, (intptr_t)static_cast<NativeFunction>(jsDOMSelectionPrototypeFunctionToString), (intptr_t)0 THUNK_GENERATOR(0) },
    { "modify", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDOMSelectionPrototypeFunctionModify), (intptr_t)3 THUNK_GENERATOR(0) },
    { "setBaseAndExtent", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDOMSelectionPrototypeFunctionSetBaseAndExtent), (intptr_t)4 THUNK_GENERATOR(0) },
    { "setPosition", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDOMSelectionPrototypeFunctionSetPosition), (intptr_t)2 THUNK_GENERATOR(0) },
    { "empty", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDOMSelectionPrototypeFunctionEmpty), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSDOMSelectionPrototypeTable = { 34, 31, JSDOMSelectionPrototypeTableValues, 0 };
const ClassInfo JSDOMSelectionPrototype::s_info = { "DOMSelectionPrototype", 0, &JSDOMSelectionPrototypeTable, 0 };

JSObject* JSDOMSelectionPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSDOMSelection>(exec, globalObject);
}

bool JSDOMSelectionPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSDOMSelectionPrototypeTable, this, propertyName, slot);
}

bool JSDOMSelectionPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSDOMSelectionPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSDOMSelection::s_info = { "DOMSelection", 0, &JSDOMSelectionTable, 0 };

JSDOMSelection::JSDOMSelection(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<DOMSelection> impl)
    : DOMObjectWithGlobalPointer(structure, globalObject)
    , m_impl(impl)
{
}

JSDOMSelection::~JSDOMSelection()
{
    forgetDOMObject(this, impl());
}

JSObject* JSDOMSelection::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSDOMSelectionPrototype(globalObject, JSDOMSelectionPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSDOMSelection::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSDOMSelection, Base>(exec, &JSDOMSelectionTable, this, propertyName, slot);
}

bool JSDOMSelection::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSDOMSelection, Base>(exec, &JSDOMSelectionTable, this, propertyName, descriptor);
}

JSValue jsDOMSelectionAnchorNode(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDOMSelection* castedThis = static_cast<JSDOMSelection*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    DOMSelection* imp = static_cast<DOMSelection*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->anchorNode()));
    return result;
}

JSValue jsDOMSelectionAnchorOffset(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDOMSelection* castedThis = static_cast<JSDOMSelection*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    DOMSelection* imp = static_cast<DOMSelection*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->anchorOffset());
    return result;
}

JSValue jsDOMSelectionFocusNode(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDOMSelection* castedThis = static_cast<JSDOMSelection*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    DOMSelection* imp = static_cast<DOMSelection*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->focusNode()));
    return result;
}

JSValue jsDOMSelectionFocusOffset(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDOMSelection* castedThis = static_cast<JSDOMSelection*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    DOMSelection* imp = static_cast<DOMSelection*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->focusOffset());
    return result;
}

JSValue jsDOMSelectionIsCollapsed(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDOMSelection* castedThis = static_cast<JSDOMSelection*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    DOMSelection* imp = static_cast<DOMSelection*>(castedThis->impl());
    JSValue result = jsBoolean(imp->isCollapsed());
    return result;
}

JSValue jsDOMSelectionRangeCount(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDOMSelection* castedThis = static_cast<JSDOMSelection*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    DOMSelection* imp = static_cast<DOMSelection*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->rangeCount());
    return result;
}

JSValue jsDOMSelectionBaseNode(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDOMSelection* castedThis = static_cast<JSDOMSelection*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    DOMSelection* imp = static_cast<DOMSelection*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->baseNode()));
    return result;
}

JSValue jsDOMSelectionBaseOffset(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDOMSelection* castedThis = static_cast<JSDOMSelection*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    DOMSelection* imp = static_cast<DOMSelection*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->baseOffset());
    return result;
}

JSValue jsDOMSelectionExtentNode(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDOMSelection* castedThis = static_cast<JSDOMSelection*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    DOMSelection* imp = static_cast<DOMSelection*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->extentNode()));
    return result;
}

JSValue jsDOMSelectionExtentOffset(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDOMSelection* castedThis = static_cast<JSDOMSelection*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    DOMSelection* imp = static_cast<DOMSelection*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->extentOffset());
    return result;
}

JSValue jsDOMSelectionType(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDOMSelection* castedThis = static_cast<JSDOMSelection*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    DOMSelection* imp = static_cast<DOMSelection*>(castedThis->impl());
    JSValue result = jsString(exec, imp->type());
    return result;
}

EncodedJSValue JSC_HOST_CALL jsDOMSelectionPrototypeFunctionCollapse(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDOMSelection::s_info))
        return throwVMTypeError(exec);
    JSDOMSelection* castedThis = static_cast<JSDOMSelection*>(asObject(thisValue));
    DOMSelection* imp = static_cast<DOMSelection*>(castedThis->impl());
    ExceptionCode ec = 0;
    Node* node = toNode(exec->argument(0));
    int index = exec->argument(1).toInt32(exec);

    imp->collapse(node, index, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDOMSelectionPrototypeFunctionCollapseToEnd(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDOMSelection::s_info))
        return throwVMTypeError(exec);
    JSDOMSelection* castedThis = static_cast<JSDOMSelection*>(asObject(thisValue));
    DOMSelection* imp = static_cast<DOMSelection*>(castedThis->impl());

    imp->collapseToEnd();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDOMSelectionPrototypeFunctionCollapseToStart(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDOMSelection::s_info))
        return throwVMTypeError(exec);
    JSDOMSelection* castedThis = static_cast<JSDOMSelection*>(asObject(thisValue));
    DOMSelection* imp = static_cast<DOMSelection*>(castedThis->impl());

    imp->collapseToStart();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDOMSelectionPrototypeFunctionDeleteFromDocument(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDOMSelection::s_info))
        return throwVMTypeError(exec);
    JSDOMSelection* castedThis = static_cast<JSDOMSelection*>(asObject(thisValue));
    DOMSelection* imp = static_cast<DOMSelection*>(castedThis->impl());

    imp->deleteFromDocument();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDOMSelectionPrototypeFunctionContainsNode(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDOMSelection::s_info))
        return throwVMTypeError(exec);
    JSDOMSelection* castedThis = static_cast<JSDOMSelection*>(asObject(thisValue));
    DOMSelection* imp = static_cast<DOMSelection*>(castedThis->impl());
    Node* node = toNode(exec->argument(0));
    bool allowPartial = exec->argument(1).toBoolean(exec);


    JSC::JSValue result = jsBoolean(imp->containsNode(node, allowPartial));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDOMSelectionPrototypeFunctionSelectAllChildren(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDOMSelection::s_info))
        return throwVMTypeError(exec);
    JSDOMSelection* castedThis = static_cast<JSDOMSelection*>(asObject(thisValue));
    DOMSelection* imp = static_cast<DOMSelection*>(castedThis->impl());
    ExceptionCode ec = 0;
    Node* node = toNode(exec->argument(0));

    imp->selectAllChildren(node, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDOMSelectionPrototypeFunctionExtend(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDOMSelection::s_info))
        return throwVMTypeError(exec);
    JSDOMSelection* castedThis = static_cast<JSDOMSelection*>(asObject(thisValue));
    DOMSelection* imp = static_cast<DOMSelection*>(castedThis->impl());
    ExceptionCode ec = 0;
    Node* node = toNode(exec->argument(0));
    int offset = exec->argument(1).toInt32(exec);

    imp->extend(node, offset, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDOMSelectionPrototypeFunctionGetRangeAt(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDOMSelection::s_info))
        return throwVMTypeError(exec);
    JSDOMSelection* castedThis = static_cast<JSDOMSelection*>(asObject(thisValue));
    DOMSelection* imp = static_cast<DOMSelection*>(castedThis->impl());
    ExceptionCode ec = 0;
    int index = exec->argument(0).toInt32(exec);


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->getRangeAt(index, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDOMSelectionPrototypeFunctionRemoveAllRanges(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDOMSelection::s_info))
        return throwVMTypeError(exec);
    JSDOMSelection* castedThis = static_cast<JSDOMSelection*>(asObject(thisValue));
    DOMSelection* imp = static_cast<DOMSelection*>(castedThis->impl());

    imp->removeAllRanges();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDOMSelectionPrototypeFunctionAddRange(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDOMSelection::s_info))
        return throwVMTypeError(exec);
    JSDOMSelection* castedThis = static_cast<JSDOMSelection*>(asObject(thisValue));
    DOMSelection* imp = static_cast<DOMSelection*>(castedThis->impl());
    Range* range = toRange(exec->argument(0));

    imp->addRange(range);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDOMSelectionPrototypeFunctionToString(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDOMSelection::s_info))
        return throwVMTypeError(exec);
    JSDOMSelection* castedThis = static_cast<JSDOMSelection*>(asObject(thisValue));
    DOMSelection* imp = static_cast<DOMSelection*>(castedThis->impl());


    JSC::JSValue result = jsString(exec, imp->toString());
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDOMSelectionPrototypeFunctionModify(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDOMSelection::s_info))
        return throwVMTypeError(exec);
    JSDOMSelection* castedThis = static_cast<JSDOMSelection*>(asObject(thisValue));
    DOMSelection* imp = static_cast<DOMSelection*>(castedThis->impl());
    const String& alter = ustringToString(exec->argument(0).toString(exec));
    const String& direction = ustringToString(exec->argument(1).toString(exec));
    const String& granularity = ustringToString(exec->argument(2).toString(exec));

    imp->modify(alter, direction, granularity);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDOMSelectionPrototypeFunctionSetBaseAndExtent(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDOMSelection::s_info))
        return throwVMTypeError(exec);
    JSDOMSelection* castedThis = static_cast<JSDOMSelection*>(asObject(thisValue));
    DOMSelection* imp = static_cast<DOMSelection*>(castedThis->impl());
    ExceptionCode ec = 0;
    Node* baseNode = toNode(exec->argument(0));
    int baseOffset = exec->argument(1).toInt32(exec);
    Node* extentNode = toNode(exec->argument(2));
    int extentOffset = exec->argument(3).toInt32(exec);

    imp->setBaseAndExtent(baseNode, baseOffset, extentNode, extentOffset, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDOMSelectionPrototypeFunctionSetPosition(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDOMSelection::s_info))
        return throwVMTypeError(exec);
    JSDOMSelection* castedThis = static_cast<JSDOMSelection*>(asObject(thisValue));
    DOMSelection* imp = static_cast<DOMSelection*>(castedThis->impl());
    ExceptionCode ec = 0;
    Node* node = toNode(exec->argument(0));
    int offset = exec->argument(1).toInt32(exec);

    imp->setPosition(node, offset, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDOMSelectionPrototypeFunctionEmpty(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDOMSelection::s_info))
        return throwVMTypeError(exec);
    JSDOMSelection* castedThis = static_cast<JSDOMSelection*>(asObject(thisValue));
    DOMSelection* imp = static_cast<DOMSelection*>(castedThis->impl());

    imp->empty();
    return JSValue::encode(jsUndefined());
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, DOMSelection* object)
{
    return getDOMObjectWrapper<JSDOMSelection>(exec, globalObject, object);
}
DOMSelection* toDOMSelection(JSC::JSValue value)
{
    return value.inherits(&JSDOMSelection::s_info) ? static_cast<JSDOMSelection*>(asObject(value))->impl() : 0;
}

}
