/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(INDEXED_DATABASE)

#include "JSIDBDatabaseRequest.h"

#include "DOMStringList.h"
#include "IDBDatabaseRequest.h"
#include "IDBObjectStoreRequest.h"
#include "IDBRequest.h"
#include "JSDOMStringList.h"
#include "JSIDBObjectStoreRequest.h"
#include "JSIDBRequest.h"
#include "KURL.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSIDBDatabaseRequest);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSIDBDatabaseRequestTableValues[6] =
{
    { "name", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBDatabaseRequestName), (intptr_t)0 THUNK_GENERATOR(0) },
    { "description", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBDatabaseRequestDescription), (intptr_t)0 THUNK_GENERATOR(0) },
    { "version", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBDatabaseRequestVersion), (intptr_t)0 THUNK_GENERATOR(0) },
    { "objectStores", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBDatabaseRequestObjectStores), (intptr_t)0 THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBDatabaseRequestConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSIDBDatabaseRequestTable = { 18, 15, JSIDBDatabaseRequestTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSIDBDatabaseRequestConstructorTableValues[1] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSIDBDatabaseRequestConstructorTable = { 1, 0, JSIDBDatabaseRequestConstructorTableValues, 0 };
class JSIDBDatabaseRequestConstructor : public DOMConstructorObject {
public:
    JSIDBDatabaseRequestConstructor(JSC::ExecState*, JSDOMGlobalObject*);

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    virtual const JSC::ClassInfo* classInfo() const { return &s_info; }
    static const JSC::ClassInfo s_info;
    static PassRefPtr<JSC::Structure> createStructure(JSC::JSValue prototype)
    {
        return JSC::Structure::create(prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), AnonymousSlotCount);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSIDBDatabaseRequestConstructor::s_info = { "IDBDatabaseRequestConstructor", 0, &JSIDBDatabaseRequestConstructorTable, 0 };

JSIDBDatabaseRequestConstructor::JSIDBDatabaseRequestConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(JSIDBDatabaseRequestConstructor::createStructure(globalObject->objectPrototype()), globalObject)
{
    putDirect(exec->propertyNames().prototype, JSIDBDatabaseRequestPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSIDBDatabaseRequestConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSIDBDatabaseRequestConstructor, DOMObject>(exec, &JSIDBDatabaseRequestConstructorTable, this, propertyName, slot);
}

bool JSIDBDatabaseRequestConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSIDBDatabaseRequestConstructor, DOMObject>(exec, &JSIDBDatabaseRequestConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSIDBDatabaseRequestPrototypeTableValues[4] =
{
    { "createObjectStore", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsIDBDatabaseRequestPrototypeFunctionCreateObjectStore), (intptr_t)3 THUNK_GENERATOR(0) },
    { "objectStore", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsIDBDatabaseRequestPrototypeFunctionObjectStore), (intptr_t)2 THUNK_GENERATOR(0) },
    { "removeObjectStore", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsIDBDatabaseRequestPrototypeFunctionRemoveObjectStore), (intptr_t)1 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSIDBDatabaseRequestPrototypeTable = { 8, 7, JSIDBDatabaseRequestPrototypeTableValues, 0 };
const ClassInfo JSIDBDatabaseRequestPrototype::s_info = { "IDBDatabaseRequestPrototype", 0, &JSIDBDatabaseRequestPrototypeTable, 0 };

JSObject* JSIDBDatabaseRequestPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSIDBDatabaseRequest>(exec, globalObject);
}

bool JSIDBDatabaseRequestPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSIDBDatabaseRequestPrototypeTable, this, propertyName, slot);
}

bool JSIDBDatabaseRequestPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSIDBDatabaseRequestPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSIDBDatabaseRequest::s_info = { "IDBDatabaseRequest", 0, &JSIDBDatabaseRequestTable, 0 };

JSIDBDatabaseRequest::JSIDBDatabaseRequest(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<IDBDatabaseRequest> impl)
    : DOMObjectWithGlobalPointer(structure, globalObject)
    , m_impl(impl)
{
}

JSIDBDatabaseRequest::~JSIDBDatabaseRequest()
{
    forgetDOMObject(this, impl());
}

JSObject* JSIDBDatabaseRequest::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSIDBDatabaseRequestPrototype(globalObject, JSIDBDatabaseRequestPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSIDBDatabaseRequest::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSIDBDatabaseRequest, Base>(exec, &JSIDBDatabaseRequestTable, this, propertyName, slot);
}

bool JSIDBDatabaseRequest::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSIDBDatabaseRequest, Base>(exec, &JSIDBDatabaseRequestTable, this, propertyName, descriptor);
}

JSValue jsIDBDatabaseRequestName(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSIDBDatabaseRequest* castedThis = static_cast<JSIDBDatabaseRequest*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    IDBDatabaseRequest* imp = static_cast<IDBDatabaseRequest*>(castedThis->impl());
    JSValue result = jsString(exec, imp->name());
    return result;
}

JSValue jsIDBDatabaseRequestDescription(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSIDBDatabaseRequest* castedThis = static_cast<JSIDBDatabaseRequest*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    IDBDatabaseRequest* imp = static_cast<IDBDatabaseRequest*>(castedThis->impl());
    JSValue result = jsString(exec, imp->description());
    return result;
}

JSValue jsIDBDatabaseRequestVersion(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSIDBDatabaseRequest* castedThis = static_cast<JSIDBDatabaseRequest*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    IDBDatabaseRequest* imp = static_cast<IDBDatabaseRequest*>(castedThis->impl());
    JSValue result = jsString(exec, imp->version());
    return result;
}

JSValue jsIDBDatabaseRequestObjectStores(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSIDBDatabaseRequest* castedThis = static_cast<JSIDBDatabaseRequest*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    IDBDatabaseRequest* imp = static_cast<IDBDatabaseRequest*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->objectStores()));
    return result;
}

JSValue jsIDBDatabaseRequestConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSIDBDatabaseRequest* domObject = static_cast<JSIDBDatabaseRequest*>(asObject(slotBase));
    return JSIDBDatabaseRequest::getConstructor(exec, domObject->globalObject());
}
JSValue JSIDBDatabaseRequest::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSIDBDatabaseRequestConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsIDBDatabaseRequestPrototypeFunctionCreateObjectStore(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSIDBDatabaseRequest::s_info))
        return throwVMTypeError(exec);
    JSIDBDatabaseRequest* castedThis = static_cast<JSIDBDatabaseRequest*>(asObject(thisValue));
    IDBDatabaseRequest* imp = static_cast<IDBDatabaseRequest*>(castedThis->impl());
    ScriptExecutionContext* scriptContext = static_cast<JSDOMGlobalObject*>(exec->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return JSValue::encode(jsUndefined());
    const String& name = ustringToString(exec->argument(0).toString(exec));

    int argsCount = exec->argumentCount();
    if (argsCount < 2) {

        JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->createObjectStore(scriptContext, name)));
        return JSValue::encode(result);
    }

    const String& keyPath = valueToStringWithNullCheck(exec, exec->argument(1));
    if (argsCount < 3) {

        JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->createObjectStore(scriptContext, name, keyPath)));
        return JSValue::encode(result);
    }

    bool autoIncrement = exec->argument(2).toBoolean(exec);


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->createObjectStore(scriptContext, name, keyPath, autoIncrement)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsIDBDatabaseRequestPrototypeFunctionObjectStore(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSIDBDatabaseRequest::s_info))
        return throwVMTypeError(exec);
    JSIDBDatabaseRequest* castedThis = static_cast<JSIDBDatabaseRequest*>(asObject(thisValue));
    IDBDatabaseRequest* imp = static_cast<IDBDatabaseRequest*>(castedThis->impl());
    const String& name = ustringToString(exec->argument(0).toString(exec));

    int argsCount = exec->argumentCount();
    if (argsCount < 2) {

        JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->objectStore(name)));
        return JSValue::encode(result);
    }

    unsigned short mode = exec->argument(1).toInt32(exec);


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->objectStore(name, mode)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsIDBDatabaseRequestPrototypeFunctionRemoveObjectStore(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSIDBDatabaseRequest::s_info))
        return throwVMTypeError(exec);
    JSIDBDatabaseRequest* castedThis = static_cast<JSIDBDatabaseRequest*>(asObject(thisValue));
    IDBDatabaseRequest* imp = static_cast<IDBDatabaseRequest*>(castedThis->impl());
    ScriptExecutionContext* scriptContext = static_cast<JSDOMGlobalObject*>(exec->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return JSValue::encode(jsUndefined());
    const String& name = ustringToString(exec->argument(0).toString(exec));


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->removeObjectStore(scriptContext, name)));
    return JSValue::encode(result);
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, IDBDatabaseRequest* object)
{
    return getDOMObjectWrapper<JSIDBDatabaseRequest>(exec, globalObject, object);
}
IDBDatabaseRequest* toIDBDatabaseRequest(JSC::JSValue value)
{
    return value.inherits(&JSIDBDatabaseRequest::s_info) ? static_cast<JSIDBDatabaseRequest*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(INDEXED_DATABASE)
