/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGStyleElement.h"

#include "KURL.h"
#include "SVGStyleElement.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGStyleElement);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSSVGStyleElementTableValues[7] =
{
    { "type", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGStyleElementType), (intptr_t)setJSSVGStyleElementType THUNK_GENERATOR(0) },
    { "media", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGStyleElementMedia), (intptr_t)setJSSVGStyleElementMedia THUNK_GENERATOR(0) },
    { "title", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGStyleElementTitle), (intptr_t)setJSSVGStyleElementTitle THUNK_GENERATOR(0) },
    { "xmllang", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGStyleElementXmllang), (intptr_t)setJSSVGStyleElementXmllang THUNK_GENERATOR(0) },
    { "xmlspace", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGStyleElementXmlspace), (intptr_t)setJSSVGStyleElementXmlspace THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGStyleElementConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSSVGStyleElementTable = { 17, 15, JSSVGStyleElementTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSSVGStyleElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSSVGStyleElementConstructorTable = { 1, 0, JSSVGStyleElementConstructorTableValues, 0 };
class JSSVGStyleElementConstructor : public DOMConstructorObject {
public:
    JSSVGStyleElementConstructor(JSC::ExecState*, JSDOMGlobalObject*);

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    virtual const JSC::ClassInfo* classInfo() const { return &s_info; }
    static const JSC::ClassInfo s_info;
    static PassRefPtr<JSC::Structure> createStructure(JSC::JSValue prototype)
    {
        return JSC::Structure::create(prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), AnonymousSlotCount);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSSVGStyleElementConstructor::s_info = { "SVGStyleElementConstructor", 0, &JSSVGStyleElementConstructorTable, 0 };

JSSVGStyleElementConstructor::JSSVGStyleElementConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(JSSVGStyleElementConstructor::createStructure(globalObject->objectPrototype()), globalObject)
{
    putDirect(exec->propertyNames().prototype, JSSVGStyleElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSSVGStyleElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGStyleElementConstructor, DOMObject>(exec, &JSSVGStyleElementConstructorTable, this, propertyName, slot);
}

bool JSSVGStyleElementConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGStyleElementConstructor, DOMObject>(exec, &JSSVGStyleElementConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSSVGStyleElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSSVGStyleElementPrototypeTable = { 1, 0, JSSVGStyleElementPrototypeTableValues, 0 };
const ClassInfo JSSVGStyleElementPrototype::s_info = { "SVGStyleElementPrototype", 0, &JSSVGStyleElementPrototypeTable, 0 };

JSObject* JSSVGStyleElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGStyleElement>(exec, globalObject);
}

const ClassInfo JSSVGStyleElement::s_info = { "SVGStyleElement", &JSSVGElement::s_info, &JSSVGStyleElementTable, 0 };

JSSVGStyleElement::JSSVGStyleElement(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGStyleElement> impl)
    : JSSVGElement(structure, globalObject, impl)
{
}

JSObject* JSSVGStyleElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSSVGStyleElementPrototype(globalObject, JSSVGStyleElementPrototype::createStructure(JSSVGElementPrototype::self(exec, globalObject)));
}

bool JSSVGStyleElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGStyleElement, Base>(exec, &JSSVGStyleElementTable, this, propertyName, slot);
}

bool JSSVGStyleElement::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGStyleElement, Base>(exec, &JSSVGStyleElementTable, this, propertyName, descriptor);
}

JSValue jsSVGStyleElementType(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGStyleElement* castedThis = static_cast<JSSVGStyleElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGStyleElement* imp = static_cast<SVGStyleElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->type());
    return result;
}

JSValue jsSVGStyleElementMedia(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGStyleElement* castedThis = static_cast<JSSVGStyleElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGStyleElement* imp = static_cast<SVGStyleElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->media());
    return result;
}

JSValue jsSVGStyleElementTitle(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGStyleElement* castedThis = static_cast<JSSVGStyleElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGStyleElement* imp = static_cast<SVGStyleElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->title());
    return result;
}

JSValue jsSVGStyleElementXmllang(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGStyleElement* castedThis = static_cast<JSSVGStyleElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGStyleElement* imp = static_cast<SVGStyleElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->xmllang());
    return result;
}

JSValue jsSVGStyleElementXmlspace(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGStyleElement* castedThis = static_cast<JSSVGStyleElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGStyleElement* imp = static_cast<SVGStyleElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->xmlspace());
    return result;
}

JSValue jsSVGStyleElementConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGStyleElement* domObject = static_cast<JSSVGStyleElement*>(asObject(slotBase));
    return JSSVGStyleElement::getConstructor(exec, domObject->globalObject());
}
void JSSVGStyleElement::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSSVGStyleElement, Base>(exec, propertyName, value, &JSSVGStyleElementTable, this, slot);
}

void setJSSVGStyleElementType(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSSVGStyleElement* castedThis = static_cast<JSSVGStyleElement*>(thisObject);
    SVGStyleElement* imp = static_cast<SVGStyleElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    imp->setType(ustringToString(value.toString(exec)), ec);
    setDOMException(exec, ec);
}

void setJSSVGStyleElementMedia(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSSVGStyleElement* castedThis = static_cast<JSSVGStyleElement*>(thisObject);
    SVGStyleElement* imp = static_cast<SVGStyleElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    imp->setMedia(ustringToString(value.toString(exec)), ec);
    setDOMException(exec, ec);
}

void setJSSVGStyleElementTitle(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSSVGStyleElement* castedThis = static_cast<JSSVGStyleElement*>(thisObject);
    SVGStyleElement* imp = static_cast<SVGStyleElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    imp->setTitle(ustringToString(value.toString(exec)), ec);
    setDOMException(exec, ec);
}

void setJSSVGStyleElementXmllang(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSSVGStyleElement* castedThis = static_cast<JSSVGStyleElement*>(thisObject);
    SVGStyleElement* imp = static_cast<SVGStyleElement*>(castedThis->impl());
    imp->setXmllang(ustringToString(value.toString(exec)));
}

void setJSSVGStyleElementXmlspace(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSSVGStyleElement* castedThis = static_cast<JSSVGStyleElement*>(thisObject);
    SVGStyleElement* imp = static_cast<SVGStyleElement*>(castedThis->impl());
    imp->setXmlspace(ustringToString(value.toString(exec)));
}

JSValue JSSVGStyleElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGStyleElementConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}


}

#endif // ENABLE(SVG)
