/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(3D_CANVAS)

#include "JSUint32Array.h"

#include "Uint32Array.h"
#include <runtime/Error.h>
#include <runtime/PropertyNameArray.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSUint32Array);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSUint32ArrayTableValues[2] =
{
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsUint32ArrayConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSUint32ArrayTable = { 2, 1, JSUint32ArrayTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSUint32ArrayConstructorTableValues[2] =
{
    { "BYTES_PER_ELEMENT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsUint32ArrayBYTES_PER_ELEMENT), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSUint32ArrayConstructorTable = { 2, 1, JSUint32ArrayConstructorTableValues, 0 };
const ClassInfo JSUint32ArrayConstructor::s_info = { "Uint32ArrayConstructor", 0, &JSUint32ArrayConstructorTable, 0 };

JSUint32ArrayConstructor::JSUint32ArrayConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(JSUint32ArrayConstructor::createStructure(globalObject->objectPrototype()), globalObject)
{
    putDirect(exec->propertyNames().prototype, JSUint32ArrayPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSUint32ArrayConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSUint32ArrayConstructor, DOMObject>(exec, &JSUint32ArrayConstructorTable, this, propertyName, slot);
}

bool JSUint32ArrayConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSUint32ArrayConstructor, DOMObject>(exec, &JSUint32ArrayConstructorTable, this, propertyName, descriptor);
}

ConstructType JSUint32ArrayConstructor::getConstructData(ConstructData& constructData)
{
    constructData.native.function = constructJSUint32Array;
    return ConstructTypeHost;
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSUint32ArrayPrototypeTableValues[3] =
{
    { "BYTES_PER_ELEMENT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsUint32ArrayBYTES_PER_ELEMENT), (intptr_t)0 THUNK_GENERATOR(0) },
    { "set", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsUint32ArrayPrototypeFunctionSet), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSUint32ArrayPrototypeTable = { 4, 3, JSUint32ArrayPrototypeTableValues, 0 };
const ClassInfo JSUint32ArrayPrototype::s_info = { "Uint32ArrayPrototype", 0, &JSUint32ArrayPrototypeTable, 0 };

JSObject* JSUint32ArrayPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSUint32Array>(exec, globalObject);
}

bool JSUint32ArrayPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticPropertySlot<JSUint32ArrayPrototype, JSObject>(exec, &JSUint32ArrayPrototypeTable, this, propertyName, slot);
}

bool JSUint32ArrayPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticPropertyDescriptor<JSUint32ArrayPrototype, JSObject>(exec, &JSUint32ArrayPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSUint32Array::s_info = { "Uint32Array", &JSArrayBufferView::s_info, &JSUint32ArrayTable, 0 };

JSUint32Array::JSUint32Array(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<Uint32Array> impl)
    : JSArrayBufferView(structure, globalObject, impl)
{
}

JSObject* JSUint32Array::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSUint32ArrayPrototype(globalObject, JSUint32ArrayPrototype::createStructure(JSArrayBufferViewPrototype::self(exec, globalObject)));
}

bool JSUint32Array::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    bool ok;
    unsigned index = propertyName.toUInt32(&ok, false);
    if (ok && index < static_cast<Uint32Array*>(impl())->length()) {
        slot.setValue(getByIndex(exec, index));
        return true;
    }
    return getStaticValueSlot<JSUint32Array, Base>(exec, &JSUint32ArrayTable, this, propertyName, slot);
}

bool JSUint32Array::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    bool ok;
    unsigned index = propertyName.toUInt32(&ok, false);
    if (ok && index < static_cast<Uint32Array*>(impl())->length()) {
        descriptor.setDescriptor(getByIndex(exec, index), DontDelete);
        return true;
    }
    return getStaticValueDescriptor<JSUint32Array, Base>(exec, &JSUint32ArrayTable, this, propertyName, descriptor);
}

bool JSUint32Array::getOwnPropertySlot(ExecState* exec, unsigned propertyName, PropertySlot& slot)
{
    if (propertyName < static_cast<Uint32Array*>(impl())->length()) {
        slot.setValue(getByIndex(exec, propertyName));
        return true;
    }
    return getOwnPropertySlot(exec, Identifier::from(exec, propertyName), slot);
}

JSValue jsUint32ArrayConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSUint32Array* domObject = static_cast<JSUint32Array*>(asObject(slotBase));
    return JSUint32Array::getConstructor(exec, domObject->globalObject());
}
void JSUint32Array::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    bool ok;
    unsigned index = propertyName.toUInt32(&ok, false);
    if (ok) {
        indexSetter(exec, index, value);
        return;
    }
    Base::put(exec, propertyName, value, slot);
}

void JSUint32Array::put(ExecState* exec, unsigned propertyName, JSValue value)
{
    indexSetter(exec, propertyName, value);
    return;
}

void JSUint32Array::getOwnPropertyNames(ExecState* exec, PropertyNameArray& propertyNames, EnumerationMode mode)
{
    for (unsigned i = 0; i < static_cast<Uint32Array*>(impl())->length(); ++i)
        propertyNames.add(Identifier::from(exec, i));
     Base::getOwnPropertyNames(exec, propertyNames, mode);
}

JSValue JSUint32Array::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSUint32ArrayConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsUint32ArrayPrototypeFunctionSet(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSUint32Array::s_info))
        return throwVMTypeError(exec);
    JSUint32Array* castedThis = static_cast<JSUint32Array*>(asObject(thisValue));
    return JSValue::encode(castedThis->set(exec));
}

// Constant getters

JSValue jsUint32ArrayBYTES_PER_ELEMENT(ExecState* exec, JSValue, const Identifier&)
{
    return jsNumber(exec, static_cast<int>(4));
}


JSValue JSUint32Array::getByIndex(ExecState* exec, unsigned index)
{
    return jsNumber(exec, static_cast<Uint32Array*>(impl())->item(index));
}
Uint32Array* toUint32Array(JSC::JSValue value)
{
    return value.inherits(&JSUint32Array::s_info) ? static_cast<JSUint32Array*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(3D_CANVAS)
