/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(3D_CANVAS)

#include "JSFloat32Array.h"

#include "Float32Array.h"
#include <runtime/Error.h>
#include <runtime/PropertyNameArray.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSFloat32Array);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSFloat32ArrayTableValues[2] =
{
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFloat32ArrayConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSFloat32ArrayTable = { 2, 1, JSFloat32ArrayTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSFloat32ArrayConstructorTableValues[2] =
{
    { "BYTES_PER_ELEMENT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFloat32ArrayBYTES_PER_ELEMENT), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSFloat32ArrayConstructorTable = { 2, 1, JSFloat32ArrayConstructorTableValues, 0 };
const ClassInfo JSFloat32ArrayConstructor::s_info = { "Float32ArrayConstructor", 0, &JSFloat32ArrayConstructorTable, 0 };

JSFloat32ArrayConstructor::JSFloat32ArrayConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(JSFloat32ArrayConstructor::createStructure(globalObject->objectPrototype()), globalObject)
{
    putDirect(exec->propertyNames().prototype, JSFloat32ArrayPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSFloat32ArrayConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSFloat32ArrayConstructor, DOMObject>(exec, &JSFloat32ArrayConstructorTable, this, propertyName, slot);
}

bool JSFloat32ArrayConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSFloat32ArrayConstructor, DOMObject>(exec, &JSFloat32ArrayConstructorTable, this, propertyName, descriptor);
}

ConstructType JSFloat32ArrayConstructor::getConstructData(ConstructData& constructData)
{
    constructData.native.function = constructJSFloat32Array;
    return ConstructTypeHost;
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSFloat32ArrayPrototypeTableValues[3] =
{
    { "BYTES_PER_ELEMENT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFloat32ArrayBYTES_PER_ELEMENT), (intptr_t)0 THUNK_GENERATOR(0) },
    { "set", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsFloat32ArrayPrototypeFunctionSet), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSFloat32ArrayPrototypeTable = { 4, 3, JSFloat32ArrayPrototypeTableValues, 0 };
const ClassInfo JSFloat32ArrayPrototype::s_info = { "Float32ArrayPrototype", 0, &JSFloat32ArrayPrototypeTable, 0 };

JSObject* JSFloat32ArrayPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSFloat32Array>(exec, globalObject);
}

bool JSFloat32ArrayPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticPropertySlot<JSFloat32ArrayPrototype, JSObject>(exec, &JSFloat32ArrayPrototypeTable, this, propertyName, slot);
}

bool JSFloat32ArrayPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticPropertyDescriptor<JSFloat32ArrayPrototype, JSObject>(exec, &JSFloat32ArrayPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSFloat32Array::s_info = { "Float32Array", &JSArrayBufferView::s_info, &JSFloat32ArrayTable, 0 };

JSFloat32Array::JSFloat32Array(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<Float32Array> impl)
    : JSArrayBufferView(structure, globalObject, impl)
{
}

JSObject* JSFloat32Array::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSFloat32ArrayPrototype(globalObject, JSFloat32ArrayPrototype::createStructure(JSArrayBufferViewPrototype::self(exec, globalObject)));
}

bool JSFloat32Array::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    bool ok;
    unsigned index = propertyName.toUInt32(&ok, false);
    if (ok && index < static_cast<Float32Array*>(impl())->length()) {
        slot.setValue(getByIndex(exec, index));
        return true;
    }
    return getStaticValueSlot<JSFloat32Array, Base>(exec, &JSFloat32ArrayTable, this, propertyName, slot);
}

bool JSFloat32Array::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    bool ok;
    unsigned index = propertyName.toUInt32(&ok, false);
    if (ok && index < static_cast<Float32Array*>(impl())->length()) {
        descriptor.setDescriptor(getByIndex(exec, index), DontDelete);
        return true;
    }
    return getStaticValueDescriptor<JSFloat32Array, Base>(exec, &JSFloat32ArrayTable, this, propertyName, descriptor);
}

bool JSFloat32Array::getOwnPropertySlot(ExecState* exec, unsigned propertyName, PropertySlot& slot)
{
    if (propertyName < static_cast<Float32Array*>(impl())->length()) {
        slot.setValue(getByIndex(exec, propertyName));
        return true;
    }
    return getOwnPropertySlot(exec, Identifier::from(exec, propertyName), slot);
}

JSValue jsFloat32ArrayConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSFloat32Array* domObject = static_cast<JSFloat32Array*>(asObject(slotBase));
    return JSFloat32Array::getConstructor(exec, domObject->globalObject());
}
void JSFloat32Array::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    bool ok;
    unsigned index = propertyName.toUInt32(&ok, false);
    if (ok) {
        indexSetter(exec, index, value);
        return;
    }
    Base::put(exec, propertyName, value, slot);
}

void JSFloat32Array::put(ExecState* exec, unsigned propertyName, JSValue value)
{
    indexSetter(exec, propertyName, value);
    return;
}

void JSFloat32Array::getOwnPropertyNames(ExecState* exec, PropertyNameArray& propertyNames, EnumerationMode mode)
{
    for (unsigned i = 0; i < static_cast<Float32Array*>(impl())->length(); ++i)
        propertyNames.add(Identifier::from(exec, i));
     Base::getOwnPropertyNames(exec, propertyNames, mode);
}

JSValue JSFloat32Array::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSFloat32ArrayConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsFloat32ArrayPrototypeFunctionSet(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSFloat32Array::s_info))
        return throwVMTypeError(exec);
    JSFloat32Array* castedThis = static_cast<JSFloat32Array*>(asObject(thisValue));
    return JSValue::encode(castedThis->set(exec));
}

// Constant getters

JSValue jsFloat32ArrayBYTES_PER_ELEMENT(ExecState* exec, JSValue, const Identifier&)
{
    return jsNumber(exec, static_cast<int>(4));
}


JSValue JSFloat32Array::getByIndex(ExecState* exec, unsigned index)
{
    return jsNumber(exec, static_cast<Float32Array*>(impl())->item(index));
}
Float32Array* toFloat32Array(JSC::JSValue value)
{
    return value.inherits(&JSFloat32Array::s_info) ? static_cast<JSFloat32Array*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(3D_CANVAS)
