/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(INDEXED_DATABASE)

#include "JSIDBKey.h"

#include "IDBKey.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSIDBKey);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSIDBKeyTableValues[2] =
{
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBKeyConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSIDBKeyTable = { 2, 1, JSIDBKeyTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSIDBKeyConstructorTableValues[1] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSIDBKeyConstructorTable = { 1, 0, JSIDBKeyConstructorTableValues, 0 };
class JSIDBKeyConstructor : public DOMConstructorObject {
public:
    JSIDBKeyConstructor(JSC::ExecState*, JSDOMGlobalObject*);

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    virtual const JSC::ClassInfo* classInfo() const { return &s_info; }
    static const JSC::ClassInfo s_info;
    static PassRefPtr<JSC::Structure> createStructure(JSC::JSValue prototype)
    {
        return JSC::Structure::create(prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), AnonymousSlotCount);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSIDBKeyConstructor::s_info = { "IDBKeyConstructor", 0, &JSIDBKeyConstructorTable, 0 };

JSIDBKeyConstructor::JSIDBKeyConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(JSIDBKeyConstructor::createStructure(globalObject->objectPrototype()), globalObject)
{
    putDirect(exec->propertyNames().prototype, JSIDBKeyPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSIDBKeyConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSIDBKeyConstructor, DOMObject>(exec, &JSIDBKeyConstructorTable, this, propertyName, slot);
}

bool JSIDBKeyConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSIDBKeyConstructor, DOMObject>(exec, &JSIDBKeyConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSIDBKeyPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSIDBKeyPrototypeTable = { 1, 0, JSIDBKeyPrototypeTableValues, 0 };
const ClassInfo JSIDBKeyPrototype::s_info = { "IDBKeyPrototype", 0, &JSIDBKeyPrototypeTable, 0 };

JSObject* JSIDBKeyPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSIDBKey>(exec, globalObject);
}

const ClassInfo JSIDBKey::s_info = { "IDBKey", 0, &JSIDBKeyTable, 0 };

JSIDBKey::JSIDBKey(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<IDBKey> impl)
    : DOMObjectWithGlobalPointer(structure, globalObject)
    , m_impl(impl)
{
}

JSIDBKey::~JSIDBKey()
{
    forgetDOMObject(this, impl());
}

JSObject* JSIDBKey::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSIDBKeyPrototype(globalObject, JSIDBKeyPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSIDBKey::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSIDBKey, Base>(exec, &JSIDBKeyTable, this, propertyName, slot);
}

bool JSIDBKey::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSIDBKey, Base>(exec, &JSIDBKeyTable, this, propertyName, descriptor);
}

JSValue jsIDBKeyConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSIDBKey* domObject = static_cast<JSIDBKey*>(asObject(slotBase));
    return JSIDBKey::getConstructor(exec, domObject->globalObject());
}
JSValue JSIDBKey::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSIDBKeyConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

IDBKey* toIDBKey(JSC::JSValue value)
{
    return value.inherits(&JSIDBKey::s_info) ? static_cast<JSIDBKey*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(INDEXED_DATABASE)
