/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(3D_CANVAS)

#include "JSUint16Array.h"

#include "Uint16Array.h"
#include <runtime/Error.h>
#include <runtime/PropertyNameArray.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSUint16Array);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSUint16ArrayTableValues[2] =
{
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsUint16ArrayConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSUint16ArrayTable = { 2, 1, JSUint16ArrayTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSUint16ArrayConstructorTableValues[2] =
{
    { "BYTES_PER_ELEMENT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsUint16ArrayBYTES_PER_ELEMENT), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSUint16ArrayConstructorTable = { 2, 1, JSUint16ArrayConstructorTableValues, 0 };
const ClassInfo JSUint16ArrayConstructor::s_info = { "Uint16ArrayConstructor", 0, &JSUint16ArrayConstructorTable, 0 };

JSUint16ArrayConstructor::JSUint16ArrayConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(JSUint16ArrayConstructor::createStructure(globalObject->objectPrototype()), globalObject)
{
    putDirect(exec->propertyNames().prototype, JSUint16ArrayPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSUint16ArrayConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSUint16ArrayConstructor, DOMObject>(exec, &JSUint16ArrayConstructorTable, this, propertyName, slot);
}

bool JSUint16ArrayConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSUint16ArrayConstructor, DOMObject>(exec, &JSUint16ArrayConstructorTable, this, propertyName, descriptor);
}

ConstructType JSUint16ArrayConstructor::getConstructData(ConstructData& constructData)
{
    constructData.native.function = constructJSUint16Array;
    return ConstructTypeHost;
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSUint16ArrayPrototypeTableValues[3] =
{
    { "BYTES_PER_ELEMENT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsUint16ArrayBYTES_PER_ELEMENT), (intptr_t)0 THUNK_GENERATOR(0) },
    { "set", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsUint16ArrayPrototypeFunctionSet), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSUint16ArrayPrototypeTable = { 4, 3, JSUint16ArrayPrototypeTableValues, 0 };
const ClassInfo JSUint16ArrayPrototype::s_info = { "Uint16ArrayPrototype", 0, &JSUint16ArrayPrototypeTable, 0 };

JSObject* JSUint16ArrayPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSUint16Array>(exec, globalObject);
}

bool JSUint16ArrayPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticPropertySlot<JSUint16ArrayPrototype, JSObject>(exec, &JSUint16ArrayPrototypeTable, this, propertyName, slot);
}

bool JSUint16ArrayPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticPropertyDescriptor<JSUint16ArrayPrototype, JSObject>(exec, &JSUint16ArrayPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSUint16Array::s_info = { "Uint16Array", &JSArrayBufferView::s_info, &JSUint16ArrayTable, 0 };

JSUint16Array::JSUint16Array(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<Uint16Array> impl)
    : JSArrayBufferView(structure, globalObject, impl)
{
}

JSObject* JSUint16Array::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSUint16ArrayPrototype(globalObject, JSUint16ArrayPrototype::createStructure(JSArrayBufferViewPrototype::self(exec, globalObject)));
}

bool JSUint16Array::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    bool ok;
    unsigned index = propertyName.toUInt32(&ok, false);
    if (ok && index < static_cast<Uint16Array*>(impl())->length()) {
        slot.setValue(getByIndex(exec, index));
        return true;
    }
    return getStaticValueSlot<JSUint16Array, Base>(exec, &JSUint16ArrayTable, this, propertyName, slot);
}

bool JSUint16Array::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    bool ok;
    unsigned index = propertyName.toUInt32(&ok, false);
    if (ok && index < static_cast<Uint16Array*>(impl())->length()) {
        descriptor.setDescriptor(getByIndex(exec, index), DontDelete);
        return true;
    }
    return getStaticValueDescriptor<JSUint16Array, Base>(exec, &JSUint16ArrayTable, this, propertyName, descriptor);
}

bool JSUint16Array::getOwnPropertySlot(ExecState* exec, unsigned propertyName, PropertySlot& slot)
{
    if (propertyName < static_cast<Uint16Array*>(impl())->length()) {
        slot.setValue(getByIndex(exec, propertyName));
        return true;
    }
    return getOwnPropertySlot(exec, Identifier::from(exec, propertyName), slot);
}

JSValue jsUint16ArrayConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSUint16Array* domObject = static_cast<JSUint16Array*>(asObject(slotBase));
    return JSUint16Array::getConstructor(exec, domObject->globalObject());
}
void JSUint16Array::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    bool ok;
    unsigned index = propertyName.toUInt32(&ok, false);
    if (ok) {
        indexSetter(exec, index, value);
        return;
    }
    Base::put(exec, propertyName, value, slot);
}

void JSUint16Array::put(ExecState* exec, unsigned propertyName, JSValue value)
{
    indexSetter(exec, propertyName, value);
    return;
}

void JSUint16Array::getOwnPropertyNames(ExecState* exec, PropertyNameArray& propertyNames, EnumerationMode mode)
{
    for (unsigned i = 0; i < static_cast<Uint16Array*>(impl())->length(); ++i)
        propertyNames.add(Identifier::from(exec, i));
     Base::getOwnPropertyNames(exec, propertyNames, mode);
}

JSValue JSUint16Array::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSUint16ArrayConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsUint16ArrayPrototypeFunctionSet(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSUint16Array::s_info))
        return throwVMTypeError(exec);
    JSUint16Array* castedThis = static_cast<JSUint16Array*>(asObject(thisValue));
    return JSValue::encode(castedThis->set(exec));
}

// Constant getters

JSValue jsUint16ArrayBYTES_PER_ELEMENT(ExecState* exec, JSValue, const Identifier&)
{
    return jsNumber(exec, static_cast<int>(2));
}


JSValue JSUint16Array::getByIndex(ExecState* exec, unsigned index)
{
    return jsNumber(exec, static_cast<Uint16Array*>(impl())->item(index));
}
Uint16Array* toUint16Array(JSC::JSValue value)
{
    return value.inherits(&JSUint16Array::s_info) ? static_cast<JSUint16Array*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(3D_CANVAS)
