/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(DATAGRID)

#include "JSHTMLDataGridRowElement.h"

#include "HTMLDataGridRowElement.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLDataGridRowElement);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSHTMLDataGridRowElementTableValues[5] =
{
    { "selected", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLDataGridRowElementSelected), (intptr_t)setJSHTMLDataGridRowElementSelected THUNK_GENERATOR(0) },
    { "focused", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLDataGridRowElementFocused), (intptr_t)setJSHTMLDataGridRowElementFocused THUNK_GENERATOR(0) },
    { "expanded", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLDataGridRowElementExpanded), (intptr_t)setJSHTMLDataGridRowElementExpanded THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLDataGridRowElementConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSHTMLDataGridRowElementTable = { 10, 7, JSHTMLDataGridRowElementTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSHTMLDataGridRowElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSHTMLDataGridRowElementConstructorTable = { 1, 0, JSHTMLDataGridRowElementConstructorTableValues, 0 };
class JSHTMLDataGridRowElementConstructor : public DOMConstructorObject {
public:
    JSHTMLDataGridRowElementConstructor(JSC::ExecState*, JSDOMGlobalObject*);

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    virtual const JSC::ClassInfo* classInfo() const { return &s_info; }
    static const JSC::ClassInfo s_info;
    static PassRefPtr<JSC::Structure> createStructure(JSC::JSValue prototype)
    {
        return JSC::Structure::create(prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), AnonymousSlotCount);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSHTMLDataGridRowElementConstructor::s_info = { "HTMLDataGridRowElementConstructor", 0, &JSHTMLDataGridRowElementConstructorTable, 0 };

JSHTMLDataGridRowElementConstructor::JSHTMLDataGridRowElementConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(JSHTMLDataGridRowElementConstructor::createStructure(globalObject->objectPrototype()), globalObject)
{
    putDirect(exec->propertyNames().prototype, JSHTMLDataGridRowElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSHTMLDataGridRowElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLDataGridRowElementConstructor, DOMObject>(exec, &JSHTMLDataGridRowElementConstructorTable, this, propertyName, slot);
}

bool JSHTMLDataGridRowElementConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLDataGridRowElementConstructor, DOMObject>(exec, &JSHTMLDataGridRowElementConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSHTMLDataGridRowElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSHTMLDataGridRowElementPrototypeTable = { 1, 0, JSHTMLDataGridRowElementPrototypeTableValues, 0 };
const ClassInfo JSHTMLDataGridRowElementPrototype::s_info = { "HTMLDataGridRowElementPrototype", 0, &JSHTMLDataGridRowElementPrototypeTable, 0 };

JSObject* JSHTMLDataGridRowElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLDataGridRowElement>(exec, globalObject);
}

const ClassInfo JSHTMLDataGridRowElement::s_info = { "HTMLDataGridRowElement", &JSHTMLElement::s_info, &JSHTMLDataGridRowElementTable, 0 };

JSHTMLDataGridRowElement::JSHTMLDataGridRowElement(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLDataGridRowElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

JSObject* JSHTMLDataGridRowElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSHTMLDataGridRowElementPrototype(globalObject, JSHTMLDataGridRowElementPrototype::createStructure(JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLDataGridRowElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLDataGridRowElement, Base>(exec, &JSHTMLDataGridRowElementTable, this, propertyName, slot);
}

bool JSHTMLDataGridRowElement::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLDataGridRowElement, Base>(exec, &JSHTMLDataGridRowElementTable, this, propertyName, descriptor);
}

JSValue jsHTMLDataGridRowElementSelected(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLDataGridRowElement* castedThis = static_cast<JSHTMLDataGridRowElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLDataGridRowElement* imp = static_cast<HTMLDataGridRowElement*>(castedThis->impl());
    JSValue result = jsBoolean(imp->selected());
    return result;
}

JSValue jsHTMLDataGridRowElementFocused(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLDataGridRowElement* castedThis = static_cast<JSHTMLDataGridRowElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLDataGridRowElement* imp = static_cast<HTMLDataGridRowElement*>(castedThis->impl());
    JSValue result = jsBoolean(imp->focused());
    return result;
}

JSValue jsHTMLDataGridRowElementExpanded(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLDataGridRowElement* castedThis = static_cast<JSHTMLDataGridRowElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLDataGridRowElement* imp = static_cast<HTMLDataGridRowElement*>(castedThis->impl());
    JSValue result = jsBoolean(imp->expanded());
    return result;
}

JSValue jsHTMLDataGridRowElementConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLDataGridRowElement* domObject = static_cast<JSHTMLDataGridRowElement*>(asObject(slotBase));
    return JSHTMLDataGridRowElement::getConstructor(exec, domObject->globalObject());
}
void JSHTMLDataGridRowElement::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSHTMLDataGridRowElement, Base>(exec, propertyName, value, &JSHTMLDataGridRowElementTable, this, slot);
}

void setJSHTMLDataGridRowElementSelected(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLDataGridRowElement* castedThis = static_cast<JSHTMLDataGridRowElement*>(thisObject);
    HTMLDataGridRowElement* imp = static_cast<HTMLDataGridRowElement*>(castedThis->impl());
    imp->setSelected(value.toBoolean(exec));
}

void setJSHTMLDataGridRowElementFocused(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLDataGridRowElement* castedThis = static_cast<JSHTMLDataGridRowElement*>(thisObject);
    HTMLDataGridRowElement* imp = static_cast<HTMLDataGridRowElement*>(castedThis->impl());
    imp->setFocused(value.toBoolean(exec));
}

void setJSHTMLDataGridRowElementExpanded(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLDataGridRowElement* castedThis = static_cast<JSHTMLDataGridRowElement*>(thisObject);
    HTMLDataGridRowElement* imp = static_cast<HTMLDataGridRowElement*>(castedThis->impl());
    imp->setExpanded(value.toBoolean(exec));
}

JSValue JSHTMLDataGridRowElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLDataGridRowElementConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}


}

#endif // ENABLE(DATAGRID)
