/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(INDEXED_DATABASE)

#include "JSIDBErrorEvent.h"

#include "IDBErrorEvent.h"
#include "KURL.h"
#include <runtime/JSNumberCell.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSIDBErrorEvent);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSIDBErrorEventTableValues[4] =
{
    { "code", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBErrorEventCode), (intptr_t)0 THUNK_GENERATOR(0) },
    { "message", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBErrorEventMessage), (intptr_t)0 THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBErrorEventConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSIDBErrorEventTable = { 9, 7, JSIDBErrorEventTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSIDBErrorEventConstructorTableValues[1] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSIDBErrorEventConstructorTable = { 1, 0, JSIDBErrorEventConstructorTableValues, 0 };
class JSIDBErrorEventConstructor : public DOMConstructorObject {
public:
    JSIDBErrorEventConstructor(JSC::ExecState*, JSDOMGlobalObject*);

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    virtual const JSC::ClassInfo* classInfo() const { return &s_info; }
    static const JSC::ClassInfo s_info;
    static PassRefPtr<JSC::Structure> createStructure(JSC::JSValue prototype)
    {
        return JSC::Structure::create(prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), AnonymousSlotCount);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSIDBErrorEventConstructor::s_info = { "IDBErrorEventConstructor", 0, &JSIDBErrorEventConstructorTable, 0 };

JSIDBErrorEventConstructor::JSIDBErrorEventConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(JSIDBErrorEventConstructor::createStructure(globalObject->objectPrototype()), globalObject)
{
    putDirect(exec->propertyNames().prototype, JSIDBErrorEventPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSIDBErrorEventConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSIDBErrorEventConstructor, DOMObject>(exec, &JSIDBErrorEventConstructorTable, this, propertyName, slot);
}

bool JSIDBErrorEventConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSIDBErrorEventConstructor, DOMObject>(exec, &JSIDBErrorEventConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSIDBErrorEventPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSIDBErrorEventPrototypeTable = { 1, 0, JSIDBErrorEventPrototypeTableValues, 0 };
const ClassInfo JSIDBErrorEventPrototype::s_info = { "IDBErrorEventPrototype", 0, &JSIDBErrorEventPrototypeTable, 0 };

JSObject* JSIDBErrorEventPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSIDBErrorEvent>(exec, globalObject);
}

const ClassInfo JSIDBErrorEvent::s_info = { "IDBErrorEvent", &JSIDBEvent::s_info, &JSIDBErrorEventTable, 0 };

JSIDBErrorEvent::JSIDBErrorEvent(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<IDBErrorEvent> impl)
    : JSIDBEvent(structure, globalObject, impl)
{
}

JSObject* JSIDBErrorEvent::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSIDBErrorEventPrototype(globalObject, JSIDBErrorEventPrototype::createStructure(JSIDBEventPrototype::self(exec, globalObject)));
}

bool JSIDBErrorEvent::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSIDBErrorEvent, Base>(exec, &JSIDBErrorEventTable, this, propertyName, slot);
}

bool JSIDBErrorEvent::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSIDBErrorEvent, Base>(exec, &JSIDBErrorEventTable, this, propertyName, descriptor);
}

JSValue jsIDBErrorEventCode(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSIDBErrorEvent* castedThis = static_cast<JSIDBErrorEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    IDBErrorEvent* imp = static_cast<IDBErrorEvent*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->code());
    return result;
}

JSValue jsIDBErrorEventMessage(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSIDBErrorEvent* castedThis = static_cast<JSIDBErrorEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    IDBErrorEvent* imp = static_cast<IDBErrorEvent*>(castedThis->impl());
    JSValue result = jsString(exec, imp->message());
    return result;
}

JSValue jsIDBErrorEventConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSIDBErrorEvent* domObject = static_cast<JSIDBErrorEvent*>(asObject(slotBase));
    return JSIDBErrorEvent::getConstructor(exec, domObject->globalObject());
}
JSValue JSIDBErrorEvent::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSIDBErrorEventConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}


}

#endif // ENABLE(INDEXED_DATABASE)
