/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WORKERS)

#include "JSWorkerLocation.h"

#include "KURL.h"
#include "WorkerLocation.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSWorkerLocation);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSWorkerLocationTableValues[10] =
{
    { "href", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerLocationHref), (intptr_t)0 THUNK_GENERATOR(0) },
    { "protocol", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerLocationProtocol), (intptr_t)0 THUNK_GENERATOR(0) },
    { "host", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerLocationHost), (intptr_t)0 THUNK_GENERATOR(0) },
    { "hostname", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerLocationHostname), (intptr_t)0 THUNK_GENERATOR(0) },
    { "port", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerLocationPort), (intptr_t)0 THUNK_GENERATOR(0) },
    { "pathname", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerLocationPathname), (intptr_t)0 THUNK_GENERATOR(0) },
    { "search", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerLocationSearch), (intptr_t)0 THUNK_GENERATOR(0) },
    { "hash", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerLocationHash), (intptr_t)0 THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerLocationConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSWorkerLocationTable = { 35, 31, JSWorkerLocationTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSWorkerLocationConstructorTableValues[1] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSWorkerLocationConstructorTable = { 1, 0, JSWorkerLocationConstructorTableValues, 0 };
class JSWorkerLocationConstructor : public DOMConstructorObject {
public:
    JSWorkerLocationConstructor(JSC::ExecState*, JSDOMGlobalObject*);

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    virtual const JSC::ClassInfo* classInfo() const { return &s_info; }
    static const JSC::ClassInfo s_info;
    static PassRefPtr<JSC::Structure> createStructure(JSC::JSValue prototype)
    {
        return JSC::Structure::create(prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), AnonymousSlotCount);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSWorkerLocationConstructor::s_info = { "WorkerLocationConstructor", 0, &JSWorkerLocationConstructorTable, 0 };

JSWorkerLocationConstructor::JSWorkerLocationConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(JSWorkerLocationConstructor::createStructure(globalObject->objectPrototype()), globalObject)
{
    putDirect(exec->propertyNames().prototype, JSWorkerLocationPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSWorkerLocationConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSWorkerLocationConstructor, DOMObject>(exec, &JSWorkerLocationConstructorTable, this, propertyName, slot);
}

bool JSWorkerLocationConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSWorkerLocationConstructor, DOMObject>(exec, &JSWorkerLocationConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSWorkerLocationPrototypeTableValues[2] =
{
    { "toString", DontDelete | DontEnum | Function, (intptr_t)static_cast<NativeFunction>(jsWorkerLocationPrototypeFunctionToString), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSWorkerLocationPrototypeTable = { 2, 1, JSWorkerLocationPrototypeTableValues, 0 };
static const HashTable* getJSWorkerLocationPrototypeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSWorkerLocationPrototypeTable);
}
const ClassInfo JSWorkerLocationPrototype::s_info = { "WorkerLocationPrototype", 0, 0, getJSWorkerLocationPrototypeTable };

JSObject* JSWorkerLocationPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSWorkerLocation>(exec, globalObject);
}

bool JSWorkerLocationPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, getJSWorkerLocationPrototypeTable(exec), this, propertyName, slot);
}

bool JSWorkerLocationPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, getJSWorkerLocationPrototypeTable(exec), this, propertyName, descriptor);
}

static const HashTable* getJSWorkerLocationTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSWorkerLocationTable);
}
const ClassInfo JSWorkerLocation::s_info = { "WorkerLocation", 0, 0, getJSWorkerLocationTable };

JSWorkerLocation::JSWorkerLocation(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<WorkerLocation> impl)
    : DOMObjectWithGlobalPointer(structure, globalObject)
    , m_impl(impl)
{
}

JSWorkerLocation::~JSWorkerLocation()
{
    forgetDOMObject(this, impl());
}

JSObject* JSWorkerLocation::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSWorkerLocationPrototype(globalObject, JSWorkerLocationPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSWorkerLocation::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSWorkerLocation, Base>(exec, getJSWorkerLocationTable(exec), this, propertyName, slot);
}

bool JSWorkerLocation::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSWorkerLocation, Base>(exec, getJSWorkerLocationTable(exec), this, propertyName, descriptor);
}

JSValue jsWorkerLocationHref(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSWorkerLocation* castedThis = static_cast<JSWorkerLocation*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WorkerLocation* imp = static_cast<WorkerLocation*>(castedThis->impl());
    JSValue result = jsString(exec, imp->href());
    return result;
}

JSValue jsWorkerLocationProtocol(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSWorkerLocation* castedThis = static_cast<JSWorkerLocation*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WorkerLocation* imp = static_cast<WorkerLocation*>(castedThis->impl());
    JSValue result = jsString(exec, imp->protocol());
    return result;
}

JSValue jsWorkerLocationHost(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSWorkerLocation* castedThis = static_cast<JSWorkerLocation*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WorkerLocation* imp = static_cast<WorkerLocation*>(castedThis->impl());
    JSValue result = jsString(exec, imp->host());
    return result;
}

JSValue jsWorkerLocationHostname(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSWorkerLocation* castedThis = static_cast<JSWorkerLocation*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WorkerLocation* imp = static_cast<WorkerLocation*>(castedThis->impl());
    JSValue result = jsString(exec, imp->hostname());
    return result;
}

JSValue jsWorkerLocationPort(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSWorkerLocation* castedThis = static_cast<JSWorkerLocation*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WorkerLocation* imp = static_cast<WorkerLocation*>(castedThis->impl());
    JSValue result = jsString(exec, imp->port());
    return result;
}

JSValue jsWorkerLocationPathname(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSWorkerLocation* castedThis = static_cast<JSWorkerLocation*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WorkerLocation* imp = static_cast<WorkerLocation*>(castedThis->impl());
    JSValue result = jsString(exec, imp->pathname());
    return result;
}

JSValue jsWorkerLocationSearch(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSWorkerLocation* castedThis = static_cast<JSWorkerLocation*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WorkerLocation* imp = static_cast<WorkerLocation*>(castedThis->impl());
    JSValue result = jsString(exec, imp->search());
    return result;
}

JSValue jsWorkerLocationHash(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSWorkerLocation* castedThis = static_cast<JSWorkerLocation*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WorkerLocation* imp = static_cast<WorkerLocation*>(castedThis->impl());
    JSValue result = jsString(exec, imp->hash());
    return result;
}

JSValue jsWorkerLocationConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSWorkerLocation* domObject = static_cast<JSWorkerLocation*>(asObject(slotBase));
    return JSWorkerLocation::getConstructor(exec, domObject->globalObject());
}
JSValue JSWorkerLocation::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWorkerLocationConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsWorkerLocationPrototypeFunctionToString(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSWorkerLocation::s_info))
        return throwVMTypeError(exec);
    JSWorkerLocation* castedThis = static_cast<JSWorkerLocation*>(asObject(thisValue));
    WorkerLocation* imp = static_cast<WorkerLocation*>(castedThis->impl());


    JSC::JSValue result = jsString(exec, imp->toString());
    return JSValue::encode(result);
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, WorkerLocation* object)
{
    return getDOMObjectWrapper<JSWorkerLocation>(exec, globalObject, object);
}
WorkerLocation* toWorkerLocation(JSC::JSValue value)
{
    return value.inherits(&JSWorkerLocation::s_info) ? static_cast<JSWorkerLocation*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(WORKERS)
