/*
 * Copyright (c) 2008, Google Inc. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 
 *     * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above
 * copyright notice, this list of conditions and the following disclaimer
 * in the documentation and/or other materials provided with the
 * distribution.
 *     * Neither the name of Google Inc. nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef ChromeClientChromium_h
#define ChromeClientChromium_h

#include "ChromeClient.h"
#include <wtf/Forward.h>

namespace WebCore {
class AccessibilityObject;
class IntRect;
class PopupContainer;

#if USE(ACCELERATED_COMPOSITING)
class GLES2Context;
#endif

// Contains Chromium-specific extensions to the ChromeClient.  Only put
// things here that don't make sense for other ports.
class ChromeClientChromium : public ChromeClient {
public:
    // Notifies the client of a new popup widget.  The client should place
    // and size the widget with the given bounds, relative to the screen.
    // If handleExternal is true, then drawing and input handling for the
    // popup will be handled by the external embedder.
    virtual void popupOpened(PopupContainer* popupContainer, const IntRect& bounds,
                             bool handleExternal) = 0;
                             
    // Notifies the client a popup was closed.
    virtual void popupClosed(PopupContainer* popupContainer) = 0;

    // Notifies embedder that the state of an accessibility object has changed.
    virtual void didChangeAccessibilityObjectState(AccessibilityObject*) = 0;

#if USE(ACCELERATED_COMPOSITING)
    // Request a GL ES 2 context to use for compositing this page's content.
    virtual PassOwnPtr<GLES2Context> getOnscreenGLES2Context() = 0;
    virtual PassOwnPtr<GLES2Context> getOffscreenGLES2Context() = 0;
#endif
};

} // namespace WebCore

#endif
