// Copyright (c) 2006-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
//

/**
 @file
 @internalTechnology
*/

#ifndef __CMTPSETOBJECTPROPVALUE_H__
#define __CMTPSETOBJECTPROPVALUE_H__

#include <e32std.h> 
#include <mtp/cmtpobjectmetadata.h>
#include "cmtprequestprocessor.h"
#include "rmtpframework.h"
#include "rmtpdpsingletons.h"

class CMTPTypeString;
class TMTPTypeUint8;


/** 
Defines file data provider SetObjectPropValue request processor

@internalTechnology
*/
class CMTPSetObjectPropValue : public CMTPRequestProcessor
	{
public:
	IMPORT_C static MMTPRequestProcessor* NewL(
									MMTPDataProviderFramework& aFramework,
									MMTPConnection& aConnection);	
	IMPORT_C ~CMTPSetObjectPropValue();	
	
private:	
	CMTPSetObjectPropValue(
					MMTPDataProviderFramework& aFramework,
					MMTPConnection& aConnection);
	void ConstructL();
	TBool IsPropCodeReadonly(TUint32 aObjectPropCode);

private:	//from CMTPRequestProcessor
	virtual TMTPResponseCode CheckRequestL();
	virtual void ServiceL();
	virtual TBool DoHandleResponsePhaseL();
	TBool HasDataphase() const;

private:
	CMTPTypeString*			iMTPTypeString;
	TMTPTypeUint8			iMTPTypeUint8;
	TMTPTypeUint16			iMTPTypeUint16;
	TMTPTypeUint32			iMTPTypeUint32;
	RMTPFramework			iSingleton;
	TEntry 					iFileEntry;
	RFs&					iRfs;
	CMTPObjectMetaData*		iObjMeta;
	
    /**
    DP utility singletons
    */
    RMTPDpSingletons					iDpSingletons;
	};
	
#endif

