/*
* Copyright (c) 2002 Nokia Corporation and/or its subsidiary(-ies). 
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:  UIDs for project Provisioning
*
*/



#ifndef PROVISIONINGUID_H
#define PROVISIONINGUID_H

//  CONSTANTS  

/// ECOM plugin
#define KECOMUid2 0x10009D8D

/// Normal Symbian OS DLL
#define KSymbianDLLUid2 0x1000008d

/// UID2 for Provisioning BIO control
#define KProvisioningBCUid2 0x10005F5F

/// UID3 for Provisioning BIO control
#define KProvisioningBCUid3 0x0F10F123

/// UID for the Provisioning Message type for BIO database
#define KProvisioningMessageTypeUid 0x0F10127

/// UID2 for the handler plugin for WAP Provisioning documents
#define KProvisioningHandlerUid2 KECOMUid2

/// UID3 for the handler plugin DLL for WAP Provisioning documents
#define KProvisioningHandlerUid3 0x0F10F124

/// UID for the handler plugin implementation
#define KProvisioningHandlerImplUid 0x0F10F126

/// UID of the Content Type Handler plugin interface
#define KProvisioningHandlerInterface 0x101F3E5E

/// UID2 of the Provisioning Parser DLL
#define KProvisioningParserUid2 KSymbianDLLUid2

/// UID3 of the Provisioning Parser DLL
#define KProvisioningParserUid3 0x0F10F125

/// UID of the Provisisioning Adapter plugin interface
#define KProvisioningAdapterInterface 0x0F10F128

/// UID2 of the Provisioning Engine DLL
#define KProvisioningEngineUid2 KSymbianDLLUid2

/// UID3 of the Provisioning Engine DLL
#define KProvisioningEngineUid3 0x0F10F129

/// UID for HTTPHeader stream in WAP Provisioning message
#define KProvisioningHeaderStreamUid 0x0F10F12C

/// UID for HTTPHeader stream in WAP Provisioning message
#define KProvisioningBodyStreamUid 0x0F10F12D

/// UID2 for the BootstrapAdapter DLL
#define KProvisioningBootstrapAdapterDllUid2 KECOMUid2

/// UID3 for the BootstrapAdapter DLL
#define KProvisioningBootstrapAdapterDllUid3 0x0F10F12A

/// UID for the BootstrapAdapter
#define KProvisioningBootstrapAdapterUid 0xF10F12B

/// UID2 for the APAdapter and BrowserAdapter DLL
#define KProvisioningAPBrowserAdapterDllUid2 KECOMUid2

/// UID3 for the APAdapter and BrowserAdapter DLL
#define KProvisioningAPBrowserAdapterDllUid3 0x0F10F12E

/// UID for the APAdapter
#define KProvisioningAPAdapterUid 0xF10F12F

/// UID for the BrowserAdapter
#define KProvisioningBrowserAdapterUid 0xF10F130

/// UID2 for the SyncMLAdapter DLL
#define KProvisioningSyncMLAdapterDllUid2 KECOMUid2

/// UID3 for the SyncMLAdapter DLL
#define KProvisioningSyncMLAdapterDllUid3 0x0F10F131

/// UID for the SyncMLAdapter
#define KProvisioningSyncMLAdapterUid 0xF10F132

/// UID2 for the WVAdapter DLL
#define KProvisioningWVAdapterDllUid2 KECOMUid2

/// UID3 for the WVAdapter DLL
#define KProvisioningWVAdapterDllUid3 0x0F10F133

/// UID for the WVAdapter
#define KProvisioningWVAdapterUid 0xF10F134

/// UID2 for the IACAdapter DLL
#define KProvisioningIACAdapterUid2 KECOMUid2

/// UID3 for the IACAdapter DLL
#define KProvisioningIACAdapterDllUid3 0x0F10F135

/// UID for the IACAdapter
#define KProvisioningIACAdapterUid 0xF10F136

#endif      //  PROVISIONINGUID_H
            
// End of File
