/*
* ============================================================================
*  Name        : hbindicatortestplugin.h
*  Part of     : hb / hbcore
*  Description : indicator test plugin header
*  Version     : %version: %
*
*  Copyright (c) 2009 Nokia.  All rights reserved.
*  This material, including documentation and any related computer
*  programs, is protected by copyright controlled by Nokia.  All
*  rights are reserved.  Copying, including reproducing, storing,
*  adapting or translating, any or all of this material requires the
*  prior written consent of Nokia.  This material also contains
*  confidential information which may not be disclosed to others
*  without the prior written consent of Nokia.
* ============================================================================
*/

#ifndef HBINDICATORTESTPLUGIN_H
#define HBINDICATORTESTPLUGIN_H

#include <QObject>
#include <QStringList>
#include <QVariant>

#include <hbindicatorplugininterface.h>
#include <hbindicatorinterface.h>
#include "testindicators.h"

class HbIndicatorTestPlugin : public QObject, public HbIndicatorPluginInterface
{
    Q_OBJECT
    Q_INTERFACES(HbIndicatorPluginInterface)

public:
    HbIndicatorTestPlugin();
    ~HbIndicatorTestPlugin();

    QStringList indicatorTypes() const;
    bool accessAllowed(const QString &indicatorType,
        const QVariantMap &securityInfo) const;
    HbIndicatorInterface* createIndicator(const QString &indicatorType);
    int error() const;
private:
    int typeIndex(const QString &indicatorType) const;
private:
    Q_DISABLE_COPY(HbIndicatorTestPlugin)
    int mError;
    QStringList mIndicatorTypes;
};

class HbTestIndicator : public HbIndicatorInterface
{
public:
    HbTestIndicator(const QString &indicatorType,
                    int typeIndex,
                    Interaction interaction);
    ~HbTestIndicator();
    bool handleInteraction(InteractionType type);
    QVariant indicatorData(int role) const;
protected:
    bool handleClientRequest(RequestType type, const QVariant &parameter);
private:
    QString mPrimaryText;
    QString mSecondaryText;
    QString mIcon;
    QString mIconMono;
    int mTypeIndex;
    Interaction mInteraction;
    QVariant mParameter;
};

#endif // HBINDICATORTESTPLUGIN_H

